/*
 * Decompiled with CFR 0.152.
 */
package androidx.credentials.playservices.controllers.BeginSignIn;

import androidx.credentials.CredentialOption;
import androidx.credentials.GetCredentialRequest;
import androidx.credentials.GetPasswordOption;
import androidx.credentials.GetPublicKeyCredentialOption;
import androidx.credentials.playservices.controllers.CreatePublicKeyCredential.PublicKeyCredentialControllerUtility;
import com.google.android.gms.auth.api.identity.BeginSignInRequest;
import com.google.android.libraries.identity.googleid.GetGoogleIdOption;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Landroidx/credentials/playservices/controllers/BeginSignIn/BeginSignInControllerUtility;", "", "()V", "Companion", "credentials-play-services-auth_release"})
public final class BeginSignInControllerUtility {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final String TAG = BeginSignInControllerUtility.class.getName();

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/credentials/playservices/controllers/BeginSignIn/BeginSignInControllerUtility$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "constructBeginSignInRequest", "Lcom/google/android/gms/auth/api/identity/BeginSignInRequest;", "request", "Landroidx/credentials/GetCredentialRequest;", "constructBeginSignInRequest$credentials_play_services_auth_release", "convertToGoogleIdTokenOption", "Lcom/google/android/gms/auth/api/identity/BeginSignInRequest$GoogleIdTokenRequestOptions;", "option", "Lcom/google/android/libraries/identity/googleid/GetGoogleIdOption;", "credentials-play-services-auth_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BeginSignInRequest constructBeginSignInRequest$credentials_play_services_auth_release(@NotNull GetCredentialRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            boolean isPublicKeyCredReqFound = false;
            BeginSignInRequest.Builder requestBuilder = new BeginSignInRequest.Builder();
            boolean autoSelect = false;
            for (CredentialOption option : request.getCredentialOptions()) {
                if (option instanceof GetPasswordOption) {
                    requestBuilder.setPasswordRequestOptions(new BeginSignInRequest.PasswordRequestOptions.Builder().setSupported(true).build());
                    autoSelect = autoSelect || option.isAutoSelectAllowed();
                    continue;
                }
                if (option instanceof GetPublicKeyCredentialOption && !isPublicKeyCredReqFound) {
                    requestBuilder.setPasskeysSignInRequestOptions(PublicKeyCredentialControllerUtility.Companion.convertToPlayAuthPasskeyRequest((GetPublicKeyCredentialOption)option));
                    isPublicKeyCredReqFound = true;
                    continue;
                }
                if (!(option instanceof GetGoogleIdOption)) continue;
                requestBuilder.setGoogleIdTokenRequestOptions(this.convertToGoogleIdTokenOption((GetGoogleIdOption)option));
                autoSelect = autoSelect || ((GetGoogleIdOption)option).getAutoSelectEnabled();
            }
            BeginSignInRequest beginSignInRequest = requestBuilder.setAutoSelectEnabled(autoSelect).build();
            Intrinsics.checkNotNullExpressionValue((Object)beginSignInRequest, (String)"requestBuilder\n         \u2026\n                .build()");
            return beginSignInRequest;
        }

        private final BeginSignInRequest.GoogleIdTokenRequestOptions convertToGoogleIdTokenOption(GetGoogleIdOption option) {
            BeginSignInRequest.GoogleIdTokenRequestOptions.Builder builder = BeginSignInRequest.GoogleIdTokenRequestOptions.builder().setFilterByAuthorizedAccounts(option.getFilterByAuthorizedAccounts()).setNonce(option.getNonce()).setRequestVerifiedPhoneNumber(option.getRequestVerifiedPhoneNumber()).setServerClientId(option.getServerClientId()).setSupported(true);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder()\n              \u2026      .setSupported(true)");
            BeginSignInRequest.GoogleIdTokenRequestOptions.Builder idTokenOption = builder;
            if (option.getLinkedServiceId() != null) {
                String string = option.getLinkedServiceId();
                Intrinsics.checkNotNull((Object)string);
                idTokenOption.associateLinkedAccounts(string, option.getIdTokenDepositionScopes());
            }
            BeginSignInRequest.GoogleIdTokenRequestOptions googleIdTokenRequestOptions = idTokenOption.build();
            Intrinsics.checkNotNullExpressionValue((Object)googleIdTokenRequestOptions, (String)"idTokenOption.build()");
            return googleIdTokenRequestOptions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

