/*
 * Decompiled with CFR 0.152.
 */
package androidx.credentials.playservices.controllers.CreatePublicKeyCredential;

import android.util.Base64;
import android.util.Log;
import androidx.credentials.CreatePublicKeyCredentialRequest;
import androidx.credentials.GetPublicKeyCredentialOption;
import androidx.credentials.exceptions.CreateCredentialCancellationException;
import androidx.credentials.exceptions.CreateCredentialException;
import androidx.credentials.exceptions.GetCredentialCancellationException;
import androidx.credentials.exceptions.GetCredentialException;
import androidx.credentials.exceptions.domerrors.AbortError;
import androidx.credentials.exceptions.domerrors.ConstraintError;
import androidx.credentials.exceptions.domerrors.DataError;
import androidx.credentials.exceptions.domerrors.DomError;
import androidx.credentials.exceptions.domerrors.EncodingError;
import androidx.credentials.exceptions.domerrors.InvalidStateError;
import androidx.credentials.exceptions.domerrors.NetworkError;
import androidx.credentials.exceptions.domerrors.NotAllowedError;
import androidx.credentials.exceptions.domerrors.NotReadableError;
import androidx.credentials.exceptions.domerrors.NotSupportedError;
import androidx.credentials.exceptions.domerrors.SecurityError;
import androidx.credentials.exceptions.domerrors.TimeoutError;
import androidx.credentials.exceptions.domerrors.UnknownError;
import androidx.credentials.exceptions.publickeycredential.CreatePublicKeyCredentialDomException;
import androidx.credentials.exceptions.publickeycredential.GetPublicKeyCredentialDomException;
import com.google.android.gms.auth.api.identity.BeginSignInRequest;
import com.google.android.gms.auth.api.identity.SignInCredential;
import com.google.android.gms.fido.common.Transport;
import com.google.android.gms.fido.fido2.api.common.Attachment;
import com.google.android.gms.fido.fido2.api.common.AttestationConveyancePreference;
import com.google.android.gms.fido.fido2.api.common.AuthenticationExtensions;
import com.google.android.gms.fido.fido2.api.common.AuthenticationExtensionsClientOutputs;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorAssertionResponse;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorAttestationResponse;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorErrorResponse;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorResponse;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorSelectionCriteria;
import com.google.android.gms.fido.fido2.api.common.COSEAlgorithmIdentifier;
import com.google.android.gms.fido.fido2.api.common.ErrorCode;
import com.google.android.gms.fido.fido2.api.common.FidoAppIdExtension;
import com.google.android.gms.fido.fido2.api.common.GoogleThirdPartyPaymentExtension;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredential;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialCreationOptions;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialDescriptor;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialParameters;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialRpEntity;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialUserEntity;
import com.google.android.gms.fido.fido2.api.common.ResidentKeyRequirement;
import com.google.android.gms.fido.fido2.api.common.UserVerificationMethodExtension;
import com.google.android.gms.fido.fido2.api.common.UvmEntries;
import com.google.android.gms.fido.fido2.api.common.UvmEntry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Landroidx/credentials/playservices/controllers/CreatePublicKeyCredential/PublicKeyCredentialControllerUtility;", "", "()V", "Companion", "credentials-play-services-auth_release"})
public final class PublicKeyCredentialControllerUtility {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String JSON_KEY_CLIENT_DATA = "clientDataJSON";
    @NotNull
    private static final String JSON_KEY_ATTESTATION_OBJ = "attestationObject";
    @NotNull
    private static final String JSON_KEY_AUTH_DATA = "authenticationData";
    @NotNull
    private static final String JSON_KEY_SIGNATURE = "signature";
    @NotNull
    private static final String JSON_KEY_USER_HANDLE = "userHandle";
    @NotNull
    private static final String JSON_KEY_RESPONSE = "response";
    @NotNull
    private static final String JSON_KEY_ID = "id";
    @NotNull
    private static final String JSON_KEY_RAW_ID = "rawId";
    @NotNull
    private static final String JSON_KEY_TYPE = "type";
    @NotNull
    private static final String JSON_KEY_RPID = "rpId";
    @NotNull
    private static final String JSON_KEY_CHALLENGE = "challenge";
    @NotNull
    private static final String JSON_KEY_APPID = "appid";
    @NotNull
    private static final String JSON_KEY_THIRD_PARTY_PAYMENT = "thirdPartyPayment";
    @NotNull
    private static final String JSON_KEY_AUTH_SELECTION = "authenticatorSelection";
    @NotNull
    private static final String JSON_KEY_REQUIRE_RES_KEY = "requireResidentKey";
    @NotNull
    private static final String JSON_KEY_RES_KEY = "residentKey";
    @NotNull
    private static final String JSON_KEY_AUTH_ATTACHMENT = "authenticatorAttachment";
    @NotNull
    private static final String JSON_KEY_TIMEOUT = "timeout";
    @NotNull
    private static final String JSON_KEY_EXCLUDE_CREDENTIALS = "excludeCredentials";
    @NotNull
    private static final String JSON_KEY_TRANSPORTS = "transports";
    @NotNull
    private static final String JSON_KEY_RP = "rp";
    @NotNull
    private static final String JSON_KEY_NAME = "name";
    @NotNull
    private static final String JSON_KEY_ICON = "icon";
    @NotNull
    private static final String JSON_KEY_ALG = "alg";
    @NotNull
    private static final String JSON_KEY_USER = "user";
    @NotNull
    private static final String JSON_KEY_DISPLAY_NAME = "displayName";
    @NotNull
    private static final String JSON_KEY_USER_VERIFICATION_METHOD = "userVerificationMethod";
    @NotNull
    private static final String JSON_KEY_KEY_PROTECTION_TYPE = "keyProtectionType";
    @NotNull
    private static final String JSON_KEY_MATCHER_PROTECTION_TYPE = "matcherProtectionType";
    @NotNull
    private static final String JSON_KEY_EXTENSTIONS = "extensions";
    @NotNull
    private static final String JSON_KEY_ATTESTATION = "attestation";
    @NotNull
    private static final String JSON_KEY_PUB_KEY_CRED_PARAMS = "pubKeyCredParams";
    private static final int FLAGS = 11;
    @NotNull
    private static final String TAG = "PublicKeyUtility";
    @NotNull
    private static final LinkedHashMap<ErrorCode, DomError> orderedErrorCodeToExceptions;

    @JvmStatic
    @NotNull
    public static final PublicKeyCredentialCreationOptions convert(@NotNull CreatePublicKeyCredentialRequest request) {
        return Companion.convert(request);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ErrorCode.UNKNOWN_ERR, (Object)new UnknownError()), TuplesKt.to((Object)ErrorCode.ABORT_ERR, (Object)new AbortError()), TuplesKt.to((Object)ErrorCode.ATTESTATION_NOT_PRIVATE_ERR, (Object)new NotReadableError()), TuplesKt.to((Object)ErrorCode.CONSTRAINT_ERR, (Object)new ConstraintError()), TuplesKt.to((Object)ErrorCode.DATA_ERR, (Object)new DataError()), TuplesKt.to((Object)ErrorCode.INVALID_STATE_ERR, (Object)new InvalidStateError()), TuplesKt.to((Object)ErrorCode.ENCODING_ERR, (Object)new EncodingError()), TuplesKt.to((Object)ErrorCode.NETWORK_ERR, (Object)new NetworkError()), TuplesKt.to((Object)ErrorCode.NOT_ALLOWED_ERR, (Object)new NotAllowedError()), TuplesKt.to((Object)ErrorCode.NOT_SUPPORTED_ERR, (Object)new NotSupportedError()), TuplesKt.to((Object)ErrorCode.SECURITY_ERR, (Object)new SecurityError()), TuplesKt.to((Object)ErrorCode.TIMEOUT_ERR, (Object)new TimeoutError())};
        orderedErrorCodeToExceptions = MapsKt.linkedMapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\u000e\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u0006J\u000e\u00107\u001a\u00020\u00062\u0006\u00108\u001a\u000205J \u00109\u001a\u00020/2\u0006\u0010:\u001a\u00020;2\u0006\u00102\u001a\u0002032\u0006\u0010<\u001a\u000201H\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u0010:\u001a\u00020?H\u0002J\u000e\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u0004J\u0010\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FH\u0007J\u000e\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020JJ\u0010\u0010K\u001a\u00020L2\u0006\u0010I\u001a\u00020JH\u0007J\u001d\u0010M\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060N2\u0006\u0010:\u001a\u00020OH\u0002\u00a2\u0006\u0002\u0010PJ\u0010\u0010Q\u001a\u0002052\u0006\u00102\u001a\u000203H\u0002J\u001d\u0010R\u001a\u00020/2\u0006\u00102\u001a\u0002032\u0006\u0010S\u001a\u00020TH\u0000\u00a2\u0006\u0002\bUJ\u001d\u0010V\u001a\u00020/2\u0006\u00102\u001a\u0002032\u0006\u0010S\u001a\u00020TH\u0000\u00a2\u0006\u0002\bWJ\u001d\u0010X\u001a\u00020/2\u0006\u00102\u001a\u0002032\u0006\u0010S\u001a\u00020TH\u0000\u00a2\u0006\u0002\bYJ\u001d\u0010Z\u001a\u00020/2\u0006\u00102\u001a\u0002032\u0006\u0010S\u001a\u00020TH\u0000\u00a2\u0006\u0002\b[J\u001d\u0010\\\u001a\u00020/2\u0006\u00102\u001a\u0002032\u0006\u0010S\u001a\u00020TH\u0000\u00a2\u0006\u0002\b]J\u001d\u0010^\u001a\u00020/2\u0006\u00102\u001a\u0002032\u0006\u0010S\u001a\u00020TH\u0000\u00a2\u0006\u0002\b_J\u0010\u0010`\u001a\u0004\u0018\u00010a2\u0006\u00100\u001a\u000201J\u000e\u0010b\u001a\u00020\u00062\u0006\u00100\u001a\u00020cJ\u000e\u0010d\u001a\u00020\u00062\u0006\u00100\u001a\u000201R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R0\u0010'\u001a\u001e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0(j\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*`+X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u0006e"}, d2={"Landroidx/credentials/playservices/controllers/CreatePublicKeyCredential/PublicKeyCredentialControllerUtility$Companion;", "", "()V", "FLAGS", "", "JSON_KEY_ALG", "", "JSON_KEY_APPID", "JSON_KEY_ATTESTATION", "JSON_KEY_ATTESTATION_OBJ", "JSON_KEY_AUTH_ATTACHMENT", "JSON_KEY_AUTH_DATA", "JSON_KEY_AUTH_SELECTION", "JSON_KEY_CHALLENGE", "JSON_KEY_CLIENT_DATA", "JSON_KEY_DISPLAY_NAME", "JSON_KEY_EXCLUDE_CREDENTIALS", "JSON_KEY_EXTENSTIONS", "JSON_KEY_ICON", "JSON_KEY_ID", "JSON_KEY_KEY_PROTECTION_TYPE", "JSON_KEY_MATCHER_PROTECTION_TYPE", "JSON_KEY_NAME", "JSON_KEY_PUB_KEY_CRED_PARAMS", "JSON_KEY_RAW_ID", "JSON_KEY_REQUIRE_RES_KEY", "JSON_KEY_RESPONSE", "JSON_KEY_RES_KEY", "JSON_KEY_RP", "JSON_KEY_RPID", "JSON_KEY_SIGNATURE", "JSON_KEY_THIRD_PARTY_PAYMENT", "JSON_KEY_TIMEOUT", "JSON_KEY_TRANSPORTS", "JSON_KEY_TYPE", "JSON_KEY_USER", "JSON_KEY_USER_HANDLE", "JSON_KEY_USER_VERIFICATION_METHOD", "TAG", "orderedErrorCodeToExceptions", "Ljava/util/LinkedHashMap;", "Lcom/google/android/gms/fido/fido2/api/common/ErrorCode;", "Landroidx/credentials/exceptions/domerrors/DomError;", "Lkotlin/collections/LinkedHashMap;", "getOrderedErrorCodeToExceptions$credentials_play_services_auth_release", "()Ljava/util/LinkedHashMap;", "addOptionalAuthenticatorAttachmentAndExtensions", "", "cred", "Lcom/google/android/gms/fido/fido2/api/common/PublicKeyCredential;", "json", "Lorg/json/JSONObject;", "b64Decode", "", "str", "b64Encode", "data", "beginSignInAssertionResponse", "authenticatorResponse", "Lcom/google/android/gms/fido/fido2/api/common/AuthenticatorAssertionResponse;", "publicKeyCred", "beginSignInPublicKeyCredentialResponseContainsError", "Landroidx/credentials/exceptions/GetCredentialException;", "Lcom/google/android/gms/fido/fido2/api/common/AuthenticatorErrorResponse;", "checkAlgSupported", "", "alg", "convert", "Lcom/google/android/gms/fido/fido2/api/common/PublicKeyCredentialCreationOptions;", "request", "Landroidx/credentials/CreatePublicKeyCredentialRequest;", "convertToPlayAuthPasskeyJsonRequest", "Lcom/google/android/gms/auth/api/identity/BeginSignInRequest$PasskeyJsonRequestOptions;", "option", "Landroidx/credentials/GetPublicKeyCredentialOption;", "convertToPlayAuthPasskeyRequest", "Lcom/google/android/gms/auth/api/identity/BeginSignInRequest$PasskeysRequestOptions;", "convertToProperNamingScheme", "", "Lcom/google/android/gms/fido/fido2/api/common/AuthenticatorAttestationResponse;", "(Lcom/google/android/gms/fido/fido2/api/common/AuthenticatorAttestationResponse;)[Ljava/lang/String;", "getChallenge", "parseOptionalAuthenticatorSelection", "builder", "Lcom/google/android/gms/fido/fido2/api/common/PublicKeyCredentialCreationOptions$Builder;", "parseOptionalAuthenticatorSelection$credentials_play_services_auth_release", "parseOptionalExtensions", "parseOptionalExtensions$credentials_play_services_auth_release", "parseOptionalTimeout", "parseOptionalTimeout$credentials_play_services_auth_release", "parseOptionalWithRequiredDefaultsAttestationAndExcludeCredentials", "parseOptionalWithRequiredDefaultsAttestationAndExcludeCredentials$credentials_play_services_auth_release", "parseRequiredChallengeAndUser", "parseRequiredChallengeAndUser$credentials_play_services_auth_release", "parseRequiredRpAndParams", "parseRequiredRpAndParams$credentials_play_services_auth_release", "publicKeyCredentialResponseContainsError", "Landroidx/credentials/exceptions/CreateCredentialException;", "toAssertPasskeyResponse", "Lcom/google/android/gms/auth/api/identity/SignInCredential;", "toCreatePasskeyResponseJson", "credentials-play-services-auth_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PublicKeyCredentialCreationOptions convert(@NotNull CreatePublicKeyCredentialRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            String requestJson = request.getRequestJson();
            JSONObject json = new JSONObject(requestJson);
            PublicKeyCredentialCreationOptions.Builder builder = new PublicKeyCredentialCreationOptions.Builder();
            this.parseRequiredChallengeAndUser$credentials_play_services_auth_release(json, builder);
            this.parseRequiredRpAndParams$credentials_play_services_auth_release(json, builder);
            this.parseOptionalWithRequiredDefaultsAttestationAndExcludeCredentials$credentials_play_services_auth_release(json, builder);
            this.parseOptionalTimeout$credentials_play_services_auth_release(json, builder);
            this.parseOptionalAuthenticatorSelection$credentials_play_services_auth_release(json, builder);
            this.parseOptionalExtensions$credentials_play_services_auth_release(json, builder);
            PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)publicKeyCredentialCreationOptions, (String)"builder.build()");
            return publicKeyCredentialCreationOptions;
        }

        @NotNull
        public final String toCreatePasskeyResponseJson(@NotNull PublicKeyCredential cred) {
            Intrinsics.checkNotNullParameter((Object)cred, (String)"cred");
            JSONObject json = new JSONObject();
            AuthenticatorResponse authenticatorResponse = cred.getResponse();
            Intrinsics.checkNotNullExpressionValue((Object)authenticatorResponse, (String)"cred.response");
            AuthenticatorResponse authenticatorResponse2 = authenticatorResponse;
            if (authenticatorResponse2 instanceof AuthenticatorAttestationResponse) {
                JSONObject responseJson = new JSONObject();
                String string = JSON_KEY_CLIENT_DATA;
                byte[] byArray = ((AuthenticatorAttestationResponse)authenticatorResponse2).getClientDataJSON();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"authenticatorResponse.clientDataJSON");
                responseJson.put(string, (Object)this.b64Encode(byArray));
                String string2 = JSON_KEY_ATTESTATION_OBJ;
                byte[] byArray2 = ((AuthenticatorAttestationResponse)authenticatorResponse2).getAttestationObject();
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"authenticatorResponse.attestationObject");
                responseJson.put(string2, (Object)this.b64Encode(byArray2));
                String[] transportArray = this.convertToProperNamingScheme((AuthenticatorAttestationResponse)authenticatorResponse2);
                JSONArray transports = new JSONArray((Object)transportArray);
                responseJson.put(JSON_KEY_TRANSPORTS, (Object)transports);
                json.put(JSON_KEY_RESPONSE, (Object)responseJson);
            } else {
                Log.e((String)PublicKeyCredentialControllerUtility.TAG, (String)("Authenticator response expected registration response but got: " + authenticatorResponse2.getClass().getName()));
            }
            this.addOptionalAuthenticatorAttachmentAndExtensions(cred, json);
            json.put(JSON_KEY_ID, (Object)cred.getId());
            String string = JSON_KEY_RAW_ID;
            byte[] byArray = cred.getRawId();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cred.rawId");
            json.put(string, (Object)this.b64Encode(byArray));
            json.put(JSON_KEY_TYPE, (Object)cred.getType());
            String string3 = json.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"json.toString()");
            return string3;
        }

        private final String[] convertToProperNamingScheme(AuthenticatorAttestationResponse authenticatorResponse) {
            String[] stringArray = authenticatorResponse.getTransports();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"authenticatorResponse.transports");
            String[] transportArray = stringArray;
            int ix = 0;
            int n = transportArray.length;
            for (int i = 0; i < n; ++i) {
                String transport = transportArray[i];
                if (Intrinsics.areEqual((Object)transport, (Object)"cable")) {
                    transportArray[ix] = "hybrid";
                }
                ++ix;
            }
            return transportArray;
        }

        private final void addOptionalAuthenticatorAttachmentAndExtensions(PublicKeyCredential cred, JSONObject json) {
            String authenticatorAttachment = cred.getAuthenticatorAttachment();
            AuthenticationExtensionsClientOutputs clientExtensionResults = cred.getClientExtensionResults();
            if (authenticatorAttachment != null) {
                json.put(JSON_KEY_AUTH_ATTACHMENT, (Object)authenticatorAttachment);
            }
            if (clientExtensionResults != null) {
                try {
                    List uvmEntriesList;
                    UvmEntries uvmEntries;
                    UvmEntries uvmEntries2 = uvmEntries = clientExtensionResults.getUvmEntries();
                    List list = uvmEntriesList = uvmEntries2 != null ? uvmEntries2.getUvmEntryList() : null;
                    if (uvmEntriesList != null) {
                        JSONArray uvmEntriesJSON = new JSONArray();
                        for (UvmEntry entry : uvmEntriesList) {
                            JSONObject uvmEntryJSON = new JSONObject();
                            uvmEntryJSON.put(JSON_KEY_USER_VERIFICATION_METHOD, entry.getUserVerificationMethod());
                            uvmEntryJSON.put(JSON_KEY_KEY_PROTECTION_TYPE, (Object)entry.getKeyProtectionType());
                            uvmEntryJSON.put(JSON_KEY_MATCHER_PROTECTION_TYPE, (Object)entry.getMatcherProtectionType());
                            uvmEntriesJSON.put((Object)uvmEntryJSON);
                        }
                        json.put("uvm", (Object)uvmEntriesJSON);
                    }
                }
                catch (Throwable t) {
                    Log.e((String)PublicKeyCredentialControllerUtility.TAG, (String)("ClientExtensionResults faced possible implementation inconsistency in uvmEntries - " + t));
                }
            }
        }

        @NotNull
        public final String toAssertPasskeyResponse(@NotNull SignInCredential cred) {
            PublicKeyCredential publicKeyCred;
            Intrinsics.checkNotNullParameter((Object)cred, (String)"cred");
            JSONObject json = new JSONObject();
            PublicKeyCredential publicKeyCredential = publicKeyCred = cred.getPublicKeyCredential();
            Object object = publicKeyCredential != null ? publicKeyCredential.getResponse() : null;
            Intrinsics.checkNotNull((Object)object);
            AuthenticatorResponse authenticatorResponse = object;
            if (authenticatorResponse instanceof AuthenticatorErrorResponse) {
                throw this.beginSignInPublicKeyCredentialResponseContainsError((AuthenticatorErrorResponse)authenticatorResponse);
            }
            if (authenticatorResponse instanceof AuthenticatorAssertionResponse) {
                this.beginSignInAssertionResponse((AuthenticatorAssertionResponse)authenticatorResponse, json, publicKeyCred);
            } else {
                Log.e((String)PublicKeyCredentialControllerUtility.TAG, (String)("AuthenticatorResponse expected assertion response but got: " + authenticatorResponse.getClass().getName()));
            }
            String string = json.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.toString()");
            return string;
        }

        private final void beginSignInAssertionResponse(AuthenticatorAssertionResponse authenticatorResponse, JSONObject json, PublicKeyCredential publicKeyCred) {
            JSONObject responseJson = new JSONObject();
            String string = JSON_KEY_CLIENT_DATA;
            byte[] byArray = authenticatorResponse.getClientDataJSON();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"authenticatorResponse.clientDataJSON");
            responseJson.put(string, (Object)this.b64Encode(byArray));
            String string2 = JSON_KEY_AUTH_DATA;
            byte[] byArray2 = authenticatorResponse.getAuthenticatorData();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"authenticatorResponse.authenticatorData");
            responseJson.put(string2, (Object)this.b64Encode(byArray2));
            String string3 = JSON_KEY_SIGNATURE;
            byte[] byArray3 = authenticatorResponse.getSignature();
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"authenticatorResponse.signature");
            responseJson.put(string3, (Object)this.b64Encode(byArray3));
            byte[] byArray4 = authenticatorResponse.getUserHandle();
            if (byArray4 != null) {
                byte[] it = byArray4;
                boolean bl = false;
                String string4 = JSON_KEY_USER_HANDLE;
                byte[] byArray5 = authenticatorResponse.getUserHandle();
                Intrinsics.checkNotNull((Object)byArray5);
                responseJson.put(string4, (Object)Companion.b64Encode(byArray5));
            }
            json.put(JSON_KEY_RESPONSE, (Object)responseJson);
            json.put(JSON_KEY_ID, (Object)publicKeyCred.getId());
            String string5 = JSON_KEY_RAW_ID;
            byte[] byArray6 = publicKeyCred.getRawId();
            Intrinsics.checkNotNullExpressionValue((Object)byArray6, (String)"publicKeyCred.rawId");
            json.put(string5, (Object)this.b64Encode(byArray6));
            json.put(JSON_KEY_TYPE, (Object)publicKeyCred.getType());
        }

        @NotNull
        public final BeginSignInRequest.PasskeyJsonRequestOptions convertToPlayAuthPasskeyJsonRequest(@NotNull GetPublicKeyCredentialOption option) {
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            BeginSignInRequest.PasskeyJsonRequestOptions passkeyJsonRequestOptions = new BeginSignInRequest.PasskeyJsonRequestOptions.Builder().setSupported(true).setRequestJson(option.getRequestJson()).build();
            Intrinsics.checkNotNullExpressionValue((Object)passkeyJsonRequestOptions, (String)"Builder()\n              \u2026\n                .build()");
            return passkeyJsonRequestOptions;
        }

        @Deprecated(message="Upgrade GMS version so 'convertToPlayAuthPasskeyJsoNRequest' is used")
        @NotNull
        public final BeginSignInRequest.PasskeysRequestOptions convertToPlayAuthPasskeyRequest(@NotNull GetPublicKeyCredentialOption option) {
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            JSONObject json = new JSONObject(option.getRequestJson());
            String rpId = json.optString(JSON_KEY_RPID, "");
            Intrinsics.checkNotNullExpressionValue((Object)rpId, (String)"rpId");
            if (((CharSequence)rpId).length() == 0) {
                throw new JSONException("GetPublicKeyCredentialOption - rpId not specified in the request or is unexpectedly empty");
            }
            byte[] challenge = this.getChallenge(json);
            BeginSignInRequest.PasskeysRequestOptions passkeysRequestOptions = new BeginSignInRequest.PasskeysRequestOptions.Builder().setSupported(true).setRpId(rpId).setChallenge(challenge).build();
            Intrinsics.checkNotNullExpressionValue((Object)passkeysRequestOptions, (String)"Builder()\n              \u2026\n                .build()");
            return passkeysRequestOptions;
        }

        private final byte[] getChallenge(JSONObject json) {
            String challengeB64 = json.optString(JSON_KEY_CHALLENGE, "");
            Intrinsics.checkNotNullExpressionValue((Object)challengeB64, (String)"challengeB64");
            if (((CharSequence)challengeB64).length() == 0) {
                throw new JSONException("Challenge not found in request or is unexpectedly empty");
            }
            return this.b64Decode(challengeB64);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final CreateCredentialException publicKeyCredentialResponseContainsError(@NotNull PublicKeyCredential cred) {
            Intrinsics.checkNotNullParameter((Object)cred, (String)"cred");
            AuthenticatorResponse authenticatorResponse = cred.getResponse();
            Intrinsics.checkNotNullExpressionValue((Object)authenticatorResponse, (String)"cred.response");
            AuthenticatorResponse authenticatorResponse2 = authenticatorResponse;
            if (!(authenticatorResponse2 instanceof AuthenticatorErrorResponse)) return null;
            ErrorCode errorCode = ((AuthenticatorErrorResponse)authenticatorResponse2).getErrorCode();
            Intrinsics.checkNotNullExpressionValue((Object)errorCode, (String)"authenticatorResponse.errorCode");
            ErrorCode code = errorCode;
            DomError exceptionError = this.getOrderedErrorCodeToExceptions$credentials_play_services_auth_release().get(code);
            String msg = ((AuthenticatorErrorResponse)authenticatorResponse2).getErrorMessage();
            CreateCredentialException exception = null;
            if (exceptionError == null) {
                return (CreateCredentialException)new CreatePublicKeyCredentialDomException((DomError)new UnknownError(), (CharSequence)("unknown fido gms exception - " + msg));
            }
            if (code != ErrorCode.CONSTRAINT_ERR) return (CreateCredentialException)new CreatePublicKeyCredentialDomException(exceptionError, (CharSequence)msg);
            String string = msg;
            if (!(string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Unable to get sync account", (boolean)false, (int)2, null) : false)) return (CreateCredentialException)new CreatePublicKeyCredentialDomException(exceptionError, (CharSequence)msg);
            return (CreateCredentialException)new CreateCredentialCancellationException((CharSequence)"Passkey registration was cancelled by the user.");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final GetCredentialException beginSignInPublicKeyCredentialResponseContainsError(AuthenticatorErrorResponse authenticatorResponse) {
            ErrorCode errorCode = authenticatorResponse.getErrorCode();
            Intrinsics.checkNotNullExpressionValue((Object)errorCode, (String)"authenticatorResponse.errorCode");
            ErrorCode code = errorCode;
            DomError exceptionError = this.getOrderedErrorCodeToExceptions$credentials_play_services_auth_release().get(code);
            String msg = authenticatorResponse.getErrorMessage();
            GetCredentialException exception = null;
            if (exceptionError == null) {
                return (GetCredentialException)new GetPublicKeyCredentialDomException((DomError)new UnknownError(), (CharSequence)("unknown fido gms exception - " + msg));
            }
            if (code != ErrorCode.CONSTRAINT_ERR) return (GetCredentialException)new GetPublicKeyCredentialDomException(exceptionError, (CharSequence)msg);
            String string = msg;
            if (!(string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Unable to get sync account", (boolean)false, (int)2, null) : false)) return (GetCredentialException)new GetPublicKeyCredentialDomException(exceptionError, (CharSequence)msg);
            return (GetCredentialException)new GetCredentialCancellationException((CharSequence)"Passkey retrieval was cancelled by the user.");
        }

        public final void parseOptionalExtensions$credentials_play_services_auth_release(@NotNull JSONObject json, @NotNull PublicKeyCredentialCreationOptions.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            if (json.has(JSON_KEY_EXTENSTIONS)) {
                boolean uvmStatus;
                boolean thirdPartyPaymentExtension;
                JSONObject extensions = json.getJSONObject(JSON_KEY_EXTENSTIONS);
                AuthenticationExtensions.Builder extensionBuilder = new AuthenticationExtensions.Builder();
                String appIdExtension = extensions.optString(JSON_KEY_APPID, "");
                Intrinsics.checkNotNullExpressionValue((Object)appIdExtension, (String)"appIdExtension");
                if (((CharSequence)appIdExtension).length() > 0) {
                    extensionBuilder.setFido2Extension(new FidoAppIdExtension(appIdExtension));
                }
                if (thirdPartyPaymentExtension = extensions.optBoolean(JSON_KEY_THIRD_PARTY_PAYMENT, false)) {
                    extensionBuilder.setGoogleThirdPartyPaymentExtension(new GoogleThirdPartyPaymentExtension(true));
                }
                if (uvmStatus = extensions.optBoolean("uvm", false)) {
                    extensionBuilder.setUserVerificationMethodExtension(new UserVerificationMethodExtension(true));
                }
                builder.setAuthenticationExtensions(extensionBuilder.build());
            }
        }

        public final void parseOptionalAuthenticatorSelection$credentials_play_services_auth_release(@NotNull JSONObject json, @NotNull PublicKeyCredentialCreationOptions.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            if (json.has(JSON_KEY_AUTH_SELECTION)) {
                JSONObject authenticatorSelection = json.getJSONObject(JSON_KEY_AUTH_SELECTION);
                AuthenticatorSelectionCriteria.Builder authSelectionBuilder = new AuthenticatorSelectionCriteria.Builder();
                boolean requireResidentKey = authenticatorSelection.optBoolean(JSON_KEY_REQUIRE_RES_KEY, false);
                String residentKey = authenticatorSelection.optString(JSON_KEY_RES_KEY, "");
                ResidentKeyRequirement residentKeyRequirement = null;
                Intrinsics.checkNotNullExpressionValue((Object)residentKey, (String)"residentKey");
                if (((CharSequence)residentKey).length() > 0) {
                    residentKeyRequirement = ResidentKeyRequirement.fromString((String)residentKey);
                }
                authSelectionBuilder.setRequireResidentKey(Boolean.valueOf(requireResidentKey)).setResidentKeyRequirement(residentKeyRequirement);
                String authenticatorAttachmentString = authenticatorSelection.optString(JSON_KEY_AUTH_ATTACHMENT, "");
                Intrinsics.checkNotNullExpressionValue((Object)authenticatorAttachmentString, (String)"authenticatorAttachmentString");
                if (((CharSequence)authenticatorAttachmentString).length() > 0) {
                    authSelectionBuilder.setAttachment(Attachment.fromString((String)authenticatorAttachmentString));
                }
                builder.setAuthenticatorSelection(authSelectionBuilder.build());
            }
        }

        public final void parseOptionalTimeout$credentials_play_services_auth_release(@NotNull JSONObject json, @NotNull PublicKeyCredentialCreationOptions.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            if (json.has(JSON_KEY_TIMEOUT)) {
                double timeout = (double)json.getLong(JSON_KEY_TIMEOUT) / (double)1000;
                builder.setTimeoutSeconds(Double.valueOf(timeout));
            }
        }

        public final void parseOptionalWithRequiredDefaultsAttestationAndExcludeCredentials$credentials_play_services_auth_release(@NotNull JSONObject json, @NotNull PublicKeyCredentialCreationOptions.Builder builder) {
            String attestationString;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            List excludeCredentialsList = new ArrayList();
            if (json.has(JSON_KEY_EXCLUDE_CREDENTIALS)) {
                JSONArray pubKeyDescriptorJSONs = json.getJSONArray(JSON_KEY_EXCLUDE_CREDENTIALS);
                int n = pubKeyDescriptorJSONs.length();
                for (int i = 0; i < n; ++i) {
                    JSONObject descriptorJSON = pubKeyDescriptorJSONs.getJSONObject(i);
                    String string = descriptorJSON.getString(JSON_KEY_ID);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptorJSON.getString(JSON_KEY_ID)");
                    byte[] descriptorId = this.b64Decode(string);
                    String descriptorType = descriptorJSON.getString(JSON_KEY_TYPE);
                    Intrinsics.checkNotNullExpressionValue((Object)descriptorType, (String)"descriptorType");
                    if (((CharSequence)descriptorType).length() == 0) {
                        throw new JSONException("PublicKeyCredentialDescriptor type value is not found or unexpectedly empty");
                    }
                    if (descriptorId.length == 0) {
                        throw new JSONException("PublicKeyCredentialDescriptor id value is not found or unexpectedly empty");
                    }
                    List transports = null;
                    if (descriptorJSON.has(JSON_KEY_TRANSPORTS)) {
                        transports = new ArrayList();
                        JSONArray descriptorTransports = descriptorJSON.getJSONArray(JSON_KEY_TRANSPORTS);
                        int n2 = descriptorTransports.length();
                        for (int j = 0; j < n2; ++j) {
                            try {
                                ArrayList arrayList = (ArrayList)transports;
                                Transport transport = Transport.fromString((String)descriptorTransports.getString(j));
                                Intrinsics.checkNotNullExpressionValue((Object)transport, (String)"fromString(\n            \u2026rTransports.getString(j))");
                                arrayList.add(transport);
                                continue;
                            }
                            catch (Transport.UnsupportedTransportException e) {
                                throw new CreatePublicKeyCredentialDomException((DomError)new EncodingError(), (CharSequence)e.getMessage());
                            }
                        }
                    }
                    excludeCredentialsList.add(new PublicKeyCredentialDescriptor(descriptorType, descriptorId, transports));
                }
            }
            builder.setExcludeList(excludeCredentialsList);
            String string = attestationString = json.optString(JSON_KEY_ATTESTATION, "none");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attestationString");
            if (((CharSequence)string).length() == 0) {
                attestationString = "none";
            }
            builder.setAttestationConveyancePreference(AttestationConveyancePreference.fromString((String)attestationString));
        }

        public final void parseRequiredRpAndParams$credentials_play_services_auth_release(@NotNull JSONObject json, @NotNull PublicKeyCredentialCreationOptions.Builder builder) {
            String rpIcon;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            JSONObject rp = json.getJSONObject(JSON_KEY_RP);
            String rpId = rp.getString(JSON_KEY_ID);
            String rpName = rp.optString(JSON_KEY_NAME, "");
            String string = rpIcon = rp.optString(JSON_KEY_ICON, "");
            Intrinsics.checkNotNull((Object)string);
            if (((CharSequence)string).length() == 0) {
                rpIcon = null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)rpName, (String)"rpName");
            if (((CharSequence)rpName).length() == 0) {
                throw new JSONException("PublicKeyCredentialCreationOptions rp name is missing or unexpectedly empty");
            }
            Intrinsics.checkNotNullExpressionValue((Object)rpId, (String)"rpId");
            if (((CharSequence)rpId).length() == 0) {
                throw new JSONException("PublicKeyCredentialCreationOptions rp ID is missing or unexpectedly empty");
            }
            builder.setRp(new PublicKeyCredentialRpEntity(rpId, rpName, rpIcon));
            JSONArray pubKeyCredParams = json.getJSONArray(JSON_KEY_PUB_KEY_CRED_PARAMS);
            List paramsList = new ArrayList();
            int n = pubKeyCredParams.length();
            for (int i = 0; i < n; ++i) {
                JSONObject param = pubKeyCredParams.getJSONObject(i);
                int paramAlg = (int)param.getLong(JSON_KEY_ALG);
                String typeParam = param.optString(JSON_KEY_TYPE, "");
                Intrinsics.checkNotNullExpressionValue((Object)typeParam, (String)"typeParam");
                if (((CharSequence)typeParam).length() == 0) {
                    throw new JSONException("PublicKeyCredentialCreationOptions PublicKeyCredentialParameter type missing or unexpectedly empty");
                }
                if (!this.checkAlgSupported(paramAlg)) continue;
                paramsList.add(new PublicKeyCredentialParameters(typeParam, paramAlg));
            }
            builder.setParameters(paramsList);
        }

        public final void parseRequiredChallengeAndUser$credentials_play_services_auth_release(@NotNull JSONObject json, @NotNull PublicKeyCredentialCreationOptions.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            byte[] challenge = this.getChallenge(json);
            builder.setChallenge(challenge);
            JSONObject user = json.getJSONObject(JSON_KEY_USER);
            String string = user.getString(JSON_KEY_ID);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"user.getString(JSON_KEY_ID)");
            byte[] userId = this.b64Decode(string);
            String userName = user.getString(JSON_KEY_NAME);
            String displayName = user.getString(JSON_KEY_DISPLAY_NAME);
            String userIcon = user.optString(JSON_KEY_ICON, "");
            Intrinsics.checkNotNullExpressionValue((Object)displayName, (String)"displayName");
            if (((CharSequence)displayName).length() == 0) {
                throw new JSONException("PublicKeyCredentialCreationOptions UserEntity missing displayName or they are unexpectedly empty");
            }
            if (userId.length == 0) {
                throw new JSONException("PublicKeyCredentialCreationOptions UserEntity missing user id or they are unexpectedly empty");
            }
            Intrinsics.checkNotNullExpressionValue((Object)userName, (String)"userName");
            if (((CharSequence)userName).length() == 0) {
                throw new JSONException("PublicKeyCredentialCreationOptions UserEntity missing user name or they are unexpectedly empty");
            }
            builder.setUser(new PublicKeyCredentialUserEntity(userId, userName, userIcon, displayName));
        }

        @NotNull
        public final byte[] b64Decode(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            byte[] byArray = Base64.decode((String)str, (int)11);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(str, FLAGS)");
            return byArray;
        }

        @NotNull
        public final String b64Encode(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            String string = Base64.encodeToString((byte[])data, (int)11);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(data, FLAGS)");
            return string;
        }

        public final boolean checkAlgSupported(int alg) {
            try {
                COSEAlgorithmIdentifier.fromCoseValue((int)alg);
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        @NotNull
        public final LinkedHashMap<ErrorCode, DomError> getOrderedErrorCodeToExceptions$credentials_play_services_auth_release() {
            return orderedErrorCodeToExceptions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

