/*
 * Decompiled with CFR 0.152.
 */
package androidx.credentials.playservices.controllers.BeginSignIn;

import android.content.Context;
import android.content.pm.PackageManager;
import androidx.credentials.CredentialOption;
import androidx.credentials.GetCredentialRequest;
import androidx.credentials.GetPasswordOption;
import androidx.credentials.GetPublicKeyCredentialOption;
import androidx.credentials.playservices.controllers.CreatePublicKeyCredential.PublicKeyCredentialControllerUtility;
import com.google.android.gms.auth.api.identity.BeginSignInRequest;
import com.google.android.libraries.identity.googleid.GetGoogleIdOption;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Landroidx/credentials/playservices/controllers/BeginSignIn/BeginSignInControllerUtility;", "", "()V", "Companion", "credentials-play-services-auth_release"})
public final class BeginSignInControllerUtility {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "BeginSignInUtility";
    private static final long AUTH_MIN_VERSION_JSON_PARSING = 231815000L;
    private static final long AUTH_MIN_VERSION_PREFER_IMME_CRED = 241217000L;

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/credentials/playservices/controllers/BeginSignIn/BeginSignInControllerUtility$Companion;", "", "()V", "AUTH_MIN_VERSION_JSON_PARSING", "", "AUTH_MIN_VERSION_PREFER_IMME_CRED", "TAG", "", "constructBeginSignInRequest", "Lcom/google/android/gms/auth/api/identity/BeginSignInRequest;", "request", "Landroidx/credentials/GetCredentialRequest;", "context", "Landroid/content/Context;", "constructBeginSignInRequest$credentials_play_services_auth_release", "convertToGoogleIdTokenOption", "Lcom/google/android/gms/auth/api/identity/BeginSignInRequest$GoogleIdTokenRequestOptions;", "option", "Lcom/google/android/libraries/identity/googleid/GetGoogleIdOption;", "determineDeviceGMSVersionCode", "needsBackwardsCompatibleRequest", "", "curAuthVersion", "credentials-play-services-auth_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BeginSignInRequest constructBeginSignInRequest$credentials_play_services_auth_release(@NotNull GetCredentialRequest request, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            boolean isPublicKeyCredReqFound = false;
            BeginSignInRequest.Builder requestBuilder = new BeginSignInRequest.Builder();
            boolean autoSelect = false;
            long curAuthVersion = this.determineDeviceGMSVersionCode(context);
            for (CredentialOption option : request.getCredentialOptions()) {
                if (option instanceof GetPasswordOption) {
                    requestBuilder.setPasswordRequestOptions(new BeginSignInRequest.PasswordRequestOptions.Builder().setSupported(true).build());
                    autoSelect = autoSelect || option.isAutoSelectAllowed();
                    continue;
                }
                if (option instanceof GetPublicKeyCredentialOption && !isPublicKeyCredReqFound) {
                    if (this.needsBackwardsCompatibleRequest(curAuthVersion)) {
                        requestBuilder.setPasskeysSignInRequestOptions(PublicKeyCredentialControllerUtility.Companion.convertToPlayAuthPasskeyRequest((GetPublicKeyCredentialOption)option));
                    } else {
                        requestBuilder.setPasskeyJsonSignInRequestOptions(PublicKeyCredentialControllerUtility.Companion.convertToPlayAuthPasskeyJsonRequest((GetPublicKeyCredentialOption)option));
                    }
                    isPublicKeyCredReqFound = true;
                    continue;
                }
                if (!(option instanceof GetGoogleIdOption)) continue;
                requestBuilder.setGoogleIdTokenRequestOptions(this.convertToGoogleIdTokenOption((GetGoogleIdOption)option));
                autoSelect = autoSelect || ((GetGoogleIdOption)option).getAutoSelectEnabled();
            }
            if (curAuthVersion > 241217000L) {
                requestBuilder.setPreferImmediatelyAvailableCredentials(request.preferImmediatelyAvailableCredentials());
            }
            BeginSignInRequest beginSignInRequest = requestBuilder.setAutoSelectEnabled(autoSelect).build();
            Intrinsics.checkNotNullExpressionValue((Object)beginSignInRequest, (String)"requestBuilder.setAutoSe\u2026abled(autoSelect).build()");
            return beginSignInRequest;
        }

        private final long determineDeviceGMSVersionCode(Context context) {
            PackageManager packageManager = context.getPackageManager();
            Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"context.packageManager");
            PackageManager packageManager2 = packageManager;
            String packageName = "com.google.android.gms";
            return packageManager2.getPackageInfo((String)packageName, (int)0).versionCode;
        }

        private final boolean needsBackwardsCompatibleRequest(long curAuthVersion) {
            return curAuthVersion < 231815000L;
        }

        private final BeginSignInRequest.GoogleIdTokenRequestOptions convertToGoogleIdTokenOption(GetGoogleIdOption option) {
            BeginSignInRequest.GoogleIdTokenRequestOptions.Builder builder = BeginSignInRequest.GoogleIdTokenRequestOptions.builder().setFilterByAuthorizedAccounts(option.getFilterByAuthorizedAccounts()).setNonce(option.getNonce()).setRequestVerifiedPhoneNumber(option.getRequestVerifiedPhoneNumber()).setServerClientId(option.getServerClientId()).setSupported(true);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder()\n              \u2026      .setSupported(true)");
            BeginSignInRequest.GoogleIdTokenRequestOptions.Builder idTokenOption = builder;
            if (option.getLinkedServiceId() != null) {
                String string = option.getLinkedServiceId();
                Intrinsics.checkNotNull((Object)string);
                idTokenOption.associateLinkedAccounts(string, option.getIdTokenDepositionScopes());
            }
            BeginSignInRequest.GoogleIdTokenRequestOptions googleIdTokenRequestOptions = idTokenOption.build();
            Intrinsics.checkNotNullExpressionValue((Object)googleIdTokenRequestOptions, (String)"idTokenOption.build()");
            return googleIdTokenRequestOptions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

