/*
 * Decompiled with CFR 0.152.
 */
package androidx.credentials.playservices.controllers.GetSignInIntent;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.credentials.Credential;
import androidx.credentials.CredentialManagerCallback;
import androidx.credentials.GetCredentialRequest;
import androidx.credentials.GetCredentialResponse;
import androidx.credentials.exceptions.GetCredentialCancellationException;
import androidx.credentials.exceptions.GetCredentialException;
import androidx.credentials.exceptions.GetCredentialInterruptedException;
import androidx.credentials.exceptions.GetCredentialUnknownException;
import androidx.credentials.exceptions.GetCredentialUnsupportedException;
import androidx.credentials.playservices.CredentialProviderPlayServicesImpl;
import androidx.credentials.playservices.HiddenActivity;
import androidx.credentials.playservices.controllers.CredentialProviderBaseController;
import androidx.credentials.playservices.controllers.CredentialProviderController;
import androidx.credentials.playservices.controllers.GetSignInIntent.CredentialProviderGetSignInIntentController;
import com.google.android.gms.auth.api.identity.GetSignInIntentRequest;
import com.google.android.gms.auth.api.identity.Identity;
import com.google.android.gms.auth.api.identity.SignInCredential;
import com.google.android.gms.common.api.ApiException;
import com.google.android.libraries.identity.googleid.GetSignInWithGoogleOption;
import com.google.android.libraries.identity.googleid.GoogleIdTokenCredential;
import java.util.Collection;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u001d\b\u0000\u0018\u0000 .2 \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0001:\u0001.B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0002H\u0017J\u0010\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0004H\u0014J\u0010\u0010#\u001a\u00020$2\u0006\u0010\"\u001a\u00020\u0004H\u0007J'\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\b\u0010*\u001a\u0004\u0018\u00010+H\u0000\u00a2\u0006\u0002\b,J6\u0010-\u001a\u00020&2\u0006\u0010 \u001a\u00020\u00022\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R0\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u000b8\u0006@\u0006X\u0087.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u00020\u00168\u0006@\u0006X\u0087.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0017\u0010\r\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001e\u00a8\u0006/"}, d2={"Landroidx/credentials/playservices/controllers/GetSignInIntent/CredentialProviderGetSignInIntentController;", "Landroidx/credentials/playservices/controllers/CredentialProviderController;", "Landroidx/credentials/GetCredentialRequest;", "Lcom/google/android/gms/auth/api/identity/GetSignInIntentRequest;", "Lcom/google/android/gms/auth/api/identity/SignInCredential;", "Landroidx/credentials/GetCredentialResponse;", "Landroidx/credentials/exceptions/GetCredentialException;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "callback", "Landroidx/credentials/CredentialManagerCallback;", "getCallback$annotations", "()V", "getCallback", "()Landroidx/credentials/CredentialManagerCallback;", "setCallback", "(Landroidx/credentials/CredentialManagerCallback;)V", "cancellationSignal", "Landroid/os/CancellationSignal;", "getCancellationSignal$annotations", "executor", "Ljava/util/concurrent/Executor;", "getExecutor$annotations", "getExecutor", "()Ljava/util/concurrent/Executor;", "setExecutor", "(Ljava/util/concurrent/Executor;)V", "resultReceiver", "androidx/credentials/playservices/controllers/GetSignInIntent/CredentialProviderGetSignInIntentController$resultReceiver$1", "Landroidx/credentials/playservices/controllers/GetSignInIntent/CredentialProviderGetSignInIntentController$resultReceiver$1;", "convertRequestToPlayServices", "request", "convertResponseToCredentialManager", "response", "createGoogleIdCredential", "Lcom/google/android/libraries/identity/googleid/GoogleIdTokenCredential;", "handleResponse", "", "uniqueRequestCode", "", "resultCode", "data", "Landroid/content/Intent;", "handleResponse$credentials_play_services_auth_release", "invokePlayServices", "Companion", "credentials-play-services-auth_release"})
public final class CredentialProviderGetSignInIntentController
extends CredentialProviderController<GetCredentialRequest, GetSignInIntentRequest, SignInCredential, GetCredentialResponse, GetCredentialException> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    public CredentialManagerCallback<GetCredentialResponse, GetCredentialException> callback;
    public Executor executor;
    @Nullable
    private CancellationSignal cancellationSignal;
    @NotNull
    private final resultReceiver.1 resultReceiver;
    @NotNull
    private static final String TAG = "GetSignInIntent";

    public CredentialProviderGetSignInIntentController(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.context = context;
        Handler handler = new Handler(Looper.getMainLooper());
        this.resultReceiver = new ResultReceiver(this, handler){
            final /* synthetic */ CredentialProviderGetSignInIntentController this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void onReceiveResult(int resultCode, @NotNull Bundle resultData) {
                Intrinsics.checkNotNullParameter((Object)resultData, (String)"resultData");
                if (CredentialProviderGetSignInIntentController.access$maybeReportErrorFromResultReceiver(this.this$0, resultData, (Function2)new Function2<String, String, GetCredentialException>((Object)CredentialProviderBaseController.Companion){

                    @NotNull
                    public final GetCredentialException invoke(@Nullable String p0, @Nullable String p1) {
                        return ((CredentialProviderBaseController.Companion)this.receiver).getCredentialExceptionTypeToException$credentials_play_services_auth_release(p0, p1);
                    }
                }, this.this$0.getExecutor(), this.this$0.getCallback(), CredentialProviderGetSignInIntentController.access$getCancellationSignal$p(this.this$0))) {
                    return;
                }
                this.this$0.handleResponse$credentials_play_services_auth_release(resultData.getInt("ACTIVITY_REQUEST_CODE"), resultCode, (Intent)resultData.getParcelable("RESULT_DATA"));
            }
        };
    }

    @NotNull
    public final CredentialManagerCallback<GetCredentialResponse, GetCredentialException> getCallback() {
        CredentialManagerCallback<GetCredentialResponse, GetCredentialException> credentialManagerCallback = this.callback;
        if (credentialManagerCallback != null) {
            return credentialManagerCallback;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"callback");
        return null;
    }

    public final void setCallback(@NotNull CredentialManagerCallback<GetCredentialResponse, GetCredentialException> credentialManagerCallback) {
        Intrinsics.checkNotNullParameter(credentialManagerCallback, (String)"<set-?>");
        this.callback = credentialManagerCallback;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCallback$annotations() {
    }

    @NotNull
    public final Executor getExecutor() {
        Executor executor = this.executor;
        if (executor != null) {
            return executor;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
        return null;
    }

    public final void setExecutor(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"<set-?>");
        this.executor = executor;
    }

    @VisibleForTesting
    public static /* synthetic */ void getExecutor$annotations() {
    }

    @VisibleForTesting
    private static /* synthetic */ void getCancellationSignal$annotations() {
    }

    @Override
    public void invokePlayServices(@NotNull GetCredentialRequest request, @NotNull CredentialManagerCallback<GetCredentialResponse, GetCredentialException> callback, @NotNull Executor executor, @Nullable CancellationSignal cancellationSignal) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.cancellationSignal = cancellationSignal;
        this.setCallback(callback);
        this.setExecutor(executor);
        if (CredentialProviderPlayServicesImpl.Companion.cancellationReviewer$credentials_play_services_auth_release(cancellationSignal)) {
            return;
        }
        try {
            GetSignInIntentRequest convertedRequest = this.convertRequestToPlayServices(request);
            Intent hiddenIntent = new Intent(this.context, HiddenActivity.class);
            hiddenIntent.putExtra("REQUEST_TYPE", (Parcelable)convertedRequest);
            this.generateHiddenActivityIntent(this.resultReceiver, hiddenIntent, "SIGN_IN_INTENT");
            this.context.startActivity(hiddenIntent);
        }
        catch (Exception e) {
            if (e instanceof GetCredentialUnsupportedException) {
                CredentialProviderController.cancelOrCallbackExceptionOrResult(cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>(this, e){
                    final /* synthetic */ CredentialProviderGetSignInIntentController this$0;
                    final /* synthetic */ Exception $e;
                    {
                        this.this$0 = $receiver;
                        this.$e = $e;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.getExecutor().execute(() -> invokePlayServices.1.invoke$lambda$0(this.this$0, this.$e));
                    }

                    private static final void invoke$lambda$0(CredentialProviderGetSignInIntentController this$0, Exception $e) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
                        this$0.getCallback().onError((Object)$e);
                    }
                }));
            }
            CredentialProviderController.cancelOrCallbackExceptionOrResult(cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ CredentialProviderGetSignInIntentController this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.getExecutor().execute(() -> invokePlayServices.2.invoke$lambda$0(this.this$0));
                }

                private static final void invoke$lambda$0(CredentialProviderGetSignInIntentController this$0) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    this$0.getCallback().onError((Object)new GetCredentialUnknownException((CharSequence)"Failed to launch the selector UI. Hint: ensure the `context` parameter is an Activity-based context."));
                }
            }));
        }
    }

    @Override
    @VisibleForTesting
    @NotNull
    public GetSignInIntentRequest convertRequestToPlayServices(@NotNull GetCredentialRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (((Collection)request.getCredentialOptions()).size() != 1) {
            throw new GetCredentialUnsupportedException((CharSequence)"GetSignInWithGoogleOption cannot be combined with other options.");
        }
        Object e = request.getCredentialOptions().get(0);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type com.google.android.libraries.identity.googleid.GetSignInWithGoogleOption");
        GetSignInWithGoogleOption option = (GetSignInWithGoogleOption)e;
        GetSignInIntentRequest getSignInIntentRequest = GetSignInIntentRequest.builder().setServerClientId(option.getServerClientId()).filterByHostedDomain(option.getHostedDomainFilter()).setNonce(option.getNonce()).build();
        Intrinsics.checkNotNullExpressionValue((Object)getSignInIntentRequest, (String)"builder()\n            .s\u2026nce)\n            .build()");
        return getSignInIntentRequest;
    }

    @Override
    @NotNull
    protected GetCredentialResponse convertResponseToCredentialManager(@NotNull SignInCredential response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Credential cred = null;
        if (response.getGoogleIdToken() != null) {
            cred = (Credential)this.createGoogleIdCredential(response);
        } else {
            Log.w((String)TAG, (String)"Credential returned but no google Id found");
        }
        if (cred == null) {
            throw new GetCredentialUnknownException((CharSequence)"When attempting to convert get response, null credential found");
        }
        return new GetCredentialResponse(cred);
    }

    @VisibleForTesting
    @NotNull
    public final GoogleIdTokenCredential createGoogleIdCredential(@NotNull SignInCredential response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        GoogleIdTokenCredential.Builder builder = new GoogleIdTokenCredential.Builder();
        String string = response.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
        GoogleIdTokenCredential.Builder cred = builder.setId(string);
        try {
            String string2 = response.getGoogleIdToken();
            Intrinsics.checkNotNull((Object)string2);
            cred.setIdToken(string2);
        }
        catch (Exception e) {
            throw new GetCredentialUnknownException((CharSequence)"When attempting to convert get response, null Google ID Token found");
        }
        if (response.getDisplayName() != null) {
            cred.setDisplayName(response.getDisplayName());
        }
        if (response.getGivenName() != null) {
            cred.setGivenName(response.getGivenName());
        }
        if (response.getFamilyName() != null) {
            cred.setFamilyName(response.getFamilyName());
        }
        if (response.getPhoneNumber() != null) {
            cred.setPhoneNumber(response.getPhoneNumber());
        }
        if (response.getProfilePictureUri() != null) {
            cred.setProfilePictureUri(response.getProfilePictureUri());
        }
        return cred.build();
    }

    public final void handleResponse$credentials_play_services_auth_release(int uniqueRequestCode, int resultCode, @Nullable Intent data) {
        if (uniqueRequestCode != CredentialProviderBaseController.getCONTROLLER_REQUEST_CODE()) {
            Log.w((String)TAG, (String)("Returned request code " + CredentialProviderBaseController.getCONTROLLER_REQUEST_CODE() + " which  does not match what was given " + uniqueRequestCode));
            return;
        }
        if (CredentialProviderController.maybeReportErrorResultCodeGet(resultCode, (Function2<? super CancellationSignal, ? super Function0<Unit>, Unit>)((Function2)handleResponse.1.INSTANCE), (Function1<? super GetCredentialException, Unit>)((Function1)new Function1<GetCredentialException, Unit>(this){
            final /* synthetic */ CredentialProviderGetSignInIntentController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull GetCredentialException e) {
                Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
                this.this$0.getExecutor().execute(() -> handleResponse.2.invoke$lambda$0(this.this$0, e));
            }

            private static final void invoke$lambda$0(CredentialProviderGetSignInIntentController this$0, GetCredentialException $e) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)((Object)$e), (String)"$e");
                this$0.getCallback().onError((Object)((Object)$e));
            }
        }), this.cancellationSignal)) {
            return;
        }
        try {
            SignInCredential signInCredential = Identity.getSignInClient((Context)this.context).getSignInCredentialFromIntent(data);
            Intrinsics.checkNotNullExpressionValue((Object)signInCredential, (String)"getSignInClient(context)\u2026redentialFromIntent(data)");
            SignInCredential signInCredential2 = signInCredential;
            GetCredentialResponse response = this.convertResponseToCredentialManager(signInCredential2);
            CredentialProviderController.cancelOrCallbackExceptionOrResult(this.cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>(this, response){
                final /* synthetic */ CredentialProviderGetSignInIntentController this$0;
                final /* synthetic */ GetCredentialResponse $response;
                {
                    this.this$0 = $receiver;
                    this.$response = $response;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.getExecutor().execute(() -> handleResponse.3.invoke$lambda$0(this.this$0, this.$response));
                }

                private static final void invoke$lambda$0(CredentialProviderGetSignInIntentController this$0, GetCredentialResponse $response) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$response, (String)"$response");
                    this$0.getCallback().onResult((Object)$response);
                }
            }));
        }
        catch (ApiException e) {
            Ref.ObjectRef exception = new Ref.ObjectRef();
            exception.element = new GetCredentialUnknownException((CharSequence)e.getMessage());
            if (e.getStatusCode() == 16) {
                exception.element = new GetCredentialCancellationException((CharSequence)e.getMessage());
            } else if (CredentialProviderBaseController.Companion.getRetryables().contains(e.getStatusCode())) {
                exception.element = new GetCredentialInterruptedException((CharSequence)e.getMessage());
            }
            CredentialProviderController.cancelOrCallbackExceptionOrResult(this.cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>(this, (Ref.ObjectRef<GetCredentialException>)exception){
                final /* synthetic */ CredentialProviderGetSignInIntentController this$0;
                final /* synthetic */ Ref.ObjectRef<GetCredentialException> $exception;
                {
                    this.this$0 = $receiver;
                    this.$exception = $exception;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.getExecutor().execute(() -> handleResponse.4.invoke$lambda$0(this.this$0, this.$exception));
                }

                private static final void invoke$lambda$0(CredentialProviderGetSignInIntentController this$0, Ref.ObjectRef $exception) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$exception, (String)"$exception");
                    this$0.getCallback().onError($exception.element);
                }
            }));
            return;
        }
        catch (GetCredentialException e) {
            CredentialProviderController.cancelOrCallbackExceptionOrResult(this.cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>(this, e){
                final /* synthetic */ CredentialProviderGetSignInIntentController this$0;
                final /* synthetic */ GetCredentialException $e;
                {
                    this.this$0 = $receiver;
                    this.$e = $e;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.getExecutor().execute(() -> handleResponse.5.invoke$lambda$0(this.this$0, this.$e));
                }

                private static final void invoke$lambda$0(CredentialProviderGetSignInIntentController this$0, GetCredentialException $e) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)((Object)$e), (String)"$e");
                    this$0.getCallback().onError((Object)((Object)$e));
                }
            }));
        }
        catch (Throwable t) {
            GetCredentialUnknownException e = new GetCredentialUnknownException((CharSequence)t.getMessage());
            CredentialProviderController.cancelOrCallbackExceptionOrResult(this.cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>(this, e){
                final /* synthetic */ CredentialProviderGetSignInIntentController this$0;
                final /* synthetic */ GetCredentialUnknownException $e;
                {
                    this.this$0 = $receiver;
                    this.$e = $e;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.getExecutor().execute(() -> handleResponse.6.invoke$lambda$0(this.this$0, this.$e));
                }

                private static final void invoke$lambda$0(CredentialProviderGetSignInIntentController this$0, GetCredentialUnknownException $e) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
                    this$0.getCallback().onError((Object)$e);
                }
            }));
        }
    }

    @JvmStatic
    @NotNull
    public static final CredentialProviderGetSignInIntentController getInstance(@NotNull Context context) {
        return Companion.getInstance(context);
    }

    public static final /* synthetic */ void access$cancelOrCallbackExceptionOrResult$s895630660(CancellationSignal cancellationSignal, Function0 onResultOrException) {
        CredentialProviderController.cancelOrCallbackExceptionOrResult(cancellationSignal, (Function0<Unit>)onResultOrException);
    }

    public static final /* synthetic */ boolean access$maybeReportErrorFromResultReceiver(CredentialProviderGetSignInIntentController $this, Bundle resultData, Function2 conversionFn, Executor executor, CredentialManagerCallback callback, CancellationSignal cancellationSignal) {
        return $this.maybeReportErrorFromResultReceiver(resultData, conversionFn, executor, callback, cancellationSignal);
    }

    public static final /* synthetic */ CancellationSignal access$getCancellationSignal$p(CredentialProviderGetSignInIntentController $this) {
        return $this.cancellationSignal;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/credentials/playservices/controllers/GetSignInIntent/CredentialProviderGetSignInIntentController$Companion;", "", "()V", "TAG", "", "getInstance", "Landroidx/credentials/playservices/controllers/GetSignInIntent/CredentialProviderGetSignInIntentController;", "context", "Landroid/content/Context;", "credentials-play-services-auth_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CredentialProviderGetSignInIntentController getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new CredentialProviderGetSignInIntentController(context);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

