/*
 * Decompiled with CFR 0.152.
 */
package androidx.credentials.playservices.controllers.CreatePublicKeyCredential;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.credentials.CreateCredentialResponse;
import androidx.credentials.CreatePublicKeyCredentialRequest;
import androidx.credentials.CreatePublicKeyCredentialResponse;
import androidx.credentials.CredentialManagerCallback;
import androidx.credentials.exceptions.CreateCredentialException;
import androidx.credentials.exceptions.CreateCredentialUnknownException;
import androidx.credentials.exceptions.domerrors.DomError;
import androidx.credentials.exceptions.domerrors.EncodingError;
import androidx.credentials.exceptions.domerrors.UnknownError;
import androidx.credentials.exceptions.publickeycredential.CreatePublicKeyCredentialDomException;
import androidx.credentials.playservices.CredentialProviderPlayServicesImpl;
import androidx.credentials.playservices.HiddenActivity;
import androidx.credentials.playservices.controllers.CreatePublicKeyCredential.CredentialProviderCreatePublicKeyCredentialController;
import androidx.credentials.playservices.controllers.CreatePublicKeyCredential.PublicKeyCredentialControllerUtility;
import androidx.credentials.playservices.controllers.CredentialProviderBaseController;
import androidx.credentials.playservices.controllers.CredentialProviderController;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredential;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialCreationOptions;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000i\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0015\b\u0000\u0018\u0000 (2 \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0001:\u0001(B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0002H\u0017J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0004H\u0017J'\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010%H\u0000\u00a2\u0006\u0002\b&J6\u0010'\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u00022\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R$\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u000b8\u0002@\u0002X\u0083.\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0010\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\u00020\u00128\u0002@\u0002X\u0083.\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0013\u0010\rR\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016\u00a8\u0006)"}, d2={"Landroidx/credentials/playservices/controllers/CreatePublicKeyCredential/CredentialProviderCreatePublicKeyCredentialController;", "Landroidx/credentials/playservices/controllers/CredentialProviderController;", "Landroidx/credentials/CreatePublicKeyCredentialRequest;", "Lcom/google/android/gms/fido/fido2/api/common/PublicKeyCredentialCreationOptions;", "Lcom/google/android/gms/fido/fido2/api/common/PublicKeyCredential;", "Landroidx/credentials/CreateCredentialResponse;", "Landroidx/credentials/exceptions/CreateCredentialException;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "callback", "Landroidx/credentials/CredentialManagerCallback;", "getCallback$annotations", "()V", "cancellationSignal", "Landroid/os/CancellationSignal;", "getCancellationSignal$annotations", "executor", "Ljava/util/concurrent/Executor;", "getExecutor$annotations", "resultReceiver", "androidx/credentials/playservices/controllers/CreatePublicKeyCredential/CredentialProviderCreatePublicKeyCredentialController$resultReceiver$1", "Landroidx/credentials/playservices/controllers/CreatePublicKeyCredential/CredentialProviderCreatePublicKeyCredentialController$resultReceiver$1;", "JSONExceptionToPKCError", "Landroidx/credentials/exceptions/publickeycredential/CreatePublicKeyCredentialDomException;", "exception", "Lorg/json/JSONException;", "convertRequestToPlayServices", "request", "convertResponseToCredentialManager", "response", "handleResponse", "", "uniqueRequestCode", "", "resultCode", "data", "Landroid/content/Intent;", "handleResponse$credentials_play_services_auth_release", "invokePlayServices", "Companion", "credentials-play-services-auth_release"})
public final class CredentialProviderCreatePublicKeyCredentialController
extends CredentialProviderController<CreatePublicKeyCredentialRequest, PublicKeyCredentialCreationOptions, PublicKeyCredential, CreateCredentialResponse, CreateCredentialException> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    private CredentialManagerCallback<CreateCredentialResponse, CreateCredentialException> callback;
    private Executor executor;
    @Nullable
    private CancellationSignal cancellationSignal;
    @NotNull
    private final resultReceiver.1 resultReceiver;
    @NotNull
    private static final String TAG = "CreatePublicKey";

    public CredentialProviderCreatePublicKeyCredentialController(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.context = context;
        Handler handler = new Handler(Looper.getMainLooper());
        this.resultReceiver = new ResultReceiver(this, handler){
            final /* synthetic */ CredentialProviderCreatePublicKeyCredentialController this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void onReceiveResult(int resultCode, @NotNull Bundle resultData) {
                CredentialManagerCallback credentialManagerCallback;
                Intrinsics.checkNotNullParameter((Object)resultData, (String)"resultData");
                Function2 function2 = (Function2)new Function2<String, String, CreateCredentialException>((Object)CredentialProviderBaseController.Companion){

                    @NotNull
                    public final CreateCredentialException invoke(@Nullable String p0, @Nullable String p1) {
                        return ((CredentialProviderBaseController.Companion)this.receiver).createCredentialExceptionTypeToException$credentials_play_services_auth_release(p0, p1);
                    }
                };
                Executor executor = CredentialProviderCreatePublicKeyCredentialController.access$getExecutor$p(this.this$0);
                if (executor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
                    executor = null;
                }
                if ((credentialManagerCallback = CredentialProviderCreatePublicKeyCredentialController.access$getCallback$p(this.this$0)) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"callback");
                    credentialManagerCallback = null;
                }
                if (CredentialProviderCreatePublicKeyCredentialController.access$maybeReportErrorFromResultReceiver(this.this$0, resultData, function2, executor, credentialManagerCallback, CredentialProviderCreatePublicKeyCredentialController.access$getCancellationSignal$p(this.this$0))) {
                    return;
                }
                this.this$0.handleResponse$credentials_play_services_auth_release(resultData.getInt("ACTIVITY_REQUEST_CODE"), resultCode, (Intent)resultData.getParcelable("RESULT_DATA"));
            }
        };
    }

    @VisibleForTesting(otherwise=2)
    private static /* synthetic */ void getCallback$annotations() {
    }

    @VisibleForTesting(otherwise=2)
    private static /* synthetic */ void getExecutor$annotations() {
    }

    @VisibleForTesting(otherwise=2)
    private static /* synthetic */ void getCancellationSignal$annotations() {
    }

    @Override
    public void invokePlayServices(@NotNull CreatePublicKeyCredentialRequest request, @NotNull CredentialManagerCallback<CreateCredentialResponse, CreateCredentialException> callback, @NotNull Executor executor, @Nullable CancellationSignal cancellationSignal) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.cancellationSignal = cancellationSignal;
        this.callback = callback;
        this.executor = executor;
        PublicKeyCredentialCreationOptions fidoRegistrationRequest = null;
        try {
            fidoRegistrationRequest = this.convertRequestToPlayServices(request);
        }
        catch (JSONException e) {
            CredentialProviderController.cancelOrCallbackExceptionOrResult(cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>(this, e){
                final /* synthetic */ CredentialProviderCreatePublicKeyCredentialController this$0;
                final /* synthetic */ JSONException $e;
                {
                    this.this$0 = $receiver;
                    this.$e = $e;
                    super(0);
                }

                public final void invoke() {
                    Executor executor = CredentialProviderCreatePublicKeyCredentialController.access$getExecutor$p(this.this$0);
                    if (executor == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
                        executor = null;
                    }
                    executor.execute(() -> invokePlayServices.1.invoke$lambda$0(this.this$0, this.$e));
                }

                private static final void invoke$lambda$0(CredentialProviderCreatePublicKeyCredentialController this$0, JSONException $e) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)((Object)$e), (String)"$e");
                    CredentialManagerCallback credentialManagerCallback = CredentialProviderCreatePublicKeyCredentialController.access$getCallback$p(this$0);
                    if (credentialManagerCallback == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"callback");
                        credentialManagerCallback = null;
                    }
                    credentialManagerCallback.onError((Object)CredentialProviderCreatePublicKeyCredentialController.access$JSONExceptionToPKCError(this$0, $e));
                }
            }));
            return;
        }
        catch (Throwable t) {
            CredentialProviderController.cancelOrCallbackExceptionOrResult(cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>(this, t){
                final /* synthetic */ CredentialProviderCreatePublicKeyCredentialController this$0;
                final /* synthetic */ Throwable $t;
                {
                    this.this$0 = $receiver;
                    this.$t = $t;
                    super(0);
                }

                public final void invoke() {
                    Executor executor = CredentialProviderCreatePublicKeyCredentialController.access$getExecutor$p(this.this$0);
                    if (executor == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
                        executor = null;
                    }
                    executor.execute(() -> invokePlayServices.2.invoke$lambda$0(this.this$0, this.$t));
                }

                private static final void invoke$lambda$0(CredentialProviderCreatePublicKeyCredentialController this$0, Throwable $t) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$t, (String)"$t");
                    CredentialManagerCallback credentialManagerCallback = CredentialProviderCreatePublicKeyCredentialController.access$getCallback$p(this$0);
                    if (credentialManagerCallback == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"callback");
                        credentialManagerCallback = null;
                    }
                    credentialManagerCallback.onError((Object)new CreateCredentialUnknownException((CharSequence)$t.getMessage()));
                }
            }));
            return;
        }
        if (CredentialProviderPlayServicesImpl.Companion.cancellationReviewer$credentials_play_services_auth_release(cancellationSignal)) {
            return;
        }
        Intent hiddenIntent = new Intent(this.context, HiddenActivity.class);
        hiddenIntent.putExtra("REQUEST_TYPE", (Parcelable)fidoRegistrationRequest);
        this.generateHiddenActivityIntent(this.resultReceiver, hiddenIntent, "CREATE_PUBLIC_KEY_CREDENTIAL");
        try {
            this.context.startActivity(hiddenIntent);
        }
        catch (Exception e) {
            CredentialProviderController.cancelOrCallbackExceptionOrResult(cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ CredentialProviderCreatePublicKeyCredentialController this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    Executor executor = CredentialProviderCreatePublicKeyCredentialController.access$getExecutor$p(this.this$0);
                    if (executor == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
                        executor = null;
                    }
                    executor.execute(() -> invokePlayServices.3.invoke$lambda$0(this.this$0));
                }

                private static final void invoke$lambda$0(CredentialProviderCreatePublicKeyCredentialController this$0) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    CredentialManagerCallback credentialManagerCallback = CredentialProviderCreatePublicKeyCredentialController.access$getCallback$p(this$0);
                    if (credentialManagerCallback == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"callback");
                        credentialManagerCallback = null;
                    }
                    credentialManagerCallback.onError((Object)new CreateCredentialUnknownException((CharSequence)"Failed to launch the selector UI. Hint: ensure the `context` parameter is an Activity-based context."));
                }
            }));
        }
    }

    public final void handleResponse$credentials_play_services_auth_release(int uniqueRequestCode, int resultCode, @Nullable Intent data) {
        byte[] bytes;
        if (uniqueRequestCode != CredentialProviderBaseController.getCONTROLLER_REQUEST_CODE()) {
            Log.w((String)TAG, (String)("Returned request code " + CredentialProviderBaseController.getCONTROLLER_REQUEST_CODE() + " does not match what was given " + uniqueRequestCode));
            return;
        }
        if (CredentialProviderController.maybeReportErrorResultCodeCreate(resultCode, (Function2<? super CancellationSignal, ? super Function0<Unit>, Unit>)((Function2)handleResponse.1.INSTANCE), (Function1<? super CreateCredentialException, Unit>)((Function1)new Function1<CreateCredentialException, Unit>(this){
            final /* synthetic */ CredentialProviderCreatePublicKeyCredentialController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull CreateCredentialException e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Executor executor = CredentialProviderCreatePublicKeyCredentialController.access$getExecutor$p(this.this$0);
                if (executor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
                    executor = null;
                }
                executor.execute(() -> handleResponse.2.invoke$lambda$0(this.this$0, e));
            }

            private static final void invoke$lambda$0(CredentialProviderCreatePublicKeyCredentialController this$0, CreateCredentialException $e) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
                CredentialManagerCallback credentialManagerCallback = CredentialProviderCreatePublicKeyCredentialController.access$getCallback$p(this$0);
                if (credentialManagerCallback == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"callback");
                    credentialManagerCallback = null;
                }
                credentialManagerCallback.onError((Object)$e);
            }
        }), this.cancellationSignal)) {
            return;
        }
        Intent intent = data;
        Object object = bytes = (Object)(intent != null ? intent.getByteArrayExtra("FIDO2_CREDENTIAL_EXTRA") : null);
        if (bytes == null) {
            if (CredentialProviderPlayServicesImpl.Companion.cancellationReviewer$credentials_play_services_auth_release(this.cancellationSignal)) {
                return;
            }
            Executor executor = this.executor;
            if (executor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
                executor = null;
            }
            executor.execute(() -> CredentialProviderCreatePublicKeyCredentialController.handleResponse$lambda$0(this));
            return;
        }
        PublicKeyCredential publicKeyCredential = PublicKeyCredential.deserializeFromBytes((byte[])bytes);
        Intrinsics.checkNotNullExpressionValue((Object)publicKeyCredential, (String)"deserializeFromBytes(bytes)");
        PublicKeyCredential cred = publicKeyCredential;
        CreateCredentialException exception = PublicKeyCredentialControllerUtility.Companion.publicKeyCredentialResponseContainsError(cred);
        if (exception != null) {
            CredentialProviderController.cancelOrCallbackExceptionOrResult(this.cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>(this, exception){
                final /* synthetic */ CredentialProviderCreatePublicKeyCredentialController this$0;
                final /* synthetic */ CreateCredentialException $exception;
                {
                    this.this$0 = $receiver;
                    this.$exception = $exception;
                    super(0);
                }

                public final void invoke() {
                    Executor executor = CredentialProviderCreatePublicKeyCredentialController.access$getExecutor$p(this.this$0);
                    if (executor == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
                        executor = null;
                    }
                    executor.execute(() -> handleResponse.4.invoke$lambda$0(this.this$0, this.$exception));
                }

                private static final void invoke$lambda$0(CredentialProviderCreatePublicKeyCredentialController this$0, CreateCredentialException $exception) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    CredentialManagerCallback credentialManagerCallback = CredentialProviderCreatePublicKeyCredentialController.access$getCallback$p(this$0);
                    if (credentialManagerCallback == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"callback");
                        credentialManagerCallback = null;
                    }
                    credentialManagerCallback.onError((Object)$exception);
                }
            }));
            return;
        }
        try {
            CreateCredentialResponse response = this.convertResponseToCredentialManager(cred);
            CredentialProviderController.cancelOrCallbackExceptionOrResult(this.cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>(this, response){
                final /* synthetic */ CredentialProviderCreatePublicKeyCredentialController this$0;
                final /* synthetic */ CreateCredentialResponse $response;
                {
                    this.this$0 = $receiver;
                    this.$response = $response;
                    super(0);
                }

                public final void invoke() {
                    Executor executor = CredentialProviderCreatePublicKeyCredentialController.access$getExecutor$p(this.this$0);
                    if (executor == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
                        executor = null;
                    }
                    executor.execute(() -> handleResponse.5.invoke$lambda$0(this.this$0, this.$response));
                }

                private static final void invoke$lambda$0(CredentialProviderCreatePublicKeyCredentialController this$0, CreateCredentialResponse $response) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$response, (String)"$response");
                    CredentialManagerCallback credentialManagerCallback = CredentialProviderCreatePublicKeyCredentialController.access$getCallback$p(this$0);
                    if (credentialManagerCallback == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"callback");
                        credentialManagerCallback = null;
                    }
                    credentialManagerCallback.onResult((Object)$response);
                }
            }));
        }
        catch (JSONException e) {
            CredentialProviderController.cancelOrCallbackExceptionOrResult(this.cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>(this, e){
                final /* synthetic */ CredentialProviderCreatePublicKeyCredentialController this$0;
                final /* synthetic */ JSONException $e;
                {
                    this.this$0 = $receiver;
                    this.$e = $e;
                    super(0);
                }

                public final void invoke() {
                    Executor executor = CredentialProviderCreatePublicKeyCredentialController.access$getExecutor$p(this.this$0);
                    if (executor == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
                        executor = null;
                    }
                    executor.execute(() -> handleResponse.6.invoke$lambda$0(this.this$0, this.$e));
                }

                private static final void invoke$lambda$0(CredentialProviderCreatePublicKeyCredentialController this$0, JSONException $e) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)((Object)$e), (String)"$e");
                    CredentialManagerCallback credentialManagerCallback = CredentialProviderCreatePublicKeyCredentialController.access$getCallback$p(this$0);
                    if (credentialManagerCallback == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"callback");
                        credentialManagerCallback = null;
                    }
                    credentialManagerCallback.onError((Object)new CreatePublicKeyCredentialDomException((DomError)new EncodingError(), (CharSequence)$e.getMessage()));
                }
            }));
        }
        catch (Throwable t) {
            CredentialProviderController.cancelOrCallbackExceptionOrResult(this.cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>(this, t){
                final /* synthetic */ CredentialProviderCreatePublicKeyCredentialController this$0;
                final /* synthetic */ Throwable $t;
                {
                    this.this$0 = $receiver;
                    this.$t = $t;
                    super(0);
                }

                public final void invoke() {
                    Executor executor = CredentialProviderCreatePublicKeyCredentialController.access$getExecutor$p(this.this$0);
                    if (executor == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
                        executor = null;
                    }
                    executor.execute(() -> handleResponse.7.invoke$lambda$0(this.this$0, this.$t));
                }

                private static final void invoke$lambda$0(CredentialProviderCreatePublicKeyCredentialController this$0, Throwable $t) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$t, (String)"$t");
                    CredentialManagerCallback credentialManagerCallback = CredentialProviderCreatePublicKeyCredentialController.access$getCallback$p(this$0);
                    if (credentialManagerCallback == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"callback");
                        credentialManagerCallback = null;
                    }
                    credentialManagerCallback.onError((Object)new CreatePublicKeyCredentialDomException((DomError)new UnknownError(), (CharSequence)$t.getMessage()));
                }
            }));
        }
    }

    @Override
    @VisibleForTesting(otherwise=4)
    @NotNull
    public PublicKeyCredentialCreationOptions convertRequestToPlayServices(@NotNull CreatePublicKeyCredentialRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return PublicKeyCredentialControllerUtility.Companion.convert(request, this.context);
    }

    @Override
    @VisibleForTesting(otherwise=4)
    @NotNull
    public CreateCredentialResponse convertResponseToCredentialManager(@NotNull PublicKeyCredential response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        try {
            String string = response.toJson();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.toJson()");
            return (CreateCredentialResponse)new CreatePublicKeyCredentialResponse(string);
        }
        catch (Throwable t) {
            throw new CreateCredentialUnknownException((CharSequence)("The PublicKeyCredential response json had an unexpected exception when parsing: " + t.getMessage()));
        }
    }

    private final CreatePublicKeyCredentialDomException JSONExceptionToPKCError(JSONException exception) {
        String myCopy = exception.getMessage();
        if (myCopy != null && myCopy.length() > 0) {
            return new CreatePublicKeyCredentialDomException((DomError)new EncodingError(), (CharSequence)myCopy);
        }
        return new CreatePublicKeyCredentialDomException((DomError)new EncodingError(), (CharSequence)"Unknown error");
    }

    private static final void handleResponse$lambda$0(CredentialProviderCreatePublicKeyCredentialController this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        CredentialManagerCallback<CreateCredentialResponse, CreateCredentialException> credentialManagerCallback = this$0.callback;
        if (credentialManagerCallback == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"callback");
            credentialManagerCallback = null;
        }
        credentialManagerCallback.onError((Object)new CreatePublicKeyCredentialDomException((DomError)new UnknownError(), (CharSequence)"Upon handling create public key credential response, fido module giving null bytes indicating internal error"));
    }

    @JvmStatic
    @NotNull
    public static final CredentialProviderCreatePublicKeyCredentialController getInstance(@NotNull Context context) {
        return Companion.getInstance(context);
    }

    public static final /* synthetic */ Executor access$getExecutor$p(CredentialProviderCreatePublicKeyCredentialController $this) {
        return $this.executor;
    }

    public static final /* synthetic */ CredentialManagerCallback access$getCallback$p(CredentialProviderCreatePublicKeyCredentialController $this) {
        return $this.callback;
    }

    public static final /* synthetic */ CreatePublicKeyCredentialDomException access$JSONExceptionToPKCError(CredentialProviderCreatePublicKeyCredentialController $this, JSONException exception) {
        return $this.JSONExceptionToPKCError(exception);
    }

    public static final /* synthetic */ void access$cancelOrCallbackExceptionOrResult$s895630660(CancellationSignal cancellationSignal, Function0 onResultOrException) {
        CredentialProviderController.cancelOrCallbackExceptionOrResult(cancellationSignal, (Function0<Unit>)onResultOrException);
    }

    public static final /* synthetic */ boolean access$maybeReportErrorFromResultReceiver(CredentialProviderCreatePublicKeyCredentialController $this, Bundle resultData, Function2 conversionFn, Executor executor, CredentialManagerCallback callback, CancellationSignal cancellationSignal) {
        return $this.maybeReportErrorFromResultReceiver(resultData, conversionFn, executor, callback, cancellationSignal);
    }

    public static final /* synthetic */ CancellationSignal access$getCancellationSignal$p(CredentialProviderCreatePublicKeyCredentialController $this) {
        return $this.cancellationSignal;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/credentials/playservices/controllers/CreatePublicKeyCredential/CredentialProviderCreatePublicKeyCredentialController$Companion;", "", "()V", "TAG", "", "getInstance", "Landroidx/credentials/playservices/controllers/CreatePublicKeyCredential/CredentialProviderCreatePublicKeyCredentialController;", "context", "Landroid/content/Context;", "credentials-play-services-auth_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CredentialProviderCreatePublicKeyCredentialController getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new CredentialProviderCreatePublicKeyCredentialController(context);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

