/*
 * Decompiled with CFR 0.152.
 */
package androidx.credentials.playservices.controllers.CreateRestoreCredential;

import android.content.Context;
import android.os.CancellationSignal;
import androidx.credentials.CreateCredentialResponse;
import androidx.credentials.CreateRestoreCredentialRequest;
import androidx.credentials.CreateRestoreCredentialResponse;
import androidx.credentials.CredentialManagerCallback;
import androidx.credentials.exceptions.CreateCredentialException;
import androidx.credentials.exceptions.CreateCredentialUnknownException;
import androidx.credentials.exceptions.domerrors.DataError;
import androidx.credentials.exceptions.domerrors.DomError;
import androidx.credentials.exceptions.restorecredential.CreateRestoreCredentialDomException;
import androidx.credentials.exceptions.restorecredential.E2eeUnavailableException;
import androidx.credentials.playservices.CredentialProviderPlayServicesImpl;
import androidx.credentials.playservices.controllers.CreateRestoreCredential.CredentialProviderCreateRestoreCredentialController;
import androidx.credentials.playservices.controllers.CredentialProviderController;
import com.google.android.gms.auth.blockstore.restorecredential.RestoreCredential;
import com.google.android.gms.common.api.ApiException;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0001B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0004H\u0016J6\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00022\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/credentials/playservices/controllers/CreateRestoreCredential/CredentialProviderCreateRestoreCredentialController;", "Landroidx/credentials/playservices/controllers/CredentialProviderController;", "Landroidx/credentials/CreateRestoreCredentialRequest;", "Lcom/google/android/gms/auth/blockstore/restorecredential/CreateRestoreCredentialRequest;", "Lcom/google/android/gms/auth/blockstore/restorecredential/CreateRestoreCredentialResponse;", "Landroidx/credentials/CreateCredentialResponse;", "Landroidx/credentials/exceptions/CreateCredentialException;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "convertRequestToPlayServices", "request", "convertResponseToCredentialManager", "response", "invokePlayServices", "", "callback", "Landroidx/credentials/CredentialManagerCallback;", "executor", "Ljava/util/concurrent/Executor;", "cancellationSignal", "Landroid/os/CancellationSignal;", "credentials-play-services-auth_release"})
public final class CredentialProviderCreateRestoreCredentialController
extends CredentialProviderController<CreateRestoreCredentialRequest, com.google.android.gms.auth.blockstore.restorecredential.CreateRestoreCredentialRequest, com.google.android.gms.auth.blockstore.restorecredential.CreateRestoreCredentialResponse, CreateCredentialResponse, CreateCredentialException> {
    @NotNull
    private final Context context;

    public CredentialProviderCreateRestoreCredentialController(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.context = context;
    }

    @Override
    public void invokePlayServices(@NotNull CreateRestoreCredentialRequest request, @NotNull CredentialManagerCallback<CreateCredentialResponse, CreateCredentialException> callback, @NotNull Executor executor, @Nullable CancellationSignal cancellationSignal) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        if (CredentialProviderPlayServicesImpl.Companion.cancellationReviewer$credentials_play_services_auth_release(cancellationSignal)) {
            return;
        }
        com.google.android.gms.auth.blockstore.restorecredential.CreateRestoreCredentialRequest convertedRequest = this.convertRequestToPlayServices(request);
        RestoreCredential.getRestoreCredentialClient((Context)this.context).createRestoreCredential(convertedRequest).addOnSuccessListener(arg_0 -> CredentialProviderCreateRestoreCredentialController.invokePlayServices$lambda$0((Function1)new Function1<com.google.android.gms.auth.blockstore.restorecredential.CreateRestoreCredentialResponse, Unit>(this, cancellationSignal, executor, callback){
            final /* synthetic */ CredentialProviderCreateRestoreCredentialController this$0;
            final /* synthetic */ CancellationSignal $cancellationSignal;
            final /* synthetic */ Executor $executor;
            final /* synthetic */ CredentialManagerCallback<CreateCredentialResponse, CreateCredentialException> $callback;
            {
                this.this$0 = $receiver;
                this.$cancellationSignal = $cancellationSignal;
                this.$executor = $executor;
                this.$callback = $callback;
                super(1);
            }

            public final void invoke(com.google.android.gms.auth.blockstore.restorecredential.CreateRestoreCredentialResponse it) {
                try {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    CreateCredentialResponse response = this.this$0.convertResponseToCredentialManager(it);
                    CredentialProviderCreateRestoreCredentialController.access$cancelOrCallbackExceptionOrResult$s895630660(this.$cancellationSignal, (Function0)new Function0<Unit>(this.$executor, this.$callback, response){
                        final /* synthetic */ Executor $executor;
                        final /* synthetic */ CredentialManagerCallback<CreateCredentialResponse, CreateCredentialException> $callback;
                        final /* synthetic */ CreateCredentialResponse $response;
                        {
                            this.$executor = $executor;
                            this.$callback = $callback;
                            this.$response = $response;
                            super(0);
                        }

                        public final void invoke() {
                            this.$executor.execute(() -> invokePlayServices.1.invoke$lambda$0(this.$callback, this.$response));
                        }

                        private static final void invoke$lambda$0(CredentialManagerCallback $callback, CreateCredentialResponse $response) {
                            Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
                            Intrinsics.checkNotNullParameter((Object)$response, (String)"$response");
                            $callback.onResult((Object)$response);
                        }
                    });
                }
                catch (Exception e) {
                    CredentialProviderCreateRestoreCredentialController.access$cancelOrCallbackExceptionOrResult$s895630660(this.$cancellationSignal, (Function0)new Function0<Unit>(this.$executor, this.$callback, e){
                        final /* synthetic */ Executor $executor;
                        final /* synthetic */ CredentialManagerCallback<CreateCredentialResponse, CreateCredentialException> $callback;
                        final /* synthetic */ Exception $e;
                        {
                            this.$executor = $executor;
                            this.$callback = $callback;
                            this.$e = $e;
                            super(0);
                        }

                        public final void invoke() {
                            this.$executor.execute(() -> invokePlayServices.2.invoke$lambda$0(this.$callback, this.$e));
                        }

                        private static final void invoke$lambda$0(CredentialManagerCallback $callback, Exception $e) {
                            Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
                            Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
                            $callback.onError((Object)new CreateCredentialUnknownException((CharSequence)$e.getMessage()));
                        }
                    });
                }
            }
        }, arg_0)).addOnFailureListener(arg_0 -> CredentialProviderCreateRestoreCredentialController.invokePlayServices$lambda$1(cancellationSignal, executor, callback, arg_0));
    }

    @Override
    @NotNull
    public com.google.android.gms.auth.blockstore.restorecredential.CreateRestoreCredentialRequest convertRequestToPlayServices(@NotNull CreateRestoreCredentialRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new com.google.android.gms.auth.blockstore.restorecredential.CreateRestoreCredentialRequest(request.getCredentialData());
    }

    @Override
    @NotNull
    public CreateCredentialResponse convertResponseToCredentialManager(@NotNull com.google.android.gms.auth.blockstore.restorecredential.CreateRestoreCredentialResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return (CreateCredentialResponse)CreateRestoreCredentialResponse.Companion.createFrom(response.getResponseBundle());
    }

    private static final void invokePlayServices$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void invokePlayServices$lambda$1(CancellationSignal $cancellationSignal, Executor $executor, CredentialManagerCallback $callback, Exception e) {
        Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Ref.ObjectRef createException = new Ref.ObjectRef();
        createException.element = new CreateCredentialUnknownException((CharSequence)("Create restore credential failed for unknown reason, failure: " + e.getMessage()));
        if (e instanceof ApiException) {
            switch (((ApiException)((Object)e)).getStatusCode()) {
                case 40203: {
                    createException.element = new E2eeUnavailableException((CharSequence)"E2ee is not available on the device. Check whether the backup and screen lock are enabled.");
                    break;
                }
                case 40202: {
                    createException.element = new CreateRestoreCredentialDomException((DomError)new DataError(), (CharSequence)("The request did not match the fido spec, failure: " + e.getMessage()));
                    break;
                }
                case 40201: {
                    createException.element = new CreateCredentialUnknownException((CharSequence)("The restore credential internal service had a failure, failure: " + e.getMessage()));
                    break;
                }
                default: {
                    createException.element = new CreateCredentialUnknownException((CharSequence)("The restore credential service failed with unsupported status code, failure: " + e.getMessage() + ", status code: " + ((ApiException)((Object)e)).getStatusCode()));
                }
            }
        }
        CredentialProviderController.cancelOrCallbackExceptionOrResult($cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>($executor, (CredentialManagerCallback<CreateCredentialResponse, CreateCredentialException>)$callback, (Ref.ObjectRef<CreateCredentialException>)createException){
            final /* synthetic */ Executor $executor;
            final /* synthetic */ CredentialManagerCallback<CreateCredentialResponse, CreateCredentialException> $callback;
            final /* synthetic */ Ref.ObjectRef<CreateCredentialException> $createException;
            {
                this.$executor = $executor;
                this.$callback = $callback;
                this.$createException = $createException;
                super(0);
            }

            public final void invoke() {
                this.$executor.execute(() -> invokePlayServices.2.1.invoke$lambda$0(this.$callback, this.$createException));
            }

            private static final void invoke$lambda$0(CredentialManagerCallback $callback, Ref.ObjectRef $createException) {
                Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
                Intrinsics.checkNotNullParameter((Object)$createException, (String)"$createException");
                $callback.onError($createException.element);
            }
        }));
    }

    public static final /* synthetic */ void access$cancelOrCallbackExceptionOrResult$s895630660(CancellationSignal cancellationSignal, Function0 onResultOrException) {
        CredentialProviderController.cancelOrCallbackExceptionOrResult(cancellationSignal, (Function0<Unit>)onResultOrException);
    }
}

