/*
 * Decompiled with CFR 0.152.
 */
package androidx.credentials.playservices.controllers.GetRestoreCredential;

import android.content.Context;
import android.os.CancellationSignal;
import androidx.credentials.Credential;
import androidx.credentials.CredentialManagerCallback;
import androidx.credentials.CredentialOption;
import androidx.credentials.GetCredentialRequest;
import androidx.credentials.GetCredentialResponse;
import androidx.credentials.GetRestoreCredentialOption;
import androidx.credentials.exceptions.GetCredentialException;
import androidx.credentials.exceptions.GetCredentialUnknownException;
import androidx.credentials.exceptions.NoCredentialException;
import androidx.credentials.playservices.CredentialProviderPlayServicesImpl;
import androidx.credentials.playservices.controllers.CredentialProviderController;
import androidx.credentials.playservices.controllers.GetRestoreCredential.CredentialProviderGetRestoreCredentialController;
import com.google.android.gms.auth.blockstore.restorecredential.GetRestoreCredentialRequest;
import com.google.android.gms.auth.blockstore.restorecredential.GetRestoreCredentialResponse;
import com.google.android.gms.auth.blockstore.restorecredential.RestoreCredential;
import com.google.android.gms.common.api.ApiException;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0001B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0004H\u0016J6\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00022\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/credentials/playservices/controllers/GetRestoreCredential/CredentialProviderGetRestoreCredentialController;", "Landroidx/credentials/playservices/controllers/CredentialProviderController;", "Landroidx/credentials/GetCredentialRequest;", "Lcom/google/android/gms/auth/blockstore/restorecredential/GetRestoreCredentialRequest;", "Lcom/google/android/gms/auth/blockstore/restorecredential/GetRestoreCredentialResponse;", "Landroidx/credentials/GetCredentialResponse;", "Landroidx/credentials/exceptions/GetCredentialException;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "convertRequestToPlayServices", "request", "convertResponseToCredentialManager", "response", "invokePlayServices", "", "callback", "Landroidx/credentials/CredentialManagerCallback;", "executor", "Ljava/util/concurrent/Executor;", "cancellationSignal", "Landroid/os/CancellationSignal;", "credentials-play-services-auth_release"})
public final class CredentialProviderGetRestoreCredentialController
extends CredentialProviderController<GetCredentialRequest, GetRestoreCredentialRequest, GetRestoreCredentialResponse, GetCredentialResponse, GetCredentialException> {
    @NotNull
    private final Context context;

    public CredentialProviderGetRestoreCredentialController(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.context = context;
    }

    @Override
    public void invokePlayServices(@NotNull GetCredentialRequest request, @NotNull CredentialManagerCallback<GetCredentialResponse, GetCredentialException> callback, @NotNull Executor executor, @Nullable CancellationSignal cancellationSignal) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        if (CredentialProviderPlayServicesImpl.Companion.cancellationReviewer$credentials_play_services_auth_release(cancellationSignal)) {
            return;
        }
        GetRestoreCredentialRequest convertedRequest = this.convertRequestToPlayServices(request);
        RestoreCredential.getRestoreCredentialClient((Context)this.context).getRestoreCredential(convertedRequest).addOnSuccessListener(arg_0 -> CredentialProviderGetRestoreCredentialController.invokePlayServices$lambda$0((Function1)new Function1<GetRestoreCredentialResponse, Unit>(this, cancellationSignal, executor, callback){
            final /* synthetic */ CredentialProviderGetRestoreCredentialController this$0;
            final /* synthetic */ CancellationSignal $cancellationSignal;
            final /* synthetic */ Executor $executor;
            final /* synthetic */ CredentialManagerCallback<GetCredentialResponse, GetCredentialException> $callback;
            {
                this.this$0 = $receiver;
                this.$cancellationSignal = $cancellationSignal;
                this.$executor = $executor;
                this.$callback = $callback;
                super(1);
            }

            public final void invoke(GetRestoreCredentialResponse it) {
                try {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    GetCredentialResponse response = this.this$0.convertResponseToCredentialManager(it);
                    CredentialProviderGetRestoreCredentialController.access$cancelOrCallbackExceptionOrResult$s895630660(this.$cancellationSignal, (Function0)new Function0<Unit>(this.$executor, this.$callback, response){
                        final /* synthetic */ Executor $executor;
                        final /* synthetic */ CredentialManagerCallback<GetCredentialResponse, GetCredentialException> $callback;
                        final /* synthetic */ GetCredentialResponse $response;
                        {
                            this.$executor = $executor;
                            this.$callback = $callback;
                            this.$response = $response;
                            super(0);
                        }

                        public final void invoke() {
                            this.$executor.execute(() -> invokePlayServices.1.invoke$lambda$0(this.$callback, this.$response));
                        }

                        private static final void invoke$lambda$0(CredentialManagerCallback $callback, GetCredentialResponse $response) {
                            Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
                            Intrinsics.checkNotNullParameter((Object)$response, (String)"$response");
                            $callback.onResult((Object)$response);
                        }
                    });
                }
                catch (Exception e) {
                    CredentialProviderGetRestoreCredentialController.access$cancelOrCallbackExceptionOrResult$s895630660(this.$cancellationSignal, (Function0)new Function0<Unit>(this.$executor, this.$callback, e){
                        final /* synthetic */ Executor $executor;
                        final /* synthetic */ CredentialManagerCallback<GetCredentialResponse, GetCredentialException> $callback;
                        final /* synthetic */ Exception $e;
                        {
                            this.$executor = $executor;
                            this.$callback = $callback;
                            this.$e = $e;
                            super(0);
                        }

                        public final void invoke() {
                            this.$executor.execute(() -> invokePlayServices.2.invoke$lambda$0(this.$callback, this.$e));
                        }

                        private static final void invoke$lambda$0(CredentialManagerCallback $callback, Exception $e) {
                            Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
                            Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
                            $callback.onError((Object)((Object)($e instanceof NoCredentialException ? (GetCredentialException)((Object)$e) : (GetCredentialException)new GetCredentialUnknownException((CharSequence)$e.getMessage()))));
                        }
                    });
                }
            }
        }, arg_0)).addOnFailureListener(arg_0 -> CredentialProviderGetRestoreCredentialController.invokePlayServices$lambda$1(cancellationSignal, executor, callback, arg_0));
    }

    @Override
    @NotNull
    public GetRestoreCredentialRequest convertRequestToPlayServices(@NotNull GetCredentialRequest request) {
        GetRestoreCredentialOption getRestoreCredentialOption;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        GetRestoreCredentialOption credentialOption = null;
        for (CredentialOption option : request.getCredentialOptions()) {
            if (!(option instanceof GetRestoreCredentialOption)) continue;
            credentialOption = (GetRestoreCredentialOption)option;
            break;
        }
        if ((getRestoreCredentialOption = credentialOption) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"credentialOption");
            getRestoreCredentialOption = null;
        }
        return new GetRestoreCredentialRequest(getRestoreCredentialOption.getRequestData());
    }

    @Override
    @NotNull
    public GetCredentialResponse convertResponseToCredentialManager(@NotNull GetRestoreCredentialResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return new GetCredentialResponse(Credential.Companion.createFrom("androidx.credentials.TYPE_RESTORE_CREDENTIAL", response.getResponseBundle()));
    }

    private static final void invokePlayServices$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void invokePlayServices$lambda$1(CancellationSignal $cancellationSignal, Executor $executor, CredentialManagerCallback $callback, Exception e) {
        Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Ref.ObjectRef getException = new Ref.ObjectRef();
        getException.element = new GetCredentialUnknownException((CharSequence)("Get restore credential failed for unknown reason, failure: " + e.getMessage()));
        if (e instanceof ApiException) {
            getException.element = ((ApiException)((Object)e)).getStatusCode() == 40201 ? new GetCredentialUnknownException((CharSequence)("The restore credential internal service had a failure, failure: " + e.getMessage())) : new GetCredentialUnknownException((CharSequence)("The restore credential service failed with unsupported status code, failure: " + e.getMessage() + ", status code: " + ((ApiException)((Object)e)).getStatusCode()));
        }
        CredentialProviderController.cancelOrCallbackExceptionOrResult($cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>($executor, (CredentialManagerCallback<GetCredentialResponse, GetCredentialException>)$callback, (Ref.ObjectRef<GetCredentialException>)getException){
            final /* synthetic */ Executor $executor;
            final /* synthetic */ CredentialManagerCallback<GetCredentialResponse, GetCredentialException> $callback;
            final /* synthetic */ Ref.ObjectRef<GetCredentialException> $getException;
            {
                this.$executor = $executor;
                this.$callback = $callback;
                this.$getException = $getException;
                super(0);
            }

            public final void invoke() {
                this.$executor.execute(() -> invokePlayServices.2.1.invoke$lambda$0(this.$callback, this.$getException));
            }

            private static final void invoke$lambda$0(CredentialManagerCallback $callback, Ref.ObjectRef $getException) {
                Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
                Intrinsics.checkNotNullParameter((Object)$getException, (String)"$getException");
                $callback.onError($getException.element);
            }
        }));
    }

    public static final /* synthetic */ void access$cancelOrCallbackExceptionOrResult$s895630660(CancellationSignal cancellationSignal, Function0 onResultOrException) {
        CredentialProviderController.cancelOrCallbackExceptionOrResult(cancellationSignal, (Function0<Unit>)onResultOrException);
    }
}

