/*
 * Decompiled with CFR 0.152.
 */
package androidx.credentials.playservices;

import android.content.Context;
import android.os.Build;
import android.os.CancellationSignal;
import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.credentials.ClearCredentialStateRequest;
import androidx.credentials.CreateCredentialRequest;
import androidx.credentials.CreateCredentialResponse;
import androidx.credentials.CreatePasswordRequest;
import androidx.credentials.CreatePublicKeyCredentialRequest;
import androidx.credentials.CreateRestoreCredentialRequest;
import androidx.credentials.CredentialManagerCallback;
import androidx.credentials.CredentialOption;
import androidx.credentials.CredentialProvider;
import androidx.credentials.GetCredentialRequest;
import androidx.credentials.GetCredentialResponse;
import androidx.credentials.GetDigitalCredentialOption;
import androidx.credentials.GetRestoreCredentialOption;
import androidx.credentials.exceptions.ClearCredentialException;
import androidx.credentials.exceptions.ClearCredentialProviderConfigurationException;
import androidx.credentials.exceptions.ClearCredentialUnknownException;
import androidx.credentials.exceptions.CreateCredentialException;
import androidx.credentials.exceptions.CreateCredentialProviderConfigurationException;
import androidx.credentials.exceptions.GetCredentialException;
import androidx.credentials.exceptions.GetCredentialProviderConfigurationException;
import androidx.credentials.playservices.CredentialProviderPlayServicesImpl;
import androidx.credentials.playservices.controllers.BeginSignIn.CredentialProviderBeginSignInController;
import androidx.credentials.playservices.controllers.CreatePassword.CredentialProviderCreatePasswordController;
import androidx.credentials.playservices.controllers.CreatePublicKeyCredential.CredentialProviderCreatePublicKeyCredentialController;
import androidx.credentials.playservices.controllers.CreateRestoreCredential.CredentialProviderCreateRestoreCredentialController;
import androidx.credentials.playservices.controllers.GetRestoreCredential.CredentialProviderGetDigitalCredentialController;
import androidx.credentials.playservices.controllers.GetRestoreCredential.CredentialProviderGetRestoreCredentialController;
import androidx.credentials.playservices.controllers.GetSignInIntent.CredentialProviderGetSignInIntentController;
import com.google.android.gms.auth.api.identity.Identity;
import com.google.android.gms.auth.blockstore.restorecredential.ClearRestoreCredentialRequest;
import com.google.android.gms.auth.blockstore.restorecredential.RestoreCredential;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.ApiException;
import com.google.android.libraries.identity.googleid.GetSignInWithGoogleOption;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J8\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0014\u0010\u001a\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0012\u0004\u0012\u00020\u001d0\u001bH\u0016J>\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u001f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001bH\u0016J>\u0010\"\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020#2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006'"}, d2={"Landroidx/credentials/playservices/CredentialProviderPlayServicesImpl;", "Landroidx/credentials/CredentialProvider;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "googleApiAvailability", "Lcom/google/android/gms/common/GoogleApiAvailability;", "getGoogleApiAvailability$annotations", "()V", "getGoogleApiAvailability", "()Lcom/google/android/gms/common/GoogleApiAvailability;", "setGoogleApiAvailability", "(Lcom/google/android/gms/common/GoogleApiAvailability;)V", "isAvailableOnDevice", "", "minApkVersion", "", "isGooglePlayServicesAvailable", "onClearCredential", "", "request", "Landroidx/credentials/ClearCredentialStateRequest;", "cancellationSignal", "Landroid/os/CancellationSignal;", "executor", "Ljava/util/concurrent/Executor;", "callback", "Landroidx/credentials/CredentialManagerCallback;", "Ljava/lang/Void;", "Landroidx/credentials/exceptions/ClearCredentialException;", "onCreateCredential", "Landroidx/credentials/CreateCredentialRequest;", "Landroidx/credentials/CreateCredentialResponse;", "Landroidx/credentials/exceptions/CreateCredentialException;", "onGetCredential", "Landroidx/credentials/GetCredentialRequest;", "Landroidx/credentials/GetCredentialResponse;", "Landroidx/credentials/exceptions/GetCredentialException;", "Companion", "credentials-play-services-auth_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class CredentialProviderPlayServicesImpl
implements CredentialProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private GoogleApiAvailability googleApiAvailability;
    @NotNull
    private static final String TAG = "PlayServicesImpl";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int MIN_GMS_APK_VERSION = 230815045;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int MIN_GMS_APK_VERSION_RESTORE_CRED = 242200000;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int MIN_GMS_APK_VERSION_DIGITAL_CRED = 243100000;

    public CredentialProviderPlayServicesImpl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)googleApiAvailability, (String)"getInstance(...)");
        this.googleApiAvailability = googleApiAvailability;
    }

    @NotNull
    public final GoogleApiAvailability getGoogleApiAvailability() {
        return this.googleApiAvailability;
    }

    public final void setGoogleApiAvailability(@NotNull GoogleApiAvailability googleApiAvailability) {
        Intrinsics.checkNotNullParameter((Object)googleApiAvailability, (String)"<set-?>");
        this.googleApiAvailability = googleApiAvailability;
    }

    @VisibleForTesting
    public static /* synthetic */ void getGoogleApiAvailability$annotations() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onGetCredential(@NotNull Context context, @NotNull GetCredentialRequest request, @Nullable CancellationSignal cancellationSignal, @NotNull Executor executor, @NotNull CredentialManagerCallback<GetCredentialResponse, GetCredentialException> callback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (Companion.cancellationReviewer$credentials_play_services_auth_release(cancellationSignal)) {
            return;
        }
        if (Companion.isDigitalCredentialRequest$credentials_play_services_auth_release(request)) {
            if (!this.isAvailableOnDevice(243100000)) {
                Companion.cancellationReviewerWithCallback$credentials_play_services_auth_release(cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>(executor, callback){
                    final /* synthetic */ Executor $executor;
                    final /* synthetic */ CredentialManagerCallback<GetCredentialResponse, GetCredentialException> $callback;
                    {
                        this.$executor = $executor;
                        this.$callback = $callback;
                        super(0);
                    }

                    public final void invoke() {
                        this.$executor.execute(() -> onGetCredential.1.invoke$lambda$0(this.$callback));
                    }

                    private static final void invoke$lambda$0(CredentialManagerCallback $callback) {
                        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
                        $callback.onError((Object)new GetCredentialProviderConfigurationException((CharSequence)"this device requires a Google Play Services update for the given feature to be supported"));
                    }
                }));
                return;
            }
            if (Build.VERSION.SDK_INT >= 23) {
                new CredentialProviderGetDigitalCredentialController(context).invokePlayServices(request, callback, executor, cancellationSignal);
                return;
            }
            Companion.cancellationReviewerWithCallback$credentials_play_services_auth_release(cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>(executor, callback){
                final /* synthetic */ Executor $executor;
                final /* synthetic */ CredentialManagerCallback<GetCredentialResponse, GetCredentialException> $callback;
                {
                    this.$executor = $executor;
                    this.$callback = $callback;
                    super(0);
                }

                public final void invoke() {
                    this.$executor.execute(() -> onGetCredential.2.invoke$lambda$0(this.$callback));
                }

                private static final void invoke$lambda$0(CredentialManagerCallback $callback) {
                    Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
                    $callback.onError((Object)new GetCredentialProviderConfigurationException((CharSequence)"this feature requires the minimum API level to be 23"));
                }
            }));
            return;
        }
        if (Companion.isGetRestoreCredentialRequest$credentials_play_services_auth_release(request)) {
            if (!this.isAvailableOnDevice(242200000)) {
                Companion.cancellationReviewerWithCallback$credentials_play_services_auth_release(cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>(executor, callback){
                    final /* synthetic */ Executor $executor;
                    final /* synthetic */ CredentialManagerCallback<GetCredentialResponse, GetCredentialException> $callback;
                    {
                        this.$executor = $executor;
                        this.$callback = $callback;
                        super(0);
                    }

                    public final void invoke() {
                        this.$executor.execute(() -> onGetCredential.3.invoke$lambda$0(this.$callback));
                    }

                    private static final void invoke$lambda$0(CredentialManagerCallback $callback) {
                        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
                        $callback.onError((Object)new GetCredentialProviderConfigurationException((CharSequence)"getCredentialAsync no provider dependencies found - please ensure the desired provider dependencies are added"));
                    }
                }));
                return;
            }
            new CredentialProviderGetRestoreCredentialController(context).invokePlayServices(request, callback, executor, cancellationSignal);
            return;
        }
        if (Companion.isGetSignInIntentRequest$credentials_play_services_auth_release(request)) {
            new CredentialProviderGetSignInIntentController(context).invokePlayServices(request, callback, executor, cancellationSignal);
            return;
        }
        new CredentialProviderBeginSignInController(context).invokePlayServices(request, callback, executor, cancellationSignal);
    }

    public void onCreateCredential(@NotNull Context context, @NotNull CreateCredentialRequest request, @Nullable CancellationSignal cancellationSignal, @NotNull Executor executor, @NotNull CredentialManagerCallback<CreateCredentialResponse, CreateCredentialException> callback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (Companion.cancellationReviewer$credentials_play_services_auth_release(cancellationSignal)) {
            return;
        }
        CreateCredentialRequest createCredentialRequest = request;
        if (createCredentialRequest instanceof CreatePasswordRequest) {
            CredentialProviderCreatePasswordController.Companion.getInstance(context).invokePlayServices((CreatePasswordRequest)request, callback, executor, cancellationSignal);
        } else if (createCredentialRequest instanceof CreatePublicKeyCredentialRequest) {
            CredentialProviderCreatePublicKeyCredentialController.Companion.getInstance(context).invokePlayServices((CreatePublicKeyCredentialRequest)request, callback, executor, cancellationSignal);
        } else if (createCredentialRequest instanceof CreateRestoreCredentialRequest) {
            if (!this.isAvailableOnDevice(242200000)) {
                Companion.cancellationReviewerWithCallback$credentials_play_services_auth_release(cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>(executor, callback){
                    final /* synthetic */ Executor $executor;
                    final /* synthetic */ CredentialManagerCallback<CreateCredentialResponse, CreateCredentialException> $callback;
                    {
                        this.$executor = $executor;
                        this.$callback = $callback;
                        super(0);
                    }

                    public final void invoke() {
                        this.$executor.execute(() -> onCreateCredential.1.invoke$lambda$0(this.$callback));
                    }

                    private static final void invoke$lambda$0(CredentialManagerCallback $callback) {
                        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
                        $callback.onError((Object)new CreateCredentialProviderConfigurationException((CharSequence)"createCredentialAsync no provider dependencies found - please ensure the desired provider dependencies are added"));
                    }
                }));
                return;
            }
            new CredentialProviderCreateRestoreCredentialController(context).invokePlayServices((CreateRestoreCredentialRequest)request, callback, executor, cancellationSignal);
        } else {
            throw new UnsupportedOperationException("Create Credential request is unsupported, not password or publickeycredential");
        }
    }

    public boolean isAvailableOnDevice() {
        return this.isAvailableOnDevice(230815045);
    }

    public final boolean isAvailableOnDevice(int minApkVersion) {
        boolean isSuccessful;
        int resultCode = this.isGooglePlayServicesAvailable(this.context, minApkVersion);
        boolean bl = isSuccessful = resultCode == 0;
        if (!isSuccessful) {
            ConnectionResult connectionResult = new ConnectionResult(resultCode);
            Log.w((String)TAG, (String)("Connection with Google Play Services was not successful. Connection result is: " + connectionResult));
        }
        return isSuccessful;
    }

    private final int isGooglePlayServicesAvailable(Context context, int minApkVersion) {
        return this.googleApiAvailability.isGooglePlayServicesAvailable(context, minApkVersion);
    }

    public void onClearCredential(@NotNull ClearCredentialStateRequest request, @Nullable CancellationSignal cancellationSignal, @NotNull Executor executor, @NotNull CredentialManagerCallback<Void, ClearCredentialException> callback) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (Companion.cancellationReviewer$credentials_play_services_auth_release(cancellationSignal)) {
            return;
        }
        if (Intrinsics.areEqual((Object)request.getRequestType(), (Object)"androidx.credentials.TYPE_CLEAR_RESTORE_CREDENTIAL")) {
            if (!this.isAvailableOnDevice(242200000)) {
                Companion.cancellationReviewerWithCallback$credentials_play_services_auth_release(cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>(executor, callback){
                    final /* synthetic */ Executor $executor;
                    final /* synthetic */ CredentialManagerCallback<Void, ClearCredentialException> $callback;
                    {
                        this.$executor = $executor;
                        this.$callback = $callback;
                        super(0);
                    }

                    public final void invoke() {
                        this.$executor.execute(() -> onClearCredential.1.invoke$lambda$0(this.$callback));
                    }

                    private static final void invoke$lambda$0(CredentialManagerCallback $callback) {
                        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
                        $callback.onError((Object)new ClearCredentialProviderConfigurationException((CharSequence)"clearCredentialStateAsync no provider dependencies found - please ensure the desired provider dependencies are added"));
                    }
                }));
                return;
            }
            RestoreCredential.getRestoreCredentialClient((Context)this.context).clearRestoreCredential(new ClearRestoreCredentialRequest(request.getRequestBundle())).addOnSuccessListener(arg_0 -> CredentialProviderPlayServicesImpl.onClearCredential$lambda$0((Function1)new Function1<Boolean, Unit>(cancellationSignal, executor, callback){
                final /* synthetic */ CancellationSignal $cancellationSignal;
                final /* synthetic */ Executor $executor;
                final /* synthetic */ CredentialManagerCallback<Void, ClearCredentialException> $callback;
                {
                    this.$cancellationSignal = $cancellationSignal;
                    this.$executor = $executor;
                    this.$callback = $callback;
                    super(1);
                }

                public final void invoke(Boolean it) {
                    CredentialProviderPlayServicesImpl.Companion.cancellationReviewerWithCallback$credentials_play_services_auth_release(this.$cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>(this.$executor, this.$callback){
                        final /* synthetic */ Executor $executor;
                        final /* synthetic */ CredentialManagerCallback<Void, ClearCredentialException> $callback;
                        {
                            this.$executor = $executor;
                            this.$callback = $callback;
                            super(0);
                        }

                        public final void invoke() {
                            Log.i((String)"PlayServicesImpl", (String)"Cleared restore credential successfully!");
                            this.$executor.execute(() -> onClearCredential.1.invoke$lambda$0(this.$callback));
                        }

                        private static final void invoke$lambda$0(CredentialManagerCallback $callback) {
                            Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
                            $callback.onResult(null);
                        }
                    }));
                }
            }, arg_0)).addOnFailureListener(arg_0 -> CredentialProviderPlayServicesImpl.onClearCredential$lambda$1(cancellationSignal, executor, callback, arg_0));
        } else {
            Identity.getSignInClient((Context)this.context).signOut().addOnSuccessListener(arg_0 -> CredentialProviderPlayServicesImpl.onClearCredential$lambda$2((Function1)new Function1<Void, Unit>(cancellationSignal, executor, callback){
                final /* synthetic */ CancellationSignal $cancellationSignal;
                final /* synthetic */ Executor $executor;
                final /* synthetic */ CredentialManagerCallback<Void, ClearCredentialException> $callback;
                {
                    this.$cancellationSignal = $cancellationSignal;
                    this.$executor = $executor;
                    this.$callback = $callback;
                    super(1);
                }

                public final void invoke(Void it) {
                    CredentialProviderPlayServicesImpl.Companion.cancellationReviewerWithCallback$credentials_play_services_auth_release(this.$cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>(this.$executor, this.$callback){
                        final /* synthetic */ Executor $executor;
                        final /* synthetic */ CredentialManagerCallback<Void, ClearCredentialException> $callback;
                        {
                            this.$executor = $executor;
                            this.$callback = $callback;
                            super(0);
                        }

                        public final void invoke() {
                            Log.i((String)"PlayServicesImpl", (String)"During clear credential, signed out successfully!");
                            this.$executor.execute(() -> onClearCredential.1.invoke$lambda$0(this.$callback));
                        }

                        private static final void invoke$lambda$0(CredentialManagerCallback $callback) {
                            Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
                            $callback.onResult(null);
                        }
                    }));
                }
            }, arg_0)).addOnFailureListener(arg_0 -> CredentialProviderPlayServicesImpl.onClearCredential$lambda$4(this, cancellationSignal, executor, callback, arg_0));
        }
    }

    private static final void onClearCredential$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void onClearCredential$lambda$1(CancellationSignal $cancellationSignal, Executor $executor, CredentialManagerCallback $callback, Exception e) {
        Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Log.w((String)TAG, (String)"Clearing restore credential failed", (Throwable)e);
        Ref.ObjectRef clearException = new Ref.ObjectRef();
        clearException.element = new ClearCredentialUnknownException((CharSequence)"Clear restore credential failed for unknown reason.");
        if (e instanceof ApiException && ((ApiException)e).getStatusCode() == 40201) {
            clearException.element = new ClearCredentialUnknownException((CharSequence)"The restore credential internal service had a failure.");
        }
        Companion.cancellationReviewerWithCallback$credentials_play_services_auth_release($cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>($executor, (CredentialManagerCallback<Void, ClearCredentialException>)$callback, (Ref.ObjectRef<ClearCredentialException>)clearException){
            final /* synthetic */ Executor $executor;
            final /* synthetic */ CredentialManagerCallback<Void, ClearCredentialException> $callback;
            final /* synthetic */ Ref.ObjectRef<ClearCredentialException> $clearException;
            {
                this.$executor = $executor;
                this.$callback = $callback;
                this.$clearException = $clearException;
                super(0);
            }

            public final void invoke() {
                this.$executor.execute(() -> onClearCredential.3.1.invoke$lambda$0(this.$callback, this.$clearException));
            }

            private static final void invoke$lambda$0(CredentialManagerCallback $callback, Ref.ObjectRef $clearException) {
                Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
                Intrinsics.checkNotNullParameter((Object)$clearException, (String)"$clearException");
                $callback.onError($clearException.element);
            }
        }));
    }

    private static final void onClearCredential$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void onClearCredential$lambda$4(CredentialProviderPlayServicesImpl this$0, CancellationSignal $cancellationSignal, Executor $executor, CredentialManagerCallback $callback, Exception e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        CredentialProviderPlayServicesImpl $this$onClearCredential_u24lambda_u244_u24lambda_u243 = this$0;
        boolean bl = false;
        Companion.cancellationReviewerWithCallback$credentials_play_services_auth_release($cancellationSignal, (Function0<Unit>)((Function0)new Function0<Unit>(e, $executor, (CredentialManagerCallback<Void, ClearCredentialException>)$callback){
            final /* synthetic */ Exception $e;
            final /* synthetic */ Executor $executor;
            final /* synthetic */ CredentialManagerCallback<Void, ClearCredentialException> $callback;
            {
                this.$e = $e;
                this.$executor = $executor;
                this.$callback = $callback;
                super(0);
            }

            public final void invoke() {
                Log.w((String)"PlayServicesImpl", (String)("During clear credential sign out failed with " + this.$e));
                this.$executor.execute(() -> onClearCredential.5.1.1.invoke$lambda$0(this.$callback, this.$e));
            }

            private static final void invoke$lambda$0(CredentialManagerCallback $callback, Exception $e) {
                Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
                Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
                $callback.onError((Object)new ClearCredentialUnknownException((CharSequence)$e.getMessage()));
            }
        }));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0002\b\rJ%\u0010\u000e\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0015\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u0015\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0018J\u0015\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001aR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/credentials/playservices/CredentialProviderPlayServicesImpl$Companion;", "", "()V", "MIN_GMS_APK_VERSION", "", "MIN_GMS_APK_VERSION_DIGITAL_CRED", "MIN_GMS_APK_VERSION_RESTORE_CRED", "TAG", "", "cancellationReviewer", "", "cancellationSignal", "Landroid/os/CancellationSignal;", "cancellationReviewer$credentials_play_services_auth_release", "cancellationReviewerWithCallback", "", "callback", "Lkotlin/Function0;", "cancellationReviewerWithCallback$credentials_play_services_auth_release", "isDigitalCredentialRequest", "request", "Landroidx/credentials/GetCredentialRequest;", "isDigitalCredentialRequest$credentials_play_services_auth_release", "isGetRestoreCredentialRequest", "isGetRestoreCredentialRequest$credentials_play_services_auth_release", "isGetSignInIntentRequest", "isGetSignInIntentRequest$credentials_play_services_auth_release", "credentials-play-services-auth_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void cancellationReviewerWithCallback$credentials_play_services_auth_release(@Nullable CancellationSignal cancellationSignal, @NotNull Function0<Unit> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            if (!this.cancellationReviewer$credentials_play_services_auth_release(cancellationSignal)) {
                callback.invoke();
            }
        }

        public final boolean cancellationReviewer$credentials_play_services_auth_release(@Nullable CancellationSignal cancellationSignal) {
            if (cancellationSignal != null) {
                if (cancellationSignal.isCanceled()) {
                    Log.i((String)CredentialProviderPlayServicesImpl.TAG, (String)"the flow has been canceled");
                    return true;
                }
            } else {
                Log.i((String)CredentialProviderPlayServicesImpl.TAG, (String)"No cancellationSignal found");
            }
            return false;
        }

        public final boolean isGetSignInIntentRequest$credentials_play_services_auth_release(@NotNull GetCredentialRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            for (CredentialOption option : request.getCredentialOptions()) {
                if (!(option instanceof GetSignInWithGoogleOption)) continue;
                return true;
            }
            return false;
        }

        public final boolean isGetRestoreCredentialRequest$credentials_play_services_auth_release(@NotNull GetCredentialRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            for (CredentialOption option : request.getCredentialOptions()) {
                if (!(option instanceof GetRestoreCredentialOption)) continue;
                return true;
            }
            return false;
        }

        public final boolean isDigitalCredentialRequest$credentials_play_services_auth_release(@NotNull GetCredentialRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            for (CredentialOption option : request.getCredentialOptions()) {
                if (!(option instanceof GetDigitalCredentialOption)) continue;
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

