/*
 * Decompiled with CFR 0.152.
 */
package androidx.credentials.registry.provider.playservices;

import android.content.Context;
import android.os.CancellationSignal;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.credentials.CredentialManagerCallback;
import androidx.credentials.registry.provider.RegisterCredentialsException;
import androidx.credentials.registry.provider.RegisterCredentialsRequest;
import androidx.credentials.registry.provider.RegisterCredentialsResponse;
import androidx.credentials.registry.provider.RegisterCredentialsUnknownException;
import androidx.credentials.registry.provider.RegistryManagerProvider;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.identitycredentials.IdentityCredentialClient;
import com.google.android.gms.identitycredentials.IdentityCredentialManager;
import com.google.android.gms.identitycredentials.RegistrationRequest;
import com.google.android.gms.identitycredentials.RegistrationResponse;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J6\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"Landroidx/credentials/registry/provider/playservices/RegistryManagerProviderPlayServicesImpl;", "Landroidx/credentials/registry/provider/RegistryManagerProvider;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "client", "Lcom/google/android/gms/identitycredentials/IdentityCredentialClient;", "googleApiAvailability", "Lcom/google/android/gms/common/GoogleApiAvailability;", "getGoogleApiAvailability$registry_provider_play_services_release$annotations", "()V", "getGoogleApiAvailability$registry_provider_play_services_release", "()Lcom/google/android/gms/common/GoogleApiAvailability;", "setGoogleApiAvailability$registry_provider_play_services_release", "(Lcom/google/android/gms/common/GoogleApiAvailability;)V", "isAvailable", "", "isAvailableOnDevice", "minApkVersion", "", "isGooglePlayServicesAvailable", "onRegisterCredentials", "", "request", "Landroidx/credentials/registry/provider/RegisterCredentialsRequest;", "cancellationSignal", "Landroid/os/CancellationSignal;", "executor", "Ljava/util/concurrent/Executor;", "callback", "Landroidx/credentials/CredentialManagerCallback;", "Landroidx/credentials/registry/provider/RegisterCredentialsResponse;", "Landroidx/credentials/registry/provider/RegisterCredentialsException;", "Companion", "registry-provider-play-services_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class RegistryManagerProviderPlayServicesImpl
implements RegistryManagerProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private GoogleApiAvailability googleApiAvailability;
    @NotNull
    private final IdentityCredentialClient client;
    @Deprecated
    public static final int MIN_GMS_APK_VERSION = 243100000;

    public RegistryManagerProviderPlayServicesImpl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)googleApiAvailability, (String)"getInstance(...)");
        this.googleApiAvailability = googleApiAvailability;
        this.client = IdentityCredentialManager.Companion.getClient(this.context);
    }

    @NotNull
    public final GoogleApiAvailability getGoogleApiAvailability$registry_provider_play_services_release() {
        return this.googleApiAvailability;
    }

    public final void setGoogleApiAvailability$registry_provider_play_services_release(@NotNull GoogleApiAvailability googleApiAvailability) {
        Intrinsics.checkNotNullParameter((Object)googleApiAvailability, (String)"<set-?>");
        this.googleApiAvailability = googleApiAvailability;
    }

    @VisibleForTesting
    public static /* synthetic */ void getGoogleApiAvailability$registry_provider_play_services_release$annotations() {
    }

    public void onRegisterCredentials(@NotNull RegisterCredentialsRequest request, @Nullable CancellationSignal cancellationSignal, @NotNull Executor executor, @NotNull CredentialManagerCallback<RegisterCredentialsResponse, RegisterCredentialsException> callback) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        RegistrationRequest gmsRequest = new RegistrationRequest(request.getCredentials(), request.getMatcher(), request.getType(), "", CollectionsKt.emptyList());
        this.client.registerCredentials(gmsRequest).addOnSuccessListener(arg_0 -> RegistryManagerProviderPlayServicesImpl.onRegisterCredentials$lambda$0((Function1)new Function1<RegistrationResponse, Unit>(callback, request){
            final /* synthetic */ CredentialManagerCallback<RegisterCredentialsResponse, RegisterCredentialsException> $callback;
            final /* synthetic */ RegisterCredentialsRequest $request;
            {
                this.$callback = $callback;
                this.$request = $request;
                super(1);
            }

            public final void invoke(RegistrationResponse it) {
                String string = this.$request.getType();
                this.$callback.onResult((Object)new RegisterCredentialsResponse(string){});
            }
        }, arg_0)).addOnFailureListener(arg_0 -> RegistryManagerProviderPlayServicesImpl.onRegisterCredentials$lambda$1(callback, arg_0));
    }

    public boolean isAvailable() {
        return this.isAvailableOnDevice(243100000);
    }

    private final int isGooglePlayServicesAvailable(Context context, int minApkVersion) {
        return this.googleApiAvailability.isGooglePlayServicesAvailable(context, minApkVersion);
    }

    private final boolean isAvailableOnDevice(int minApkVersion) {
        int resultCode = this.isGooglePlayServicesAvailable(this.context, minApkVersion);
        return resultCode == 0;
    }

    private static final void onRegisterCredentials$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void onRegisterCredentials$lambda$1(CredentialManagerCallback $callback, Exception it) {
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $callback.onError((Object)new RegisterCredentialsUnknownException((CharSequence)it.getMessage()));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/credentials/registry/provider/playservices/RegistryManagerProviderPlayServicesImpl$Companion;", "", "()V", "MIN_GMS_APK_VERSION", "", "registry-provider-play-services_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

