/*
 * Decompiled with CFR 0.152.
 */
package androidx.credentials.registry.provider;

import android.content.Context;
import android.os.CancellationSignal;
import androidx.credentials.CredentialManagerCallback;
import androidx.credentials.registry.provider.RegisterCredentialsConfigurationException;
import androidx.credentials.registry.provider.RegisterCredentialsException;
import androidx.credentials.registry.provider.RegisterCredentialsRequest;
import androidx.credentials.registry.provider.RegisterCredentialsResponse;
import androidx.credentials.registry.provider.RegistryManager;
import androidx.credentials.registry.provider.RegistryManagerProvider;
import androidx.credentials.registry.provider.RegistryManagerProviderFactory;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/credentials/registry/provider/RegistryManagerImpl;", "Landroidx/credentials/registry/provider/RegistryManager;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "registerCredentialsAsync", "", "request", "Landroidx/credentials/registry/provider/RegisterCredentialsRequest;", "cancellationSignal", "Landroid/os/CancellationSignal;", "executor", "Ljava/util/concurrent/Executor;", "callback", "Landroidx/credentials/CredentialManagerCallback;", "Landroidx/credentials/registry/provider/RegisterCredentialsResponse;", "Landroidx/credentials/registry/provider/RegisterCredentialsException;", "registry-provider_release"})
public final class RegistryManagerImpl
extends RegistryManager {
    @NotNull
    private final Context context;

    public RegistryManagerImpl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    public void registerCredentialsAsync(@NotNull RegisterCredentialsRequest request, @Nullable CancellationSignal cancellationSignal, @NotNull Executor executor, @NotNull CredentialManagerCallback<RegisterCredentialsResponse, RegisterCredentialsException> callback2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        RegistryManagerProvider provider = new RegistryManagerProviderFactory(this.context).getBestAvailableProvider();
        if (provider == null) {
            callback2.onError((Object)new RegisterCredentialsConfigurationException((CharSequence)"registerCredentials: no provider dependencies found - please ensure the desired provider dependencies are added"));
            return;
        }
        provider.onRegisterCredentials(request, cancellationSignal, executor, callback2);
    }
}

