/*
 * Decompiled with CFR 0.152.
 */
package androidx.credentials.registry.provider;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.ServiceInfo;
import androidx.credentials.registry.provider.RegistryManagerProvider;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0018\u0010\n\u001a\u0004\u0018\u00010\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/credentials/registry/provider/RegistryManagerProviderFactory;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getAllowedProvidersFromManifest", "", "", "getBestAvailableProvider", "Landroidx/credentials/registry/provider/RegistryManagerProvider;", "instantiateProvider", "classNames", "Companion", "registry-provider_release"})
public final class RegistryManagerProviderFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private static final String REGISTRY_MANAGER_PROVIDER_KEY = "androidx.credentials.registry.provider.REGISTRY_MANAGER_PROVIDER_KEY";

    public RegistryManagerProviderFactory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Nullable
    public final RegistryManagerProvider getBestAvailableProvider() {
        List<String> classNames = this.getAllowedProvidersFromManifest();
        return classNames.isEmpty() ? null : this.instantiateProvider(classNames);
    }

    private final List<String> getAllowedProvidersFromManifest() {
        PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 132);
        List classNames = new ArrayList();
        if (packageInfo.services != null) {
            Intrinsics.checkNotNull((Object)packageInfo.services);
            for (ServiceInfo serviceInfo : packageInfo.services) {
                String className;
                if (serviceInfo.metaData == null || (className = serviceInfo.metaData.getString(REGISTRY_MANAGER_PROVIDER_KEY)) == null) continue;
                classNames.add(className);
            }
        }
        return CollectionsKt.toList((Iterable)classNames);
    }

    private final RegistryManagerProvider instantiateProvider(List<String> classNames) {
        RegistryManagerProvider provider = null;
        for (String className : classNames) {
            try {
                Class<?> klass = Class.forName(className);
                Object[] objectArray = new Class[]{Context.class};
                Constructor<?> constructor = klass.getConstructor((Class<?>[])objectArray);
                objectArray = new Object[]{this.context};
                Object obj = constructor.newInstance(objectArray);
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type androidx.credentials.registry.provider.RegistryManagerProvider");
                RegistryManagerProvider p = (RegistryManagerProvider)obj;
                if (!p.isAvailable()) continue;
                if (provider != null) {
                    return null;
                }
                provider = p;
            }
            catch (Throwable throwable) {}
        }
        return provider;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/credentials/registry/provider/RegistryManagerProviderFactory$Companion;", "", "()V", "REGISTRY_MANAGER_PROVIDER_KEY", "", "registry-provider_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

