/*
 * Decompiled with CFR 0.152.
 */
package androidx.databinding.adapters;

import android.widget.CalendarView;
import androidx.annotation.RestrictTo;
import androidx.databinding.BindingAdapter;
import androidx.databinding.InverseBindingListener;
import androidx.databinding.InverseBindingMethod;
import androidx.databinding.InverseBindingMethods;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@InverseBindingMethods(value={@InverseBindingMethod(type=CalendarView.class, attribute="android:date")})
public class CalendarViewBindingAdapter {
    @BindingAdapter(value={"android:date"})
    public static void setDate(CalendarView view, long date) {
        if (view.getDate() != date) {
            view.setDate(date);
        }
    }

    @BindingAdapter(value={"android:onSelectedDayChange", "android:dateAttrChanged"}, requireAll=false)
    public static void setListeners(CalendarView view, final CalendarView.OnDateChangeListener onDayChange, final InverseBindingListener attrChange) {
        if (attrChange == null) {
            view.setOnDateChangeListener(onDayChange);
        } else {
            view.setOnDateChangeListener(new CalendarView.OnDateChangeListener(){

                public void onSelectedDayChange(CalendarView view, int year, int month, int dayOfMonth) {
                    if (onDayChange != null) {
                        onDayChange.onSelectedDayChange(view, year, month, dayOfMonth);
                    }
                    attrChange.onChange();
                }
            });
        }
    }
}

