/*
 * Decompiled with CFR 0.152.
 */
package androidx.databinding.adapters;

import android.widget.RadioGroup;
import androidx.annotation.RestrictTo;
import androidx.databinding.BindingAdapter;
import androidx.databinding.InverseBindingListener;
import androidx.databinding.InverseBindingMethod;
import androidx.databinding.InverseBindingMethods;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@InverseBindingMethods(value={@InverseBindingMethod(type=RadioGroup.class, attribute="android:checkedButton", method="getCheckedRadioButtonId")})
public class RadioGroupBindingAdapter {
    @BindingAdapter(value={"android:checkedButton"})
    public static void setCheckedButton(RadioGroup view, int id2) {
        if (id2 != view.getCheckedRadioButtonId()) {
            view.check(id2);
        }
    }

    @BindingAdapter(value={"android:onCheckedChanged", "android:checkedButtonAttrChanged"}, requireAll=false)
    public static void setListeners(RadioGroup view, final RadioGroup.OnCheckedChangeListener listener, final InverseBindingListener attrChange) {
        if (attrChange == null) {
            view.setOnCheckedChangeListener(listener);
        } else {
            view.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

                public void onCheckedChanged(RadioGroup group, int checkedId) {
                    if (listener != null) {
                        listener.onCheckedChanged(group, checkedId);
                    }
                    attrChange.onChange();
                }
            });
        }
    }
}

