/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.LayoutXmlProcessor;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.ScopedException;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.writer.JavaFileWriter;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class DataBindingBuilder {
    Versions mVersions;
    private static final List<String> EXCLUDE_PATTERNS = Arrays.asList("android/databinding/layouts/*.*", "androidx/databinding/layouts/*.*");
    public static final String PROCESSOR_NAME = "android.databinding.annotationprocessor.ProcessDataBinding";
    public static final String ARTIFACT_BASE_CLASSES_DIR_FROM_LIBS = "dependent-lib-base-classes";
    public static final String INCREMENTAL_BIN_AAR_DIR = "bin-files";
    public static final String INCREMENTAL_BINDING_CLASSES_LIST_DIR = "binding-class-list";
    public static final String DATA_BINDING_ROOT_FOLDER_IN_AAR = "data-binding";
    public static final String DATA_BINDING_CLASS_LOG_ROOT_FOLDER_IN_AAR = "data-binding-base-class-log";
    public static final String BR_FILE_EXT = "-br.bin";
    public static final String LAYOUT_INFO_FILE_EXT = "-layoutinfo.bin";
    private static final String SETTER_STORE_FILE_EXT = "-setter_store.bin";
    private static final String SETTER_STORE_JSON_FILE_EXT = "-setter_store.json";
    public static final List<String> RESOURCE_FILE_EXTENSIONS = ImmutableList.of((Object)"-br.bin", (Object)"-layoutinfo.bin", (Object)"-setter_store.bin", (Object)"-setter_store.json");
    public static final String BINDING_CLASS_LIST_SUFFIX = "-binding_classes.json";
    public static final String FEATURE_PACKAGE_LIST_FILE_NAME = "all_features.json";
    public static final String FEATURE_BR_OFFSET_FILE_NAME = "feature_data.json";

    public String getCompilerVersion() {
        return this.getVersions().compiler;
    }

    public String getBaseLibraryVersion(String compilerVersion) {
        return this.getVersions().baseLibrary;
    }

    public String getLibraryVersion(String compilerVersion) {
        return this.getVersions().extensions;
    }

    public String getBaseAdaptersVersion(String compilerVersion) {
        return this.getVersions().extensions;
    }

    public void setPrintMachineReadableOutput(boolean machineReadableOutput) {
        ScopedException.encodeOutput(machineReadableOutput);
    }

    public boolean getPrintMachineReadableOutput() {
        return ScopedException.issEncodeOutput();
    }

    public void setDebugLogEnabled(boolean enableDebugLogs) {
        L.setDebugLog(enableDebugLogs);
    }

    public boolean isDebugLogEnabled() {
        return L.isDebugEnabled();
    }

    private Versions getVersions() {
        if (this.mVersions != null) {
            return this.mVersions;
        }
        try {
            Properties props = new Properties();
            InputStream stream = this.getClass().getResourceAsStream("/data_binding_version_info.properties");
            try {
                props.load(stream);
                this.mVersions = new Versions(props);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        catch (IOException exception) {
            L.e(exception, "Cannot read data binding version", new Object[0]);
        }
        return this.mVersions;
    }

    public List<String> getJarExcludeList(LayoutXmlProcessor layoutXmlProcessor, File generatedClassListFile, File dataBindingCompilerBuildFolder) {
        ArrayList<String> excludes = new ArrayList<String>();
        String infoClassAsFile = layoutXmlProcessor.getInfoClassFullName().replace('.', '/');
        excludes.add(infoClassAsFile + ".class");
        excludes.addAll(EXCLUDE_PATTERNS);
        excludes.add(layoutXmlProcessor.getPackage().replace('.', '/') + "/BR.*");
        for (String pkg : DataBindingBuilder.getBRFilePackages(dataBindingCompilerBuildFolder)) {
            excludes.add(pkg.replace('.', '/') + "/BR.*");
        }
        if (generatedClassListFile != null) {
            List<String> generatedClasses = this.readGeneratedClasses(generatedClassListFile);
            for (String klass : generatedClasses) {
                excludes.add(klass.replace('.', '/') + ".class");
            }
        }
        Scope.assertNoError();
        return excludes;
    }

    private static List<String> getBRFilePackages(File dependencyArtifactsDir) {
        ArrayList<String> packages = new ArrayList<String>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dependencyArtifactsDir.toPath());){
            for (Path path : directoryStream) {
                String filename = path.getFileName().toString();
                if (!filename.endsWith(BR_FILE_EXT)) continue;
                packages.add(filename.substring(0, filename.indexOf(45)));
            }
        }
        catch (IOException e) {
            L.e(e, "Error reading contents of %s directory", dependencyArtifactsDir);
        }
        return packages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<String> readGeneratedClasses(File generatedClassListFile) {
        List list;
        Preconditions.checkNotNull(generatedClassListFile, "Data binding exclude generated task is not configured properly", new Object[0]);
        Preconditions.check(generatedClassListFile.exists(), "Generated class list does not exist %s", generatedClassListFile.getAbsolutePath());
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(generatedClassListFile);
            list = IOUtils.readLines((InputStream)fis);
        }
        catch (FileNotFoundException e) {
            L.e(e, "Unable to read generated class list from %s", generatedClassListFile.getAbsoluteFile());
            IOUtils.closeQuietly((InputStream)fis);
        }
        catch (IOException e2) {
            L.e(e2, "Unexpected exception while reading %s", generatedClassListFile.getAbsoluteFile());
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)fis);
        }
        IOUtils.closeQuietly((InputStream)fis);
        return list;
        L.e("Could not read data binding generated class list", new Object[0]);
        return null;
    }

    public JavaFileWriter createJavaFileWriter(File outFolder) {
        return new GradleFileWriter(outFolder.getAbsolutePath());
    }

    private static class Versions {
        final String compilerCommon;
        final String compiler;
        final String baseLibrary;
        final String extensions;

        public Versions(Properties properties) {
            this.compilerCommon = properties.getProperty("compilerCommon");
            this.compiler = properties.getProperty("compiler");
            this.baseLibrary = properties.getProperty("baseLibrary");
            this.extensions = properties.getProperty("extensions");
            Preconditions.checkNotNull(this.compilerCommon, "cannot read compiler common version", new Object[0]);
            Preconditions.checkNotNull(this.compiler, "cannot read compiler version", new Object[0]);
            Preconditions.checkNotNull(this.baseLibrary, "cannot read baseLibrary version", new Object[0]);
            Preconditions.checkNotNull(this.extensions, "cannot read extensions version", new Object[0]);
        }
    }

    public static class GradleFileWriter
    extends JavaFileWriter {
        private final String outputBase;

        public GradleFileWriter(String outputBase) {
            this.outputBase = outputBase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeToFile(String canonicalName, String contents) {
            File f = this.toFile(canonicalName);
            f.getParentFile().mkdirs();
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                IOUtils.write((String)contents, (OutputStream)fos);
            }
            catch (IOException e) {
                try {
                    L.e(e, "cannot write file " + f.getAbsolutePath(), new Object[0]);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fos);
            }
            IOUtils.closeQuietly((OutputStream)fos);
        }

        private File toFile(String canonicalName) {
            String asPath = canonicalName.replace('.', File.separatorChar);
            return new File(this.outputBase + File.separatorChar + asPath + ".java");
        }

        @Override
        public void deleteFile(String canonicalName) {
            FileUtils.deleteQuietly((File)this.toFile(canonicalName));
        }
    }
}

