/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.store;

import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.ScopedException;
import android.databinding.tool.processing.scopes.FileScopeProvider;
import android.databinding.tool.processing.scopes.LocationScopeProvider;
import android.databinding.tool.store.GenClassInfoLog;
import android.databinding.tool.store.Location;
import android.databinding.tool.util.L;
import android.databinding.tool.util.ParserHelper;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.util.RelativizableFile;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class ResourceBundle
implements Serializable {
    private static final List<String> ANDROID_VIEW_PACKAGE_VIEWS = Arrays.asList("View", "ViewGroup", "ViewStub", "TextureView", "SurfaceView");
    private String mAppPackage;
    private HashMap<String, List<LayoutFileBundle>> mLayoutBundles = new HashMap();
    private Set<LayoutFileBundle> mLayoutFileBundlesInSource = new HashSet<LayoutFileBundle>();
    private Map<String, IncludedLayout> mDependencyBinders = new HashMap<String, IncludedLayout>();
    private List<File> mRemovedFiles = new ArrayList<File>();
    private final String viewDataBindingClass;

    public ResourceBundle(String appPackage, boolean useAndroidX) {
        this.mAppPackage = appPackage;
        this.viewDataBindingClass = useAndroidX ? "androidx.databinding.ViewDataBinding" : "android.databinding.ViewDataBinding";
    }

    public void addLayoutBundle(LayoutFileBundle bundle, boolean fromSource) {
        if (bundle.mFileName == null) {
            L.e("File bundle must have a name. %s does not have one.", bundle);
            return;
        }
        if (fromSource) {
            this.mLayoutFileBundlesInSource.add(bundle);
        }
        List bundles = this.mLayoutBundles.computeIfAbsent(bundle.mFileName, ignored -> new ArrayList());
        for (LayoutFileBundle existing : bundles) {
            if (!existing.equals(bundle)) continue;
            L.d("skipping layout bundle %s because it already exists.", bundle);
            return;
        }
        L.d("adding bundle %s", bundle);
        bundles.add(bundle);
    }

    public void addDependencyLayouts(GenClassInfoLog genClassInfoLog) {
        genClassInfoLog.mappings().forEach((key, value) -> this.mDependencyBinders.put((String)key, new IncludedLayout.Builder().layoutName((String)key).modulePackage(value.getModulePackage()).interfaceQName(value.getQName()).build()));
    }

    @Deprecated
    public Set<LayoutFileBundle> getLayoutFileBundlesInSource() {
        return Sets.filter(this.mLayoutFileBundlesInSource, LayoutFileBundle::isBindingData);
    }

    public Set<LayoutFileBundle> getAllLayoutFileBundlesInSource() {
        return this.mLayoutFileBundlesInSource;
    }

    @Deprecated
    public Map<String, List<LayoutFileBundle>> getLayoutBundles() {
        return Maps.filterEntries(this.mLayoutBundles, entry -> ((LayoutFileBundle)((List)entry.getValue()).get(0)).isBindingData());
    }

    public Map<String, List<LayoutFileBundle>> getAllLayoutBundles() {
        return this.mLayoutBundles;
    }

    public String getAppPackage() {
        return this.mAppPackage;
    }

    public static GenClassInfoLog loadClassInfoFromFolder(File folder) throws IOException {
        GenClassInfoLog merged = new GenClassInfoLog();
        if (folder.isFile()) {
            try (ZipFile zipFile = new ZipFile(folder);){
                zipFile.stream().forEach(zipEntry -> {
                    if (zipEntry.getName().endsWith("-binding_classes.json")) {
                        try {
                            merged.addAll(GenClassInfoLog.fromInputStream(zipFile.getInputStream((ZipEntry)zipEntry)));
                        }
                        catch (IOException e) {
                            L.e(e, "failed to read gen class info log from entry %s", zipEntry.getName());
                        }
                    }
                });
            }
        } else if (folder.isDirectory()) {
            SuffixFileFilter fileFilter = new SuffixFileFilter("-binding_classes.json", IOCase.SYSTEM);
            Collection files = FileUtils.listFiles((File)folder, (IOFileFilter)fileFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
            for (File file : files) {
                merged.addAll(GenClassInfoLog.fromFile(file));
            }
        } else {
            L.w("no info log is passed. There are no resources?", new Object[0]);
        }
        return merged;
    }

    public void validateAndRegisterErrors() {
        this.validateBindingTargetIds();
        this.validateMultiResLayouts();
    }

    private void validateBindingTargetIds() {
        this.mLayoutBundles.forEach((name, layoutFileBundles) -> layoutFileBundles.forEach(bundle -> {
            HashSet ids = new HashSet();
            HashSet conflictingIds = new HashSet();
            bundle.getBindingTargetBundles().forEach(bindingTarget -> {
                String id = bindingTarget.getId();
                if (id != null && !ids.add(id)) {
                    conflictingIds.add(id);
                }
            });
            bundle.getBindingTargetBundles().forEach(bindingTarget -> {
                String id = bindingTarget.getId();
                if (id != null && conflictingIds.contains(id)) {
                    String tag = bindingTarget.mViewName != null ? bindingTarget.mViewName : (bindingTarget.mIncludedLayout != null ? "include" : "view");
                    String error = String.format("<%s id='%s'> conflicts with another tag that has the same ID", tag, id);
                    Scope.registerError(error, bundle, bindingTarget);
                }
            });
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void validateMultiResLayouts() {
        for (List<LayoutFileBundle> list : this.mLayoutBundles.values()) {
            for (LayoutFileBundle layoutFileBundle : list) {
                ArrayList<BindingTargetBundle> unboundIncludes = new ArrayList<BindingTargetBundle>();
                for (BindingTargetBundle target : layoutFileBundle.getBindingTargetBundles()) {
                    void var9_13;
                    if (!target.isBinder()) continue;
                    Iterator<Map.Entry<String, NameTypeLocation>> boundTo = this.mLayoutBundles.get(target.getIncludedLayout());
                    Object var9_14 = null;
                    String targetBindingPackage = null;
                    if (boundTo != null && !boundTo.isEmpty()) {
                        String string = boundTo.get(0).getFullBindingClass();
                        targetBindingPackage = boundTo.get(0).getModulePackage();
                    } else {
                        IncludedLayout included = this.mDependencyBinders.getOrDefault(target.getIncludedLayout(), null);
                        if (included != null) {
                            String string = included.interfaceQName;
                            targetBindingPackage = included.modulePackage;
                        }
                    }
                    if (var9_13 == null) {
                        L.d("There is no binding for %s, reverting to plain layout", target.getIncludedLayout());
                        if (target.getId() == null) {
                            unboundIncludes.add(target);
                            continue;
                        }
                        target.setInterfaceType("android.view.View");
                        target.mViewName = "android.view.View";
                        continue;
                    }
                    target.setInterfaceType((String)var9_13, targetBindingPackage);
                }
                layoutFileBundle.getBindingTargetBundles().removeAll(unboundIncludes);
            }
        }
        for (Map.Entry entry : this.mLayoutBundles.entrySet()) {
            if (((List)entry.getValue()).size() < 2) continue;
            for (LayoutFileBundle bundle : (List)entry.getValue()) {
                bundle.mHasVariations = true;
            }
            String bindingClass = this.validateAndGetSharedClassName((List)entry.getValue());
            Map<String, NameTypeLocation> variableTypes = this.validateAndMergeNameTypeLocations((List)entry.getValue(), "<variable name='%s' type='%s'> is not defined consistently on alternative layout '%s'", new ValidateAndFilterCallback(){

                @Override
                public List<? extends NameTypeLocation> get(LayoutFileBundle bundle) {
                    return bundle.mVariables;
                }
            });
            Map<String, NameTypeLocation> importTypes = this.validateAndMergeNameTypeLocations((List)entry.getValue(), "<import alias='%s' type='%s'> is not defined consistently on alternative layout '%s'", new ValidateAndFilterCallback(){

                public List<NameTypeLocation> get(LayoutFileBundle bundle) {
                    return bundle.mImports;
                }
            });
            for (LayoutFileBundle bundle : (List)entry.getValue()) {
                L.d("checking for missing variables in %s / %s", bundle.mFileName, bundle.mConfigName);
                for (Map.Entry entry2 : variableTypes.entrySet()) {
                    if (NameTypeLocation.contains(bundle.mVariables, (String)entry2.getKey())) continue;
                    NameTypeLocation orig = (NameTypeLocation)entry2.getValue();
                    bundle.addVariable(orig.name, orig.type, orig.location, false);
                    L.d("adding missing variable %s to %s / %s", entry2.getKey(), bundle.mFileName, bundle.mConfigName);
                }
                for (Map.Entry<String, NameTypeLocation> entry3 : importTypes.entrySet()) {
                    if (NameTypeLocation.contains(bundle.mImports, entry3.getKey())) continue;
                    bundle.mImports.add(entry3.getValue());
                    L.d("adding missing import %s to %s / %s", entry3.getKey(), bundle.mFileName, bundle.mConfigName);
                }
            }
            HashSet<String> includeBindingIds = new HashSet<String>();
            HashSet<String> viewBindingIds = new HashSet<String>();
            HashMap<String, String> viewTypes = new HashMap<String, String>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            L.d("validating ids for %s", entry.getKey());
            HashSet<String> conflictingIds = new HashSet<String>();
            for (LayoutFileBundle bundle : (List)entry.getValue()) {
                try {
                    Scope.enter(bundle);
                    for (BindingTargetBundle bindingTargetBundle : bundle.mBindingTargetBundles) {
                        try {
                            Scope.enter(bindingTargetBundle);
                            L.d("checking %s %s %s", bindingTargetBundle.getId(), bindingTargetBundle.getFullClassName(), bindingTargetBundle.isBinder());
                            if (bindingTargetBundle.mId == null) continue;
                            if (bindingTargetBundle.isBinder()) {
                                if (viewBindingIds.contains(bindingTargetBundle.mId)) {
                                    L.d("%s is conflicting", bindingTargetBundle.mId);
                                    conflictingIds.add(bindingTargetBundle.mId);
                                    continue;
                                }
                                includeBindingIds.add(bindingTargetBundle.mId);
                            } else {
                                if (includeBindingIds.contains(bindingTargetBundle.mId)) {
                                    L.d("%s is conflicting", bindingTargetBundle.mId);
                                    conflictingIds.add(bindingTargetBundle.mId);
                                    continue;
                                }
                                viewBindingIds.add(bindingTargetBundle.mId);
                            }
                            String existingType = (String)viewTypes.get(bindingTargetBundle.mId);
                            if (existingType == null) {
                                L.d("assigning %s as %s", bindingTargetBundle.getId(), bindingTargetBundle.getFullClassName());
                                viewTypes.put(bindingTargetBundle.mId, bindingTargetBundle.getFullClassName());
                                if (!bindingTargetBundle.isBinder()) continue;
                                hashMap.put(bindingTargetBundle.mId, bindingTargetBundle.getIncludedLayout());
                                continue;
                            }
                            if (existingType.equals(bindingTargetBundle.getFullClassName())) continue;
                            if (bindingTargetBundle.isBinder()) {
                                L.d("overriding %s as base binder", bindingTargetBundle.getId());
                                viewTypes.put(bindingTargetBundle.mId, this.viewDataBindingClass);
                                hashMap.put(bindingTargetBundle.mId, bindingTargetBundle.getIncludedLayout());
                                continue;
                            }
                            L.d("overriding %s as base view", bindingTargetBundle.getId());
                            viewTypes.put(bindingTargetBundle.mId, "android.view.View");
                        }
                        catch (ScopedException ex) {
                            Scope.defer(ex);
                        }
                        finally {
                            Scope.exit();
                        }
                    }
                }
                finally {
                    Scope.exit();
                }
            }
            if (!conflictingIds.isEmpty()) {
                for (LayoutFileBundle bundle : (List)entry.getValue()) {
                    for (BindingTargetBundle bindingTargetBundle : bundle.mBindingTargetBundles) {
                        if (!conflictingIds.contains(bindingTargetBundle.mId)) continue;
                        Scope.registerError(String.format("<include id='%s'> conflicts with an ID used by a view in this layout", bindingTargetBundle.mId), bundle, bindingTargetBundle);
                    }
                }
            }
            for (LayoutFileBundle bundle : (List)entry.getValue()) {
                try {
                    Scope.enter(bundle);
                    for (Map.Entry entry4 : viewTypes.entrySet()) {
                        BindingTargetBundle target = bundle.getBindingTargetById((String)entry4.getKey());
                        if (target == null) {
                            String include = (String)hashMap.get(entry4.getKey());
                            if (include == null) {
                                bundle.createBindingTarget((String)entry4.getKey(), (String)entry4.getValue(), false, null, null, null);
                                continue;
                            }
                            BindingTargetBundle bindingTargetBundle = bundle.createBindingTarget((String)entry4.getKey(), null, false, null, null, null);
                            bindingTargetBundle.setIncludedLayout(include);
                            bindingTargetBundle.setInterfaceType((String)entry4.getValue());
                            continue;
                        }
                        L.d("setting interface type on %s (%s) as %s", target.mId, target.getFullClassName(), entry4.getValue());
                        target.setInterfaceType((String)entry4.getValue());
                    }
                }
                catch (ScopedException ex) {
                    Scope.defer(ex);
                }
                finally {
                    Scope.exit();
                }
            }
        }
        for (Map.Entry entry : this.mLayoutBundles.entrySet()) {
            for (LayoutFileBundle bundle : (List)entry.getValue()) {
                String configName;
                if (bundle.hasVariations()) {
                    String parentFileName = bundle.mDirectory;
                    L.d("parent file for %s is %s", bundle.getFileName(), parentFileName);
                    configName = "layout".equals(parentFileName) ? "" : ParserHelper.toClassName(parentFileName.substring("layout-".length()));
                } else {
                    configName = "";
                }
                bundle.mConfigName = configName;
            }
        }
    }

    private Map<String, NameTypeLocation> validateAndMergeNameTypeLocations(List<LayoutFileBundle> bundles, String errorMessage, ValidateAndFilterCallback callback) {
        HashMap<String, NameTypeLocation> result = new HashMap<String, NameTypeLocation>();
        HashSet<String> mismatched = new HashSet<String>();
        for (LayoutFileBundle bundle : bundles) {
            for (NameTypeLocation nameTypeLocation : callback.get(bundle)) {
                NameTypeLocation existing = (NameTypeLocation)result.get(nameTypeLocation.name);
                if (existing != null && !existing.type.equals(nameTypeLocation.type)) {
                    mismatched.add(nameTypeLocation.name);
                    continue;
                }
                result.put(nameTypeLocation.name, nameTypeLocation);
            }
        }
        if (mismatched.isEmpty()) {
            return result;
        }
        for (String mismatch : mismatched) {
            for (LayoutFileBundle layoutFileBundle : bundles) {
                NameTypeLocation found = null;
                for (NameTypeLocation nameTypeLocation : callback.get(layoutFileBundle)) {
                    if (!mismatch.equals(nameTypeLocation.name)) continue;
                    found = nameTypeLocation;
                    break;
                }
                if (found == null) continue;
                Scope.registerError(String.format(errorMessage, found.name, found.type, layoutFileBundle.mDirectory + "/" + layoutFileBundle.getFileName()), layoutFileBundle, found.location.createScope());
            }
        }
        return result;
    }

    private String validateAndGetSharedClassName(List<LayoutFileBundle> bundles) {
        String sharedClassName = null;
        boolean hasMismatch = false;
        for (LayoutFileBundle bundle : bundles) {
            bundle.mHasVariations = true;
            String fullBindingClass = bundle.getFullBindingClass();
            if (sharedClassName == null) {
                sharedClassName = fullBindingClass;
                continue;
            }
            if (sharedClassName.equals(fullBindingClass)) continue;
            hasMismatch = true;
            break;
        }
        if (!hasMismatch) {
            return sharedClassName;
        }
        for (LayoutFileBundle bundle : bundles) {
            Scope.registerError(String.format("<data class='%s'> is not defined consistently on alternative layout '%s'", bundle.getFullBindingClass(), bundle.mDirectory + "/" + bundle.getFileName()), bundle, bundle.getClassNameLocationProvider());
        }
        return sharedClassName;
    }

    public void addRemovedFile(File file) {
        this.mRemovedFiles.add(file);
    }

    public List<File> getRemovedFiles() {
        return this.mRemovedFiles;
    }

    public static class IncludedLayout {
        public final String layoutName;
        public final String modulePackage;
        public final String interfaceQName;

        private IncludedLayout(String layoutName, String modulePackage, String interfaceQName) {
            this.layoutName = layoutName;
            this.modulePackage = modulePackage;
            this.interfaceQName = interfaceQName;
        }

        private static class Builder {
            private String mLayoutName;
            private String mModulePackage;
            private String mInterfaceQName;

            private Builder() {
            }

            Builder layoutName(String layoutName) {
                this.mLayoutName = layoutName;
                return this;
            }

            Builder modulePackage(String modulePackage) {
                this.mModulePackage = modulePackage;
                return this;
            }

            Builder interfaceQName(String interfaceQName) {
                this.mInterfaceQName = interfaceQName;
                return this;
            }

            public IncludedLayout build() {
                return new IncludedLayout(this.mLayoutName, this.mModulePackage, this.mInterfaceQName);
            }
        }
    }

    private static interface ValidateAndFilterCallback {
        public List<? extends NameTypeLocation> get(LayoutFileBundle var1);
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class BindingTargetBundle
    implements Serializable,
    LocationScopeProvider {
        @XmlAttribute(name="id")
        public String mId;
        @XmlAttribute(name="tag", required=true)
        public String mTag;
        @XmlAttribute(name="originalTag")
        public String mOriginalTag;
        @XmlAttribute(name="view", required=false)
        public String mViewName;
        private String mFullClassName;
        public boolean mUsed = true;
        @XmlElementWrapper(name="Expressions")
        @XmlElement(name="Expression")
        public List<BindingBundle> mBindingBundleList = new ArrayList<BindingBundle>();
        @XmlAttribute(name="include")
        public String mIncludedLayout;
        @XmlElement(name="location")
        public Location mLocation;
        private String mInterfaceType;
        private String mModulePackage;

        public BindingTargetBundle() {
        }

        public BindingTargetBundle(String id, String viewName, boolean used, String tag, String originalTag, Location location) {
            this.mId = id;
            this.mViewName = viewName;
            this.mUsed = used;
            this.mTag = tag;
            this.mOriginalTag = originalTag;
            this.mLocation = location;
        }

        public void addBinding(String name, String expr, boolean isTwoWay, Location location, Location valueLocation) {
            this.mBindingBundleList.add(new BindingBundle(name, expr, isTwoWay, location, valueLocation));
        }

        public void setIncludedLayout(String includedLayout) {
            this.mIncludedLayout = includedLayout;
        }

        public String getIncludedLayout() {
            return this.mIncludedLayout;
        }

        public String getViewName() {
            return this.mViewName;
        }

        public boolean isBinder() {
            return this.mIncludedLayout != null && (!"android.view.View".equals(this.mInterfaceType) || !"android.view.View".equals(this.mViewName));
        }

        public void setInterfaceType(String interfaceType) {
            this.setInterfaceType(interfaceType, null);
        }

        public void setInterfaceType(String interfaceType, String modulePackage) {
            this.mInterfaceType = interfaceType;
            this.mModulePackage = modulePackage;
        }

        public String getModulePackage() {
            return this.mModulePackage;
        }

        public void setLocation(Location location) {
            this.mLocation = location;
        }

        public Location getLocation() {
            return this.mLocation;
        }

        public String getId() {
            return this.mId;
        }

        public String getTag() {
            return this.mTag;
        }

        public String getOriginalTag() {
            return this.mOriginalTag;
        }

        public String getFullClassName() {
            if (this.mFullClassName == null) {
                this.mFullClassName = this.isBinder() ? this.mInterfaceType : (this.mViewName.indexOf(46) == -1 ? (ANDROID_VIEW_PACKAGE_VIEWS.contains(this.mViewName) ? "android.view." + this.mViewName : ("WebView".equals(this.mViewName) ? "android.webkit." + this.mViewName : "android.widget." + this.mViewName)) : this.mViewName);
            }
            if (this.mFullClassName == null) {
                L.e("Unexpected full class name = null. view = %s, interface = %s, layout = %s", this.mViewName, this.mInterfaceType, this.mIncludedLayout);
            }
            return this.mFullClassName;
        }

        public boolean isUsed() {
            return this.mUsed;
        }

        public List<BindingBundle> getBindingBundleList() {
            return this.mBindingBundleList;
        }

        public String getInterfaceType() {
            return this.mInterfaceType;
        }

        @Override
        public List<Location> provideScopeLocation() {
            return this.mLocation == null ? null : Collections.singletonList(this.mLocation);
        }

        @XmlAccessorType(value=XmlAccessType.NONE)
        public static class BindingBundle
        implements Serializable {
            private String mName;
            private String mExpr;
            private Location mLocation;
            private Location mValueLocation;
            private boolean mIsTwoWay;

            public BindingBundle() {
            }

            public BindingBundle(String name, String expr, boolean isTwoWay, Location location, Location valueLocation) {
                this.mName = name;
                this.mExpr = expr;
                this.mLocation = location;
                this.mIsTwoWay = isTwoWay;
                this.mValueLocation = valueLocation;
            }

            @XmlAttribute(name="attribute", required=true)
            public String getName() {
                return this.mName;
            }

            @XmlAttribute(name="text", required=true)
            public String getExpr() {
                return this.mExpr;
            }

            public void setName(String name) {
                this.mName = name;
            }

            public void setExpr(String expr) {
                this.mExpr = expr;
            }

            public void setTwoWay(boolean isTwoWay) {
                this.mIsTwoWay = isTwoWay;
            }

            @XmlElement(name="Location")
            public Location getLocation() {
                return this.mLocation;
            }

            public void setLocation(Location location) {
                this.mLocation = location;
            }

            @XmlElement(name="ValueLocation")
            public Location getValueLocation() {
                return this.mValueLocation;
            }

            @XmlElement(name="TwoWay")
            public boolean isTwoWay() {
                return this.mIsTwoWay;
            }

            public void setValueLocation(Location valueLocation) {
                this.mValueLocation = valueLocation;
            }
        }
    }

    public static class MarshalledMapType {
        public List<NameTypeLocation> entries;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class VariableDeclaration
    extends NameTypeLocation {
        @XmlAttribute(name="declared", required=false)
        public boolean declared;

        public VariableDeclaration() {
        }

        public VariableDeclaration(String name, String type, Location location, boolean declared) {
            super(name, type, location);
            this.declared = declared;
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class NameTypeLocation {
        @XmlAttribute(name="type", required=true)
        public String type;
        @XmlAttribute(name="name", required=true)
        public String name;
        @XmlElement(name="location", required=false)
        public Location location;

        public NameTypeLocation() {
        }

        public NameTypeLocation(String name, String type, Location location) {
            this.type = type;
            this.name = name;
            this.location = location;
        }

        public String toString() {
            return "{type='" + this.type + '\'' + ", name='" + this.name + '\'' + ", location=" + this.location + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameTypeLocation that = (NameTypeLocation)o;
            return Objects.equals(this.location, that.location) && this.name.equals(that.name) && this.type.equals(that.type);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.name, this.location);
        }

        public static boolean contains(List<? extends NameTypeLocation> list, String name) {
            for (NameTypeLocation nameTypeLocation : list) {
                if (!name.equals(nameTypeLocation.name)) continue;
                return true;
            }
            return false;
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlRootElement(name="Layout")
    public static class LayoutFileBundle
    implements Serializable,
    FileScopeProvider {
        @XmlAttribute(name="layout", required=true)
        public String mFileName;
        @XmlAttribute(name="modulePackage", required=true)
        public String mModulePackage;
        @XmlAttribute(name="filePath", required=true)
        public String mFilePath;
        private String mConfigName;
        @XmlAttribute(name="bindingClass", required=false)
        public String mBindingClass;
        @XmlElement(name="ClassNameLocation", required=false)
        private Location mClassNameLocation;
        private String mFullBindingClass;
        private String mBindingClassName;
        private String mBindingPackage;
        @XmlAttribute(name="directory", required=true)
        public String mDirectory;
        public boolean mHasVariations;
        @XmlElement(name="Variables")
        public List<VariableDeclaration> mVariables = new ArrayList<VariableDeclaration>();
        @XmlElement(name="Imports")
        public List<NameTypeLocation> mImports = new ArrayList<NameTypeLocation>();
        @XmlElementWrapper(name="Targets")
        @XmlElement(name="Target")
        public List<BindingTargetBundle> mBindingTargetBundles = new ArrayList<BindingTargetBundle>();
        @XmlAttribute(name="isMerge", required=true)
        private boolean mIsMerge;
        @XmlAttribute(name="isBindingData")
        private boolean mIsBindingData = true;
        private LocationScopeProvider mClassNameLocationProvider;
        private static final Marshaller sMarshaller;
        private static final Unmarshaller sUnmarshaller;

        public LayoutFileBundle() {
        }

        public void inheritConfigurationFrom(LayoutFileBundle other) {
            this.mFileName = other.mFileName;
            this.mModulePackage = other.mModulePackage;
            this.mBindingClass = other.mBindingClass;
            this.mFullBindingClass = other.mFullBindingClass;
            this.mBindingClassName = other.mBindingClassName;
            this.mBindingPackage = other.mBindingPackage;
            this.mHasVariations = other.mHasVariations;
            this.mIsMerge = other.mIsMerge;
            this.mIsBindingData = other.mIsBindingData;
        }

        public LayoutFileBundle(RelativizableFile file, String fileName, String directory, String modulePackage, boolean isMerge, boolean isBindingData) {
            this.mFilePath = file.getRelativeFile() != null ? file.getRelativeFile().getPath() : file.getAbsoluteFile().getPath();
            this.mFileName = fileName;
            this.mDirectory = directory;
            this.mModulePackage = modulePackage;
            this.mIsMerge = isMerge;
            this.mIsBindingData = isBindingData;
        }

        public LocationScopeProvider getClassNameLocationProvider() {
            if (this.mClassNameLocationProvider == null && this.mClassNameLocation != null && this.mClassNameLocation.isValid()) {
                this.mClassNameLocationProvider = this.mClassNameLocation.createScope();
            }
            return this.mClassNameLocationProvider;
        }

        public void addVariable(String name, String type, Location location, boolean declared) {
            Preconditions.check(!NameTypeLocation.contains(this.mVariables, name), "Cannot use same variable name twice. %s in %s", name, location);
            this.mVariables.add(new VariableDeclaration(name, type, location, declared));
        }

        public void addImport(String alias, String type, Location location) {
            Preconditions.check(!NameTypeLocation.contains(this.mImports, alias), "Cannot import same alias twice. %s in %s", alias, location);
            this.mImports.add(new NameTypeLocation(alias, type, location));
        }

        public BindingTargetBundle createBindingTarget(String id, String viewName, boolean used, String tag, String originalTag, Location location) {
            BindingTargetBundle target = new BindingTargetBundle(id, viewName, used, tag, originalTag, location);
            this.mBindingTargetBundles.add(target);
            return target;
        }

        public boolean isEmpty() {
            return this.mVariables.isEmpty() && this.mImports.isEmpty() && this.mBindingTargetBundles.isEmpty();
        }

        public BindingTargetBundle getBindingTargetById(String key) {
            for (BindingTargetBundle target : this.mBindingTargetBundles) {
                if (!key.equals(target.mId)) continue;
                return target;
            }
            return null;
        }

        public String getFileName() {
            return this.mFileName;
        }

        public String getConfigName() {
            return this.mConfigName;
        }

        public String getDirectory() {
            return this.mDirectory;
        }

        public boolean hasVariations() {
            return this.mHasVariations;
        }

        public List<VariableDeclaration> getVariables() {
            return this.mVariables;
        }

        public List<NameTypeLocation> getImports() {
            return this.mImports;
        }

        public boolean isMerge() {
            return this.mIsMerge;
        }

        public boolean isBindingData() {
            return this.mIsBindingData;
        }

        public String getBindingClassName() {
            if (this.mBindingClassName == null) {
                String fullClass = this.getFullBindingClass();
                int dotIndex = fullClass.lastIndexOf(46);
                this.mBindingClassName = fullClass.substring(dotIndex + 1);
            }
            return this.mBindingClassName;
        }

        public void setBindingClass(String bindingClass, Location location) {
            this.mBindingClass = bindingClass;
            this.mClassNameLocation = location;
        }

        public String getBindingClassPackage() {
            if (this.mBindingPackage == null) {
                String fullClass = this.getFullBindingClass();
                int dotIndex = fullClass.lastIndexOf(46);
                this.mBindingPackage = fullClass.substring(0, dotIndex);
            }
            return this.mBindingPackage;
        }

        public String getFullBindingClass() {
            if (this.mFullBindingClass == null) {
                this.mFullBindingClass = this.mBindingClass == null ? this.getModulePackage() + ".databinding." + ParserHelper.toClassName(this.getFileName()) + "Binding" : (this.mBindingClass.startsWith(".") ? this.getModulePackage() + this.mBindingClass : (this.mBindingClass.indexOf(46) < 0 ? this.getModulePackage() + ".databinding." + this.mBindingClass : this.mBindingClass));
            }
            return this.mFullBindingClass;
        }

        public String createImplClassNameWithConfig() {
            return this.getBindingClassName() + this.getConfigName() + "Impl";
        }

        public List<BindingTargetBundle> getBindingTargetBundles() {
            return this.mBindingTargetBundles;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LayoutFileBundle bundle = (LayoutFileBundle)o;
            return Objects.equals(this.mConfigName, bundle.mConfigName) && Objects.equals(this.mDirectory, bundle.mDirectory) && Objects.equals(this.mFileName, bundle.mFileName);
        }

        public int hashCode() {
            return Objects.hash(this.mFileName, this.mConfigName, this.mDirectory);
        }

        public String toString() {
            return "LayoutFileBundle{mHasVariations=" + this.mHasVariations + ", mDirectory='" + this.mDirectory + '\'' + ", mConfigName='" + this.mConfigName + '\'' + ", mModulePackage='" + this.mModulePackage + '\'' + ", mFileName='" + this.mFileName + '\'' + '}';
        }

        public String getModulePackage() {
            return this.mModulePackage;
        }

        public String getFilePath() {
            return this.mFilePath;
        }

        @Override
        public String provideScopeFilePath() {
            return this.getFilePath();
        }

        private static JAXBContext jaxbContext(Class<?> clazz) throws JAXBException {
            try {
                return (JAXBContext)Class.forName("com.sun.xml.bind.v2.ContextFactory").getMethod("createContext", Class[].class, Map.class).invoke(null, new Class[]{clazz}, Collections.emptyMap());
            }
            catch (ClassNotFoundException e) {
                return JAXBContext.newInstance((Class[])new Class[]{clazz});
            }
            catch (ReflectiveOperationException e) {
                throw new LinkageError(e.getMessage(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toXML() throws JAXBException {
            StringWriter writer = new StringWriter();
            Marshaller marshaller = sMarshaller;
            synchronized (marshaller) {
                sMarshaller.marshal((Object)this, (Writer)writer);
                return writer.getBuffer().toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static LayoutFileBundle fromXML(InputStream inputStream) throws JAXBException {
            Unmarshaller unmarshaller = sUnmarshaller;
            synchronized (unmarshaller) {
                return (LayoutFileBundle)sUnmarshaller.unmarshal(inputStream);
            }
        }

        public String createTag() {
            return this.getDirectory() + "/" + this.getFileName();
        }

        static {
            try {
                JAXBContext context = LayoutFileBundle.jaxbContext(LayoutFileBundle.class);
                sMarshaller = context.createMarshaller();
                sMarshaller.setProperty("jaxb.encoding", (Object)"utf-8");
                sUnmarshaller = context.createUnmarshaller();
            }
            catch (JAXBException e) {
                throw new RuntimeException("Cannot create the xml marshaller", e);
            }
        }
    }
}

