/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.LibTypes;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.store.GenClassInfoLog;
import android.databinding.tool.store.LayoutInfoInput;
import android.databinding.tool.store.LayoutInfoLog;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.writer.BaseLayoutBinderWriter;
import android.databinding.tool.writer.BaseLayoutModel;
import android.databinding.tool.writer.JavaFileWriter;
import android.databinding.tool.writer.ViewBinder;
import android.databinding.tool.writer.ViewBinderGenerateJavaKt;
import android.databinding.tool.writer.ViewBinderKt;
import com.squareup.javapoet.JavaFile;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001a\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R%\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroid/databinding/tool/BaseDataBinder;", "", "input", "Landroid/databinding/tool/store/LayoutInfoInput;", "getRPackage", "Lkotlin/Function2;", "", "(Landroid/databinding/tool/store/LayoutInfoInput;Lkotlin/jvm/functions/Function2;)V", "getGetRPackage", "()Lkotlin/jvm/functions/Function2;", "getInput", "()Landroid/databinding/tool/store/LayoutInfoInput;", "resourceBundle", "Landroid/databinding/tool/store/ResourceBundle;", "generateAll", "", "writer", "Landroid/databinding/tool/writer/JavaFileWriter;", "databinding-compiler-common"})
public final class BaseDataBinder {
    private final ResourceBundle resourceBundle;
    @NotNull
    private final LayoutInfoInput input;
    @Nullable
    private final Function2<String, String, String> getRPackage;

    /*
     * WARNING - void declaration
     */
    public final void generateAll(@NotNull JavaFileWriter writer) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Object it;
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Iterable $this$forEach$iv = this.input.getInvalidatedClasses();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            writer.deleteFile((String)it);
        }
        LayoutInfoLog myLog = new LayoutInfoLog();
        myLog.addAll(this.input.getUnchangedLog());
        boolean useAndroidX = this.input.getArgs().getUseAndroidX();
        LibTypes libTypes = new LibTypes(useAndroidX);
        Set<ResourceBundle.LayoutFileBundle> set = this.resourceBundle.getAllLayoutFileBundlesInSource();
        Intrinsics.checkNotNullExpressionValue(set, (String)"resourceBundle.allLayoutFileBundlesInSource");
        it = set;
        boolean $i$f$groupBy = false;
        void var8_8 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ResourceBundle.LayoutFileBundle p1 = (ResourceBundle.LayoutFileBundle)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = p1.getFileName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        SortedMap layoutBindings = MapsKt.toSortedMap((Map)destination$iv$iv);
        layoutBindings.forEach(new BiConsumer(this, libTypes, useAndroidX, writer, myLog){
            final /* synthetic */ BaseDataBinder this$0;
            final /* synthetic */ LibTypes $libTypes;
            final /* synthetic */ boolean $useAndroidX;
            final /* synthetic */ JavaFileWriter $writer;
            final /* synthetic */ LayoutInfoLog $myLog;

            public final void accept(String layoutName, List<? extends ResourceBundle.LayoutFileBundle> variations) {
                boolean bl;
                boolean bl2;
                List<? extends ResourceBundle.LayoutFileBundle> list = variations;
                Intrinsics.checkNotNullExpressionValue(list, (String)"variations");
                BaseLayoutModel layoutModel = new BaseLayoutModel(list, this.this$0.getGetRPackage());
                JavaFile javaFile = null;
                GenClassInfoLog.GenClass classInfo = null;
                Object object = CollectionsKt.first(variations);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"variations.first()");
                if (((ResourceBundle.LayoutFileBundle)object).isBindingData()) {
                    boolean bl3 = this.this$0.getInput().getArgs().getEnableDataBinding();
                    bl2 = false;
                    bl = false;
                    if (!bl3) {
                        boolean bl4 = false;
                        String string = "Data binding is not enabled but found data binding layouts: " + variations;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    BaseLayoutBinderWriter binderWriter = new BaseLayoutBinderWriter(layoutModel, this.$libTypes);
                    javaFile = binderWriter.write();
                    classInfo = binderWriter.generateClassInfo();
                } else {
                    boolean binderWriter = this.this$0.getInput().getArgs().getEnableViewBinding();
                    bl2 = false;
                    bl = false;
                    if (!binderWriter) {
                        boolean bl5 = false;
                        String string = "View binding is not enabled but found non-data binding layouts: " + variations;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    ViewBinder viewBinder = ViewBinderKt.toViewBinder(layoutModel);
                    javaFile = ViewBinderGenerateJavaKt.toJavaFile(viewBinder, !this.$useAndroidX);
                    classInfo = ViewBinderGenerateJavaKt.generatedClassInfo(viewBinder);
                }
                this.$writer.writeToFile(javaFile);
                GenClassInfoLog genClassInfoLog = this.$myLog.getClassInfoLog();
                String string = layoutName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"layoutName");
                genClassInfoLog.addMapping(string, classInfo);
                Iterable $this$forEach$iv = variations;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ResourceBundle.LayoutFileBundle it = (ResourceBundle.LayoutFileBundle)element$iv;
                    boolean bl6 = false;
                    ResourceBundle.LayoutFileBundle layoutFileBundle = it;
                    Intrinsics.checkNotNullExpressionValue((Object)layoutFileBundle, (String)"it");
                    List<ResourceBundle.BindingTargetBundle> list2 = layoutFileBundle.getBindingTargetBundles();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"it.bindingTargetBundles");
                    Iterable $this$forEach$iv2 = list2;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        ResourceBundle.BindingTargetBundle bundle = (ResourceBundle.BindingTargetBundle)element$iv2;
                        boolean bl7 = false;
                        ResourceBundle.BindingTargetBundle bindingTargetBundle = bundle;
                        Intrinsics.checkNotNullExpressionValue((Object)bindingTargetBundle, (String)"bundle");
                        if (!bindingTargetBundle.isBinder()) continue;
                        String string2 = bundle.getIncludedLayout();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"bundle.includedLayout");
                        this.$myLog.addDependency(layoutName, string2);
                    }
                }
            }
            {
                this.this$0 = baseDataBinder;
                this.$libTypes = libTypes;
                this.$useAndroidX = bl;
                this.$writer = javaFileWriter;
                this.$myLog = layoutInfoLog;
            }
        });
        this.input.saveLog(myLog);
        Scope.assertNoError();
    }

    @NotNull
    public final LayoutInfoInput getInput() {
        return this.input;
    }

    @Nullable
    public final Function2<String, String, String> getGetRPackage() {
        return this.getRPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseDataBinder(@NotNull LayoutInfoInput input, @Nullable Function2<? super String, ? super String, String> getRPackage) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
        this.getRPackage = getRPackage;
        this.resourceBundle = new ResourceBundle(this.input.getPackageName(), this.input.getArgs().getUseAndroidX());
        Iterable $this$forEach$iv = this.input.getFilesToConsider();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            Object object = it;
            boolean bl2 = false;
            object = new FileInputStream((File)object);
            bl2 = false;
            boolean bl3 = false;
            Throwable throwable = null;
            try {
                FileInputStream it2 = (FileInputStream)object;
                boolean bl4 = false;
                ResourceBundle.LayoutFileBundle bundle = ResourceBundle.LayoutFileBundle.fromXML(it2);
                this.resourceBundle.addLayoutBundle(bundle, true);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        this.resourceBundle.addDependencyLayouts(this.input.getExistingBindingClasses());
        this.resourceBundle.validateAndRegisterErrors();
    }
}

