/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.writer;

import android.databinding.tool.LibTypes;
import android.databinding.tool.ext.ExtKt;
import android.databinding.tool.ext.Javapoet_extKt;
import android.databinding.tool.store.GenClassInfoLog;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.writer.BaseLayoutBinderWriter;
import android.databinding.tool.writer.BaseLayoutModel;
import android.databinding.tool.writer.CommonKt;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0015H\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u0015H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \n*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Landroid/databinding/tool/writer/BaseLayoutBinderWriter;", "", "model", "Landroid/databinding/tool/writer/BaseLayoutModel;", "libTypes", "Landroid/databinding/tool/LibTypes;", "(Landroid/databinding/tool/writer/BaseLayoutModel;Landroid/databinding/tool/LibTypes;)V", "bindable", "Lcom/squareup/javapoet/ClassName;", "binderTypeName", "kotlin.jvm.PlatformType", "dataBindingComponent", "dataBindingUtil", "getLibTypes", "()Landroid/databinding/tool/LibTypes;", "getModel", "()Landroid/databinding/tool/writer/BaseLayoutModel;", "nonNull", "nullable", "viewDataBinding", "createBindingTargetFields", "", "Lcom/squareup/javapoet/FieldSpec;", "createConstructor", "Lcom/squareup/javapoet/MethodSpec;", "createGettersAndSetters", "createStaticInflaters", "createType", "Lcom/squareup/javapoet/TypeSpec;", "createVariableFields", "generateClassInfo", "Landroid/databinding/tool/store/GenClassInfoLog$GenClass;", "write", "Lcom/squareup/javapoet/JavaFile;", "Companion", "databinding-compiler-common"})
public final class BaseLayoutBinderWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BaseLayoutModel model;
    @NotNull
    private final LibTypes libTypes;
    private final ClassName binderTypeName;
    @NotNull
    private final ClassName viewDataBinding;
    @NotNull
    private final ClassName nonNull;
    @NotNull
    private final ClassName nullable;
    private final ClassName dataBindingComponent;
    @NotNull
    private final ClassName dataBindingUtil;
    @NotNull
    private final ClassName bindable;
    private static final ClassName DEPRECATED = ClassName.get(Deprecated.class);
    @NotNull
    private static final String JAVADOC_BINDING_COMPONENT = StringsKt.trimIndent((String)"\n            This method receives DataBindingComponent instance as type Object instead of\n            type DataBindingComponent to avoid causing too many compilation errors if\n            compilation fails for another reason.\n            https://issuetracker.google.com/issues/116541301\n            ");

    public BaseLayoutBinderWriter(@NotNull BaseLayoutModel model, @NotNull LibTypes libTypes) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)libTypes, (String)"libTypes");
        this.model = model;
        this.libTypes = libTypes;
        this.binderTypeName = ClassName.get((String)this.model.getBindingClassPackage(), (String)this.model.getBindingClassName(), (String[])new String[0]);
        this.viewDataBinding = Javapoet_extKt.toClassName(this.libTypes.getViewDataBinding());
        this.nonNull = Javapoet_extKt.toClassName(this.libTypes.getNonNull());
        this.nullable = Javapoet_extKt.toClassName(this.libTypes.getNullable());
        this.dataBindingComponent = TypeName.OBJECT;
        this.dataBindingUtil = Javapoet_extKt.toClassName(this.libTypes.getDataBindingUtil());
        this.bindable = Javapoet_extKt.toClassName(this.libTypes.getBindable());
    }

    @NotNull
    public final BaseLayoutModel getModel() {
        return this.model;
    }

    @NotNull
    public final LibTypes getLibTypes() {
        return this.libTypes;
    }

    @NotNull
    public final JavaFile write() {
        String string = this.binderTypeName.packageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"binderTypeName.packageName()");
        return Javapoet_extKt.javaFile(string, this.createType(), (Function1<? super JavaFile.Builder, Unit>)((Function1)write.1.INSTANCE));
    }

    private final TypeSpec createType() {
        ClassName className = this.binderTypeName;
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"binderTypeName");
        return Javapoet_extKt.classSpec(className, (Function1<? super TypeSpec.Builder, Unit>)((Function1)new Function1<TypeSpec.Builder, Unit>(this){
            final /* synthetic */ BaseLayoutBinderWriter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull TypeSpec.Builder $this$classSpec) {
                Intrinsics.checkNotNullParameter((Object)$this$classSpec, (String)"$this$classSpec");
                $this$classSpec.superclass((TypeName)BaseLayoutBinderWriter.access$getViewDataBinding$p(this.this$0));
                Modifier[] modifierArray = new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC};
                $this$classSpec.addModifiers(modifierArray);
                $this$classSpec.addFields((Iterable)BaseLayoutBinderWriter.access$createBindingTargetFields(this.this$0));
                $this$classSpec.addFields((Iterable)BaseLayoutBinderWriter.access$createVariableFields(this.this$0));
                $this$classSpec.addMethod(BaseLayoutBinderWriter.access$createConstructor(this.this$0));
                $this$classSpec.addMethods((Iterable)BaseLayoutBinderWriter.access$createGettersAndSetters(this.this$0));
                $this$classSpec.addMethods((Iterable)BaseLayoutBinderWriter.access$createStaticInflaters(this.this$0));
            }
        }));
    }

    private final List<MethodSpec> createStaticInflaters() {
        ParameterSpec inflaterParam2 = Javapoet_extKt.parameterSpec((TypeName)CommonKt.getANDROID_LAYOUT_INFLATER(), "inflater", (Function1<? super ParameterSpec.Builder, Unit>)((Function1)new Function1<ParameterSpec.Builder, Unit>(this){
            final /* synthetic */ BaseLayoutBinderWriter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ParameterSpec.Builder $this$parameterSpec) {
                Intrinsics.checkNotNullParameter((Object)$this$parameterSpec, (String)"$this$parameterSpec");
                $this$parameterSpec.addAnnotation(BaseLayoutBinderWriter.access$getNonNull$p(this.this$0));
            }
        }));
        ParameterSpec viewGroupParam2 = Javapoet_extKt.parameterSpec((TypeName)CommonKt.getANDROID_VIEW_GROUP(), "root", (Function1<? super ParameterSpec.Builder, Unit>)((Function1)new Function1<ParameterSpec.Builder, Unit>(this){
            final /* synthetic */ BaseLayoutBinderWriter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ParameterSpec.Builder $this$parameterSpec) {
                Intrinsics.checkNotNullParameter((Object)$this$parameterSpec, (String)"$this$parameterSpec");
                $this$parameterSpec.addAnnotation(BaseLayoutBinderWriter.access$getNullable$p(this.this$0));
            }
        }));
        ParameterSpec viewParam2 = Javapoet_extKt.parameterSpec((TypeName)CommonKt.getANDROID_VIEW(), "view", (Function1<? super ParameterSpec.Builder, Unit>)((Function1)new Function1<ParameterSpec.Builder, Unit>(this){
            final /* synthetic */ BaseLayoutBinderWriter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ParameterSpec.Builder $this$parameterSpec) {
                Intrinsics.checkNotNullParameter((Object)$this$parameterSpec, (String)"$this$parameterSpec");
                $this$parameterSpec.addAnnotation(BaseLayoutBinderWriter.access$getNonNull$p(this.this$0));
            }
        }));
        ClassName className = this.dataBindingComponent;
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"dataBindingComponent");
        ParameterSpec componentParam2 = Javapoet_extKt.parameterSpec((TypeName)className, "component", (Function1<? super ParameterSpec.Builder, Unit>)((Function1)new Function1<ParameterSpec.Builder, Unit>(this){
            final /* synthetic */ BaseLayoutBinderWriter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ParameterSpec.Builder $this$parameterSpec) {
                Intrinsics.checkNotNullParameter((Object)$this$parameterSpec, (String)"$this$parameterSpec");
                $this$parameterSpec.addAnnotation(BaseLayoutBinderWriter.access$getNullable$p(this.this$0));
            }
        }));
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = new String[]{"layout"};
        objectArray[0] = ClassName.get((String)this.model.getModulePackage(), (String)"R", (String[])objectArray2);
        objectArray[1] = this.model.getBaseFileName();
        CodeBlock rLayoutFile = CodeBlock.of((String)"$T.$N", (Object[])objectArray);
        TypeName typeName = TypeName.BOOLEAN;
        Intrinsics.checkNotNullExpressionValue((Object)typeName, (String)"BOOLEAN");
        ParameterSpec attachToRootParam = Javapoet_extKt.parameterSpec$default(typeName, "attachToRoot", null, 4, null);
        objectArray2 = new MethodSpec[]{Javapoet_extKt.methodSpec("inflate", (Function1<? super MethodSpec.Builder, Unit>)((Function1)new Function1<MethodSpec.Builder, Unit>(inflaterParam2, viewGroupParam2, attachToRootParam, this){
            final /* synthetic */ ParameterSpec $inflaterParam;
            final /* synthetic */ ParameterSpec $viewGroupParam;
            final /* synthetic */ ParameterSpec $attachToRootParam;
            final /* synthetic */ BaseLayoutBinderWriter this$0;
            {
                this.$inflaterParam = $inflaterParam;
                this.$viewGroupParam = $viewGroupParam;
                this.$attachToRootParam = $attachToRootParam;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MethodSpec.Builder $this$methodSpec) {
                Intrinsics.checkNotNullParameter((Object)$this$methodSpec, (String)"$this$methodSpec");
                Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
                $this$methodSpec.addModifiers(objectArray);
                $this$methodSpec.addParameter(this.$inflaterParam);
                $this$methodSpec.addParameter(this.$viewGroupParam);
                $this$methodSpec.addParameter(this.$attachToRootParam);
                $this$methodSpec.returns((TypeName)BaseLayoutBinderWriter.access$getBinderTypeName$p(this.this$0));
                $this$methodSpec.addAnnotation(BaseLayoutBinderWriter.access$getNonNull$p(this.this$0));
                objectArray = new Object[]{this.$inflaterParam, this.$viewGroupParam, this.$attachToRootParam, BaseLayoutBinderWriter.access$getDataBindingUtil$p(this.this$0)};
                $this$methodSpec.addStatement("return inflate($N, $N, $N, $T.getDefaultComponent())", objectArray);
            }
        })), Javapoet_extKt.methodSpec("inflate", (Function1<? super MethodSpec.Builder, Unit>)((Function1)new Function1<MethodSpec.Builder, Unit>(inflaterParam2, viewGroupParam2, attachToRootParam, componentParam2, this, rLayoutFile){
            final /* synthetic */ ParameterSpec $inflaterParam;
            final /* synthetic */ ParameterSpec $viewGroupParam;
            final /* synthetic */ ParameterSpec $attachToRootParam;
            final /* synthetic */ ParameterSpec $componentParam;
            final /* synthetic */ BaseLayoutBinderWriter this$0;
            final /* synthetic */ CodeBlock $rLayoutFile;
            {
                this.$inflaterParam = $inflaterParam;
                this.$viewGroupParam = $viewGroupParam;
                this.$attachToRootParam = $attachToRootParam;
                this.$componentParam = $componentParam;
                this.this$0 = $receiver;
                this.$rLayoutFile = $rLayoutFile;
                super(1);
            }

            public final void invoke(@NotNull MethodSpec.Builder $this$methodSpec) {
                Intrinsics.checkNotNullParameter((Object)$this$methodSpec, (String)"$this$methodSpec");
                Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
                $this$methodSpec.addModifiers(objectArray);
                $this$methodSpec.addParameter(this.$inflaterParam);
                $this$methodSpec.addParameter(this.$viewGroupParam);
                $this$methodSpec.addParameter(this.$attachToRootParam);
                $this$methodSpec.addParameter(this.$componentParam);
                $this$methodSpec.returns((TypeName)BaseLayoutBinderWriter.access$getBinderTypeName$p(this.this$0));
                $this$methodSpec.addAnnotation(BaseLayoutBinderWriter.access$getNonNull$p(this.this$0));
                $this$methodSpec.addAnnotation(BaseLayoutBinderWriter.access$getDEPRECATED$cp());
                $this$methodSpec.addJavadoc(BaseLayoutBinderWriter.access$getJAVADOC_BINDING_COMPONENT$cp(), new Object[0]);
                objectArray = new Object[]{this.this$0.getModel().getBaseFileName(), this.$viewGroupParam, this.$attachToRootParam, this.$componentParam};
                $this$methodSpec.addJavadoc("\n@Deprecated Use DataBindingUtil.inflate(inflater, R.layout.$L, $N, $N, $N)\n", objectArray);
                objectArray = new Object[]{BaseLayoutBinderWriter.access$getViewDataBinding$p(this.this$0), BaseLayoutBinderWriter.access$getBinderTypeName$p(this.this$0), this.$inflaterParam, this.$rLayoutFile, this.$viewGroupParam, this.$attachToRootParam, this.$componentParam};
                $this$methodSpec.addStatement("return $T.<$T>inflateInternal($N, $L, $N, $N, $N)", objectArray);
            }
        })), Javapoet_extKt.methodSpec("inflate", (Function1<? super MethodSpec.Builder, Unit>)((Function1)new Function1<MethodSpec.Builder, Unit>(inflaterParam2, this){
            final /* synthetic */ ParameterSpec $inflaterParam;
            final /* synthetic */ BaseLayoutBinderWriter this$0;
            {
                this.$inflaterParam = $inflaterParam;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MethodSpec.Builder $this$methodSpec) {
                Intrinsics.checkNotNullParameter((Object)$this$methodSpec, (String)"$this$methodSpec");
                Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
                $this$methodSpec.addModifiers(objectArray);
                $this$methodSpec.addParameter(this.$inflaterParam);
                $this$methodSpec.returns((TypeName)BaseLayoutBinderWriter.access$getBinderTypeName$p(this.this$0));
                $this$methodSpec.addAnnotation(BaseLayoutBinderWriter.access$getNonNull$p(this.this$0));
                objectArray = new Object[]{this.$inflaterParam, BaseLayoutBinderWriter.access$getDataBindingUtil$p(this.this$0)};
                $this$methodSpec.addStatement("return inflate($N, $T.getDefaultComponent())", objectArray);
            }
        })), Javapoet_extKt.methodSpec("inflate", (Function1<? super MethodSpec.Builder, Unit>)((Function1)new Function1<MethodSpec.Builder, Unit>(inflaterParam2, componentParam2, this, rLayoutFile){
            final /* synthetic */ ParameterSpec $inflaterParam;
            final /* synthetic */ ParameterSpec $componentParam;
            final /* synthetic */ BaseLayoutBinderWriter this$0;
            final /* synthetic */ CodeBlock $rLayoutFile;
            {
                this.$inflaterParam = $inflaterParam;
                this.$componentParam = $componentParam;
                this.this$0 = $receiver;
                this.$rLayoutFile = $rLayoutFile;
                super(1);
            }

            public final void invoke(@NotNull MethodSpec.Builder $this$methodSpec) {
                Intrinsics.checkNotNullParameter((Object)$this$methodSpec, (String)"$this$methodSpec");
                Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
                $this$methodSpec.addModifiers(objectArray);
                $this$methodSpec.addParameter(this.$inflaterParam);
                $this$methodSpec.addParameter(this.$componentParam);
                $this$methodSpec.returns((TypeName)BaseLayoutBinderWriter.access$getBinderTypeName$p(this.this$0));
                $this$methodSpec.addAnnotation(BaseLayoutBinderWriter.access$getNonNull$p(this.this$0));
                $this$methodSpec.addAnnotation(BaseLayoutBinderWriter.access$getDEPRECATED$cp());
                $this$methodSpec.addJavadoc(BaseLayoutBinderWriter.access$getJAVADOC_BINDING_COMPONENT$cp(), new Object[0]);
                objectArray = new Object[]{this.this$0.getModel().getBaseFileName(), this.$componentParam};
                $this$methodSpec.addJavadoc("\n@Deprecated Use DataBindingUtil.inflate(inflater, R.layout.$L, null, false, $N)\n", objectArray);
                objectArray = new Object[]{BaseLayoutBinderWriter.access$getViewDataBinding$p(this.this$0), BaseLayoutBinderWriter.access$getBinderTypeName$p(this.this$0), this.$inflaterParam, this.$rLayoutFile, this.$componentParam};
                $this$methodSpec.addStatement("return $T.<$T>inflateInternal($N, $L, null, false, $N)", objectArray);
            }
        })), Javapoet_extKt.methodSpec("bind", (Function1<? super MethodSpec.Builder, Unit>)((Function1)new Function1<MethodSpec.Builder, Unit>(viewParam2, this){
            final /* synthetic */ ParameterSpec $viewParam;
            final /* synthetic */ BaseLayoutBinderWriter this$0;
            {
                this.$viewParam = $viewParam;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MethodSpec.Builder $this$methodSpec) {
                Intrinsics.checkNotNullParameter((Object)$this$methodSpec, (String)"$this$methodSpec");
                Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
                $this$methodSpec.addModifiers(objectArray);
                $this$methodSpec.addParameter(this.$viewParam);
                $this$methodSpec.returns((TypeName)BaseLayoutBinderWriter.access$getBinderTypeName$p(this.this$0));
                objectArray = new Object[]{this.$viewParam, BaseLayoutBinderWriter.access$getDataBindingUtil$p(this.this$0)};
                $this$methodSpec.addStatement("return bind($N, $T.getDefaultComponent())", objectArray);
            }
        })), Javapoet_extKt.methodSpec("bind", (Function1<? super MethodSpec.Builder, Unit>)((Function1)new Function1<MethodSpec.Builder, Unit>(viewParam2, componentParam2, this, rLayoutFile){
            final /* synthetic */ ParameterSpec $viewParam;
            final /* synthetic */ ParameterSpec $componentParam;
            final /* synthetic */ BaseLayoutBinderWriter this$0;
            final /* synthetic */ CodeBlock $rLayoutFile;
            {
                this.$viewParam = $viewParam;
                this.$componentParam = $componentParam;
                this.this$0 = $receiver;
                this.$rLayoutFile = $rLayoutFile;
                super(1);
            }

            public final void invoke(@NotNull MethodSpec.Builder $this$methodSpec) {
                Intrinsics.checkNotNullParameter((Object)$this$methodSpec, (String)"$this$methodSpec");
                Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
                $this$methodSpec.addModifiers(objectArray);
                $this$methodSpec.addParameter(this.$viewParam);
                $this$methodSpec.addParameter(this.$componentParam);
                $this$methodSpec.returns((TypeName)BaseLayoutBinderWriter.access$getBinderTypeName$p(this.this$0));
                $this$methodSpec.addAnnotation(BaseLayoutBinderWriter.access$getDEPRECATED$cp());
                $this$methodSpec.addJavadoc(BaseLayoutBinderWriter.access$getJAVADOC_BINDING_COMPONENT$cp(), new Object[0]);
                objectArray = new Object[]{this.$viewParam, this.$componentParam};
                $this$methodSpec.addJavadoc("\n@Deprecated Use DataBindingUtil.bind($N, $N)\n", objectArray);
                objectArray = new Object[]{BaseLayoutBinderWriter.access$getBinderTypeName$p(this.this$0), this.$componentParam, this.$viewParam, this.$rLayoutFile};
                $this$methodSpec.addStatement("return ($T)bind($N, $N, $L)", objectArray);
            }
        }))};
        return CollectionsKt.listOf((Object[])objectArray2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<MethodSpec> createGettersAndSetters() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.model.getVariables();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ResourceBundle.VariableDeclaration variable = (ResourceBundle.VariableDeclaration)element$iv$iv;
            boolean bl = false;
            String string = variable.type;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variable.type");
            TypeName typeName = ExtKt.toTypeName(string, this.libTypes, this.model.getImportsByAlias());
            Object[] objectArray = new MethodSpec[]{Javapoet_extKt.methodSpec(this.model.setterName(variable), (Function1<? super MethodSpec.Builder, Unit>)((Function1)new Function1<MethodSpec.Builder, Unit>(typeName, variable, this){
                final /* synthetic */ TypeName $typeName;
                final /* synthetic */ ResourceBundle.VariableDeclaration $variable;
                final /* synthetic */ BaseLayoutBinderWriter this$0;
                {
                    this.$typeName = $typeName;
                    this.$variable = $variable;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull MethodSpec.Builder $this$methodSpec) {
                    Intrinsics.checkNotNullParameter((Object)$this$methodSpec, (String)"$this$methodSpec");
                    Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
                    $this$methodSpec.addModifiers(modifierArray);
                    String string = this.$variable.name;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variable.name");
                    ParameterSpec param2 = Javapoet_extKt.parameterSpec(this.$typeName, string, (Function1<? super ParameterSpec.Builder, Unit>)((Function1)new Function1<ParameterSpec.Builder, Unit>(this.$typeName, this.this$0){
                        final /* synthetic */ TypeName $typeName;
                        final /* synthetic */ BaseLayoutBinderWriter this$0;
                        {
                            this.$typeName = $typeName;
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull ParameterSpec.Builder $this$parameterSpec) {
                            Intrinsics.checkNotNullParameter((Object)$this$parameterSpec, (String)"$this$parameterSpec");
                            if (!this.$typeName.isPrimitive()) {
                                $this$parameterSpec.addAnnotation(BaseLayoutBinderWriter.access$getNullable$p(this.this$0));
                            }
                        }
                    }));
                    $this$methodSpec.returns(TypeName.VOID);
                    $this$methodSpec.addParameter(param2);
                    Modifier[] modifierArray2 = new Modifier[]{Modifier.ABSTRACT};
                    $this$methodSpec.addModifiers(modifierArray2);
                    modifierArray2 = new Modifier[]{Modifier.PUBLIC};
                    $this$methodSpec.addModifiers(modifierArray2);
                }
            })), Javapoet_extKt.methodSpec(this.model.getterName(variable), (Function1<? super MethodSpec.Builder, Unit>)((Function1)new Function1<MethodSpec.Builder, Unit>(typeName, this, variable){
                final /* synthetic */ TypeName $typeName;
                final /* synthetic */ BaseLayoutBinderWriter this$0;
                final /* synthetic */ ResourceBundle.VariableDeclaration $variable;
                {
                    this.$typeName = $typeName;
                    this.this$0 = $receiver;
                    this.$variable = $variable;
                    super(1);
                }

                public final void invoke(@NotNull MethodSpec.Builder $this$methodSpec) {
                    Intrinsics.checkNotNullParameter((Object)$this$methodSpec, (String)"$this$methodSpec");
                    Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
                    $this$methodSpec.addModifiers(objectArray);
                    $this$methodSpec.returns(this.$typeName);
                    if (!this.$typeName.isPrimitive()) {
                        $this$methodSpec.addAnnotation(BaseLayoutBinderWriter.access$getNullable$p(this.this$0));
                    }
                    objectArray = new Object[]{this.this$0.getModel().fieldName(this.$variable)};
                    $this$methodSpec.addStatement("return $L", objectArray);
                }
            }))};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final MethodSpec createConstructor() {
        return Javapoet_extKt.constructorSpec((Function1<? super MethodSpec.Builder, Unit>)((Function1)new Function1<MethodSpec.Builder, Unit>(this){
            final /* synthetic */ BaseLayoutBinderWriter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull MethodSpec.Builder $this$constructorSpec) {
                void $this$filterTo$iv$iv;
                Object it;
                Object[] $this$forEach$iv;
                boolean bl;
                void $this$filterTo$iv$iv2;
                Intrinsics.checkNotNullParameter((Object)$this$constructorSpec, (String)"$this$constructorSpec");
                Modifier[] modifierArray = new Modifier[]{Modifier.PROTECTED};
                $this$constructorSpec.addModifiers(modifierArray);
                ClassName className = BaseLayoutBinderWriter.access$getDataBindingComponent$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)className, (String)"dataBindingComponent");
                ParameterSpec componentParam2 = Javapoet_extKt.parameterSpec$default((TypeName)className, "_bindingComponent", null, 4, null);
                ParameterSpec viewParam2 = Javapoet_extKt.parameterSpec$default((TypeName)CommonKt.getANDROID_VIEW(), "_root", null, 4, null);
                TypeName typeName = TypeName.INT;
                Intrinsics.checkNotNullExpressionValue((Object)typeName, (String)"INT");
                ParameterSpec localFieldCountParam = Javapoet_extKt.parameterSpec$default(typeName, "_localFieldCount", null, 4, null);
                $this$constructorSpec.addParameter(componentParam2);
                $this$constructorSpec.addParameter(viewParam2);
                $this$constructorSpec.addParameter(localFieldCountParam);
                Iterable $this$filter$iv = this.this$0.getModel().getSortedTargets();
                boolean $i$f$filter232 = false;
                Iterable iterable = $this$filter$iv;
                Object destination$iv$iv = new ArrayList<E>();
                boolean bl2 = false;
                for (T element$iv$iv : $this$filterTo$iv$iv2) {
                    ResourceBundle.BindingTargetBundle it2 = (ResourceBundle.BindingTargetBundle)element$iv$iv;
                    bl = false;
                    if (!(it2.getId() != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                BaseLayoutBinderWriter $i$f$filter232 = this.this$0;
                boolean $i$f$forEach232 = false;
                for (E e : $this$forEach$iv) {
                    it = (ResourceBundle.BindingTargetBundle)e;
                    boolean bl3 = false;
                    TypeName fieldType = ExtKt.toTypeName(CommonKt.getFieldType((ResourceBundle.BindingTargetBundle)it), $i$f$filter232.getLibTypes(), $i$f$filter232.getModel().getImportsByAlias());
                    $this$constructorSpec.addParameter(Javapoet_extKt.parameterSpec$default(fieldType, $i$f$filter232.getModel().fieldName((ResourceBundle.BindingTargetBundle)it), null, 4, null));
                }
                $this$forEach$iv = new Object[]{componentParam2, viewParam2, localFieldCountParam};
                $this$constructorSpec.addStatement("super($N, $N, $N)", $this$forEach$iv);
                $this$filter$iv = this.this$0.getModel().getSortedTargets();
                boolean $i$f$filter = false;
                Iterable $i$f$forEach232 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                boolean bl4 = false;
                for (E element$iv$iv : $this$filterTo$iv$iv) {
                    ResourceBundle.BindingTargetBundle it2 = (ResourceBundle.BindingTargetBundle)element$iv$iv;
                    bl = false;
                    if (!(it2.getId() != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                BaseLayoutBinderWriter baseLayoutBinderWriter = this.this$0;
                boolean $i$f$forEach = false;
                for (T t : $this$forEach$iv) {
                    it = (ResourceBundle.BindingTargetBundle)t;
                    boolean bl5 = false;
                    String fieldName = baseLayoutBinderWriter.getModel().fieldName((ResourceBundle.BindingTargetBundle)it);
                    Object[] objectArray = new Object[]{fieldName};
                    $this$constructorSpec.addStatement("this.$1L = $1L", objectArray);
                }
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GenClassInfoLog.GenClass generateClassInfo() {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        String string = this.binderTypeName.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"binderTypeName.toString()");
        Iterable iterable = this.model.getVariables();
        String string2 = this.model.getModulePackage();
        String string3 = string;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var4_6 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            ResourceBundle.VariableDeclaration it = (ResourceBundle.VariableDeclaration)element$iv$iv;
            boolean bl = false;
            String string4 = it.name;
            String string5 = it.type;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it.type");
            Pair pair = new Pair((Object)string4, (Object)ExtKt.toTypeName(string5, this.libTypes, this.model.getImportsByAlias()).toString());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map map = destination$iv$iv;
        Set<GenClassInfoLog.GenClassImpl> set = this.model.generateImplInfo();
        Map map2 = map;
        String string6 = string2;
        String string7 = string3;
        return new GenClassInfoLog.GenClass(string7, string6, map2, set);
    }

    /*
     * WARNING - void declaration
     */
    private final List<FieldSpec> createVariableFields() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.model.getVariables();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceBundle.VariableDeclaration variableDeclaration = (ResourceBundle.VariableDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = this.model.fieldName((ResourceBundle.VariableDeclaration)it);
            String string2 = it.type;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.type");
            collection.add(Javapoet_extKt.fieldSpec(string, ExtKt.toTypeName(string2, this.libTypes, this.model.getImportsByAlias()), (Function1<? super FieldSpec.Builder, Unit>)((Function1)new Function1<FieldSpec.Builder, Unit>(this){
                final /* synthetic */ BaseLayoutBinderWriter this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull FieldSpec.Builder $this$fieldSpec) {
                    Intrinsics.checkNotNullParameter((Object)$this$fieldSpec, (String)"$this$fieldSpec");
                    $this$fieldSpec.addAnnotation(BaseLayoutBinderWriter.access$getBindable$p(this.this$0));
                    Modifier[] modifierArray = new Modifier[]{Modifier.PROTECTED};
                    $this$fieldSpec.addModifiers(modifierArray);
                }
            })));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FieldSpec> createBindingTargetFields() {
        void $this$mapTo$iv$iv;
        ResourceBundle.BindingTargetBundle it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.model.getSortedTargets();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ResourceBundle.BindingTargetBundle)element$iv$iv;
            boolean bl = false;
            if (!(it.getId() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ResourceBundle.BindingTargetBundle)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TypeName fieldType = ExtKt.toTypeName(CommonKt.getFieldType(it), this.libTypes, this.model.getImportsByAlias());
            collection.add(Javapoet_extKt.fieldSpec(this.model.fieldName(it), fieldType, (Function1<? super FieldSpec.Builder, Unit>)((Function1)new Function1<FieldSpec.Builder, Unit>(it, this){
                final /* synthetic */ ResourceBundle.BindingTargetBundle $it;
                final /* synthetic */ BaseLayoutBinderWriter this$0;
                {
                    this.$it = $it;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull FieldSpec.Builder $this$fieldSpec) {
                    Intrinsics.checkNotNullParameter((Object)$this$fieldSpec, (String)"$this$fieldSpec");
                    Modifier[] modifierArray = new Modifier[]{Modifier.FINAL};
                    $this$fieldSpec.addModifiers(modifierArray);
                    modifierArray = new Modifier[]{this.$it.getId() != null ? Modifier.PUBLIC : Modifier.PRIVATE};
                    $this$fieldSpec.addModifiers(modifierArray);
                    modifierArray = this.this$0.getModel().layoutConfigurationMembership(this.$it);
                    List present = (List)modifierArray.component1();
                    List absent = (List)modifierArray.component2();
                    if (!((Collection)absent).isEmpty()) {
                        $this$fieldSpec.addJavadoc(CommonKt.renderConfigurationJavadoc(present, absent), new Object[0]);
                        $this$fieldSpec.addAnnotation(BaseLayoutBinderWriter.access$getNullable$p(this.this$0));
                    } else {
                        $this$fieldSpec.addAnnotation(BaseLayoutBinderWriter.access$getNonNull$p(this.this$0));
                    }
                }
            })));
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ ClassName access$getViewDataBinding$p(BaseLayoutBinderWriter $this) {
        return $this.viewDataBinding;
    }

    public static final /* synthetic */ List access$createBindingTargetFields(BaseLayoutBinderWriter $this) {
        return $this.createBindingTargetFields();
    }

    public static final /* synthetic */ List access$createVariableFields(BaseLayoutBinderWriter $this) {
        return $this.createVariableFields();
    }

    public static final /* synthetic */ MethodSpec access$createConstructor(BaseLayoutBinderWriter $this) {
        return $this.createConstructor();
    }

    public static final /* synthetic */ List access$createGettersAndSetters(BaseLayoutBinderWriter $this) {
        return $this.createGettersAndSetters();
    }

    public static final /* synthetic */ List access$createStaticInflaters(BaseLayoutBinderWriter $this) {
        return $this.createStaticInflaters();
    }

    public static final /* synthetic */ ClassName access$getNonNull$p(BaseLayoutBinderWriter $this) {
        return $this.nonNull;
    }

    public static final /* synthetic */ ClassName access$getNullable$p(BaseLayoutBinderWriter $this) {
        return $this.nullable;
    }

    public static final /* synthetic */ ClassName access$getBinderTypeName$p(BaseLayoutBinderWriter $this) {
        return $this.binderTypeName;
    }

    public static final /* synthetic */ ClassName access$getDataBindingUtil$p(BaseLayoutBinderWriter $this) {
        return $this.dataBindingUtil;
    }

    public static final /* synthetic */ ClassName access$getDEPRECATED$cp() {
        return DEPRECATED;
    }

    public static final /* synthetic */ String access$getJAVADOC_BINDING_COMPONENT$cp() {
        return JAVADOC_BINDING_COMPONENT;
    }

    public static final /* synthetic */ ClassName access$getDataBindingComponent$p(BaseLayoutBinderWriter $this) {
        return $this.dataBindingComponent;
    }

    public static final /* synthetic */ ClassName access$getBindable$p(BaseLayoutBinderWriter $this) {
        return $this.bindable;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroid/databinding/tool/writer/BaseLayoutBinderWriter$Companion;", "", "()V", "DEPRECATED", "Lcom/squareup/javapoet/ClassName;", "kotlin.jvm.PlatformType", "JAVADOC_BINDING_COMPONENT", "", "databinding-compiler-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

