/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.store;

import android.databinding.internal.org.antlr.v4.runtime.ParserRuleContext;
import android.databinding.internal.org.antlr.v4.runtime.Token;
import android.databinding.tool.processing.scopes.LocationScopeProvider;
import android.databinding.tool.util.StringUtils;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

@XmlAccessorType(value=XmlAccessType.NONE)
public class Location {
    public static final int NaN = -1;
    @XmlAttribute(name="startLine")
    public int startLine;
    @XmlAttribute(name="startOffset")
    public int startOffset;
    @XmlAttribute(name="endLine")
    public int endLine;
    @XmlAttribute(name="endOffset")
    public int endOffset;
    @XmlElement(name="parentLocation")
    public Location parentLocation;

    public Location() {
        this.endLine = -1;
        this.startLine = -1;
        this.endOffset = -1;
        this.startOffset = -1;
    }

    public Location(Location other) {
        this.startOffset = other.startOffset;
        this.endOffset = other.endOffset;
        this.startLine = other.startLine;
        this.endLine = other.endLine;
    }

    public Location(Token start, Token end) {
        if (start == null) {
            this.startOffset = -1;
            this.startLine = -1;
        } else {
            this.startLine = start.getLine() - 1;
            this.startOffset = start.getCharPositionInLine();
        }
        if (end == null) {
            this.endOffset = -1;
            this.endLine = -1;
        } else {
            this.endLine = end.getLine() - 1;
            String endText = end.getText();
            int lastLineStart = endText.lastIndexOf(StringUtils.LINE_SEPARATOR);
            String lastLine = lastLineStart < 0 ? endText : endText.substring(lastLineStart + 1);
            this.endOffset = end.getCharPositionInLine() + lastLine.length() - 1;
        }
    }

    public Location(ParserRuleContext context) {
        this(context == null ? null : context.getStart(), context == null ? null : context.getStop());
    }

    public Location(int startLine, int startOffset, int endLine, int endOffset) {
        this.startOffset = startOffset;
        this.startLine = startLine;
        this.endLine = endLine;
        this.endOffset = endOffset;
    }

    public String toString() {
        return "Location{startLine=" + this.startLine + ", startOffset=" + this.startOffset + ", endLine=" + this.endLine + ", endOffset=" + this.endOffset + ", parentLocation=" + this.parentLocation + "}";
    }

    public void setParentLocation(Location parentLocation) {
        this.parentLocation = parentLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        if (this.endLine != location.endLine) {
            return false;
        }
        if (this.endOffset != location.endOffset) {
            return false;
        }
        if (this.startLine != location.startLine) {
            return false;
        }
        if (this.startOffset != location.startOffset) {
            return false;
        }
        return !(this.parentLocation == null ? location.parentLocation != null : !this.parentLocation.equals(location.parentLocation));
    }

    public int hashCode() {
        int result = this.startLine;
        result = 31 * result + this.startOffset;
        result = 31 * result + this.endLine;
        result = 31 * result + this.endOffset;
        return result;
    }

    public boolean isValid() {
        return this.startLine != -1 && this.endLine != -1 && this.startOffset != -1 && this.endOffset != -1;
    }

    public boolean contains(Location other) {
        if (this.startLine > other.startLine) {
            return false;
        }
        if (this.startLine == other.startLine && this.startOffset > other.startOffset) {
            return false;
        }
        if (this.endLine < other.endLine) {
            return false;
        }
        return this.endLine != other.endLine || this.endOffset >= other.endOffset;
    }

    private Location getValidParentAbsoluteLocation() {
        if (this.parentLocation == null) {
            return null;
        }
        if (this.parentLocation.isValid()) {
            return this.parentLocation.toAbsoluteLocation();
        }
        return this.parentLocation.getValidParentAbsoluteLocation();
    }

    public Location toAbsoluteLocation() {
        boolean sameLine;
        Location absoluteParent = this.getValidParentAbsoluteLocation();
        if (absoluteParent == null) {
            return this;
        }
        Location copy = new Location(this);
        boolean bl = sameLine = copy.startLine == copy.endLine;
        if (copy.startLine == 0) {
            copy.startOffset += absoluteParent.startOffset;
        }
        if (sameLine) {
            copy.endOffset += absoluteParent.startOffset;
        }
        copy.startLine += absoluteParent.startLine;
        copy.endLine += absoluteParent.startLine;
        return copy;
    }

    public String toUserReadableString() {
        return this.startLine + ":" + this.startOffset + " - " + this.endLine + ":" + this.endOffset;
    }

    public static Location fromUserReadableString(String str) {
        int glue = str.indexOf(45);
        if (glue == -1) {
            return new Location();
        }
        String start = str.substring(0, glue);
        String end = str.substring(glue + 1);
        int[] point = new int[]{-1, -1};
        Location location = new Location();
        Location.parsePoint(start, point);
        location.startLine = point[0];
        location.startOffset = point[1];
        point[1] = -1;
        point[0] = -1;
        Location.parsePoint(end, point);
        location.endLine = point[0];
        location.endOffset = point[1];
        return location;
    }

    private static boolean parsePoint(String content, int[] into) {
        int index = content.indexOf(58);
        if (index == -1) {
            return false;
        }
        into[0] = Integer.parseInt(content.substring(0, index).trim());
        into[1] = Integer.parseInt(content.substring(index + 1).trim());
        return true;
    }

    public LocationScopeProvider createScope() {
        return new LocationScopeProvider(){

            @Override
            public List<Location> provideScopeLocation() {
                return Collections.singletonList(Location.this);
            }
        };
    }
}

