/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.CallbackWrapper;
import android.databinding.tool.expr.CallbackArgExpr;
import android.databinding.tool.expr.CallbackExprModel;
import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.solver.ExecutionPath;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.writer.KCode;
import android.databinding.tool.writer.LayoutBinderWriterKt;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class LambdaExpr
extends Expr {
    private static AtomicInteger sIdCounter = new AtomicInteger();
    private final int mId = sIdCounter.incrementAndGet();
    private CallbackWrapper mCallbackWrapper;
    private final CallbackExprModel mCallbackExprModel;
    private int mCallbackId;
    private ExecutionPath mExecutionPath;

    public LambdaExpr(Expr expr, CallbackExprModel callbackExprModel) {
        super(expr);
        this.mCallbackExprModel = callbackExprModel;
    }

    public Expr getExpr() {
        return this.getChildren().get(0);
    }

    public CallbackExprModel getCallbackExprModel() {
        return this.mCallbackExprModel;
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        Preconditions.checkNotNull((Object)this.mCallbackWrapper, (String)"Lambda expression must be resolved to its setter first to get the type.", (Object[])new Object[0]);
        return this.mCallbackWrapper.klass;
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return Collections.emptyList();
    }

    public CallbackWrapper getCallbackWrapper() {
        return this.mCallbackWrapper;
    }

    @Override
    public Expr resolveListeners(ModelClass valueType, Expr parent) {
        return this;
    }

    @Override
    protected String computeUniqueKey() {
        return "callback" + this.mId;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public void injectSafeUnboxing(ModelAnalyzer modelAnalyzer, ExprModel model) {
    }

    @Override
    protected KCode generateCode() {
        Preconditions.checkNotNull((Object)this.mCallbackWrapper, (String)"Cannot find the callback method for %s", (Object[])new Object[]{this});
        KCode code = new KCode("");
        int minApi = this.mCallbackWrapper.getMinApi();
        String fieldName2 = LayoutBinderWriterKt.getFieldName(this);
        if (minApi > 1) {
            code.app("(getBuildSdkInt() < " + minApi + " ? null : ").app(fieldName2).app(")");
        } else {
            code.app(fieldName2);
        }
        return code;
    }

    @Override
    public Expr cloneToModel(ExprModel model) {
        return model.lambdaExpr(this.getExpr().cloneToModel(model), (CallbackExprModel)model);
    }

    public String generateConstructor() {
        return this.getCallbackWrapper().constructForIdentifier(this.mCallbackId);
    }

    @Override
    public void markAsUsed() {
        super.markAsUsed();
    }

    @Override
    protected String getInvertibleError() {
        return "Lambda expressions cannot be inverted";
    }

    @Override
    public List<ExecutionPath> toExecutionPath(List<ExecutionPath> paths) {
        throw new UnsupportedOperationException("should not call toExecutionPath on a lambda expression");
    }

    public final ExecutionPath getExecutionPath() {
        return this.mExecutionPath;
    }

    public int getCallbackId() {
        return this.mCallbackId;
    }

    public void setup(ModelClass klass, ModelMethod method, int callbackId) {
        List<CallbackArgExpr> args;
        this.mCallbackId = callbackId;
        this.mCallbackWrapper = this.getModel().callbackWrapper(klass, method);
        ModelClass[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == (args = this.mCallbackExprModel.getArguments()).size()) {
            for (int i = 0; i < parameterTypes.length; ++i) {
                args.get(i).setClassFromCallback(parameterTypes[i]);
            }
        }
        this.getExpr().resolveTwoWayExpressions(this);
        this.getExpr().getResolvedType();
        this.mExecutionPath = ExecutionPath.createRoot();
        this.getExpr().toExecutionPath(this.mExecutionPath);
        this.mCallbackExprModel.seal();
    }

    @Override
    public String toString() {
        String parameters = this.mCallbackExprModel.getArguments().stream().map(arg -> arg.getName()).collect(Collectors.joining(", "));
        return '(' + parameters + ") -> " + this.getExpr();
    }
}

