/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.annotationprocessor;

import android.databinding.annotationprocessor.ProcessDataBinding;
import android.databinding.annotationprocessor.ProcessExpressionsFromV1Compat;
import android.databinding.tool.CompilerArguments;
import android.databinding.tool.CompilerChef;
import android.databinding.tool.LayoutXmlProcessor;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.ScopedException;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.store.GenClassInfoLog;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.util.GenerationalClassUtil;
import android.databinding.tool.util.L;
import android.databinding.tool.util.LoggedErrorException;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.util.StringUtils;
import android.databinding.tool.writer.BindingMapperWriter;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ProcessExpressions
extends ProcessDataBinding.ProcessingStep {
    @Override
    public boolean onHandleStep(RoundEnvironment roundEnvironment, ProcessingEnvironment processingEnvironment, CompilerArguments args2) throws JAXBException {
        try {
            List<IntermediateV2> intermediateList;
            ResourceBundle resourceBundle = new ResourceBundle(args2.getModulePackage(), ModelAnalyzer.getInstance().libTypes.getUseAndroidX());
            GenClassInfoLog infoLog = null;
            CompilerChef v1CompatChef = null;
            if (args2.isEnableV2()) {
                try {
                    infoLog = ResourceBundle.loadClassInfoFromFolder((File)args2.getClassLogDir());
                }
                catch (IOException e) {
                    infoLog = new GenClassInfoLog();
                    Scope.defer((ScopedException)new ScopedException("cannot load the info log from %s", new Object[]{args2.getClassLogDir()}));
                }
                resourceBundle.addDependencyLayouts(infoLog);
                intermediateList = Collections.emptyList();
                v1CompatChef = new ProcessExpressionsFromV1Compat(processingEnvironment, args2, this.loadDependencyIntermediates(), this.getWriter()).generate();
            } else {
                intermediateList = this.loadDependencyIntermediates();
                for (Intermediate intermediate : intermediateList) {
                    try {
                        try {
                            intermediate.appendTo(resourceBundle, false);
                        }
                        catch (Throwable throwable) {
                            L.e((Throwable)throwable, (String)"unable to prepare resource bundle", (Object[])new Object[0]);
                        }
                    }
                    catch (LoggedErrorException loggedErrorException) {}
                }
            }
            IntermediateV2 mine = this.createIntermediateFromLayouts(args2.getLayoutInfoDir(), intermediateList);
            if (mine != null) {
                if (!args2.isEnableV2()) {
                    mine.updateOverridden(resourceBundle);
                    intermediateList.add(mine);
                    this.saveIntermediate(processingEnvironment, args2, mine);
                }
                mine.appendTo(resourceBundle, true);
            }
            try {
                this.writeResourceBundle(resourceBundle, args2, infoLog, v1CompatChef);
            }
            catch (Throwable throwable) {
                L.e((Throwable)throwable, (String)"cannot generate view binders", (Object[])new Object[0]);
            }
        }
        catch (LoggedErrorException loggedErrorException) {
            // empty catch block
        }
        return true;
    }

    private List<IntermediateV2> loadDependencyIntermediates() {
        List original = GenerationalClassUtil.get().loadObjects(GenerationalClassUtil.ExtensionFilter.LAYOUT);
        ArrayList<IntermediateV2> upgraded = new ArrayList<IntermediateV2>(original.size());
        for (Intermediate intermediate : original) {
            Intermediate updatedIntermediate = intermediate.upgrade();
            Preconditions.check((boolean)(updatedIntermediate instanceof IntermediateV2), (String)"Incompatible data binding dependency. Please update your dependencies or recompile them with application module's data binding version.", (Object[])new Object[0]);
            upgraded.add((IntermediateV2)updatedIntermediate);
        }
        return upgraded;
    }

    private void saveIntermediate(ProcessingEnvironment processingEnvironment, CompilerArguments args2, IntermediateV2 intermediate) {
        GenerationalClassUtil.get().writeIntermediateFile(args2.getModulePackage(), args2.getModulePackage() + GenerationalClassUtil.ExtensionFilter.LAYOUT.getExtension(), intermediate);
    }

    @Override
    public void onProcessingOver(RoundEnvironment roundEnvironment, ProcessingEnvironment processingEnvironment, CompilerArguments args2) {
    }

    private IntermediateV2 createIntermediateFromLayouts(File layoutInfoDir, List<IntermediateV2> intermediateList) {
        final HashSet<String> excludeList = new HashSet<String>();
        for (IntermediateV2 lib : intermediateList) {
            excludeList.addAll(lib.mLayoutInfoMap.keySet());
        }
        if (!layoutInfoDir.isDirectory()) {
            L.d((String)"layout info folder does not exist, skipping for %s", (Object[])new Object[]{layoutInfoDir.getPath()});
            return null;
        }
        IntermediateV2 result = new IntermediateV2();
        for (File layoutFile : layoutInfoDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml") && !excludeList.contains(name);
            }
        })) {
            try {
                result.addEntry(layoutFile.getName(), FileUtils.readFileToString((File)layoutFile));
            }
            catch (IOException e) {
                L.e((Throwable)e, (String)"cannot load layout file information. Try a clean build", (Object[])new Object[0]);
            }
        }
        for (File zipFile : layoutInfoDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".zip");
            }
        })) {
            try {
                this.loadLayoutInfoFromZipFile(zipFile, result, excludeList);
            }
            catch (IOException e) {
                L.e((Throwable)e, (String)"error while reading layout zip file %s", (Object[])new Object[]{zipFile});
            }
        }
        return result;
    }

    private void loadLayoutInfoFromZipFile(File zipFile, IntermediateV2 result, Set<String> excludeList) throws IOException {
        ZipFile zf = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (excludeList.contains(entry.getName())) continue;
            try {
                result.addEntry(entry.getName(), IOUtils.toString((InputStream)zf.getInputStream(entry), (Charset)Charsets.UTF_16));
            }
            catch (IOException e) {
                L.e((Throwable)e, (String)"cannot load layout file information. Try a clean build", (Object[])new Object[0]);
            }
        }
    }

    private void writeResourceBundle(ResourceBundle resourceBundle, CompilerArguments compilerArgs, GenClassInfoLog classInfoLog, CompilerChef v1CompatChef) {
        CompilerChef compilerChef = CompilerChef.createChef(resourceBundle, this.getWriter(), compilerArgs);
        compilerChef.setV1CompatChef(v1CompatChef);
        compilerChef.sealModels();
        if (compilerArgs.isLibrary() || !compilerArgs.isTestVariant() && !compilerArgs.isFeature()) {
            compilerChef.writeComponent();
        }
        if (compilerChef.hasAnythingToGenerate()) {
            if (!compilerArgs.isEnableV2()) {
                compilerChef.writeViewBinderInterfaces(compilerArgs.isLibrary() && !compilerArgs.isTestVariant());
            }
            if (compilerArgs.isApp() != compilerArgs.isTestVariant() || compilerArgs.isEnabledForTests() && !compilerArgs.isLibrary() || compilerArgs.isEnableV2()) {
                compilerChef.writeViewBinders(compilerArgs.getMinApi());
            }
        }
        if (compilerArgs.isLibrary() && !compilerArgs.isTestVariant() && compilerArgs.getExportClassListOutFile() == null) {
            L.e((String)"When compiling a library module, build info must include exportClassListTo path", (Object[])new Object[0]);
        }
        if (compilerArgs.isLibrary() && !compilerArgs.isTestVariant()) {
            Set<String> classNames = compilerChef.getClassesToBeStripped();
            if (v1CompatChef != null) {
                classNames.addAll(v1CompatChef.getClassesToBeStripped());
                classNames.add(BindingMapperWriter.v1CompatMapperPkg(compilerChef.useAndroidX()));
            }
            String out = Joiner.on((String)StringUtils.LINE_SEPARATOR).join(classNames);
            L.d((String)"Writing list of classes to %s . \nList:%s", (Object[])new Object[]{compilerArgs.getExportClassListOutFile(), out});
            try {
                FileUtils.write((File)compilerArgs.getExportClassListOutFile(), (CharSequence)out);
            }
            catch (IOException e) {
                L.e((Throwable)e, (String)"Cannot create list of written classes", (Object[])new Object[0]);
            }
        }
        this.mCallback.onChefReady(compilerChef, classInfoLog);
    }

    public static class IntermediateV2
    extends IntermediateV1 {
        private static final long serialVersionUID = 2L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void appendTo(ResourceBundle resourceBundle, boolean fromSource) throws JAXBException {
            for (Map.Entry entry : this.mLayoutInfoMap.entrySet()) {
                InputStream is = IOUtils.toInputStream((String)((String)entry.getValue()));
                try {
                    ResourceBundle.LayoutFileBundle bundle = ResourceBundle.LayoutFileBundle.fromXML((InputStream)is);
                    resourceBundle.addLayoutBundle(bundle, fromSource);
                    L.d((String)"loaded layout info file %s", (Object[])new Object[]{bundle});
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
        }

        public void updateOverridden(ResourceBundle bundle) throws JAXBException {
            HashMap bundles = bundle.getLayoutBundles();
            for (Map.Entry info : this.mLayoutInfoMap.entrySet()) {
                String key = LayoutXmlProcessor.exportLayoutNameFromInfoFileName((String)((String)info.getKey()));
                List existingList = (List)bundles.get(key);
                if (existingList == null || existingList.isEmpty()) continue;
                ResourceBundle.LayoutFileBundle myBundle = ResourceBundle.LayoutFileBundle.fromXML((InputStream)IOUtils.toInputStream((String)((String)info.getValue())));
                ResourceBundle.LayoutFileBundle inheritFrom = (ResourceBundle.LayoutFileBundle)existingList.get(0);
                myBundle.inheritConfigurationFrom(inheritFrom);
                L.d((String)"inheriting data for %s (%s) from %s", (Object[])new Object[]{info.getKey(), key, inheritFrom});
                this.mLayoutInfoMap.put(info.getKey(), myBundle.toXML());
            }
        }
    }

    public static class IntermediateV1
    implements Intermediate {
        Map<String, String> mLayoutInfoMap = new HashMap<String, String>();

        @Override
        public Intermediate upgrade() {
            IntermediateV2 updated = new IntermediateV2();
            updated.mLayoutInfoMap = this.mLayoutInfoMap;
            return updated;
        }

        @Override
        public void appendTo(ResourceBundle resourceBundle, boolean fromSource) throws JAXBException {
            this.extractBundles().forEach(layoutFileBundle -> resourceBundle.addLayoutBundle(layoutFileBundle, fromSource));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ResourceBundle.LayoutFileBundle> extractBundles() throws JAXBException {
            ArrayList<ResourceBundle.LayoutFileBundle> bundles = new ArrayList<ResourceBundle.LayoutFileBundle>();
            for (String content : this.mLayoutInfoMap.values()) {
                InputStream is = IOUtils.toInputStream((String)content);
                try {
                    ResourceBundle.LayoutFileBundle bundle = ResourceBundle.LayoutFileBundle.fromXML((InputStream)is);
                    bundles.add(bundle);
                    L.d((String)"loaded layout info file %s", (Object[])new Object[]{bundle});
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
            return bundles;
        }

        public void addEntry(String name, String contents) {
            this.mLayoutInfoMap.put(name, contents);
        }

        public void removeOverridden(List<Intermediate> existing) {
        }
    }

    public static interface Intermediate
    extends Serializable {
        public Intermediate upgrade();

        public void appendTo(ResourceBundle var1, boolean var2) throws Throwable;
    }
}

