/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection;

import android.databinding.tool.BindableCompat;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import org.jetbrains.annotations.Nullable;

public class Callable {
    public static final int DYNAMIC = 1;
    public static final int CAN_BE_INVALIDATED = 2;
    public static final int STATIC = 4;
    public final Type type;
    public final String name;
    public final String setterName;
    public final ModelClass resolvedType;
    @Nullable
    public final ModelMethod method;
    private final int mFlags;
    private final int mParameterCount;
    @Nullable
    public final BindableCompat bindableAnnotation;

    public Callable(Type type, String name, String setterName2, ModelClass resolvedType, int parameterCount, int flags, ModelMethod method, @Nullable BindableCompat bindable) {
        this.type = type;
        this.name = name;
        this.resolvedType = resolvedType;
        this.mParameterCount = parameterCount;
        this.setterName = setterName2;
        this.mFlags = flags;
        this.method = method;
        this.bindableAnnotation = bindable;
    }

    public String getTypeCodeName() {
        return this.resolvedType.toJavaCode();
    }

    public int getParameterCount() {
        return this.mParameterCount;
    }

    public boolean isDynamic() {
        return (this.mFlags & 1) != 0;
    }

    public boolean isStatic() {
        return (this.mFlags & 4) != 0;
    }

    public boolean canBeInvalidated() {
        return (this.mFlags & 2) != 0;
    }

    public int getMinApi() {
        return 1;
    }

    public String toString() {
        return "Callable{type=" + (Object)((Object)this.type) + ", name='" + this.name + '\'' + ", resolvedType=" + this.resolvedType + ", isDynamic=" + this.isDynamic() + ", canBeInvalidated=" + this.canBeInvalidated() + ", static=" + this.isStatic() + ", method=" + this.method + '}';
    }

    public static enum Type {
        METHOD,
        FIELD;

    }
}

