/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.writer;

import android.databinding.tool.LibTypes;
import android.databinding.tool.store.SetterStore;
import java.util.List;
import java.util.Map;

public class ComponentWriter {
    private static final String INDENT = "    ";
    private final LibTypes mLibTypes;

    public ComponentWriter(LibTypes libTypes) {
        this.mLibTypes = libTypes;
    }

    public String createComponent() {
        StringBuilder builder = new StringBuilder();
        builder.append("package ");
        builder.append(this.mLibTypes.getBindingPackage());
        builder.append(";\n\n");
        builder.append("public interface DataBindingComponent {\n");
        SetterStore setterStore = SetterStore.get();
        Map<String, List<String>> bindingAdapters = setterStore.getComponentBindingAdapters();
        for (String simpleName2 : bindingAdapters.keySet()) {
            List<String> classes = bindingAdapters.get(simpleName2);
            if (classes.size() > 1) {
                int index = 1;
                for (String className : classes) {
                    ComponentWriter.addGetter(builder, simpleName2, className, index++);
                }
                continue;
            }
            ComponentWriter.addGetter(builder, simpleName2, classes.iterator().next(), 0);
        }
        builder.append("}\n");
        return builder.toString();
    }

    private static void addGetter(StringBuilder builder, String simpleName2, String className, int index) {
        builder.append(INDENT).append(className).append(" get").append(simpleName2);
        if (index > 0) {
            builder.append(index);
        }
        builder.append("();\n");
    }
}

