/*
 * Decompiled with CFR 0.152.
 */
package androidx.databinding;

import android.view.View;
import android.view.ViewStub;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;

public class ViewStubProxy {
    private ViewStub mViewStub;
    private ViewDataBinding mViewDataBinding;
    private View mRoot;
    private ViewStub.OnInflateListener mOnInflateListener;
    private ViewDataBinding mContainingBinding;
    private ViewStub.OnInflateListener mProxyListener = new ViewStub.OnInflateListener(){

        public void onInflate(ViewStub stub, View inflated) {
            ViewStubProxy.this.mRoot = inflated;
            ViewStubProxy.this.mViewDataBinding = DataBindingUtil.bind(((ViewStubProxy)ViewStubProxy.this).mContainingBinding.mBindingComponent, inflated, stub.getLayoutResource());
            ViewStubProxy.this.mViewStub = null;
            if (ViewStubProxy.this.mOnInflateListener != null) {
                ViewStubProxy.this.mOnInflateListener.onInflate(stub, inflated);
                ViewStubProxy.this.mOnInflateListener = null;
            }
            ViewStubProxy.this.mContainingBinding.invalidateAll();
            ViewStubProxy.this.mContainingBinding.forceExecuteBindings();
        }
    };

    public ViewStubProxy(@NonNull ViewStub viewStub) {
        this.mViewStub = viewStub;
        this.mViewStub.setOnInflateListener(this.mProxyListener);
    }

    public void setContainingBinding(@NonNull ViewDataBinding containingBinding) {
        this.mContainingBinding = containingBinding;
    }

    public boolean isInflated() {
        return this.mRoot != null;
    }

    public View getRoot() {
        return this.mRoot;
    }

    @Nullable
    public ViewDataBinding getBinding() {
        return this.mViewDataBinding;
    }

    @Nullable
    public ViewStub getViewStub() {
        return this.mViewStub;
    }

    public void setOnInflateListener(@Nullable ViewStub.OnInflateListener listener) {
        if (this.mViewStub != null) {
            this.mOnInflateListener = listener;
        }
    }
}

