/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.rxjava2;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.datastore.core.DataMigration;
import androidx.datastore.core.DataStore;
import androidx.datastore.core.handlers.ReplaceFileCorruptionHandler;
import androidx.datastore.preferences.PreferenceDataStoreFile;
import androidx.datastore.preferences.core.PreferenceDataStoreFactory;
import androidx.datastore.preferences.core.Preferences;
import androidx.datastore.preferences.rxjava2.DataMigrationFromRxDataMigration;
import androidx.datastore.rxjava2.RxDataMigration;
import androidx.datastore.rxjava2.RxDataStore;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.rx2.RxSchedulerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u0013\u001a\u00020\u00002\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0010J\u0014\u0010\u0015\u001a\u00020\u00002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u0017J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u0019J\u0014\u0010\u001a\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/datastore/preferences/rxjava2/RxPreferenceDataStoreBuilder;", "", "produceFile", "Ljava/util/concurrent/Callable;", "Ljava/io/File;", "(Ljava/util/concurrent/Callable;)V", "context", "Landroid/content/Context;", "name", "", "(Landroid/content/Context;Ljava/lang/String;)V", "corruptionHandler", "Landroidx/datastore/core/handlers/ReplaceFileCorruptionHandler;", "Landroidx/datastore/preferences/core/Preferences;", "dataMigrations", "", "Landroidx/datastore/core/DataMigration;", "ioScheduler", "Lio/reactivex/Scheduler;", "addDataMigration", "dataMigration", "addRxDataMigration", "rxDataMigration", "Landroidx/datastore/rxjava2/RxDataMigration;", "build", "Landroidx/datastore/rxjava2/RxDataStore;", "setCorruptionHandler", "setIoScheduler", "datastore-preferences-rxjava2_release"})
@SuppressLint(value={"TopLevelBuilder"})
@SourceDebugExtension(value={"SMAP\nRxPreferenceDataStoreBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RxPreferenceDataStoreBuilder.kt\nandroidx/datastore/preferences/rxjava2/RxPreferenceDataStoreBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1#2:183\n*E\n"})
public final class RxPreferenceDataStoreBuilder {
    @Nullable
    private Callable<File> produceFile;
    @Nullable
    private Context context;
    @Nullable
    private String name;
    @NotNull
    private Scheduler ioScheduler;
    @Nullable
    private ReplaceFileCorruptionHandler<Preferences> corruptionHandler;
    @NotNull
    private final List<DataMigration<Preferences>> dataMigrations;

    public RxPreferenceDataStoreBuilder(@NotNull Callable<File> produceFile) {
        Intrinsics.checkNotNullParameter(produceFile, (String)"produceFile");
        Scheduler scheduler = Schedulers.io();
        Intrinsics.checkNotNullExpressionValue((Object)scheduler, (String)"io()");
        this.ioScheduler = scheduler;
        this.dataMigrations = new ArrayList();
        this.produceFile = produceFile;
    }

    public RxPreferenceDataStoreBuilder(@NotNull Context context, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Scheduler scheduler = Schedulers.io();
        Intrinsics.checkNotNullExpressionValue((Object)scheduler, (String)"io()");
        this.ioScheduler = scheduler;
        this.dataMigrations = new ArrayList();
        this.context = context;
        this.name = name;
    }

    @NotNull
    public final RxPreferenceDataStoreBuilder setIoScheduler(@NotNull Scheduler ioScheduler) {
        RxPreferenceDataStoreBuilder rxPreferenceDataStoreBuilder;
        Intrinsics.checkNotNullParameter((Object)ioScheduler, (String)"ioScheduler");
        RxPreferenceDataStoreBuilder $this$setIoScheduler_u24lambda_u240 = rxPreferenceDataStoreBuilder = this;
        boolean bl = false;
        $this$setIoScheduler_u24lambda_u240.ioScheduler = ioScheduler;
        return rxPreferenceDataStoreBuilder;
    }

    @NotNull
    public final RxPreferenceDataStoreBuilder setCorruptionHandler(@NotNull ReplaceFileCorruptionHandler<Preferences> corruptionHandler) {
        RxPreferenceDataStoreBuilder rxPreferenceDataStoreBuilder;
        Intrinsics.checkNotNullParameter(corruptionHandler, (String)"corruptionHandler");
        RxPreferenceDataStoreBuilder $this$setCorruptionHandler_u24lambda_u241 = rxPreferenceDataStoreBuilder = this;
        boolean bl = false;
        $this$setCorruptionHandler_u24lambda_u241.corruptionHandler = corruptionHandler;
        return rxPreferenceDataStoreBuilder;
    }

    @NotNull
    public final RxPreferenceDataStoreBuilder addRxDataMigration(@NotNull RxDataMigration<Preferences> rxDataMigration) {
        RxPreferenceDataStoreBuilder rxPreferenceDataStoreBuilder;
        Intrinsics.checkNotNullParameter(rxDataMigration, (String)"rxDataMigration");
        RxPreferenceDataStoreBuilder $this$addRxDataMigration_u24lambda_u242 = rxPreferenceDataStoreBuilder = this;
        boolean bl = false;
        $this$addRxDataMigration_u24lambda_u242.dataMigrations.add(new DataMigrationFromRxDataMigration<Preferences>(rxDataMigration));
        return rxPreferenceDataStoreBuilder;
    }

    @NotNull
    public final RxPreferenceDataStoreBuilder addDataMigration(@NotNull DataMigration<Preferences> dataMigration) {
        RxPreferenceDataStoreBuilder rxPreferenceDataStoreBuilder;
        Intrinsics.checkNotNullParameter(dataMigration, (String)"dataMigration");
        RxPreferenceDataStoreBuilder $this$addDataMigration_u24lambda_u243 = rxPreferenceDataStoreBuilder = this;
        boolean bl = false;
        $this$addDataMigration_u24lambda_u243.dataMigrations.add(dataMigration);
        return rxPreferenceDataStoreBuilder;
    }

    @NotNull
    public final RxDataStore<Preferences> build() {
        DataStore dataStore;
        List<DataMigration<Preferences>> list;
        ReplaceFileCorruptionHandler<Preferences> replaceFileCorruptionHandler;
        PreferenceDataStoreFactory preferenceDataStoreFactory;
        CoroutineScope scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)RxSchedulerKt.asCoroutineDispatcher((Scheduler)this.ioScheduler).plus((CoroutineContext)JobKt.Job$default(null, (int)1, null)));
        Callable<File> produceFile = this.produceFile;
        Context context = this.context;
        String name = this.name;
        if (produceFile != null) {
            preferenceDataStoreFactory = PreferenceDataStoreFactory.INSTANCE;
            replaceFileCorruptionHandler = this.corruptionHandler;
            list = this.dataMigrations;
            dataStore = preferenceDataStoreFactory.create(replaceFileCorruptionHandler, list, scope, (Function0)new Function0<File>(produceFile){
                final /* synthetic */ Callable<File> $produceFile;
                {
                    this.$produceFile = $produceFile;
                    super(0);
                }

                @NotNull
                public final File invoke() {
                    File file = this.$produceFile.call();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"produceFile.call()");
                    return file;
                }
            });
        } else if (context != null && name != null) {
            preferenceDataStoreFactory = PreferenceDataStoreFactory.INSTANCE;
            replaceFileCorruptionHandler = this.corruptionHandler;
            list = this.dataMigrations;
            dataStore = preferenceDataStoreFactory.create(replaceFileCorruptionHandler, list, scope, (Function0)new Function0<File>(context, name){
                final /* synthetic */ Context $context;
                final /* synthetic */ String $name;
                {
                    this.$context = $context;
                    this.$name = $name;
                    super(0);
                }

                @NotNull
                public final File invoke() {
                    return PreferenceDataStoreFile.preferencesDataStoreFile((Context)this.$context, (String)this.$name);
                }
            });
        } else {
            throw new IllegalStateException("Either produceFile or context and name must be set. This should never happen.".toString());
        }
        DataStore delegate2 = dataStore;
        return RxDataStore.Companion.create(delegate2, scope);
    }
}

