/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences;

import androidx.datastore.CorruptionException;
import androidx.datastore.Serializer;
import androidx.datastore.preferences.MutablePreferences;
import androidx.datastore.preferences.Preferences;
import androidx.datastore.preferences.PreferencesKt;
import androidx.datastore.preferences.PreferencesMapCompat;
import androidx.datastore.preferences.PreferencesProto;
import androidx.datastore.preferences.PreferencesSerializer$WhenMappings;
import androidx.datastore.preferences.protobuf.GeneratedMessageLite;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Landroidx/datastore/preferences/PreferencesSerializer;", "Landroidx/datastore/Serializer;", "Landroidx/datastore/preferences/Preferences;", "()V", "fileExtension", "", "getFileExtension", "()Ljava/lang/String;", "addProtoEntryToPreferences", "", "name", "value", "Landroidx/datastore/preferences/PreferencesProto$Value;", "mutablePreferences", "Landroidx/datastore/preferences/MutablePreferences;", "getValueProto", "", "readFrom", "input", "Ljava/io/InputStream;", "writeTo", "t", "output", "Ljava/io/OutputStream;", "datastore-preferences_release"})
public final class PreferencesSerializer
implements Serializer<Preferences> {
    @NotNull
    private static final String fileExtension;
    public static final PreferencesSerializer INSTANCE;

    @NotNull
    public final String getFileExtension() {
        return fileExtension;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Preferences readFrom(@NotNull InputStream input) throws IOException, CorruptionException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        PreferencesProto.PreferenceMap preferencesProto = PreferencesMapCompat.Companion.readFrom(input);
        MutablePreferences mutablePreferences = PreferencesKt.mutablePreferencesOf(new Preferences.Pair[0]);
        Map map = preferencesProto.getPreferencesMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"preferencesProto.preferencesMap");
        Map $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            void name;
            Map.Entry element$iv;
            Map.Entry $dstr$name$value = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$name$value;
            boolean bl3 = false;
            String string = (String)entry.getKey();
            entry = $dstr$name$value;
            bl3 = false;
            PreferencesProto.Value value = (PreferencesProto.Value)entry.getValue();
            void v1 = name;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"name");
            PreferencesProto.Value value2 = value;
            Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
            INSTANCE.addProtoEntryToPreferences((String)v1, value2, mutablePreferences);
        }
        return PreferencesKt.toPreferences(mutablePreferences);
    }

    /*
     * WARNING - void declaration
     */
    public void writeTo(@NotNull Preferences t, @NotNull OutputStream output) throws IOException, CorruptionException {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Map<Preferences.Key<?>, Object> preferences = t.asMap();
        PreferencesProto.PreferenceMap.Builder protoBuilder = PreferencesProto.PreferenceMap.newBuilder();
        Object object = preferences;
        boolean bl = false;
        Iterator<Map.Entry<Preferences.Key<?>, Object>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry<Preferences.Key<?>, Object> entry;
            Map.Entry<Preferences.Key<?>, Object> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Object value = entry2.getValue();
            protoBuilder.putPreferences(key.getName(), this.getValueProto(value));
        }
        ((PreferencesProto.PreferenceMap)protoBuilder.build()).writeTo(output);
    }

    private final PreferencesProto.Value getValueProto(Object value) {
        PreferencesProto.Value value2;
        Object object = value;
        if (object instanceof Boolean) {
            GeneratedMessageLite generatedMessageLite = PreferencesProto.Value.newBuilder().setBoolean(((Boolean)value).booleanValue()).build();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"Value.newBuilder().setBoolean(value).build()");
            value2 = (PreferencesProto.Value)generatedMessageLite;
        } else if (object instanceof Float) {
            GeneratedMessageLite generatedMessageLite = PreferencesProto.Value.newBuilder().setFloat(((Number)value).floatValue()).build();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"Value.newBuilder().setFloat(value).build()");
            value2 = (PreferencesProto.Value)generatedMessageLite;
        } else if (object instanceof Integer) {
            GeneratedMessageLite generatedMessageLite = PreferencesProto.Value.newBuilder().setInteger(((Number)value).intValue()).build();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"Value.newBuilder().setInteger(value).build()");
            value2 = (PreferencesProto.Value)generatedMessageLite;
        } else if (object instanceof Long) {
            GeneratedMessageLite generatedMessageLite = PreferencesProto.Value.newBuilder().setLong(((Number)value).longValue()).build();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"Value.newBuilder().setLong(value).build()");
            value2 = (PreferencesProto.Value)generatedMessageLite;
        } else if (object instanceof String) {
            GeneratedMessageLite generatedMessageLite = PreferencesProto.Value.newBuilder().setString((String)value).build();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"Value.newBuilder().setString(value).build()");
            value2 = (PreferencesProto.Value)generatedMessageLite;
        } else if (object instanceof Set) {
            Object object2 = value;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Set<kotlin.String>");
            }
            GeneratedMessageLite generatedMessageLite = PreferencesProto.Value.newBuilder().setStringSet(PreferencesProto.StringSet.newBuilder().addAllStrings((Iterable)((Set)object2))).build();
            Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"Value.newBuilder().setSt\u2026                ).build()");
            value2 = (PreferencesProto.Value)generatedMessageLite;
        } else {
            throw (Throwable)new IllegalStateException("PreferencesSerializer does not support type: " + value.getClass().getName());
        }
        return value2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void addProtoEntryToPreferences(String name, PreferencesProto.Value value, MutablePreferences mutablePreferences) {
        PreferencesProto.Value.ValueCase valueCase = value.getValueCase();
        if (valueCase == null) throw (Throwable)new CorruptionException("Value case is null.", null, 2, null);
        switch (PreferencesSerializer$WhenMappings.$EnumSwitchMapping$0[valueCase.ordinal()]) {
            case 1: {
                Preferences.Key key;
                boolean $i$f$preferencesKey = false;
                KClass kClass = Reflection.getOrCreateKotlinClass(Boolean.class);
                if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    key = new Preferences.Key(name);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    key = new Preferences.Key(name);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    key = new Preferences.Key(name);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                    key = new Preferences.Key(name);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    key = new Preferences.Key(name);
                } else {
                    if (!Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Set.class))) throw (Throwable)new IllegalArgumentException("Type not supported: " + Boolean.class);
                    throw (Throwable)new IllegalArgumentException("Use `preferencesSetKey` to create keys for Sets.");
                }
                mutablePreferences.set(key, value.getBoolean());
                return;
            }
            case 2: {
                Preferences.Key key;
                boolean $i$f$preferencesKey = false;
                KClass kClass = Reflection.getOrCreateKotlinClass(Float.class);
                if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    key = new Preferences.Key(name);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    key = new Preferences.Key(name);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    key = new Preferences.Key(name);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                    key = new Preferences.Key(name);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    key = new Preferences.Key(name);
                } else {
                    if (!Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Set.class))) throw (Throwable)new IllegalArgumentException("Type not supported: " + Float.class);
                    throw (Throwable)new IllegalArgumentException("Use `preferencesSetKey` to create keys for Sets.");
                }
                mutablePreferences.set(key, Float.valueOf(value.getFloat()));
                return;
            }
            case 3: {
                Preferences.Key key;
                boolean $i$f$preferencesKey = false;
                KClass kClass = Reflection.getOrCreateKotlinClass(Integer.class);
                if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    key = new Preferences.Key(name);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    key = new Preferences.Key(name);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    key = new Preferences.Key(name);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                    key = new Preferences.Key(name);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    key = new Preferences.Key(name);
                } else {
                    if (!Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Set.class))) throw (Throwable)new IllegalArgumentException("Type not supported: " + Integer.class);
                    throw (Throwable)new IllegalArgumentException("Use `preferencesSetKey` to create keys for Sets.");
                }
                mutablePreferences.set(key, value.getInteger());
                return;
            }
            case 4: {
                Preferences.Key key;
                boolean $i$f$preferencesKey = false;
                KClass kClass = Reflection.getOrCreateKotlinClass(Long.class);
                if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    key = new Preferences.Key(name);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    key = new Preferences.Key(name);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    key = new Preferences.Key(name);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                    key = new Preferences.Key(name);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    key = new Preferences.Key(name);
                } else {
                    if (!Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Set.class))) throw (Throwable)new IllegalArgumentException("Type not supported: " + Long.class);
                    throw (Throwable)new IllegalArgumentException("Use `preferencesSetKey` to create keys for Sets.");
                }
                mutablePreferences.set(key, value.getLong());
                return;
            }
            case 5: {
                Preferences.Key key;
                boolean $i$f$preferencesKey = false;
                KClass kClass = Reflection.getOrCreateKotlinClass(String.class);
                if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    key = new Preferences.Key(name);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    key = new Preferences.Key(name);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    key = new Preferences.Key(name);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                    key = new Preferences.Key(name);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    key = new Preferences.Key(name);
                } else {
                    if (!Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Set.class))) throw (Throwable)new IllegalArgumentException("Type not supported: " + String.class);
                    throw (Throwable)new IllegalArgumentException("Use `preferencesSetKey` to create keys for Sets.");
                }
                mutablePreferences.set(key, value.getString());
                return;
            }
            case 6: {
                boolean $i$f$preferencesSetKey = false;
                if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(String.class), (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    throw (Throwable)new IllegalArgumentException("Only String sets are currently supported.");
                }
                Preferences.Key key = new Preferences.Key(name);
                PreferencesProto.StringSet stringSet = value.getStringSet();
                Intrinsics.checkNotNullExpressionValue((Object)stringSet, (String)"value.stringSet");
                List list = stringSet.getStringsList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"value.stringSet.stringsList");
                mutablePreferences.set(key, CollectionsKt.toSet((Iterable)list));
                return;
            }
            case 7: {
                throw (Throwable)new CorruptionException("Value not set.", null, 2, null);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private PreferencesSerializer() {
    }

    static {
        PreferencesSerializer preferencesSerializer;
        INSTANCE = preferencesSerializer = new PreferencesSerializer();
        fileExtension = "preferences_pb";
    }
}

