/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.rxjava2;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.datastore.DataStoreFile;
import androidx.datastore.core.DataMigration;
import androidx.datastore.core.DataStore;
import androidx.datastore.core.DataStoreFactory;
import androidx.datastore.core.Serializer;
import androidx.datastore.core.handlers.ReplaceFileCorruptionHandler;
import androidx.datastore.rxjava2.DataMigrationFromRxDataMigration;
import androidx.datastore.rxjava2.RxDataMigration;
import androidx.datastore.rxjava2.RxDataStore;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.rx2.RxSchedulerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B#\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bB%\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012J\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cJ\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0013\u001a\u00020\u0014R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/datastore/rxjava2/RxDataStoreBuilder;", "T", "", "produceFile", "Ljava/util/concurrent/Callable;", "Ljava/io/File;", "serializer", "Landroidx/datastore/core/Serializer;", "(Ljava/util/concurrent/Callable;Landroidx/datastore/core/Serializer;)V", "context", "Landroid/content/Context;", "fileName", "", "(Landroid/content/Context;Ljava/lang/String;Landroidx/datastore/core/Serializer;)V", "corruptionHandler", "Landroidx/datastore/core/handlers/ReplaceFileCorruptionHandler;", "dataMigrations", "", "Landroidx/datastore/core/DataMigration;", "ioScheduler", "Lio/reactivex/Scheduler;", "name", "addDataMigration", "dataMigration", "addRxDataMigration", "rxDataMigration", "Landroidx/datastore/rxjava2/RxDataMigration;", "build", "Landroidx/datastore/rxjava2/RxDataStore;", "setCorruptionHandler", "setIoScheduler", "datastore-rxjava2_release"})
@SuppressLint(value={"TopLevelBuilder"})
@SourceDebugExtension(value={"SMAP\nRxDataStoreBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RxDataStoreBuilder.kt\nandroidx/datastore/rxjava2/RxDataStoreBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n1#2:184\n*E\n"})
public final class RxDataStoreBuilder<T> {
    @Nullable
    private Callable<File> produceFile;
    @Nullable
    private Context context;
    @Nullable
    private String name;
    @Nullable
    private Serializer<T> serializer;
    @NotNull
    private Scheduler ioScheduler;
    @Nullable
    private ReplaceFileCorruptionHandler<T> corruptionHandler;
    @NotNull
    private final List<DataMigration<T>> dataMigrations;

    public RxDataStoreBuilder(@NotNull Callable<File> produceFile, @NotNull Serializer<T> serializer) {
        Intrinsics.checkNotNullParameter(produceFile, (String)"produceFile");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Scheduler scheduler = Schedulers.io();
        Intrinsics.checkNotNullExpressionValue((Object)scheduler, (String)"io()");
        this.ioScheduler = scheduler;
        this.dataMigrations = new ArrayList();
        this.produceFile = produceFile;
        this.serializer = serializer;
    }

    public RxDataStoreBuilder(@NotNull Context context, @NotNull String fileName, @NotNull Serializer<T> serializer) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Scheduler scheduler = Schedulers.io();
        Intrinsics.checkNotNullExpressionValue((Object)scheduler, (String)"io()");
        this.ioScheduler = scheduler;
        this.dataMigrations = new ArrayList();
        this.context = context;
        this.name = fileName;
        this.serializer = serializer;
    }

    @NotNull
    public final RxDataStoreBuilder<T> setIoScheduler(@NotNull Scheduler ioScheduler) {
        RxDataStoreBuilder rxDataStoreBuilder;
        Intrinsics.checkNotNullParameter((Object)ioScheduler, (String)"ioScheduler");
        RxDataStoreBuilder $this$setIoScheduler_u24lambda_u240 = rxDataStoreBuilder = this;
        boolean bl = false;
        $this$setIoScheduler_u24lambda_u240.ioScheduler = ioScheduler;
        return rxDataStoreBuilder;
    }

    @NotNull
    public final RxDataStoreBuilder<T> setCorruptionHandler(@NotNull ReplaceFileCorruptionHandler<T> corruptionHandler) {
        RxDataStoreBuilder rxDataStoreBuilder;
        Intrinsics.checkNotNullParameter(corruptionHandler, (String)"corruptionHandler");
        RxDataStoreBuilder $this$setCorruptionHandler_u24lambda_u241 = rxDataStoreBuilder = this;
        boolean bl = false;
        $this$setCorruptionHandler_u24lambda_u241.corruptionHandler = corruptionHandler;
        return rxDataStoreBuilder;
    }

    @NotNull
    public final RxDataStoreBuilder<T> addRxDataMigration(@NotNull RxDataMigration<T> rxDataMigration) {
        RxDataStoreBuilder rxDataStoreBuilder;
        Intrinsics.checkNotNullParameter(rxDataMigration, (String)"rxDataMigration");
        RxDataStoreBuilder $this$addRxDataMigration_u24lambda_u242 = rxDataStoreBuilder = this;
        boolean bl = false;
        $this$addRxDataMigration_u24lambda_u242.dataMigrations.add(new DataMigrationFromRxDataMigration<T>(rxDataMigration));
        return rxDataStoreBuilder;
    }

    @NotNull
    public final RxDataStoreBuilder<T> addDataMigration(@NotNull DataMigration<T> dataMigration) {
        RxDataStoreBuilder rxDataStoreBuilder;
        Intrinsics.checkNotNullParameter(dataMigration, (String)"dataMigration");
        RxDataStoreBuilder $this$addDataMigration_u24lambda_u243 = rxDataStoreBuilder = this;
        boolean bl = false;
        $this$addDataMigration_u24lambda_u243.dataMigrations.add(dataMigration);
        return rxDataStoreBuilder;
    }

    @NotNull
    public final RxDataStore<T> build() {
        DataStore dataStore;
        List<DataMigration<T>> list;
        ReplaceFileCorruptionHandler<T> replaceFileCorruptionHandler;
        Serializer<T> serializer;
        DataStoreFactory dataStoreFactory;
        CoroutineScope scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)RxSchedulerKt.asCoroutineDispatcher((Scheduler)this.ioScheduler).plus((CoroutineContext)JobKt.Job$default(null, (int)1, null)));
        if (this.produceFile != null) {
            dataStoreFactory = DataStoreFactory.INSTANCE;
            Serializer<T> serializer2 = this.serializer;
            Intrinsics.checkNotNull(serializer2);
            serializer = serializer2;
            replaceFileCorruptionHandler = this.corruptionHandler;
            list = this.dataMigrations;
            dataStore = dataStoreFactory.create(serializer, replaceFileCorruptionHandler, list, scope, (Function0)new Function0<File>(this){
                final /* synthetic */ RxDataStoreBuilder<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final File invoke() {
                    Callable callable = RxDataStoreBuilder.access$getProduceFile$p(this.this$0);
                    Intrinsics.checkNotNull((Object)callable);
                    V v = callable.call();
                    Intrinsics.checkNotNullExpressionValue(v, (String)"produceFile!!.call()");
                    return (File)v;
                }
            });
        } else if (this.context != null && this.name != null) {
            dataStoreFactory = DataStoreFactory.INSTANCE;
            Serializer<T> serializer3 = this.serializer;
            Intrinsics.checkNotNull(serializer3);
            serializer = serializer3;
            replaceFileCorruptionHandler = this.corruptionHandler;
            list = this.dataMigrations;
            dataStore = dataStoreFactory.create(serializer, replaceFileCorruptionHandler, list, scope, (Function0)new Function0<File>(this){
                final /* synthetic */ RxDataStoreBuilder<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final File invoke() {
                    Context context = RxDataStoreBuilder.access$getContext$p(this.this$0);
                    Intrinsics.checkNotNull((Object)context);
                    String string = RxDataStoreBuilder.access$getName$p(this.this$0);
                    Intrinsics.checkNotNull((Object)string);
                    return DataStoreFile.dataStoreFile((Context)context, (String)string);
                }
            });
        } else {
            throw new IllegalStateException("Either produceFile or context and name must be set. This should never happen.".toString());
        }
        DataStore delegateDs2 = dataStore;
        return RxDataStore.Companion.create(delegateDs2, scope);
    }

    public static final /* synthetic */ Callable access$getProduceFile$p(RxDataStoreBuilder $this) {
        return $this.produceFile;
    }

    public static final /* synthetic */ Context access$getContext$p(RxDataStoreBuilder $this) {
        return $this.context;
    }

    public static final /* synthetic */ String access$getName$p(RxDataStoreBuilder $this) {
        return $this.name;
    }
}

