/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.emoji2.widget.R;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class EditTextAttributeHelper {
    private int mMaxEmojiCount;

    public EditTextAttributeHelper(@NonNull View view, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (attrs != null) {
            Context context = view.getContext();
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.EmojiEditText, defStyleAttr, defStyleRes);
            this.mMaxEmojiCount = a.getInteger(R.styleable.EmojiEditText_maxEmojiCount, Integer.MAX_VALUE);
            a.recycle();
        }
    }

    public int getMaxEmojiCount() {
        return this.mMaxEmojiCount;
    }
}

