/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.widget;

import android.content.Context;
import android.inputmethodservice.ExtractEditText;
import android.text.method.KeyListener;
import android.util.AttributeSet;
import android.view.ActionMode;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.widget.TextViewCompat;
import androidx.emoji2.viewsintegration.EmojiEditTextHelper;
import androidx.emoji2.widget.EditTextAttributeHelper;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class EmojiExtractEditText
extends ExtractEditText {
    private EmojiEditTextHelper mEmojiEditTextHelper;
    private boolean mInitialized;

    public EmojiExtractEditText(@NonNull Context context) {
        super(context);
        this.init(null, 0, 0);
    }

    public EmojiExtractEditText(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 16842862, 0);
    }

    public EmojiExtractEditText(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr, 0);
    }

    private void init(@Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (!this.mInitialized) {
            this.mInitialized = true;
            EditTextAttributeHelper attrHelper = new EditTextAttributeHelper((View)this, attrs, defStyleAttr, defStyleRes);
            this.setMaxEmojiCount(attrHelper.getMaxEmojiCount());
            this.setKeyListener(super.getKeyListener());
        }
    }

    public void setKeyListener(@Nullable KeyListener keyListener) {
        if (keyListener != null) {
            keyListener = this.getEmojiEditTextHelper().getKeyListener(keyListener);
        }
        super.setKeyListener(keyListener);
    }

    @Nullable
    public InputConnection onCreateInputConnection(@NonNull EditorInfo outAttrs) {
        InputConnection inputConnection = super.onCreateInputConnection(outAttrs);
        return this.getEmojiEditTextHelper().onCreateInputConnection(inputConnection, outAttrs);
    }

    public void setMaxEmojiCount(@IntRange(from=0L) int maxEmojiCount) {
        this.getEmojiEditTextHelper().setMaxEmojiCount(maxEmojiCount);
    }

    public void setEmojiReplaceStrategy(int replaceStrategy) {
        this.getEmojiEditTextHelper().setEmojiReplaceStrategy(replaceStrategy);
    }

    public int getEmojiReplaceStrategy() {
        return this.getEmojiEditTextHelper().getEmojiReplaceStrategy();
    }

    public int getMaxEmojiCount() {
        return this.getEmojiEditTextHelper().getMaxEmojiCount();
    }

    private EmojiEditTextHelper getEmojiEditTextHelper() {
        if (this.mEmojiEditTextHelper == null) {
            this.mEmojiEditTextHelper = new EmojiEditTextHelper((EditText)this);
        }
        return this.mEmojiEditTextHelper;
    }

    public void setCustomSelectionActionModeCallback(@NonNull ActionMode.Callback actionModeCallback) {
        super.setCustomSelectionActionModeCallback(TextViewCompat.wrapCustomSelectionActionModeCallback((TextView)this, (ActionMode.Callback)actionModeCallback));
    }
}

