/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.inputmethodservice.InputMethodService;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.emoji2.widget.EmojiExtractEditText;
import androidx.emoji2.widget.ExtractButtonCompat;
import androidx.emoji2.widget.R;

public class EmojiExtractTextLayout
extends LinearLayout {
    private ExtractButtonCompat mExtractAction;
    private EmojiExtractEditText mExtractEditText;
    private ViewGroup mExtractAccessories;
    private View.OnClickListener mButtonOnClickListener;
    private boolean mInitialized;

    public EmojiExtractTextLayout(@NonNull Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public EmojiExtractTextLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public EmojiExtractTextLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    private void init(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (!this.mInitialized) {
            this.mInitialized = true;
            this.setOrientation(0);
            View view = LayoutInflater.from((Context)context).inflate(R.layout.input_method_extract_view, (ViewGroup)this, true);
            this.mExtractAccessories = (ViewGroup)view.findViewById(R.id.inputExtractAccessories);
            this.mExtractAction = (ExtractButtonCompat)view.findViewById(R.id.inputExtractAction);
            this.mExtractEditText = (EmojiExtractEditText)view.findViewById(16908325);
            if (attrs != null) {
                TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.EmojiExtractTextLayout, defStyleAttr, defStyleRes);
                ViewCompat.saveAttributeDataForStyleable((View)this, (Context)context, (int[])R.styleable.EmojiExtractTextLayout, (AttributeSet)attrs, (TypedArray)a, (int)defStyleAttr, (int)defStyleRes);
                int replaceStrategy = a.getInteger(R.styleable.EmojiExtractTextLayout_emojiReplaceStrategy, 0);
                this.mExtractEditText.setEmojiReplaceStrategy(replaceStrategy);
                a.recycle();
            }
        }
    }

    public void setEmojiReplaceStrategy(int replaceStrategy) {
        this.mExtractEditText.setEmojiReplaceStrategy(replaceStrategy);
    }

    public int getEmojiReplaceStrategy() {
        return this.mExtractEditText.getEmojiReplaceStrategy();
    }

    public void onUpdateExtractingViews(@NonNull InputMethodService inputMethodService, @NonNull EditorInfo ei) {
        boolean hasAction;
        if (!inputMethodService.isExtractViewShown()) {
            return;
        }
        if (this.mExtractAccessories == null) {
            return;
        }
        boolean bl = hasAction = ei.actionLabel != null || (ei.imeOptions & 0xFF) != 1 && (ei.imeOptions & 0x20000000) == 0 && ei.inputType != 0;
        if (hasAction) {
            this.mExtractAccessories.setVisibility(0);
            if (this.mExtractAction != null) {
                if (ei.actionLabel != null) {
                    this.mExtractAction.setText(ei.actionLabel);
                } else {
                    this.mExtractAction.setText(inputMethodService.getTextForImeAction(ei.imeOptions));
                }
                this.mExtractAction.setOnClickListener(this.getButtonClickListener(inputMethodService));
            }
        } else {
            this.mExtractAccessories.setVisibility(8);
            if (this.mExtractAction != null) {
                this.mExtractAction.setOnClickListener(null);
            }
        }
    }

    private View.OnClickListener getButtonClickListener(InputMethodService inputMethodService) {
        if (this.mButtonOnClickListener == null) {
            this.mButtonOnClickListener = new ButtonOnclickListener(inputMethodService);
        }
        return this.mButtonOnClickListener;
    }

    private static final class ButtonOnclickListener
    implements View.OnClickListener {
        private final InputMethodService mInputMethodService;

        ButtonOnclickListener(InputMethodService inputMethodService) {
            this.mInputMethodService = inputMethodService;
        }

        public void onClick(View v) {
            EditorInfo ei = this.mInputMethodService.getCurrentInputEditorInfo();
            InputConnection ic = this.mInputMethodService.getCurrentInputConnection();
            if (ei != null && ic != null) {
                if (ei.actionId != 0) {
                    ic.performEditorAction(ei.actionId);
                } else if ((ei.imeOptions & 0xFF) != 1) {
                    ic.performEditorAction(ei.imeOptions & 0xFF);
                }
            }
        }
    }
}

