/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.widget;

import android.content.Context;
import android.text.InputFilter;
import android.util.AttributeSet;
import android.view.ActionMode;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.widget.TextViewCompat;
import androidx.emoji2.viewsintegration.EmojiTextViewHelper;

public class EmojiTextView
extends TextView {
    private EmojiTextViewHelper mEmojiTextViewHelper;
    private boolean mInitialized;

    public EmojiTextView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public EmojiTextView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public EmojiTextView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        if (!this.mInitialized) {
            this.mInitialized = true;
            this.getEmojiTextViewHelper().updateTransformationMethod();
        }
    }

    public void setFilters(@NonNull InputFilter[] filters) {
        super.setFilters(this.getEmojiTextViewHelper().getFilters(filters));
    }

    public void setAllCaps(boolean allCaps) {
        super.setAllCaps(allCaps);
        this.getEmojiTextViewHelper().setAllCaps(allCaps);
    }

    private EmojiTextViewHelper getEmojiTextViewHelper() {
        if (this.mEmojiTextViewHelper == null) {
            this.mEmojiTextViewHelper = new EmojiTextViewHelper((TextView)this);
        }
        return this.mEmojiTextViewHelper;
    }

    public void setCustomSelectionActionModeCallback(@NonNull ActionMode.Callback actionModeCallback) {
        super.setCustomSelectionActionModeCallback(TextViewCompat.wrapCustomSelectionActionModeCallback((TextView)this, (ActionMode.Callback)actionModeCallback));
    }
}

