/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.lowlatency;

import android.hardware.HardwareBuffer;
import android.opengl.GLES20;
import androidx.annotation.RequiresApi;
import androidx.graphics.opengl.egl.EGLSpec;
import androidx.opengl.EGLExt;
import androidx.opengl.EGLImageKHR;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0015R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/graphics/lowlatency/FrameBuffer;", "Ljava/lang/AutoCloseable;", "egl", "Landroidx/graphics/opengl/egl/EGLSpec;", "hardwareBuffer", "Landroid/hardware/HardwareBuffer;", "(Landroidx/graphics/opengl/egl/EGLSpec;Landroid/hardware/HardwareBuffer;)V", "buffer", "", "eglImage", "Landroidx/opengl/EGLImageKHR;", "frameBuffer", "", "getHardwareBuffer", "()Landroid/hardware/HardwareBuffer;", "<set-?>", "", "isClosed", "()Z", "texture", "close", "", "makeCurrent", "graphics-core_release"})
@RequiresApi(value=26)
public final class FrameBuffer
implements AutoCloseable {
    @NotNull
    private final EGLSpec egl;
    @NotNull
    private final HardwareBuffer hardwareBuffer;
    @Nullable
    private EGLImageKHR eglImage;
    private int texture;
    private int frameBuffer;
    private boolean isClosed;
    @NotNull
    private final int[] buffer;

    public FrameBuffer(@NotNull EGLSpec egl, @NotNull HardwareBuffer hardwareBuffer) {
        EGLImageKHR image;
        Intrinsics.checkNotNullParameter((Object)egl, (String)"egl");
        Intrinsics.checkNotNullParameter((Object)hardwareBuffer, (String)"hardwareBuffer");
        this.egl = egl;
        this.hardwareBuffer = hardwareBuffer;
        this.texture = -1;
        this.frameBuffer = -1;
        this.buffer = new int[1];
        EGLImageKHR eGLImageKHR = this.egl.eglCreateImageFromHardwareBuffer(this.hardwareBuffer);
        if (eGLImageKHR == null) {
            throw new IllegalArgumentException("Unable to create EGLImage from HardwareBuffer");
        }
        this.eglImage = image = eGLImageKHR;
        GLES20.glGenTextures((int)1, (int[])this.buffer, (int)0);
        this.texture = this.buffer[0];
        GLES20.glBindTexture((int)3553, (int)this.texture);
        EGLExt.Companion.glEGLImageTargetTexture2DOES(3553, image);
        GLES20.glGenFramebuffers((int)1, (int[])this.buffer, (int)0);
        this.frameBuffer = this.buffer[0];
    }

    @NotNull
    public final HardwareBuffer getHardwareBuffer() {
        return this.hardwareBuffer;
    }

    public final boolean isClosed() {
        return this.isClosed;
    }

    public final void makeCurrent() {
        if (!this.isClosed) {
            GLES20.glBindFramebuffer((int)36160, (int)this.frameBuffer);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.texture, (int)0);
        }
    }

    @Override
    public void close() {
        this.buffer[0] = this.frameBuffer;
        GLES20.glDeleteBuffers((int)1, (int[])this.buffer, (int)0);
        this.frameBuffer = -1;
        this.buffer[0] = this.texture;
        GLES20.glDeleteTextures((int)1, (int[])this.buffer, (int)0);
        this.texture = -1;
        EGLImageKHR eGLImageKHR = this.eglImage;
        if (eGLImageKHR != null) {
            EGLImageKHR it = eGLImageKHR;
            boolean bl = false;
            this.egl.eglDestroyImageKHR(it);
        }
        this.eglImage = null;
        this.hardwareBuffer.close();
        this.isClosed = true;
    }
}

