/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.lowlatency;

import android.hardware.HardwareBuffer;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.graphics.lowlatency.FrameBuffer;
import androidx.graphics.opengl.egl.EGLSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0012R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/graphics/lowlatency/FrameBufferPool;", "", "width", "", "height", "format", "usage", "", "maxPoolSize", "(IIIJI)V", "mCondition", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "mLock", "Ljava/util/concurrent/locks/ReentrantLock;", "mNumAllocated", "mPool", "Ljava/util/ArrayList;", "Landroidx/graphics/lowlatency/FrameBuffer;", "Lkotlin/collections/ArrayList;", "close", "", "obtain", "eglSpec", "Landroidx/graphics/opengl/egl/EGLSpec;", "release", "frameBuffer", "Companion", "graphics-core_release"})
@RequiresApi(value=26)
public final class FrameBufferPool {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final int width;
    private final int height;
    private final int format;
    private final long usage;
    private final int maxPoolSize;
    @NotNull
    private final ArrayList<FrameBuffer> mPool;
    private int mNumAllocated;
    @NotNull
    private final ReentrantLock mLock;
    private final Condition mCondition;
    @Deprecated
    @NotNull
    private static final String TAG = "FrameBufferPool";

    public FrameBufferPool(int width, int height, int format, long usage, int maxPoolSize) {
        this.width = width;
        this.height = height;
        this.format = format;
        this.usage = usage;
        this.maxPoolSize = maxPoolSize;
        this.mPool = new ArrayList();
        this.mLock = new ReentrantLock();
        this.mCondition = this.mLock.newCondition();
        if (this.maxPoolSize <= 0) {
            throw new IllegalArgumentException("Pool size must be at least 1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final FrameBuffer obtain(@NotNull EGLSpec eglSpec) {
        Intrinsics.checkNotNullParameter((Object)eglSpec, (String)"eglSpec");
        Lock lock = this.mLock;
        lock.lock();
        try {
            FrameBuffer frameBuffer;
            boolean bl = false;
            while (this.mPool.isEmpty() && this.mNumAllocated >= this.maxPoolSize) {
                Log.w((String)TAG, (String)("Waiting for FrameBuffer to become available, current allocation count: " + this.mNumAllocated));
                this.mCondition.await();
            }
            if (!((Collection)this.mPool).isEmpty()) {
                FrameBuffer frameBuffer2 = this.mPool.get(this.mPool.size() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)frameBuffer2, (String)"mPool[mPool.size - 1]");
                FrameBuffer frameBuffer3 = frameBuffer2;
                this.mPool.remove(this.mPool.size() - 1);
                frameBuffer = frameBuffer3;
            } else {
                int n = this.mNumAllocated;
                this.mNumAllocated = n + 1;
                HardwareBuffer hardwareBuffer = HardwareBuffer.create((int)this.width, (int)this.height, (int)this.format, (int)1, (long)this.usage);
                Intrinsics.checkNotNullExpressionValue((Object)hardwareBuffer, (String)"create(\n                \u2026age\n                    )");
                frameBuffer = new FrameBuffer(eglSpec, hardwareBuffer);
            }
            FrameBuffer frameBuffer4 = frameBuffer;
            return frameBuffer4;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release(@NotNull FrameBuffer frameBuffer) {
        Intrinsics.checkNotNullParameter((Object)frameBuffer, (String)"frameBuffer");
        Lock lock = this.mLock;
        lock.lock();
        try {
            boolean bl = false;
            this.mPool.add(frameBuffer);
            this.mCondition.signal();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        Lock lock = this.mLock;
        lock.lock();
        try {
            boolean bl = false;
            for (FrameBuffer frameBuffer : this.mPool) {
                frameBuffer.close();
            }
            this.mPool.clear();
            this.mNumAllocated = 0;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/graphics/lowlatency/FrameBufferPool$Companion;", "", "()V", "TAG", "", "graphics-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

