/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.lowlatency;

import android.annotation.SuppressLint;
import android.opengl.EGLConfig;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import androidx.graphics.lowlatency.FrameBuffer;
import androidx.graphics.lowlatency.SyncFenceCompat;
import androidx.graphics.lowlatency.SyncStrategy;
import androidx.graphics.opengl.GLRenderer;
import androidx.graphics.opengl.egl.EGLManager;
import androidx.graphics.opengl.egl.EGLSpec;
import androidx.opengl.EGLSyncKHR;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J2\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\f\u0010\u0019\u001a\u00020\u001a*\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Landroidx/graphics/lowlatency/FrameBufferRenderer;", "Landroidx/graphics/opengl/GLRenderer$RenderCallback;", "frameBufferRendererCallbacks", "Landroidx/graphics/lowlatency/FrameBufferRenderer$RenderCallback;", "syncStrategy", "Landroidx/graphics/lowlatency/SyncStrategy;", "(Landroidx/graphics/lowlatency/FrameBufferRenderer$RenderCallback;Landroidx/graphics/lowlatency/SyncStrategy;)V", "mClear", "Ljava/util/concurrent/atomic/AtomicBoolean;", "clear", "", "onDrawFrame", "eglManager", "Landroidx/graphics/opengl/egl/EGLManager;", "onSurfaceCreated", "Landroid/opengl/EGLSurface;", "spec", "Landroidx/graphics/opengl/egl/EGLSpec;", "config", "Landroid/opengl/EGLConfig;", "surface", "Landroid/view/Surface;", "width", "", "height", "supportsNativeAndroidFence", "", "Companion", "RenderCallback", "graphics-core_release"})
@RequiresApi(value=26)
public final class FrameBufferRenderer
implements GLRenderer.RenderCallback {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final RenderCallback frameBufferRendererCallbacks;
    @NotNull
    private final SyncStrategy syncStrategy;
    @NotNull
    private final AtomicBoolean mClear;
    @Deprecated
    @NotNull
    private static final String TAG = "FrameBufferRenderer";

    public FrameBufferRenderer(@NotNull RenderCallback frameBufferRendererCallbacks, @SuppressLint(value={"ListenerLast"}) @NotNull SyncStrategy syncStrategy) {
        Intrinsics.checkNotNullParameter((Object)frameBufferRendererCallbacks, (String)"frameBufferRendererCallbacks");
        Intrinsics.checkNotNullParameter((Object)syncStrategy, (String)"syncStrategy");
        this.frameBufferRendererCallbacks = frameBufferRendererCallbacks;
        this.syncStrategy = syncStrategy;
        this.mClear = new AtomicBoolean(false);
    }

    public /* synthetic */ FrameBufferRenderer(RenderCallback renderCallback, SyncStrategy syncStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            syncStrategy = SyncStrategy.ALWAYS;
        }
        this(renderCallback, syncStrategy);
    }

    @Override
    @Nullable
    public EGLSurface onSurfaceCreated(@NotNull EGLSpec spec, @NotNull EGLConfig config, @NotNull Surface surface, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        return null;
    }

    public final void clear() {
        this.mClear.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDrawFrame(@NotNull EGLManager eglManager) {
        Intrinsics.checkNotNullParameter((Object)eglManager, (String)"eglManager");
        EGLSpec egl = eglManager.getEGLSpec();
        FrameBuffer buffer = this.frameBufferRendererCallbacks.obtainFrameBuffer(egl);
        SyncFenceCompat syncFenceCompat = null;
        try {
            SyncFenceCompat syncFenceCompat2;
            buffer.makeCurrent();
            if (this.mClear.getAndSet(false)) {
                GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                GLES20.glClear((int)16384);
            } else {
                this.frameBufferRendererCallbacks.onDraw(eglManager);
            }
            if (this.supportsNativeAndroidFence(eglManager)) {
                syncFenceCompat2 = this.syncStrategy.createSyncFence(egl);
            } else if (eglManager.isExtensionSupported("EGL_KHR_fence_sync")) {
                EGLSyncKHR syncKhr = egl.eglCreateSyncKHR(12537, null);
                if (syncKhr != null) {
                    GLES20.glFlush();
                    int status = egl.eglClientWaitSyncKHR(syncKhr, 1, -1L);
                    if (status != 12534) {
                        Log.w((String)TAG, (String)("warning waiting on sync object: " + status));
                    }
                } else {
                    Log.w((String)TAG, (String)"Unable to create EGLSync");
                    GLES20.glFinish();
                }
                syncFenceCompat2 = null;
            } else {
                Log.w((String)TAG, (String)"Device does not support creation of any fences");
                GLES20.glFinish();
                syncFenceCompat2 = null;
            }
            syncFenceCompat = syncFenceCompat2;
            this.frameBufferRendererCallbacks.onDrawComplete(buffer, syncFenceCompat);
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)("Error attempting to render to frame buffer: " + exception.getMessage()));
        }
        finally {
            this.frameBufferRendererCallbacks.onDrawComplete(buffer, syncFenceCompat);
        }
    }

    private final boolean supportsNativeAndroidFence(EGLManager $this$supportsNativeAndroidFence) {
        return $this$supportsNativeAndroidFence.isExtensionSupported("EGL_KHR_fence_sync") && $this$supportsNativeAndroidFence.isExtensionSupported("EGL_ANDROID_native_fence_sync");
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u001a\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\rH&\u00a8\u0006\u000e"}, d2={"Landroidx/graphics/lowlatency/FrameBufferRenderer$RenderCallback;", "", "obtainFrameBuffer", "Landroidx/graphics/lowlatency/FrameBuffer;", "egl", "Landroidx/graphics/opengl/egl/EGLSpec;", "onDraw", "", "eglManager", "Landroidx/graphics/opengl/egl/EGLManager;", "onDrawComplete", "frameBuffer", "syncFenceCompat", "Landroidx/graphics/lowlatency/SyncFenceCompat;", "graphics-core_release"})
    public static interface RenderCallback {
        @SuppressLint(value={"CallbackMethodName"})
        @NotNull
        public FrameBuffer obtainFrameBuffer(@NotNull EGLSpec var1);

        public void onDraw(@NotNull EGLManager var1);

        public void onDrawComplete(@NotNull FrameBuffer var1, @Nullable SyncFenceCompat var2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/graphics/lowlatency/FrameBufferRenderer$Companion;", "", "()V", "TAG", "", "graphics-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

