/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.lowlatency;

import android.hardware.HardwareBuffer;
import android.os.Build;
import android.util.Log;
import android.view.SurfaceView;
import androidx.annotation.RequiresApi;
import androidx.annotation.WorkerThread;
import androidx.graphics.lowlatency.BufferTransformer;
import androidx.graphics.lowlatency.FrameBuffer;
import androidx.graphics.lowlatency.FrameBufferPool;
import androidx.graphics.lowlatency.FrameBufferRenderer;
import androidx.graphics.lowlatency.FrontBufferSyncStrategy;
import androidx.graphics.lowlatency.GLFrontBufferedRenderer;
import androidx.graphics.lowlatency.ParamQueue;
import androidx.graphics.lowlatency.ParentRenderLayer;
import androidx.graphics.lowlatency.SurfaceViewRenderLayer;
import androidx.graphics.lowlatency.SyncFenceCompat;
import androidx.graphics.lowlatency.UsageFlagsVerificationHelper;
import androidx.graphics.opengl.GLRenderer;
import androidx.graphics.opengl.egl.EGLManager;
import androidx.graphics.opengl.egl.EGLSpec;
import androidx.graphics.surface.SurfaceControlCompat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000e*\u0004\u0011\u0014\u00170\b\u0007\u0018\u0000 V*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002UVB)\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0006\u00108\u001a\u000209J\r\u0010:\u001a\u000209H\u0000\u00a2\u0006\u0002\b;J\b\u0010<\u001a\u000209H\u0002J\u0006\u0010=\u001a\u000209J@\u0010>\u001a\u00020!2\u0006\u0010?\u001a\u00020#2\u0006\u0010@\u001a\u00020+2\u0006\u0010A\u001a\u00020+2\u0006\u0010B\u001a\u00020+2\u0006\u0010C\u001a\u00020+2\u0006\u0010D\u001a\u00020+2\u0006\u0010E\u001a\u00020)H\u0002J'\u0010F\u001a\u0002092\u0006\u0010G\u001a\u00020-2\u0010\b\u0002\u0010H\u001a\n\u0012\u0004\u0012\u000209\u0018\u00010IH\u0000\u00a2\u0006\u0002\bJJ\u0006\u0010K\u001a\u00020-J\"\u0010L\u001a\u0002092\u0006\u0010G\u001a\u00020-2\u0010\b\u0002\u0010H\u001a\n\u0012\u0004\u0012\u000209\u0018\u00010IH\u0007J\u0015\u0010M\u001a\u0002092\u0006\u0010N\u001a\u00020\rH\u0000\u00a2\u0006\u0002\bOJ\u0013\u0010P\u001a\u0002092\u0006\u0010Q\u001a\u00028\u0000\u00a2\u0006\u0002\u0010RJ\u001d\u0010S\u001a\u0002092\u0006\u0010@\u001a\u00020+2\u0006\u0010A\u001a\u00020+H\u0000\u00a2\u0006\u0002\bTR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00028\u000000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00101R\u0014\u00102\u001a\b\u0012\u0004\u0012\u00028\u000003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000605X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Landroidx/graphics/lowlatency/GLFrontBufferedRenderer;", "T", "", "surfaceView", "Landroid/view/SurfaceView;", "callback", "Landroidx/graphics/lowlatency/GLFrontBufferedRenderer$Callback;", "glRenderer", "Landroidx/graphics/opengl/GLRenderer;", "(Landroid/view/SurfaceView;Landroidx/graphics/lowlatency/GLFrontBufferedRenderer$Callback;Landroidx/graphics/opengl/GLRenderer;)V", "mActiveSegment", "Landroidx/graphics/lowlatency/ParamQueue;", "mBufferPool", "Landroidx/graphics/lowlatency/FrameBufferPool;", "mBufferTransform", "Landroidx/graphics/lowlatency/BufferTransformer;", "mCallback", "androidx/graphics/lowlatency/GLFrontBufferedRenderer$mCallback$1", "Landroidx/graphics/lowlatency/GLFrontBufferedRenderer$mCallback$1;", "mCommittedListener", "androidx/graphics/lowlatency/GLFrontBufferedRenderer$mCommittedListener$1", "Landroidx/graphics/lowlatency/GLFrontBufferedRenderer$mCommittedListener$1;", "mContextCallbacks", "androidx/graphics/lowlatency/GLFrontBufferedRenderer$mContextCallbacks$1", "Landroidx/graphics/lowlatency/GLFrontBufferedRenderer$mContextCallbacks$1;", "mDoubleBufferedLayerRenderTarget", "Landroidx/graphics/opengl/GLRenderer$RenderTarget;", "mExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "mFrontBufferSyncStrategy", "Landroidx/graphics/lowlatency/FrontBufferSyncStrategy;", "mFrontBufferedLayerRenderer", "Landroidx/graphics/lowlatency/FrameBufferRenderer;", "mFrontBufferedLayerSurfaceControl", "Landroidx/graphics/surface/SurfaceControlCompat;", "mFrontBufferedRenderTarget", "mFrontLayerBuffer", "Landroidx/graphics/lowlatency/FrameBuffer;", "mGLRenderer", "mHardwareBufferUsageFlags", "", "mHeight", "", "mIsManagingGLRenderer", "", "mIsReleased", "mParentLayerCallback", "androidx/graphics/lowlatency/GLFrontBufferedRenderer$mParentLayerCallback$1", "Landroidx/graphics/lowlatency/GLFrontBufferedRenderer$mParentLayerCallback$1;", "mParentRenderLayer", "Landroidx/graphics/lowlatency/ParentRenderLayer;", "mSegments", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "", "mWidth", "clear", "", "clearFrontBuffer", "clearFrontBuffer$graphics_core_release", "clearParamQueues", "commit", "createFrontBufferedLayerRenderer", "frontBufferedLayerSurfaceControl", "width", "height", "bufferWidth", "bufferHeight", "transformHint", "usageFlags", "detachTargets", "cancelPending", "onReleaseComplete", "Lkotlin/Function0;", "detachTargets$graphics_core_release", "isValid", "release", "releaseBuffers", "pool", "releaseBuffers$graphics_core_release", "renderFrontBufferedLayer", "param", "(Ljava/lang/Object;)V", "update", "update$graphics_core_release", "Callback", "Companion", "graphics-core_release"})
@RequiresApi(value=29)
public final class GLFrontBufferedRenderer<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ParentRenderLayer<T> mParentRenderLayer;
    @NotNull
    private final mCallback.1 mCallback;
    private final ExecutorService mExecutor;
    @NotNull
    private final mCommittedListener.1 mCommittedListener;
    @NotNull
    private final mContextCallbacks.1 mContextCallbacks;
    @NotNull
    private final mParentLayerCallback.1 mParentLayerCallback;
    @NotNull
    private final ParamQueue<T> mActiveSegment;
    @NotNull
    private final ConcurrentLinkedQueue<Collection<T>> mSegments;
    @Nullable
    private FrameBuffer mFrontLayerBuffer;
    @Nullable
    private FrameBufferPool mBufferPool;
    @Nullable
    private FrameBufferRenderer mFrontBufferedLayerRenderer;
    @Nullable
    private SurfaceControlCompat mFrontBufferedLayerSurfaceControl;
    @NotNull
    private final FrontBufferSyncStrategy mFrontBufferSyncStrategy;
    private int mWidth;
    private int mHeight;
    @NotNull
    private final GLRenderer mGLRenderer;
    private final boolean mIsManagingGLRenderer;
    @Nullable
    private GLRenderer.RenderTarget mFrontBufferedRenderTarget;
    @Nullable
    private GLRenderer.RenderTarget mDoubleBufferedLayerRenderTarget;
    private boolean mIsReleased;
    private final long mHardwareBufferUsageFlags;
    @NotNull
    private final BufferTransformer mBufferTransform;
    @NotNull
    public static final String TAG = "GLFrontBufferedRenderer";
    private static final long USAGE_COMPOSER_OVERLAY = 2048L;
    public static final long BaseFlags = 2816L;

    @JvmOverloads
    public GLFrontBufferedRenderer(@NotNull SurfaceView surfaceView, @NotNull Callback<T> callback2, @Nullable GLRenderer glRenderer) {
        GLRenderer gLRenderer;
        Intrinsics.checkNotNullParameter((Object)surfaceView, (String)"surfaceView");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        this.mParentRenderLayer = new SurfaceViewRenderLayer(surfaceView);
        this.mCallback = new Callback<T>(callback2, this){
            private final /* synthetic */ Callback<T> $$delegate_0;
            final /* synthetic */ Callback<T> $callback;
            final /* synthetic */ GLFrontBufferedRenderer<T> this$0;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
                this.$$delegate_0 = $callback;
            }

            @WorkerThread
            public void onDrawDoubleBufferedLayer(@NotNull EGLManager eglManager, int bufferWidth, int bufferHeight, @NotNull float[] transform, @NotNull Collection<? extends T> params) {
                Intrinsics.checkNotNullParameter((Object)eglManager, (String)"eglManager");
                Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
                Intrinsics.checkNotNullParameter(params, (String)"params");
                this.$$delegate_0.onDrawDoubleBufferedLayer(eglManager, bufferWidth, bufferHeight, transform, params);
            }

            @WorkerThread
            public void onDrawFrontBufferedLayer(@NotNull EGLManager eglManager, int bufferWidth, int bufferHeight, @NotNull float[] transform, T param) {
                Intrinsics.checkNotNullParameter((Object)eglManager, (String)"eglManager");
                Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
                this.$$delegate_0.onDrawFrontBufferedLayer(eglManager, bufferWidth, bufferHeight, transform, param);
            }

            @WorkerThread
            public void onDoubleBufferedLayerRenderComplete(@NotNull SurfaceControlCompat frontBufferedLayerSurfaceControl, @NotNull SurfaceControlCompat.Transaction transaction2) {
                Intrinsics.checkNotNullParameter((Object)frontBufferedLayerSurfaceControl, (String)"frontBufferedLayerSurfaceControl");
                Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
                if (Build.VERSION.SDK_INT >= 31) {
                    ExecutorService executorService = GLFrontBufferedRenderer.access$getMExecutor$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"mExecutor");
                    transaction2.addTransactionCommittedListener(executorService, GLFrontBufferedRenderer.access$getMCommittedListener$p(this.this$0));
                } else {
                    this.this$0.clearFrontBuffer$graphics_core_release();
                }
                GLFrontBufferedRenderer.access$getMFrontBufferSyncStrategy$p(this.this$0).setVisible(false);
                this.$callback.onDoubleBufferedLayerRenderComplete(frontBufferedLayerSurfaceControl, transaction2);
            }

            @WorkerThread
            public void onFrontBufferedLayerRenderComplete(@NotNull SurfaceControlCompat frontBufferedLayerSurfaceControl, @NotNull SurfaceControlCompat.Transaction transaction2) {
                Intrinsics.checkNotNullParameter((Object)frontBufferedLayerSurfaceControl, (String)"frontBufferedLayerSurfaceControl");
                Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
                GLFrontBufferedRenderer.access$getMFrontBufferSyncStrategy$p(this.this$0).setVisible(true);
                this.$callback.onFrontBufferedLayerRenderComplete(frontBufferedLayerSurfaceControl, transaction2);
            }
        };
        this.mExecutor = Executors.newSingleThreadExecutor();
        this.mCommittedListener = new SurfaceControlCompat.TransactionCommittedListener(this){
            final /* synthetic */ GLFrontBufferedRenderer<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public void onTransactionCommitted() {
                this.this$0.clearFrontBuffer$graphics_core_release();
            }
        };
        this.mContextCallbacks = new GLRenderer.EGLContextCallback(this){
            final /* synthetic */ GLFrontBufferedRenderer<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public void onEGLContextCreated(@NotNull EGLManager eglManager) {
                Intrinsics.checkNotNullParameter((Object)eglManager, (String)"eglManager");
                EGLManager $this$onEGLContextCreated_u24lambda_u240 = eglManager;
                boolean bl = false;
                boolean supportsEglFences = $this$onEGLContextCreated_u24lambda_u240.isExtensionSupported("EGL_KHR_fence_sync");
                boolean supportsAndroidFences = $this$onEGLContextCreated_u24lambda_u240.isExtensionSupported("EGL_ANDROID_native_fence_sync");
                Log.d((String)"GLFrontBufferedRenderer", (String)("Supports KHR_FENCE_SYNC: " + supportsEglFences));
                Log.d((String)"GLFrontBufferedRenderer", (String)("Supports ANDROID_NATIVE_FENCE_SYNC: " + supportsAndroidFences));
            }

            public void onEGLContextDestroyed(@NotNull EGLManager eglManager) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)eglManager, (String)"eglManager");
                    FrameBufferPool frameBufferPool = GLFrontBufferedRenderer.access$getMBufferPool$p(this.this$0);
                    if (frameBufferPool == null) break block0;
                    FrameBufferPool frameBufferPool2 = frameBufferPool;
                    GLFrontBufferedRenderer<T> gLFrontBufferedRenderer = this.this$0;
                    FrameBufferPool it = frameBufferPool2;
                    boolean bl = false;
                    gLFrontBufferedRenderer.releaseBuffers$graphics_core_release(it);
                }
            }
        };
        this.mParentLayerCallback = new ParentRenderLayer.Callback<T>(this){
            final /* synthetic */ GLFrontBufferedRenderer<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSizeChanged(int width, int height) {
                this.this$0.update$graphics_core_release(width, height);
            }

            public void onLayerDestroyed() {
                GLFrontBufferedRenderer.detachTargets$graphics_core_release$default(this.this$0, true, null, 2, null);
            }

            @Nullable
            public Collection<T> obtainDoubleBufferedLayerParams() {
                return (Collection)GLFrontBufferedRenderer.access$getMSegments$p(this.this$0).poll();
            }

            @Nullable
            public SurfaceControlCompat getFrontBufferedLayerSurfaceControl() {
                return GLFrontBufferedRenderer.access$getMFrontBufferedLayerSurfaceControl$p(this.this$0);
            }

            @Nullable
            public FrameBufferPool getFrameBufferPool() {
                return GLFrontBufferedRenderer.access$getMBufferPool$p(this.this$0);
            }
        };
        this.mActiveSegment = new ParamQueue();
        this.mSegments = new ConcurrentLinkedQueue();
        this.mWidth = -1;
        this.mHeight = -1;
        this.mBufferTransform = new BufferTransformer();
        this.mParentRenderLayer.setParentLayerCallbacks(this.mParentLayerCallback);
        if (glRenderer == null) {
            GLRenderer gLRenderer2;
            this.mIsManagingGLRenderer = true;
            GLRenderer $this$_init__u24lambda_u240 = gLRenderer2 = new GLRenderer(null, null, 3, null);
            boolean bl = false;
            GLRenderer.start$default($this$_init__u24lambda_u240, null, 1, null);
            gLRenderer = gLRenderer2;
        } else {
            this.mIsManagingGLRenderer = false;
            gLRenderer = glRenderer;
        }
        GLRenderer renderer = gLRenderer;
        renderer.registerEGLContextCallback(this.mContextCallbacks);
        this.mGLRenderer = renderer;
        this.mHardwareBufferUsageFlags = Companion.obtainHardwareBufferUsageFlags$graphics_core_release();
        this.mFrontBufferSyncStrategy = new FrontBufferSyncStrategy(this.mHardwareBufferUsageFlags);
    }

    public /* synthetic */ GLFrontBufferedRenderer(SurfaceView surfaceView, Callback callback2, GLRenderer gLRenderer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            gLRenderer = null;
        }
        this(surfaceView, callback2, gLRenderer);
    }

    public final void clearFrontBuffer$graphics_core_release() {
        block1: {
            FrameBufferRenderer frameBufferRenderer2 = this.mFrontBufferedLayerRenderer;
            if (frameBufferRenderer2 != null) {
                frameBufferRenderer2.clear();
            }
            GLRenderer.RenderTarget renderTarget2 = this.mFrontBufferedRenderTarget;
            if (renderTarget2 == null) break block1;
            GLRenderer.RenderTarget.requestRender$default(renderTarget2, null, 1, null);
        }
    }

    public final void update$graphics_core_release(int width, int height) {
        if (this.mWidth != width || this.mHeight != height && this.isValid()) {
            SurfaceControlCompat.Builder builder;
            GLRenderer.RenderTarget renderTarget2 = this.mDoubleBufferedLayerRenderTarget;
            if (renderTarget2 != null) {
                GLRenderer.RenderTarget.detach$default(renderTarget2, true, null, 2, null);
            }
            GLRenderer.RenderTarget doubleBufferTarget = this.mParentRenderLayer.createRenderTarget(this.mGLRenderer, this.mCallback);
            SurfaceControlCompat surfaceControlCompat = this.mFrontBufferedLayerSurfaceControl;
            if (surfaceControlCompat != null) {
                surfaceControlCompat.release();
            }
            SurfaceControlCompat.Builder $this$update_u24lambda_u241 = builder = new SurfaceControlCompat.Builder().setName("FrontBufferedSurfaceControl");
            boolean bl = false;
            this.mParentRenderLayer.setParent($this$update_u24lambda_u241);
            SurfaceControlCompat frontBufferedSurfaceControl = builder.build();
            int transformHint = this.mParentRenderLayer.getBufferTransformHint();
            int bufferWidth = 0;
            int bufferHeight = 0;
            switch (transformHint) {
                case 4: 
                case 7: {
                    bufferWidth = height;
                    bufferHeight = width;
                    break;
                }
                default: {
                    bufferWidth = width;
                    bufferHeight = height;
                }
            }
            FrameBufferPool bufferPool = new FrameBufferPool(bufferWidth, bufferHeight, 1, 2816L, 4);
            FrameBufferPool previousBufferPool = this.mBufferPool;
            GLRenderer.RenderTarget renderTarget3 = this.mFrontBufferedRenderTarget;
            if (renderTarget3 != null) {
                renderTarget3.detach(true, (Function1<? super GLRenderer.RenderTarget, Unit>)((Function1)new Function1<GLRenderer.RenderTarget, Unit>(previousBufferPool, this){
                    final /* synthetic */ FrameBufferPool $previousBufferPool;
                    final /* synthetic */ GLFrontBufferedRenderer<T> this$0;
                    {
                        this.$previousBufferPool = $previousBufferPool;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull GLRenderer.RenderTarget it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (this.$previousBufferPool != null) {
                            this.this$0.releaseBuffers$graphics_core_release(this.$previousBufferPool);
                        }
                    }
                }));
            }
            FrameBufferRenderer frontBufferedLayerRenderer = this.createFrontBufferedLayerRenderer(frontBufferedSurfaceControl, width, height, bufferWidth, bufferHeight, transformHint, this.mHardwareBufferUsageFlags);
            this.mFrontBufferedRenderTarget = this.mGLRenderer.createRenderTarget(width, height, frontBufferedLayerRenderer);
            this.mFrontBufferedLayerRenderer = frontBufferedLayerRenderer;
            this.mFrontBufferedLayerSurfaceControl = frontBufferedSurfaceControl;
            this.mDoubleBufferedLayerRenderTarget = doubleBufferTarget;
            this.mBufferPool = bufferPool;
            this.mWidth = width;
            this.mHeight = height;
        }
    }

    public final boolean isValid() {
        return !this.mIsReleased;
    }

    public final void renderFrontBufferedLayer(T param) {
        if (this.isValid()) {
            this.mActiveSegment.add(param);
            GLRenderer.RenderTarget renderTarget2 = this.mFrontBufferedRenderTarget;
            if (renderTarget2 != null) {
                GLRenderer.RenderTarget.requestRender$default(renderTarget2, null, 1, null);
            }
        } else {
            Log.w((String)TAG, (String)"Attempt to render to front buffered layer when GLFrontBufferedRenderer has been released");
        }
    }

    public final void clear() {
        this.clearParamQueues();
        FrameBufferRenderer frameBufferRenderer2 = this.mFrontBufferedLayerRenderer;
        if (frameBufferRenderer2 != null) {
            frameBufferRenderer2.clear();
        }
        this.mParentRenderLayer.clear();
    }

    public final void commit() {
        if (this.isValid()) {
            this.mSegments.add(this.mActiveSegment.release());
            GLRenderer.RenderTarget renderTarget2 = this.mDoubleBufferedLayerRenderTarget;
            if (renderTarget2 != null) {
                GLRenderer.RenderTarget.requestRender$default(renderTarget2, null, 1, null);
            }
        } else {
            Log.w((String)TAG, (String)"Attempt to render to the double buffered layer when GLFrontBufferedRenderer has been released");
        }
    }

    public final void detachTargets$graphics_core_release(boolean cancelPending, @Nullable Function0<Unit> onReleaseComplete) {
        int n;
        Ref.IntRef callbackCount = new Ref.IntRef();
        Ref.IntRef expectedCount = new Ref.IntRef();
        GLRenderer.RenderTarget renderTarget2 = this.mFrontBufferedRenderTarget;
        boolean bl = renderTarget2 != null ? renderTarget2.isAttached() : false;
        if (bl) {
            n = expectedCount.element;
            expectedCount.element = n + 1;
        }
        GLRenderer.RenderTarget renderTarget3 = this.mDoubleBufferedLayerRenderTarget;
        boolean bl2 = renderTarget3 != null ? renderTarget3.isAttached() : false;
        if (bl2) {
            n = expectedCount.element;
            expectedCount.element = n + 1;
        }
        SurfaceControlCompat frontBufferedLayerSurfaceControl = this.mFrontBufferedLayerSurfaceControl;
        Function1 wrappedCallback2 = (Function1)new Function1<GLRenderer.RenderTarget, Unit>(callbackCount, expectedCount, this, frontBufferedLayerSurfaceControl, onReleaseComplete){
            final /* synthetic */ Ref.IntRef $callbackCount;
            final /* synthetic */ Ref.IntRef $expectedCount;
            final /* synthetic */ GLFrontBufferedRenderer<T> this$0;
            final /* synthetic */ SurfaceControlCompat $frontBufferedLayerSurfaceControl;
            final /* synthetic */ Function0<Unit> $onReleaseComplete;
            {
                this.$callbackCount = $callbackCount;
                this.$expectedCount = $expectedCount;
                this.this$0 = $receiver;
                this.$frontBufferedLayerSurfaceControl = $frontBufferedLayerSurfaceControl;
                this.$onReleaseComplete = $onReleaseComplete;
                super(1);
            }

            public final void invoke(@NotNull GLRenderer.RenderTarget it) {
                block3: {
                    Object it2;
                    GLFrontBufferedRenderer<T> gLFrontBufferedRenderer;
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    int n = this.$callbackCount.element;
                    this.$callbackCount.element = n + 1;
                    if (this.$callbackCount.element < this.$expectedCount.element) break block3;
                    FrameBufferPool frameBufferPool = GLFrontBufferedRenderer.access$getMBufferPool$p(this.this$0);
                    if (frameBufferPool != null) {
                        object = frameBufferPool;
                        gLFrontBufferedRenderer = this.this$0;
                        it2 = object;
                        boolean bl = false;
                        gLFrontBufferedRenderer.releaseBuffers$graphics_core_release((FrameBufferPool)it2);
                    }
                    GLFrontBufferedRenderer.access$clearParamQueues(this.this$0);
                    SurfaceControlCompat surfaceControlCompat = this.$frontBufferedLayerSurfaceControl;
                    if (surfaceControlCompat != null) {
                        object = surfaceControlCompat;
                        gLFrontBufferedRenderer = this.this$0;
                        it2 = object;
                        boolean bl = false;
                        SurfaceControlCompat.Transaction transaction2 = new SurfaceControlCompat.Transaction().reparent((SurfaceControlCompat)it2, (SurfaceControlCompat)null);
                        GLFrontBufferedRenderer.access$getMParentRenderLayer$p(gLFrontBufferedRenderer).release(transaction2);
                        transaction2.commit();
                        ((SurfaceControlCompat)it2).release();
                    }
                    Function0<Unit> function0 = this.$onReleaseComplete;
                    if (function0 != null) {
                        function0.invoke();
                    }
                }
            }
        };
        this.mFrontBufferedLayerSurfaceControl = null;
        GLRenderer.RenderTarget renderTarget4 = this.mFrontBufferedRenderTarget;
        if (renderTarget4 != null) {
            renderTarget4.detach(cancelPending, (Function1<? super GLRenderer.RenderTarget, Unit>)wrappedCallback2);
        }
        GLRenderer.RenderTarget renderTarget5 = this.mDoubleBufferedLayerRenderTarget;
        if (renderTarget5 != null) {
            renderTarget5.detach(cancelPending, (Function1<? super GLRenderer.RenderTarget, Unit>)wrappedCallback2);
        }
        this.mFrontBufferedRenderTarget = null;
        this.mDoubleBufferedLayerRenderTarget = null;
        this.mWidth = -1;
        this.mHeight = -1;
    }

    public static /* synthetic */ void detachTargets$graphics_core_release$default(GLFrontBufferedRenderer gLFrontBufferedRenderer, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = null;
        }
        gLFrontBufferedRenderer.detachTargets$graphics_core_release(bl, (Function0<Unit>)function0);
    }

    @JvmOverloads
    public final void release(boolean cancelPending, @Nullable Function0<Unit> onReleaseComplete) {
        if (!this.isValid()) {
            Log.w((String)TAG, (String)"Attempt to release GLFrontbufferedRenderer that is already released");
            return;
        }
        this.detachTargets$graphics_core_release(cancelPending, onReleaseComplete);
        this.mGLRenderer.unregisterEGLContextCallback(this.mContextCallbacks);
        if (this.mIsManagingGLRenderer) {
            GLRenderer.stop$default(this.mGLRenderer, false, null, 2, null);
        }
        this.mExecutor.shutdown();
        this.mIsReleased = true;
    }

    public static /* synthetic */ void release$default(GLFrontBufferedRenderer gLFrontBufferedRenderer, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = null;
        }
        gLFrontBufferedRenderer.release(bl, (Function0<Unit>)function0);
    }

    private final FrameBufferRenderer createFrontBufferedLayerRenderer(SurfaceControlCompat frontBufferedLayerSurfaceControl, int width, int height, int bufferWidth, int bufferHeight, int transformHint, long usageFlags) {
        int inverseTransform = this.mBufferTransform.invertBufferTransform(transformHint);
        this.mBufferTransform.computeTransform(width, height, inverseTransform);
        return new FrameBufferRenderer(new FrameBufferRenderer.RenderCallback(bufferWidth, bufferHeight, this, usageFlags, frontBufferedLayerSurfaceControl, transformHint, inverseTransform){
            final /* synthetic */ int $bufferWidth;
            final /* synthetic */ int $bufferHeight;
            final /* synthetic */ GLFrontBufferedRenderer<T> this$0;
            final /* synthetic */ long $usageFlags;
            final /* synthetic */ SurfaceControlCompat $frontBufferedLayerSurfaceControl;
            final /* synthetic */ int $transformHint;
            final /* synthetic */ int $inverseTransform;
            {
                this.$bufferWidth = $bufferWidth;
                this.$bufferHeight = $bufferHeight;
                this.this$0 = $receiver;
                this.$usageFlags = $usageFlags;
                this.$frontBufferedLayerSurfaceControl = $frontBufferedLayerSurfaceControl;
                this.$transformHint = $transformHint;
                this.$inverseTransform = $inverseTransform;
            }

            private final HardwareBuffer createFrontBufferLayer(long usageFlags) {
                HardwareBuffer hardwareBuffer = HardwareBuffer.create((int)this.$bufferWidth, (int)this.$bufferHeight, (int)1, (int)1, (long)usageFlags);
                Intrinsics.checkNotNullExpressionValue((Object)hardwareBuffer, (String)"create(\n                \u2026ags\n                    )");
                return hardwareBuffer;
            }

            @WorkerThread
            @NotNull
            public FrameBuffer obtainFrameBuffer(@NotNull EGLSpec egl) {
                Intrinsics.checkNotNullParameter((Object)egl, (String)"egl");
                FrameBuffer buffer = GLFrontBufferedRenderer.access$getMFrontLayerBuffer$p(this.this$0);
                if (buffer == null) {
                    FrameBuffer frameBuffer = new FrameBuffer(egl, this.createFrontBufferLayer(this.$usageFlags));
                    GLFrontBufferedRenderer<T> gLFrontBufferedRenderer = this.this$0;
                    FrameBuffer it = frameBuffer;
                    boolean bl = false;
                    GLFrontBufferedRenderer.access$setMFrontLayerBuffer$p(gLFrontBufferedRenderer, it);
                    buffer = frameBuffer;
                }
                return buffer;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @WorkerThread
            public void onDraw(@NotNull EGLManager eglManager) {
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)eglManager, (String)"eglManager");
                ParamQueue paramQueue = GLFrontBufferedRenderer.access$getMActiveSegment$p(this.this$0);
                GLFrontBufferedRenderer<T> gLFrontBufferedRenderer = this.this$0;
                boolean $i$f$next = false;
                Lock lock = ParamQueue.access$getMLock$p((ParamQueue)this_$iv);
                lock.lock();
                try {
                    boolean bl = false;
                    if (ParamQueue.access$getMIndex$p((ParamQueue)this_$iv) < ParamQueue.access$getMParams$p((ParamQueue)this_$iv).size()) {
                        E param$iv;
                        ArrayList arrayList = ParamQueue.access$getMParams$p((ParamQueue)this_$iv);
                        int n = ParamQueue.access$getMIndex$p((ParamQueue)this_$iv);
                        ParamQueue.access$setMIndex$p((ParamQueue)this_$iv, n + 1);
                        E param = param$iv = arrayList.get(n);
                        boolean bl2 = false;
                        GLFrontBufferedRenderer.access$getMCallback$p(gLFrontBufferedRenderer).onDrawFrontBufferedLayer(eglManager, GLFrontBufferedRenderer.access$getMBufferTransform$p(gLFrontBufferedRenderer).getGlWidth(), GLFrontBufferedRenderer.access$getMBufferTransform$p(gLFrontBufferedRenderer).getGlHeight(), GLFrontBufferedRenderer.access$getMBufferTransform$p(gLFrontBufferedRenderer).getTransform(), param);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }

            @WorkerThread
            public void onDrawComplete(@NotNull FrameBuffer frameBuffer, @Nullable SyncFenceCompat syncFenceCompat) {
                Intrinsics.checkNotNullParameter((Object)frameBuffer, (String)"frameBuffer");
                SurfaceControlCompat.Transaction transaction2 = SurfaceControlCompat.Transaction.setBuffer$default(new SurfaceControlCompat.Transaction().setLayer(this.$frontBufferedLayerSurfaceControl, Integer.MAX_VALUE), this.$frontBufferedLayerSurfaceControl, frameBuffer.getHardwareBuffer(), syncFenceCompat, null, 8, null).setVisibility(this.$frontBufferedLayerSurfaceControl, true);
                if (this.$transformHint != -1) {
                    transaction2.setBufferTransform(this.$frontBufferedLayerSurfaceControl, this.$inverseTransform);
                }
                GLFrontBufferedRenderer.access$getMParentRenderLayer$p(this.this$0).buildReparentTransaction(this.$frontBufferedLayerSurfaceControl, transaction2);
                GLFrontBufferedRenderer.access$getMCallback$p(this.this$0).onFrontBufferedLayerRenderComplete(this.$frontBufferedLayerSurfaceControl, transaction2);
                transaction2.commit();
            }
        }, this.mFrontBufferSyncStrategy);
    }

    private final void clearParamQueues() {
        this.mActiveSegment.clear();
        this.mSegments.clear();
    }

    public final void releaseBuffers$graphics_core_release(@NotNull FrameBufferPool pool) {
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        FrameBuffer frameBuffer = this.mFrontLayerBuffer;
        if (frameBuffer != null) {
            frameBuffer.close();
        }
        this.mFrontLayerBuffer = null;
        pool.close();
    }

    @JvmOverloads
    public GLFrontBufferedRenderer(@NotNull SurfaceView surfaceView, @NotNull Callback<T> callback2) {
        Intrinsics.checkNotNullParameter((Object)surfaceView, (String)"surfaceView");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        this(surfaceView, callback2, null, 4, null);
    }

    @JvmOverloads
    public final void release(boolean cancelPending) {
        GLFrontBufferedRenderer.release$default(this, cancelPending, null, 2, null);
    }

    public static final /* synthetic */ FrameBufferPool access$getMBufferPool$p(GLFrontBufferedRenderer $this) {
        return $this.mBufferPool;
    }

    public static final /* synthetic */ void access$clearParamQueues(GLFrontBufferedRenderer $this) {
        $this.clearParamQueues();
    }

    public static final /* synthetic */ ParentRenderLayer access$getMParentRenderLayer$p(GLFrontBufferedRenderer $this) {
        return $this.mParentRenderLayer;
    }

    public static final /* synthetic */ FrameBuffer access$getMFrontLayerBuffer$p(GLFrontBufferedRenderer $this) {
        return $this.mFrontLayerBuffer;
    }

    public static final /* synthetic */ ParamQueue access$getMActiveSegment$p(GLFrontBufferedRenderer $this) {
        return $this.mActiveSegment;
    }

    public static final /* synthetic */ mCallback.1 access$getMCallback$p(GLFrontBufferedRenderer $this) {
        return $this.mCallback;
    }

    public static final /* synthetic */ void access$setMFrontLayerBuffer$p(GLFrontBufferedRenderer $this, FrameBuffer frameBuffer) {
        $this.mFrontLayerBuffer = frameBuffer;
    }

    public static final /* synthetic */ BufferTransformer access$getMBufferTransform$p(GLFrontBufferedRenderer $this) {
        return $this.mBufferTransform;
    }

    public static final /* synthetic */ ExecutorService access$getMExecutor$p(GLFrontBufferedRenderer $this) {
        return $this.mExecutor;
    }

    public static final /* synthetic */ mCommittedListener.1 access$getMCommittedListener$p(GLFrontBufferedRenderer $this) {
        return $this.mCommittedListener;
    }

    public static final /* synthetic */ FrontBufferSyncStrategy access$getMFrontBufferSyncStrategy$p(GLFrontBufferedRenderer $this) {
        return $this.mFrontBufferSyncStrategy;
    }

    public static final /* synthetic */ ConcurrentLinkedQueue access$getMSegments$p(GLFrontBufferedRenderer $this) {
        return $this.mSegments;
    }

    public static final /* synthetic */ SurfaceControlCompat access$getMFrontBufferedLayerSurfaceControl$p(GLFrontBufferedRenderer $this) {
        return $this.mFrontBufferedLayerSurfaceControl;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/graphics/lowlatency/GLFrontBufferedRenderer$Companion;", "", "()V", "BaseFlags", "", "TAG", "", "USAGE_COMPOSER_OVERLAY", "obtainHardwareBufferUsageFlags", "obtainHardwareBufferUsageFlags$graphics_core_release", "graphics-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long obtainHardwareBufferUsageFlags$graphics_core_release() {
            return Build.VERSION.SDK_INT >= 33 ? UsageFlagsVerificationHelper.Companion.obtainUsageFlagsV33() : 2816L;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J6\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u0012H'J5\u0010\u0013\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00028\u0001H'\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\u0017"}, d2={"Landroidx/graphics/lowlatency/GLFrontBufferedRenderer$Callback;", "T", "", "onDoubleBufferedLayerRenderComplete", "", "frontBufferedLayerSurfaceControl", "Landroidx/graphics/surface/SurfaceControlCompat;", "transaction", "Landroidx/graphics/surface/SurfaceControlCompat$Transaction;", "onDrawDoubleBufferedLayer", "eglManager", "Landroidx/graphics/opengl/egl/EGLManager;", "bufferWidth", "", "bufferHeight", "transform", "", "params", "", "onDrawFrontBufferedLayer", "param", "(Landroidx/graphics/opengl/egl/EGLManager;II[FLjava/lang/Object;)V", "onFrontBufferedLayerRenderComplete", "graphics-core_release"})
    public static interface Callback<T> {
        @WorkerThread
        public void onDrawFrontBufferedLayer(@NotNull EGLManager var1, int var2, int var3, @NotNull float[] var4, T var5);

        @WorkerThread
        public void onDrawDoubleBufferedLayer(@NotNull EGLManager var1, int var2, int var3, @NotNull float[] var4, @NotNull Collection<? extends T> var5);

        @WorkerThread
        public void onFrontBufferedLayerRenderComplete(@NotNull SurfaceControlCompat var1, @NotNull SurfaceControlCompat.Transaction var2);

        @WorkerThread
        public void onDoubleBufferedLayerRenderComplete(@NotNull SurfaceControlCompat var1, @NotNull SurfaceControlCompat.Transaction var2);

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            @WorkerThread
            public static <T> void onFrontBufferedLayerRenderComplete(@NotNull Callback<T> $this, @NotNull SurfaceControlCompat frontBufferedLayerSurfaceControl, @NotNull SurfaceControlCompat.Transaction transaction2) {
                Intrinsics.checkNotNullParameter((Object)frontBufferedLayerSurfaceControl, (String)"frontBufferedLayerSurfaceControl");
                Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
            }

            @WorkerThread
            public static <T> void onDoubleBufferedLayerRenderComplete(@NotNull Callback<T> $this, @NotNull SurfaceControlCompat frontBufferedLayerSurfaceControl, @NotNull SurfaceControlCompat.Transaction transaction2) {
                Intrinsics.checkNotNullParameter((Object)frontBufferedLayerSurfaceControl, (String)"frontBufferedLayerSurfaceControl");
                Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
            }
        }
    }
}

