/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.lowlatency;

import android.annotation.SuppressLint;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import androidx.annotation.RequiresApi;
import androidx.graphics.lowlatency.BufferTransformHintResolver;
import androidx.graphics.lowlatency.BufferTransformer;
import androidx.graphics.lowlatency.FrameBuffer;
import androidx.graphics.lowlatency.FrameBufferPool;
import androidx.graphics.lowlatency.FrameBufferRenderer;
import androidx.graphics.lowlatency.GLFrontBufferedRenderer;
import androidx.graphics.lowlatency.ParentRenderLayer;
import androidx.graphics.lowlatency.SyncFenceCompat;
import androidx.graphics.lowlatency.WrapperFrameBufferRenderer;
import androidx.graphics.opengl.GLRenderer;
import androidx.graphics.opengl.egl.EGLManager;
import androidx.graphics.opengl.egl.EGLSpec;
import androidx.graphics.surface.SurfaceControlCompat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 )*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001)B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\r\u0010\u001b\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u001cJ\u001e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0017J\b\u0010\"\u001a\u00020\u0007H\u0016J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u00162\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Landroidx/graphics/lowlatency/SurfaceViewRenderLayer;", "T", "Landroidx/graphics/lowlatency/ParentRenderLayer;", "surfaceView", "Landroid/view/SurfaceView;", "(Landroid/view/SurfaceView;)V", "inverse", "", "mBufferTransform", "Landroidx/graphics/lowlatency/BufferTransformer;", "mFrameBufferRenderer", "Landroidx/graphics/lowlatency/FrameBufferRenderer;", "mLayerCallback", "Landroidx/graphics/lowlatency/ParentRenderLayer$Callback;", "mParentSurfaceControl", "Landroidx/graphics/surface/SurfaceControlCompat;", "mRenderTarget", "Landroidx/graphics/opengl/GLRenderer$RenderTarget;", "mTransformResolver", "Landroidx/graphics/lowlatency/BufferTransformHintResolver;", "transformHint", "buildReparentTransaction", "", "child", "transaction", "Landroidx/graphics/surface/SurfaceControlCompat$Transaction;", "clear", "createDoubleBufferedSurfaceControl", "createDoubleBufferedSurfaceControl$graphics_core_release", "createRenderTarget", "renderer", "Landroidx/graphics/opengl/GLRenderer;", "renderLayerCallback", "Landroidx/graphics/lowlatency/GLFrontBufferedRenderer$Callback;", "getBufferTransformHint", "release", "setParent", "builder", "Landroidx/graphics/surface/SurfaceControlCompat$Builder;", "setParentLayerCallbacks", "callback", "Companion", "graphics-core_release"})
@RequiresApi(value=29)
public final class SurfaceViewRenderLayer<T>
implements ParentRenderLayer<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SurfaceView surfaceView;
    @Nullable
    private ParentRenderLayer.Callback<T> mLayerCallback;
    @Nullable
    private FrameBufferRenderer mFrameBufferRenderer;
    @Nullable
    private GLRenderer.RenderTarget mRenderTarget;
    @Nullable
    private SurfaceControlCompat mParentSurfaceControl;
    @NotNull
    private final BufferTransformer mBufferTransform;
    @NotNull
    private final BufferTransformHintResolver mTransformResolver;
    private int transformHint;
    private int inverse;
    @NotNull
    public static final String TAG = "SurfaceViewRenderLayer";

    public SurfaceViewRenderLayer(@NotNull SurfaceView surfaceView) {
        Intrinsics.checkNotNullParameter((Object)surfaceView, (String)"surfaceView");
        this.surfaceView = surfaceView;
        this.mBufferTransform = new BufferTransformer();
        this.mTransformResolver = new BufferTransformHintResolver();
        this.transformHint = -1;
        this.inverse = -1;
        this.surfaceView.getHolder().addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(@NotNull SurfaceHolder holder) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            }

            public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int width, int height) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                transformHint = this.getBufferTransformHint();
                inverse = mBufferTransform.invertBufferTransform(transformHint);
                mBufferTransform.computeTransform(width, height, inverse);
                SurfaceControlCompat surfaceControlCompat = mParentSurfaceControl;
                if (surfaceControlCompat != null) {
                    surfaceControlCompat.release();
                }
                ParentRenderLayer.Callback callback2 = mLayerCallback;
                if (callback2 != null) {
                    callback2.onSizeChanged(width, height);
                }
                mParentSurfaceControl = this.createDoubleBufferedSurfaceControl$graphics_core_release();
            }

            public void surfaceDestroyed(@NotNull SurfaceHolder p0) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ParentRenderLayer.Callback callback2 = mLayerCallback;
                    if (callback2 == null) break block0;
                    callback2.onLayerDestroyed();
                }
            }
        });
    }

    @Override
    public int getBufferTransformHint() {
        return this.mTransformResolver.getBufferTransformHint((View)this.surfaceView);
    }

    @Override
    public void buildReparentTransaction(@NotNull SurfaceControlCompat child, @NotNull SurfaceControlCompat.Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        transaction2.reparent(child, this.mParentSurfaceControl);
    }

    @Override
    public void setParent(@NotNull SurfaceControlCompat.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.setParent(this.surfaceView);
    }

    @Override
    @RequiresApi(value=33)
    @NotNull
    public GLRenderer.RenderTarget createRenderTarget(@NotNull GLRenderer renderer, @NotNull GLFrontBufferedRenderer.Callback<T> renderLayerCallback) {
        GLRenderer.RenderTarget renderTarget2;
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter(renderLayerCallback, (String)"renderLayerCallback");
        Ref.ObjectRef params = new Ref.ObjectRef();
        FrameBufferRenderer frameBufferRenderer2 = new FrameBufferRenderer(new FrameBufferRenderer.RenderCallback(this, renderLayerCallback, params){
            final /* synthetic */ SurfaceViewRenderLayer<T> this$0;
            final /* synthetic */ GLFrontBufferedRenderer.Callback<T> $renderLayerCallback;
            final /* synthetic */ Ref.ObjectRef<Collection<T>> $params;
            {
                this.this$0 = $receiver;
                this.$renderLayerCallback = $renderLayerCallback;
                this.$params = $params;
            }

            @NotNull
            public FrameBuffer obtainFrameBuffer(@NotNull EGLSpec egl) {
                Intrinsics.checkNotNullParameter((Object)egl, (String)"egl");
                Object object = SurfaceViewRenderLayer.access$getMLayerCallback$p(this.this$0);
                if (object == null || (object = object.getFrameBufferPool()) == null || (object = ((FrameBufferPool)object).obtain(egl)) == null) {
                    throw new IllegalArgumentException("No FrameBufferPool available");
                }
                return object;
            }

            public void onDraw(@NotNull EGLManager eglManager) {
                Intrinsics.checkNotNullParameter((Object)eglManager, (String)"eglManager");
                int n = SurfaceViewRenderLayer.access$getMBufferTransform$p(this.this$0).getGlWidth();
                int n2 = SurfaceViewRenderLayer.access$getMBufferTransform$p(this.this$0).getGlHeight();
                float[] fArray = SurfaceViewRenderLayer.access$getMBufferTransform$p(this.this$0).getTransform();
                Collection collection = (Collection)this.$params.element;
                if (collection == null) {
                    List<T> list = Collections.emptyList();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList()");
                    collection = list;
                }
                this.$renderLayerCallback.onDrawDoubleBufferedLayer(eglManager, n, n2, fArray, collection);
            }

            @SuppressLint(value={"WrongConstant"})
            @RequiresApi(value=33)
            public void onDrawComplete(@NotNull FrameBuffer frameBuffer, @Nullable SyncFenceCompat syncFenceCompat) {
                SurfaceControlCompat sc;
                Intrinsics.checkNotNullParameter((Object)frameBuffer, (String)"frameBuffer");
                ParentRenderLayer.Callback callback2 = SurfaceViewRenderLayer.access$getMLayerCallback$p(this.this$0);
                SurfaceControlCompat frontBufferedLayerSurfaceControl = callback2 != null ? callback2.getFrontBufferedLayerSurfaceControl() : null;
                SurfaceControlCompat surfaceControlCompat = SurfaceViewRenderLayer.access$getMParentSurfaceControl$p(this.this$0);
                if (surfaceControlCompat == null) {
                    SurfaceControlCompat surfaceControlCompat2 = this.this$0.createDoubleBufferedSurfaceControl$graphics_core_release();
                    SurfaceViewRenderLayer<T> surfaceViewRenderLayer = this.this$0;
                    SurfaceControlCompat it = surfaceControlCompat2;
                    boolean bl = false;
                    SurfaceViewRenderLayer.access$setMParentSurfaceControl$p(surfaceViewRenderLayer, it);
                    surfaceControlCompat = sc = surfaceControlCompat2;
                }
                if (frontBufferedLayerSurfaceControl != null) {
                    SurfaceControlCompat.Transaction transaction2 = new SurfaceControlCompat.Transaction().setVisibility(frontBufferedLayerSurfaceControl, false).setVisibility(sc, true).setBuffer(sc, frameBuffer.getHardwareBuffer(), syncFenceCompat, (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, frameBuffer){
                        final /* synthetic */ SurfaceViewRenderLayer<T> this$0;
                        final /* synthetic */ FrameBuffer $frameBuffer;
                        {
                            this.this$0 = $receiver;
                            this.$frameBuffer = $frameBuffer;
                            super(0);
                        }

                        public final void invoke() {
                            block0: {
                                Object object = SurfaceViewRenderLayer.access$getMLayerCallback$p(this.this$0);
                                if (object == null || (object = object.getFrameBufferPool()) == null) break block0;
                                ((FrameBufferPool)object).release(this.$frameBuffer);
                            }
                        }
                    }));
                    if (SurfaceViewRenderLayer.access$getTransformHint$p(this.this$0) != -1) {
                        transaction2.setBufferTransform(sc, SurfaceViewRenderLayer.access$getInverse$p(this.this$0));
                    }
                    this.$renderLayerCallback.onDoubleBufferedLayerRenderComplete(frontBufferedLayerSurfaceControl, transaction2);
                    transaction2.commit();
                } else {
                    Log.e((String)"SurfaceViewRenderLayer", (String)"Error, no front buffered SurfaceControl available to synchronize transaction with");
                }
            }
        }, null, 2, null);
        WrapperFrameBufferRenderer parentFrameBufferRenderer2 = new WrapperFrameBufferRenderer(frameBufferRenderer2, (Function0<Boolean>)((Function0)new Function0<Boolean>(params, this){
            final /* synthetic */ Ref.ObjectRef<Collection<T>> $params;
            final /* synthetic */ SurfaceViewRenderLayer<T> this$0;
            {
                this.$params = $params;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                ParentRenderLayer.Callback callback2 = SurfaceViewRenderLayer.access$getMLayerCallback$p(this.this$0);
                this.$params.element = callback2 != null ? callback2.obtainDoubleBufferedLayerParams() : null;
                return this.$params.element != null;
            }
        }));
        this.mRenderTarget = renderTarget2 = renderer.attach(this.surfaceView, (GLRenderer.RenderCallback)parentFrameBufferRenderer2);
        this.mFrameBufferRenderer = frameBufferRenderer2;
        return renderTarget2;
    }

    @NotNull
    public final SurfaceControlCompat createDoubleBufferedSurfaceControl$graphics_core_release() {
        SurfaceControlCompat surfaceControl = new SurfaceControlCompat.Builder().setParent(this.surfaceView).setName("DoubleBufferedLayer").build();
        new SurfaceControlCompat.Transaction().setVisibility(surfaceControl, true).commit();
        return surfaceControl;
    }

    @Override
    public void setParentLayerCallbacks(@Nullable ParentRenderLayer.Callback<T> callback2) {
        this.mLayerCallback = callback2;
    }

    @Override
    public void clear() {
        block1: {
            FrameBufferRenderer frameBufferRenderer2 = this.mFrameBufferRenderer;
            if (frameBufferRenderer2 != null) {
                frameBufferRenderer2.clear();
            }
            GLRenderer.RenderTarget renderTarget2 = this.mRenderTarget;
            if (renderTarget2 == null) break block1;
            GLRenderer.RenderTarget.requestRender$default(renderTarget2, null, 1, null);
        }
    }

    @Override
    @RequiresApi(value=33)
    public void release(@NotNull SurfaceControlCompat.Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        SurfaceControlCompat surfaceControlCompat = this.mParentSurfaceControl;
        if (surfaceControlCompat != null) {
            SurfaceControlCompat it = surfaceControlCompat;
            boolean bl = false;
            transaction2.reparent(it, (SurfaceControlCompat)null);
            it.release();
        }
        this.mParentSurfaceControl = null;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/graphics/lowlatency/SurfaceViewRenderLayer$Companion;", "", "()V", "TAG", "", "graphics-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

