/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.lowlatency;

import android.opengl.GLES20;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.graphics.lowlatency.SyncFenceCompatVerificationHelper;
import androidx.graphics.lowlatency.SyncFenceImpl;
import androidx.graphics.lowlatency.SyncFenceV19;
import androidx.graphics.lowlatency.SyncFenceV33;
import androidx.graphics.opengl.egl.EGLSpec;
import androidx.hardware.SyncFence;
import androidx.opengl.EGLSyncKHR;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0007J\u0006\u0010\u0013\u001a\u00020\fR\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Landroidx/graphics/lowlatency/SyncFenceCompat;", "Ljava/lang/AutoCloseable;", "syncFence", "Landroidx/hardware/SyncFence;", "(Landroidx/hardware/SyncFence;)V", "Landroid/hardware/SyncFence;", "(Landroid/hardware/SyncFence;)V", "mImpl", "Landroidx/graphics/lowlatency/SyncFenceImpl;", "getMImpl$graphics_core_release", "()Landroidx/graphics/lowlatency/SyncFenceImpl;", "await", "", "timeoutNanos", "", "awaitForever", "close", "", "getSignalTimeNanos", "isValid", "Companion", "graphics-core_release"})
@RequiresApi(value=19)
public final class SyncFenceCompat
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SyncFenceImpl mImpl;
    public static final long SIGNAL_TIME_INVALID = -1L;
    public static final long SIGNAL_TIME_PENDING = Long.MAX_VALUE;

    @NotNull
    public final SyncFenceImpl getMImpl$graphics_core_release() {
        return this.mImpl;
    }

    public SyncFenceCompat(@NotNull SyncFence syncFence) {
        Intrinsics.checkNotNullParameter((Object)syncFence, (String)"syncFence");
        this.mImpl = new SyncFenceV19(syncFence);
    }

    @RequiresApi(value=33)
    public SyncFenceCompat(@NotNull android.hardware.SyncFence syncFence) {
        Intrinsics.checkNotNullParameter((Object)syncFence, (String)"syncFence");
        this.mImpl = new SyncFenceV33(syncFence);
    }

    public final boolean await(long timeoutNanos) {
        return this.mImpl.await(timeoutNanos);
    }

    public final boolean awaitForever() {
        return this.mImpl.awaitForever();
    }

    @Override
    public void close() {
        this.mImpl.close();
    }

    @RequiresApi(value=26)
    public final long getSignalTimeNanos() {
        return this.mImpl.getSignalTimeNanos();
    }

    public final boolean isValid() {
        return this.mImpl.isValid();
    }

    @JvmStatic
    @NotNull
    public static final SyncFenceCompat createNativeSyncFence(@NotNull EGLSpec egl) {
        return Companion.createNativeSyncFence(egl);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/graphics/lowlatency/SyncFenceCompat$Companion;", "", "()V", "SIGNAL_TIME_INVALID", "", "SIGNAL_TIME_PENDING", "createNativeSyncFence", "Landroidx/graphics/lowlatency/SyncFenceCompat;", "egl", "Landroidx/graphics/opengl/egl/EGLSpec;", "graphics-core_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final SyncFenceCompat createNativeSyncFence(@NotNull EGLSpec egl) {
            SyncFenceCompat syncFenceCompat;
            Intrinsics.checkNotNullParameter((Object)egl, (String)"egl");
            if (Build.VERSION.SDK_INT >= 33) {
                syncFenceCompat = SyncFenceCompatVerificationHelper.Companion.createSyncFenceCompatV33();
            } else {
                void var3_3;
                EGLSyncKHR eGLSyncKHR = egl.eglCreateSyncKHR(12612, null);
                if (eGLSyncKHR == null) {
                    throw new IllegalArgumentException("Unable to create sync object");
                }
                EGLSyncKHR eglSync = eGLSyncKHR;
                GLES20.glFlush();
                SyncFenceCompat syncFenceCompat2 = new SyncFenceCompat(egl.eglDupNativeFenceFDANDROID(eglSync));
                egl.eglDestroySyncKHR(eglSync);
                syncFenceCompat = var3_3;
            }
            return syncFenceCompat;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

