/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.opengl.egl;

import android.hardware.HardwareBuffer;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import androidx.graphics.opengl.egl.EGLConfigAttributes;
import androidx.graphics.opengl.egl.EGLException;
import androidx.graphics.opengl.egl.EGLSpec;
import androidx.graphics.opengl.egl.EGLVersion;
import androidx.hardware.SyncFence;
import androidx.opengl.EGLExt;
import androidx.opengl.EGLImageKHR;
import androidx.opengl.EGLSyncKHR;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\bf\u0018\u0000 <2\u00020\u0001:\u0001<J%\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H'J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H&J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0015H&J\"\u0010\u0019\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H&J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000bH&J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000fH&J\u0010\u0010\"\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u0013H&J\u0010\u0010#\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0005\u001a\u00020\u0006H'J\b\u0010&\u001a\u00020\u0013H&J\b\u0010'\u001a\u00020\u0013H&J\b\u0010(\u001a\u00020\u0003H&J*\u0010)\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0003H&J\b\u0010.\u001a\u00020/H&J \u00100\u001a\u00020 2\u0006\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u00132\u0006\u00103\u001a\u00020\u0013H&J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u0003H&J(\u00107\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u00032\u0006\u00108\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0003H&J\u0010\u00109\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u0013H&J\b\u0010:\u001a\u000205H\u0016J\u0012\u0010;\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u0015H&\u00a8\u0006="}, d2={"Landroidx/graphics/opengl/egl/EGLSpec;", "", "eglClientWaitSyncKHR", "", "Landroidx/opengl/EGLExt$Companion$EGLClientWaitResult;", "sync", "Landroidx/opengl/EGLSyncKHR;", "flags", "timeoutNanos", "", "eglCreateContext", "Landroid/opengl/EGLContext;", "config", "Landroid/opengl/EGLConfig;", "eglCreateImageFromHardwareBuffer", "Landroidx/opengl/EGLImageKHR;", "hardwareBuffer", "Landroid/hardware/HardwareBuffer;", "eglCreatePBufferSurface", "Landroid/opengl/EGLSurface;", "configAttributes", "Landroidx/graphics/opengl/egl/EGLConfigAttributes;", "eglCreateSyncKHR", "type", "attributes", "eglCreateWindowSurface", "surface", "Landroid/view/Surface;", "eglDestroyContext", "", "eglContext", "eglDestroyImageKHR", "", "image", "eglDestroySurface", "eglDestroySyncKHR", "eglDupNativeFenceFDANDROID", "Landroidx/hardware/SyncFence;", "eglGetCurrentDrawSurface", "eglGetCurrentReadSurface", "eglGetError", "eglGetSyncAttribKHR", "attribute", "value", "", "offset", "eglInitialize", "Landroidx/graphics/opengl/egl/EGLVersion;", "eglMakeCurrent", "context", "drawSurface", "readSurface", "eglQueryString", "", "nameId", "eglQuerySurface", "result", "eglSwapBuffers", "getErrorMessage", "loadConfig", "Companion", "graphics-core_release"})
public interface EGLSpec {
    @NotNull
    public static final Companion Companion = androidx.graphics.opengl.egl.EGLSpec$Companion.$$INSTANCE;
    @JvmField
    @NotNull
    public static final EGLSpec V14 = new EGLSpec(){
        @NotNull
        private final int[] contextAttributes;
        @NotNull
        private final EGLConfigAttributes DefaultWindowSurfaceConfig;
        {
            EGLConfigAttributes.Builder builder;
            int[] nArray = new int[]{12440, 2, 12344};
            this.contextAttributes = nArray;
            boolean $i$f$EGLConfigAttributes = false;
            EGLConfigAttributes.Builder $this$EGLConfigAttributes_u24lambda_u240$iv = builder = new EGLConfigAttributes.Builder();
            boolean bl = false;
            EGLConfigAttributes.Builder builder2 = $this$EGLConfigAttributes_u24lambda_u240$iv;
            Companion.V14.1 var7_7 = this;
            boolean bl2 = false;
            var7_7.DefaultWindowSurfaceConfig = builder.build();
        }

        @NotNull
        public EGLVersion eglInitialize() {
            int[] nArray = new int[]{1};
            int[] major = nArray;
            int[] nArray2 = new int[]{1};
            int[] minor = nArray2;
            boolean initializeResult = EGL14.eglInitialize((EGLDisplay)this.getDefaultDisplay(), (int[])major, (int)0, (int[])minor, (int)0);
            if (initializeResult) {
                return new EGLVersion(major[0], minor[0]);
            }
            throw new EGLException(EGL14.eglGetError(), "Unable to initialize default display");
        }

        @NotNull
        public EGLSurface eglGetCurrentReadSurface() {
            EGLSurface eGLSurface = EGL14.eglGetCurrentSurface((int)12378);
            Intrinsics.checkNotNullExpressionValue((Object)eGLSurface, (String)"eglGetCurrentSurface(EGL14.EGL_READ)");
            return eGLSurface;
        }

        @NotNull
        public EGLSurface eglGetCurrentDrawSurface() {
            EGLSurface eGLSurface = EGL14.eglGetCurrentSurface((int)12377);
            Intrinsics.checkNotNullExpressionValue((Object)eGLSurface, (String)"eglGetCurrentSurface(EGL14.EGL_DRAW)");
            return eGLSurface;
        }

        @NotNull
        public String eglQueryString(int nameId) {
            String string = EGL14.eglQueryString((EGLDisplay)this.getDefaultDisplay(), (int)nameId);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"eglQueryString(getDefaultDisplay(), nameId)");
            return string;
        }

        @NotNull
        public EGLSurface eglCreatePBufferSurface(@NotNull EGLConfig config, @Nullable EGLConfigAttributes configAttributes) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            EGLConfigAttributes eGLConfigAttributes = configAttributes;
            EGLSurface eGLSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.getDefaultDisplay(), (EGLConfig)config, (int[])((int[])(eGLConfigAttributes != null ? eGLConfigAttributes.getAttrs() : null)), (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)eGLSurface, (String)"eglCreatePbufferSurface(\u2026      0\n                )");
            return eGLSurface;
        }

        @NotNull
        public EGLSurface eglCreateWindowSurface(@NotNull EGLConfig config, @NotNull Surface surface, @Nullable EGLConfigAttributes configAttributes) {
            Object object;
            EGLDisplay eGLDisplay;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                    Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
                    eGLDisplay = this.getDefaultDisplay();
                    object = configAttributes;
                    if (object == null) break block2;
                    int[] nArray = ((EGLConfigAttributes)object).getAttrs();
                    object = nArray;
                    if (nArray != null) break block3;
                }
                object = this.DefaultWindowSurfaceConfig.getAttrs();
            }
            EGLSurface eGLSurface = EGL14.eglCreateWindowSurface((EGLDisplay)eGLDisplay, (EGLConfig)config, (Object)surface, (int[])object, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)eGLSurface, (String)"eglCreateWindowSurface(\n\u2026      0\n                )");
            return eGLSurface;
        }

        public boolean eglSwapBuffers(@NotNull EGLSurface surface) {
            Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
            return EGL14.eglSwapBuffers((EGLDisplay)this.getDefaultDisplay(), (EGLSurface)surface);
        }

        public boolean eglQuerySurface(@NotNull EGLSurface surface, int attribute, @NotNull int[] result, int offset) {
            Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            return EGL14.eglQuerySurface((EGLDisplay)this.getDefaultDisplay(), (EGLSurface)surface, (int)attribute, (int[])result, (int)offset);
        }

        public boolean eglDestroySurface(@NotNull EGLSurface surface) {
            Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
            return EGL14.eglDestroySurface((EGLDisplay)this.getDefaultDisplay(), (EGLSurface)surface);
        }

        public boolean eglMakeCurrent(@NotNull EGLContext context, @NotNull EGLSurface drawSurface, @NotNull EGLSurface readSurface) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)drawSurface, (String)"drawSurface");
            Intrinsics.checkNotNullParameter((Object)readSurface, (String)"readSurface");
            return EGL14.eglMakeCurrent((EGLDisplay)this.getDefaultDisplay(), (EGLSurface)drawSurface, (EGLSurface)readSurface, (EGLContext)context);
        }

        @Nullable
        public EGLConfig loadConfig(@NotNull EGLConfigAttributes configAttributes) {
            Intrinsics.checkNotNullParameter((Object)configAttributes, (String)"configAttributes");
            EGLConfig[] configs = new EGLConfig[1];
            int[] nArray = new int[]{1};
            return EGL14.eglChooseConfig((EGLDisplay)this.getDefaultDisplay(), (int[])configAttributes.getAttrs(), (int)0, (EGLConfig[])configs, (int)0, (int)1, (int[])nArray, (int)0) ? configs[0] : (EGLConfig)null;
        }

        @NotNull
        public EGLContext eglCreateContext(@NotNull EGLConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            EGLContext eGLContext = EGL14.eglCreateContext((EGLDisplay)this.getDefaultDisplay(), (EGLConfig)config, (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])this.contextAttributes, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)eGLContext, (String)"eglCreateContext(\n      \u2026      0\n                )");
            return eGLContext;
        }

        public void eglDestroyContext(@NotNull EGLContext eglContext) {
            Intrinsics.checkNotNullParameter((Object)eglContext, (String)"eglContext");
            if (!EGL14.eglDestroyContext((EGLDisplay)this.getDefaultDisplay(), (EGLContext)eglContext)) {
                throw new EGLException(EGL14.eglGetError(), "Unable to destroy EGLContext");
            }
        }

        @RequiresApi(value=29)
        @Nullable
        public EGLImageKHR eglCreateImageFromHardwareBuffer(@NotNull HardwareBuffer hardwareBuffer) {
            Intrinsics.checkNotNullParameter((Object)hardwareBuffer, (String)"hardwareBuffer");
            EGLDisplay eGLDisplay = this.getDefaultDisplay();
            Intrinsics.checkNotNullExpressionValue((Object)eGLDisplay, (String)"getDefaultDisplay()");
            return EGLExt.Companion.eglCreateImageFromHardwareBuffer(eGLDisplay, hardwareBuffer);
        }

        public boolean eglDestroyImageKHR(@NotNull EGLImageKHR image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            EGLDisplay eGLDisplay = this.getDefaultDisplay();
            Intrinsics.checkNotNullExpressionValue((Object)eGLDisplay, (String)"getDefaultDisplay()");
            return EGLExt.Companion.eglDestroyImageKHR(eGLDisplay, image);
        }

        @Nullable
        public EGLSyncKHR eglCreateSyncKHR(int type, @Nullable EGLConfigAttributes attributes) {
            EGLDisplay eGLDisplay = this.getDefaultDisplay();
            Intrinsics.checkNotNullExpressionValue((Object)eGLDisplay, (String)"getDefaultDisplay()");
            return EGLExt.Companion.eglCreateSyncKHR(eGLDisplay, type, attributes);
        }

        public boolean eglGetSyncAttribKHR(@NotNull EGLSyncKHR sync, int attribute, @NotNull int[] value, int offset) {
            Intrinsics.checkNotNullParameter((Object)sync, (String)"sync");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            EGLDisplay eGLDisplay = this.getDefaultDisplay();
            Intrinsics.checkNotNullExpressionValue((Object)eGLDisplay, (String)"getDefaultDisplay()");
            return EGLExt.Companion.eglGetSyncAttribKHR(eGLDisplay, sync, attribute, value, offset);
        }

        public boolean eglDestroySyncKHR(@NotNull EGLSyncKHR sync) {
            Intrinsics.checkNotNullParameter((Object)sync, (String)"sync");
            EGLDisplay eGLDisplay = this.getDefaultDisplay();
            Intrinsics.checkNotNullExpressionValue((Object)eGLDisplay, (String)"getDefaultDisplay()");
            return EGLExt.Companion.eglDestroySyncKHR(eGLDisplay, sync);
        }

        public int eglGetError() {
            return EGL14.eglGetError();
        }

        @RequiresApi(value=19)
        @NotNull
        public SyncFence eglDupNativeFenceFDANDROID(@NotNull EGLSyncKHR sync) {
            Intrinsics.checkNotNullParameter((Object)sync, (String)"sync");
            EGLDisplay eGLDisplay = this.getDefaultDisplay();
            Intrinsics.checkNotNullExpressionValue((Object)eGLDisplay, (String)"getDefaultDisplay()");
            return EGLExt.Companion.eglDupNativeFenceFDANDROID(eGLDisplay, sync);
        }

        public int eglClientWaitSyncKHR(@NotNull EGLSyncKHR sync, int flags, long timeoutNanos) {
            Intrinsics.checkNotNullParameter((Object)sync, (String)"sync");
            EGLDisplay eGLDisplay = this.getDefaultDisplay();
            Intrinsics.checkNotNullExpressionValue((Object)eGLDisplay, (String)"getDefaultDisplay()");
            return EGLExt.Companion.eglClientWaitSyncKHR(eGLDisplay, sync, flags, timeoutNanos);
        }

        private final EGLDisplay getDefaultDisplay() {
            return EGL14.eglGetDisplay((int)0);
        }

        @NotNull
        public String getErrorMessage() {
            return DefaultImpls.getErrorMessage(this);
        }
    };

    @NotNull
    public String eglQueryString(int var1);

    @NotNull
    public EGLSurface eglCreatePBufferSurface(@NotNull EGLConfig var1, @Nullable EGLConfigAttributes var2);

    @NotNull
    public EGLSurface eglCreateWindowSurface(@NotNull EGLConfig var1, @NotNull Surface var2, @Nullable EGLConfigAttributes var3);

    public boolean eglDestroySurface(@NotNull EGLSurface var1);

    public boolean eglMakeCurrent(@NotNull EGLContext var1, @NotNull EGLSurface var2, @NotNull EGLSurface var3);

    @NotNull
    public EGLSurface eglGetCurrentReadSurface();

    @NotNull
    public EGLSurface eglGetCurrentDrawSurface();

    @NotNull
    public EGLVersion eglInitialize();

    @Nullable
    public EGLConfig loadConfig(@NotNull EGLConfigAttributes var1);

    @NotNull
    public EGLContext eglCreateContext(@NotNull EGLConfig var1);

    public void eglDestroyContext(@NotNull EGLContext var1);

    public boolean eglSwapBuffers(@NotNull EGLSurface var1);

    public boolean eglQuerySurface(@NotNull EGLSurface var1, int var2, @NotNull int[] var3, int var4);

    public int eglGetError();

    @NotNull
    public String getErrorMessage();

    @RequiresApi(value=26)
    @Nullable
    public EGLImageKHR eglCreateImageFromHardwareBuffer(@NotNull HardwareBuffer var1);

    public boolean eglDestroyImageKHR(@NotNull EGLImageKHR var1);

    @Nullable
    public EGLSyncKHR eglCreateSyncKHR(int var1, @Nullable EGLConfigAttributes var2);

    public boolean eglGetSyncAttribKHR(@NotNull EGLSyncKHR var1, @EGLExt.Companion.EGLSyncAttribute int var2, @NotNull int[] var3, int var4);

    public boolean eglDestroySyncKHR(@NotNull EGLSyncKHR var1);

    @RequiresApi(value=19)
    @NotNull
    public SyncFence eglDupNativeFenceFDANDROID(@NotNull EGLSyncKHR var1);

    public int eglClientWaitSyncKHR(@NotNull EGLSyncKHR var1, int var2, long var3);

    @JvmStatic
    @NotNull
    public static String getStatusString(int error) {
        return Companion.getStatusString(error);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u0013\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001\u00a8\u0006\t"}, d2={"Landroidx/graphics/opengl/egl/EGLSpec$Companion;", "", "()V", "V14", "Landroidx/graphics/opengl/egl/EGLSpec;", "getStatusString", "", "error", "", "graphics-core_release"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String getStatusString(int error) {
            String string;
            switch (error) {
                case 12288: {
                    string = "EGL_SUCCESS";
                    break;
                }
                case 12289: {
                    string = "EGL_NOT_INITIALIZED";
                    break;
                }
                case 12290: {
                    string = "EGL_BAD_ACCESS";
                    break;
                }
                case 12291: {
                    string = "EGL_BAD_ALLOC";
                    break;
                }
                case 12292: {
                    string = "EGL_BAD_ATTRIBUTE";
                    break;
                }
                case 12293: {
                    string = "EGL_BAD_CONFIG";
                    break;
                }
                case 12294: {
                    string = "EGL_BAD_CONTEXT";
                    break;
                }
                case 12295: {
                    string = "EGL_BAD_CURRENT_SURFACE";
                    break;
                }
                case 12296: {
                    string = "EGL_BAD_DISPLAY";
                    break;
                }
                case 12297: {
                    string = "EGL_BAD_MATCH";
                    break;
                }
                case 12298: {
                    string = "EGL_BAD_NATIVE_PIXMAP";
                    break;
                }
                case 12299: {
                    string = "EGL_BAD_NATIVE_WINDOW";
                    break;
                }
                case 12300: {
                    string = "EGL_BAD_PARAMETER";
                    break;
                }
                case 12301: {
                    string = "EGL_BAD_SURFACE";
                    break;
                }
                case 12302: {
                    string = "EGL_CONTEXT_LOST";
                    break;
                }
                default: {
                    String string2 = Integer.toHexString(error);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toHexString(error)");
                }
            }
            return string;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static String getErrorMessage(@NotNull EGLSpec $this) {
            return Companion.getStatusString($this.eglGetError());
        }
    }
}

