/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.surface;

import android.graphics.Rect;
import android.graphics.Region;
import android.hardware.HardwareBuffer;
import android.os.Build;
import android.view.AttachedSurfaceControl;
import android.view.SurfaceView;
import androidx.annotation.RequiresApi;
import androidx.graphics.lowlatency.SyncFenceCompat;
import androidx.graphics.surface.SurfaceControlImpl;
import androidx.graphics.surface.SurfaceControlVerificationHelper;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0005\u000b\f\r\u000e\u000fB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Landroidx/graphics/surface/SurfaceControlCompat;", "", "scImpl", "Landroidx/graphics/surface/SurfaceControlImpl;", "(Landroidx/graphics/surface/SurfaceControlImpl;)V", "getScImpl$graphics_core_release", "()Landroidx/graphics/surface/SurfaceControlImpl;", "isValid", "", "release", "", "Builder", "Companion", "Transaction", "TransactionCommittedListener", "TransactionCompletedListener", "graphics-core_release"})
@RequiresApi(value=29)
public final class SurfaceControlCompat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SurfaceControlImpl scImpl;
    public static final int BUFFER_TRANSFORM_IDENTITY = 0;
    public static final int BUFFER_TRANSFORM_MIRROR_HORIZONTAL = 1;
    public static final int BUFFER_TRANSFORM_MIRROR_VERTICAL = 2;
    public static final int BUFFER_TRANSFORM_ROTATE_180 = 3;
    public static final int BUFFER_TRANSFORM_ROTATE_90 = 4;
    public static final int BUFFER_TRANSFORM_ROTATE_270 = 7;

    public SurfaceControlCompat(@NotNull SurfaceControlImpl scImpl) {
        Intrinsics.checkNotNullParameter((Object)scImpl, (String)"scImpl");
        this.scImpl = scImpl;
    }

    @NotNull
    public final SurfaceControlImpl getScImpl$graphics_core_release() {
        return this.scImpl;
    }

    public final boolean isValid() {
        return this.scImpl.isValid();
    }

    public final void release() {
        this.scImpl.release();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/graphics/surface/SurfaceControlCompat$Companion;", "", "()V", "BUFFER_TRANSFORM_IDENTITY", "", "BUFFER_TRANSFORM_MIRROR_HORIZONTAL", "BUFFER_TRANSFORM_MIRROR_VERTICAL", "BUFFER_TRANSFORM_ROTATE_180", "BUFFER_TRANSFORM_ROTATE_270", "BUFFER_TRANSFORM_ROTATE_90", "BufferTransform", "graphics-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0080\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/graphics/surface/SurfaceControlCompat$Companion$BufferTransform;", "", "graphics-core_release"})
        public static @interface BufferTransform {
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/graphics/surface/SurfaceControlCompat$Builder;", "", "()V", "mBuilderImpl", "Landroidx/graphics/surface/SurfaceControlImpl$Builder;", "build", "Landroidx/graphics/surface/SurfaceControlCompat;", "setName", "name", "", "setParent", "surfaceView", "Landroid/view/SurfaceView;", "Companion", "graphics-core_release"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final SurfaceControlImpl.Builder mBuilderImpl = Companion.createImpl();

        @NotNull
        public final Builder setParent(@NotNull SurfaceView surfaceView) {
            Intrinsics.checkNotNullParameter((Object)surfaceView, (String)"surfaceView");
            this.mBuilderImpl.setParent(surfaceView);
            return this;
        }

        @NotNull
        public final Builder setName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.mBuilderImpl.setName(name);
            return this;
        }

        @NotNull
        public final SurfaceControlCompat build() {
            return new SurfaceControlCompat(this.mBuilderImpl.build());
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Landroidx/graphics/surface/SurfaceControlCompat$Builder$Companion;", "", "()V", "createImpl", "Landroidx/graphics/surface/SurfaceControlImpl$Builder;", "graphics-core_release"})
        public static final class Companion {
            private Companion() {
            }

            @RequiresApi(value=29)
            @NotNull
            public final SurfaceControlImpl.Builder createImpl() {
                return Build.VERSION.SDK_INT >= 33 ? SurfaceControlVerificationHelper.Companion.createBuilderV33() : SurfaceControlVerificationHelper.Companion.createBuilderV29();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Landroidx/graphics/surface/SurfaceControlCompat$TransactionCompletedListener;", "", "onTransactionCompleted", "", "graphics-core_release"})
    public static interface TransactionCompletedListener {
        public void onTransactionCompleted();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Landroidx/graphics/surface/SurfaceControlCompat$TransactionCommittedListener;", "", "onTransactionCommitted", "", "graphics-core_release"})
    public static interface TransactionCommittedListener {
        public void onTransactionCommitted();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 42\u00020\u0001:\u00014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0006\u0010\f\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012J\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J6\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0010\b\u0002\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u001dH\u0007J\u0018\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\"\u001a\u0004\u0018\u00010#J\u0018\u0010$\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010%\u001a\u0004\u0018\u00010&J\u0016\u0010'\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010(\u001a\u00020 J\u0016\u0010)\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+J\u001e\u0010,\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u0016J\u001e\u0010/\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u0016J\u0016\u00102\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00103\u001a\u00020+R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Landroidx/graphics/surface/SurfaceControlCompat$Transaction;", "Ljava/lang/AutoCloseable;", "()V", "mImpl", "Landroidx/graphics/surface/SurfaceControlImpl$Transaction;", "addTransactionCommittedListener", "executor", "Ljava/util/concurrent/Executor;", "listener", "Landroidx/graphics/surface/SurfaceControlCompat$TransactionCommittedListener;", "close", "", "commit", "commitTransactionOnDraw", "attachedSurfaceControl", "Landroid/view/AttachedSurfaceControl;", "reparent", "surfaceControl", "Landroidx/graphics/surface/SurfaceControlCompat;", "newParent", "setAlpha", "alpha", "", "setBuffer", "buffer", "Landroid/hardware/HardwareBuffer;", "fence", "Landroidx/graphics/lowlatency/SyncFenceCompat;", "releaseCallback", "Lkotlin/Function0;", "setBufferTransform", "transformation", "", "setCrop", "crop", "Landroid/graphics/Rect;", "setDamageRegion", "region", "Landroid/graphics/Region;", "setLayer", "z", "setOpaque", "isOpaque", "", "setPosition", "x", "y", "setScale", "scaleX", "scaleY", "setVisibility", "visible", "Companion", "graphics-core_release"})
    public static final class Transaction
    implements AutoCloseable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final SurfaceControlImpl.Transaction mImpl = Companion.createImpl();

        @NotNull
        public final Transaction setOpaque(@NotNull SurfaceControlCompat surfaceControl, boolean isOpaque) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.mImpl.setOpaque(surfaceControl.getScImpl$graphics_core_release(), isOpaque);
            return this;
        }

        @NotNull
        public final Transaction setVisibility(@NotNull SurfaceControlCompat surfaceControl, boolean visible) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.mImpl.setVisibility(surfaceControl.getScImpl$graphics_core_release(), visible);
            return this;
        }

        @NotNull
        public final Transaction reparent(@NotNull SurfaceControlCompat surfaceControl, @Nullable SurfaceControlCompat newParent) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            SurfaceControlCompat surfaceControlCompat = newParent;
            this.mImpl.reparent(surfaceControl.getScImpl$graphics_core_release(), surfaceControlCompat != null ? surfaceControlCompat.getScImpl$graphics_core_release() : null);
            return this;
        }

        @RequiresApi(value=33)
        @NotNull
        public final Transaction reparent(@NotNull SurfaceControlCompat surfaceControl, @NotNull AttachedSurfaceControl attachedSurfaceControl) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            Intrinsics.checkNotNullParameter((Object)attachedSurfaceControl, (String)"attachedSurfaceControl");
            this.mImpl.reparent(surfaceControl.getScImpl$graphics_core_release(), attachedSurfaceControl);
            return this;
        }

        @JvmOverloads
        @NotNull
        public final Transaction setBuffer(@NotNull SurfaceControlCompat surfaceControl, @NotNull HardwareBuffer buffer, @Nullable SyncFenceCompat fence, @Nullable Function0<Unit> releaseCallback) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            SyncFenceCompat syncFenceCompat = fence;
            this.mImpl.setBuffer(surfaceControl.getScImpl$graphics_core_release(), buffer, syncFenceCompat != null ? syncFenceCompat.getMImpl$graphics_core_release() : null, releaseCallback);
            return this;
        }

        public static /* synthetic */ Transaction setBuffer$default(Transaction transaction2, SurfaceControlCompat surfaceControlCompat, HardwareBuffer hardwareBuffer, SyncFenceCompat syncFenceCompat, Function0 function0, int n, Object object) {
            if ((n & 4) != 0) {
                syncFenceCompat = null;
            }
            if ((n & 8) != 0) {
                function0 = null;
            }
            return transaction2.setBuffer(surfaceControlCompat, hardwareBuffer, syncFenceCompat, (Function0<Unit>)function0);
        }

        @NotNull
        public final Transaction setLayer(@NotNull SurfaceControlCompat surfaceControl, int z) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.mImpl.setLayer(surfaceControl.getScImpl$graphics_core_release(), z);
            return this;
        }

        @RequiresApi(value=31)
        @NotNull
        public final Transaction addTransactionCommittedListener(@NotNull Executor executor, @NotNull TransactionCommittedListener listener) {
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.mImpl.addTransactionCommittedListener(executor, listener);
            return this;
        }

        @NotNull
        public final Transaction setDamageRegion(@NotNull SurfaceControlCompat surfaceControl, @Nullable Region region) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.mImpl.setDamageRegion(surfaceControl.getScImpl$graphics_core_release(), region);
            return this;
        }

        @NotNull
        public final Transaction setAlpha(@NotNull SurfaceControlCompat surfaceControl, float alpha) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.mImpl.setAlpha(surfaceControl.getScImpl$graphics_core_release(), alpha);
            return this;
        }

        @NotNull
        public final Transaction setCrop(@NotNull SurfaceControlCompat surfaceControl, @Nullable Rect crop) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.mImpl.setCrop(surfaceControl.getScImpl$graphics_core_release(), crop);
            return this;
        }

        @NotNull
        public final Transaction setPosition(@NotNull SurfaceControlCompat surfaceControl, float x, float y) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.mImpl.setPosition(surfaceControl.getScImpl$graphics_core_release(), x, y);
            return this;
        }

        @NotNull
        public final Transaction setScale(@NotNull SurfaceControlCompat surfaceControl, float scaleX, float scaleY) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.mImpl.setScale(surfaceControl.getScImpl$graphics_core_release(), scaleX, scaleY);
            return this;
        }

        @NotNull
        public final Transaction setBufferTransform(@NotNull SurfaceControlCompat surfaceControl, @Companion.BufferTransform int transformation) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.mImpl.setBufferTransform(surfaceControl.getScImpl$graphics_core_release(), transformation);
            return this;
        }

        public final void commit() {
            this.mImpl.commit();
        }

        @Override
        public void close() {
            this.mImpl.close();
        }

        @RequiresApi(value=33)
        public final void commitTransactionOnDraw(@NotNull AttachedSurfaceControl attachedSurfaceControl) {
            Intrinsics.checkNotNullParameter((Object)attachedSurfaceControl, (String)"attachedSurfaceControl");
            this.mImpl.commitTransactionOnDraw(attachedSurfaceControl);
        }

        @JvmOverloads
        @NotNull
        public final Transaction setBuffer(@NotNull SurfaceControlCompat surfaceControl, @NotNull HardwareBuffer buffer, @Nullable SyncFenceCompat fence) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return Transaction.setBuffer$default(this, surfaceControl, buffer, fence, null, 8, null);
        }

        @JvmOverloads
        @NotNull
        public final Transaction setBuffer(@NotNull SurfaceControlCompat surfaceControl, @NotNull HardwareBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return Transaction.setBuffer$default(this, surfaceControl, buffer, null, null, 12, null);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Landroidx/graphics/surface/SurfaceControlCompat$Transaction$Companion;", "", "()V", "createImpl", "Landroidx/graphics/surface/SurfaceControlImpl$Transaction;", "graphics-core_release"})
        public static final class Companion {
            private Companion() {
            }

            @RequiresApi(value=29)
            @NotNull
            public final SurfaceControlImpl.Transaction createImpl() {
                return Build.VERSION.SDK_INT >= 33 ? SurfaceControlVerificationHelper.Companion.createTransactionV33() : SurfaceControlVerificationHelper.Companion.createTransactionV29();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

