/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.surface;

import android.graphics.Rect;
import android.graphics.Region;
import android.hardware.HardwareBuffer;
import android.os.Build;
import android.view.AttachedSurfaceControl;
import android.view.Surface;
import android.view.SurfaceView;
import androidx.annotation.RequiresApi;
import androidx.graphics.lowlatency.SyncFenceImpl;
import androidx.graphics.lowlatency.SyncFenceV19;
import androidx.graphics.surface.SurfaceControlCompat;
import androidx.graphics.surface.SurfaceControlImpl;
import androidx.graphics.surface.SurfaceControlWrapper;
import androidx.hardware.SyncFence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Landroidx/graphics/surface/SurfaceControlV29;", "Landroidx/graphics/surface/SurfaceControlImpl;", "surfaceControl", "Landroidx/graphics/surface/SurfaceControlWrapper;", "(Landroidx/graphics/surface/SurfaceControlWrapper;)V", "currActiveBufferReleaseCallback", "Lkotlin/Function0;", "", "getSurfaceControl$graphics_core_release", "()Landroidx/graphics/surface/SurfaceControlWrapper;", "isValid", "", "release", "Builder", "Transaction", "graphics-core_release"})
@RequiresApi(value=29)
public final class SurfaceControlV29
implements SurfaceControlImpl {
    @NotNull
    private final SurfaceControlWrapper surfaceControl;
    @Nullable
    private Function0<Unit> currActiveBufferReleaseCallback;

    public SurfaceControlV29(@NotNull SurfaceControlWrapper surfaceControl) {
        Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
        this.surfaceControl = surfaceControl;
    }

    @NotNull
    public final SurfaceControlWrapper getSurfaceControl$graphics_core_release() {
        return this.surfaceControl;
    }

    @Override
    public boolean isValid() {
        return this.surfaceControl.isValid();
    }

    @Override
    public void release() {
        this.surfaceControl.release();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/graphics/surface/SurfaceControlV29$Builder;", "Landroidx/graphics/surface/SurfaceControlImpl$Builder;", "()V", "builder", "Landroidx/graphics/surface/SurfaceControlWrapper$Builder;", "build", "Landroidx/graphics/surface/SurfaceControlImpl;", "setName", "name", "", "setParent", "surfaceView", "Landroid/view/SurfaceView;", "graphics-core_release"})
    public static final class Builder
    implements SurfaceControlImpl.Builder {
        @NotNull
        private SurfaceControlWrapper.Builder builder = new SurfaceControlWrapper.Builder();

        @Override
        @NotNull
        public SurfaceControlImpl.Builder setParent(@NotNull SurfaceView surfaceView) {
            Intrinsics.checkNotNullParameter((Object)surfaceView, (String)"surfaceView");
            Surface surface = surfaceView.getHolder().getSurface();
            Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"surfaceView.holder.surface");
            this.builder.setParent(surface);
            return this;
        }

        @Override
        @NotNull
        public SurfaceControlImpl.Builder setName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.builder.setDebugName(name);
            return this;
        }

        @Override
        @NotNull
        public SurfaceControlImpl build() {
            return new SurfaceControlV29(this.builder.build());
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001AB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u000e\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u0016J\u0018\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J2\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010%H\u0016J\u001a\u0010&\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00052\b\b\u0001\u0010'\u001a\u00020\u0006H\u0016J\u001a\u0010(\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00052\b\u0010)\u001a\u0004\u0018\u00010*H\u0017J\u001a\u0010+\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00052\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0018\u0010.\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0006H\u0016J\u0018\u00100\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\u0014H\u0002J \u00104\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u001e2\u0006\u00106\u001a\u00020\u001eH\u0017J \u00107\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u001e2\u0006\u00109\u001a\u00020\u001eH\u0017J\u0018\u0010:\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010;\u001a\u000202H\u0016J\b\u0010<\u001a\u00020\u0014H\u0002J\f\u0010=\u001a\u00020>*\u00020#H\u0002J\f\u0010?\u001a\u00020@*\u00020\u0005H\u0002R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\n\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0004j\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u000b`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Landroidx/graphics/surface/SurfaceControlV29$Transaction;", "Landroidx/graphics/surface/SurfaceControlImpl$Transaction;", "()V", "pendingSetTransformCalls", "Ljava/util/HashMap;", "Landroidx/graphics/surface/SurfaceControlImpl;", "", "Lkotlin/collections/HashMap;", "transaction", "Landroidx/graphics/surface/SurfaceControlWrapper$Transaction;", "uncommittedBufferCallbackMap", "Landroidx/graphics/surface/SurfaceControlV29$Transaction$BufferData;", "addTransactionCommittedListener", "executor", "Ljava/util/concurrent/Executor;", "listener", "Landroidx/graphics/surface/SurfaceControlCompat$TransactionCommittedListener;", "addTransactionCompletedListener", "Landroidx/graphics/surface/SurfaceControlCompat$TransactionCompletedListener;", "close", "", "commit", "commitTransactionOnDraw", "attachedSurfaceControl", "Landroid/view/AttachedSurfaceControl;", "reparent", "surfaceControl", "newParent", "setAlpha", "alpha", "", "setBuffer", "buffer", "Landroid/hardware/HardwareBuffer;", "fence", "Landroidx/graphics/lowlatency/SyncFenceImpl;", "releaseCallback", "Lkotlin/Function0;", "setBufferTransform", "transformation", "setCrop", "crop", "Landroid/graphics/Rect;", "setDamageRegion", "region", "Landroid/graphics/Region;", "setLayer", "z", "setOpaque", "isOpaque", "", "setPendingBufferTransform", "setPosition", "x", "y", "setScale", "scaleX", "scaleY", "setVisibility", "visible", "updateReleaseCallbacks", "asSyncFenceCompat", "Landroidx/hardware/SyncFence;", "asWrapperSurfaceControl", "Landroidx/graphics/surface/SurfaceControlWrapper;", "BufferData", "graphics-core_release"})
    public static final class Transaction
    implements SurfaceControlImpl.Transaction {
        @NotNull
        private final SurfaceControlWrapper.Transaction transaction = new SurfaceControlWrapper.Transaction();
        @NotNull
        private final HashMap<SurfaceControlImpl, BufferData> uncommittedBufferCallbackMap = new HashMap();
        @NotNull
        private final HashMap<SurfaceControlImpl, Integer> pendingSetTransformCalls = new HashMap();

        @Override
        public void commit() {
            this.setPendingBufferTransform();
            this.updateReleaseCallbacks();
            this.uncommittedBufferCallbackMap.clear();
            this.pendingSetTransformCalls.clear();
            this.transaction.commit();
        }

        private final void updateReleaseCallbacks() {
            List callbackInvokeList = new ArrayList();
            for (SurfaceControlImpl surfaceControl : this.uncommittedBufferCallbackMap.keySet()) {
                SurfaceControlV29 surfaceControlV29;
                SurfaceControlV29 surfaceControlV292 = surfaceControl instanceof SurfaceControlV29 ? (SurfaceControlV29)surfaceControl : null;
                if (surfaceControlV292 == null) continue;
                SurfaceControlV29 $this$updateReleaseCallbacks_u24lambda_u241 = surfaceControlV29 = surfaceControlV292;
                boolean bl = false;
                if ($this$updateReleaseCallbacks_u24lambda_u241.currActiveBufferReleaseCallback != null) {
                    Function0 it;
                    boolean bl2 = false;
                    callbackInvokeList.add(it);
                }
                BufferData bufferData = this.uncommittedBufferCallbackMap.get(surfaceControl);
                $this$updateReleaseCallbacks_u24lambda_u241.currActiveBufferReleaseCallback = bufferData != null ? bufferData.getReleaseCallback() : null;
            }
            if (callbackInvokeList.size() > 0) {
                SurfaceControlCompat.TransactionCompletedListener callbackListener2 = new SurfaceControlCompat.TransactionCompletedListener(callbackInvokeList){
                    final /* synthetic */ List<Function0<Unit>> $callbackInvokeList;
                    {
                        this.$callbackInvokeList = $callbackInvokeList;
                    }

                    public void onTransactionCompleted() {
                        Iterable $this$forEach$iv = this.$callbackInvokeList;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Function0 it = (Function0)element$iv;
                            boolean bl = false;
                            it.invoke();
                        }
                        this.$callbackInvokeList.clear();
                    }
                };
                this.addTransactionCompletedListener(callbackListener2);
            }
        }

        private final void setPendingBufferTransform() {
            for (SurfaceControlImpl surfaceControl : this.pendingSetTransformCalls.keySet()) {
                BufferData it;
                if (this.uncommittedBufferCallbackMap.get(surfaceControl) == null) continue;
                boolean bl = false;
                Integer n = this.pendingSetTransformCalls.getOrDefault(surfaceControl, -1);
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"pendingSetTransformCalls\u2026ORM\n                    )");
                int transformation = ((Number)n).intValue();
                if (transformation == -1) continue;
                int dstWidth = 0;
                int dstHeight = 0;
                switch (transformation) {
                    case 4: 
                    case 7: {
                        dstWidth = it.getHeight();
                        dstHeight = it.getWidth();
                        break;
                    }
                    default: {
                        dstWidth = it.getWidth();
                        dstHeight = it.getHeight();
                    }
                }
                Intrinsics.checkNotNullExpressionValue((Object)surfaceControl, (String)"surfaceControl");
                this.transaction.setGeometry(this.asWrapperSurfaceControl(surfaceControl), it.getWidth(), it.getHeight(), dstWidth, dstHeight, transformation);
            }
        }

        @Override
        @NotNull
        public SurfaceControlImpl.Transaction setVisibility(@NotNull SurfaceControlImpl surfaceControl, boolean visible) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.transaction.setVisibility(this.asWrapperSurfaceControl(surfaceControl), visible);
            return this;
        }

        @Override
        @NotNull
        public SurfaceControlImpl.Transaction reparent(@NotNull SurfaceControlImpl surfaceControl, @Nullable SurfaceControlImpl newParent) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            SurfaceControlImpl surfaceControlImpl = newParent;
            this.transaction.reparent(this.asWrapperSurfaceControl(surfaceControl), surfaceControlImpl != null ? this.asWrapperSurfaceControl(surfaceControlImpl) : null);
            return this;
        }

        @Override
        @NotNull
        public SurfaceControlImpl.Transaction setBuffer(@NotNull SurfaceControlImpl surfaceControl, @NotNull HardwareBuffer buffer, @Nullable SyncFenceImpl fence, @Nullable Function0<Unit> releaseCallback) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            BufferData data = new BufferData(buffer.getWidth(), buffer.getHeight(), releaseCallback);
            Function0<Unit> function0 = this.uncommittedBufferCallbackMap.put(surfaceControl, data);
            if (function0 != null && (function0 = function0.getReleaseCallback()) != null) {
                function0.invoke();
            }
            if (fence == null) {
                SurfaceControlWrapper.Transaction.setBuffer$default(this.transaction, this.asWrapperSurfaceControl(surfaceControl), buffer, null, 4, null);
            } else {
                this.transaction.setBuffer(this.asWrapperSurfaceControl(surfaceControl), buffer, this.asSyncFenceCompat(fence));
            }
            return this;
        }

        @Override
        @NotNull
        public SurfaceControlImpl.Transaction setLayer(@NotNull SurfaceControlImpl surfaceControl, int z) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.transaction.setLayer(this.asWrapperSurfaceControl(surfaceControl), z);
            return this;
        }

        @Override
        @RequiresApi(value=31)
        @NotNull
        public SurfaceControlImpl.Transaction addTransactionCommittedListener(@NotNull Executor executor, @NotNull SurfaceControlCompat.TransactionCommittedListener listener) {
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.transaction.addTransactionCommittedListener(executor, listener);
            return this;
        }

        @NotNull
        public final SurfaceControlImpl.Transaction addTransactionCompletedListener(@NotNull SurfaceControlCompat.TransactionCompletedListener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.transaction.addTransactionCompletedListener$graphics_core_release(listener);
            return this;
        }

        @Override
        @NotNull
        public SurfaceControlImpl.Transaction setDamageRegion(@NotNull SurfaceControlImpl surfaceControl, @Nullable Region region) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.transaction.setDamageRegion(this.asWrapperSurfaceControl(surfaceControl), region);
            return this;
        }

        @Override
        @NotNull
        public SurfaceControlImpl.Transaction setOpaque(@NotNull SurfaceControlImpl surfaceControl, boolean isOpaque) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.transaction.setOpaque(this.asWrapperSurfaceControl(surfaceControl), isOpaque);
            return this;
        }

        @Override
        @NotNull
        public SurfaceControlImpl.Transaction setAlpha(@NotNull SurfaceControlImpl surfaceControl, float alpha) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.transaction.setAlpha(this.asWrapperSurfaceControl(surfaceControl), alpha);
            return this;
        }

        @Override
        @RequiresApi(value=31)
        @NotNull
        public SurfaceControlImpl.Transaction setCrop(@NotNull SurfaceControlImpl surfaceControl, @Nullable Rect crop) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.transaction.setCrop(this.asWrapperSurfaceControl(surfaceControl), crop);
            return this;
        }

        @Override
        @RequiresApi(value=31)
        @NotNull
        public SurfaceControlImpl.Transaction setPosition(@NotNull SurfaceControlImpl surfaceControl, float x, float y) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.transaction.setPosition(this.asWrapperSurfaceControl(surfaceControl), x, y);
            return this;
        }

        @Override
        @RequiresApi(value=31)
        @NotNull
        public SurfaceControlImpl.Transaction setScale(@NotNull SurfaceControlImpl surfaceControl, float scaleX, float scaleY) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.transaction.setScale(this.asWrapperSurfaceControl(surfaceControl), scaleX, scaleY);
            return this;
        }

        @Override
        @NotNull
        public Transaction setBufferTransform(@NotNull SurfaceControlImpl surfaceControl, @SurfaceControlCompat.Companion.BufferTransform int transformation) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            if (Build.VERSION.SDK_INT >= 31) {
                this.transaction.setBufferTransform(this.asWrapperSurfaceControl(surfaceControl), transformation);
            } else {
                Integer n = transformation;
                ((Map)this.pendingSetTransformCalls).put(surfaceControl, n);
            }
            return this;
        }

        @Override
        public void close() {
            this.transaction.close();
        }

        @Override
        @NotNull
        public SurfaceControlImpl.Transaction reparent(@NotNull SurfaceControlImpl surfaceControl, @NotNull AttachedSurfaceControl attachedSurfaceControl) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            Intrinsics.checkNotNullParameter((Object)attachedSurfaceControl, (String)"attachedSurfaceControl");
            throw new UnsupportedOperationException("Reparenting to an AttachedSurfaceControl is only available on Android T+.");
        }

        @Override
        public void commitTransactionOnDraw(@NotNull AttachedSurfaceControl attachedSurfaceControl) {
            Intrinsics.checkNotNullParameter((Object)attachedSurfaceControl, (String)"attachedSurfaceControl");
            throw new UnsupportedOperationException("Committing transactions synchronously with the draw pass of an AttachedSurfaceControl is only available on Android T+.");
        }

        private final SurfaceControlWrapper asWrapperSurfaceControl(SurfaceControlImpl $this$asWrapperSurfaceControl) {
            if (!($this$asWrapperSurfaceControl instanceof SurfaceControlV29)) {
                throw new IllegalArgumentException("Parent implementation is only for Android T+.");
            }
            return ((SurfaceControlV29)$this$asWrapperSurfaceControl).getSurfaceControl$graphics_core_release();
        }

        private final SyncFence asSyncFenceCompat(SyncFenceImpl $this$asSyncFenceCompat) {
            if (!($this$asSyncFenceCompat instanceof SyncFenceV19)) {
                throw new IllegalArgumentException("Expected SyncFenceCompat implementation for API level 19");
            }
            return ((SyncFenceV19)$this$asSyncFenceCompat).getMSyncFence$graphics_core_release();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Landroidx/graphics/surface/SurfaceControlV29$Transaction$BufferData;", "", "width", "", "height", "releaseCallback", "Lkotlin/Function0;", "", "(IILkotlin/jvm/functions/Function0;)V", "getHeight", "()I", "getReleaseCallback", "()Lkotlin/jvm/functions/Function0;", "getWidth", "graphics-core_release"})
        private static final class BufferData {
            private final int width;
            private final int height;
            @Nullable
            private final Function0<Unit> releaseCallback;

            public BufferData(int width, int height, @Nullable Function0<Unit> releaseCallback) {
                this.width = width;
                this.height = height;
                this.releaseCallback = releaseCallback;
            }

            public final int getWidth() {
                return this.width;
            }

            public final int getHeight() {
                return this.height;
            }

            @Nullable
            public final Function0<Unit> getReleaseCallback() {
                return this.releaseCallback;
            }
        }
    }
}

