/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.surface;

import android.graphics.Rect;
import android.graphics.Region;
import android.hardware.HardwareBuffer;
import android.hardware.SyncFence;
import android.view.AttachedSurfaceControl;
import android.view.SurfaceControl;
import android.view.SurfaceView;
import androidx.annotation.RequiresApi;
import androidx.graphics.lowlatency.SyncFenceImpl;
import androidx.graphics.lowlatency.SyncFenceV33;
import androidx.graphics.surface.SurfaceControlCompat;
import androidx.graphics.surface.SurfaceControlImpl;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Landroidx/graphics/surface/SurfaceControlV33;", "Landroidx/graphics/surface/SurfaceControlImpl;", "surfaceControl", "Landroid/view/SurfaceControl;", "(Landroid/view/SurfaceControl;)V", "getSurfaceControl$graphics_core_release", "()Landroid/view/SurfaceControl;", "isValid", "", "release", "", "Builder", "Transaction", "graphics-core_release"})
@RequiresApi(value=33)
public final class SurfaceControlV33
implements SurfaceControlImpl {
    @NotNull
    private final SurfaceControl surfaceControl;

    public SurfaceControlV33(@NotNull SurfaceControl surfaceControl) {
        Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
        this.surfaceControl = surfaceControl;
    }

    @NotNull
    public final SurfaceControl getSurfaceControl$graphics_core_release() {
        return this.surfaceControl;
    }

    @Override
    public boolean isValid() {
        return this.surfaceControl.isValid();
    }

    @Override
    public void release() {
        this.surfaceControl.release();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/graphics/surface/SurfaceControlV33$Builder;", "Landroidx/graphics/surface/SurfaceControlImpl$Builder;", "()V", "builder", "Landroid/view/SurfaceControl$Builder;", "build", "Landroidx/graphics/surface/SurfaceControlImpl;", "setName", "name", "", "setParent", "surfaceView", "Landroid/view/SurfaceView;", "graphics-core_release"})
    public static final class Builder
    implements SurfaceControlImpl.Builder {
        @NotNull
        private final SurfaceControl.Builder builder = new SurfaceControl.Builder();

        @Override
        @NotNull
        public SurfaceControlImpl.Builder setParent(@NotNull SurfaceView surfaceView) {
            Intrinsics.checkNotNullParameter((Object)surfaceView, (String)"surfaceView");
            this.builder.setParent(surfaceView.getSurfaceControl());
            return this;
        }

        @Override
        @NotNull
        public Builder setName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.builder.setName(name);
            return this;
        }

        @Override
        @NotNull
        public SurfaceControlImpl build() {
            SurfaceControl surfaceControl = this.builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)surfaceControl, (String)"builder.build()");
            return new SurfaceControlV33(surfaceControl);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J2\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u001dH\u0016J\u001a\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u001f\u001a\u00020 H\u0016J\u001a\u0010!\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u001a\u0010$\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0018\u0010'\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010(\u001a\u00020 H\u0016J\u0018\u0010)\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+H\u0016J \u0010,\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u0016H\u0016J \u0010/\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u0016H\u0016J\u0018\u00102\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00103\u001a\u00020+H\u0016J\f\u00104\u001a\u000205*\u00020\u0012H\u0002J\f\u00106\u001a\u000207*\u00020\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Landroidx/graphics/surface/SurfaceControlV33$Transaction;", "Landroidx/graphics/surface/SurfaceControlImpl$Transaction;", "()V", "mTransaction", "Landroid/view/SurfaceControl$Transaction;", "addTransactionCommittedListener", "executor", "Ljava/util/concurrent/Executor;", "listener", "Landroidx/graphics/surface/SurfaceControlCompat$TransactionCommittedListener;", "close", "", "commit", "commitTransactionOnDraw", "attachedSurfaceControl", "Landroid/view/AttachedSurfaceControl;", "reparent", "surfaceControl", "Landroidx/graphics/surface/SurfaceControlImpl;", "newParent", "setAlpha", "alpha", "", "setBuffer", "buffer", "Landroid/hardware/HardwareBuffer;", "fence", "Landroidx/graphics/lowlatency/SyncFenceImpl;", "releaseCallback", "Lkotlin/Function0;", "setBufferTransform", "transformation", "", "setCrop", "crop", "Landroid/graphics/Rect;", "setDamageRegion", "region", "Landroid/graphics/Region;", "setLayer", "z", "setOpaque", "isOpaque", "", "setPosition", "x", "y", "setScale", "scaleX", "scaleY", "setVisibility", "visible", "asFrameworkSurfaceControl", "Landroid/view/SurfaceControl;", "asSyncFence", "Landroid/hardware/SyncFence;", "graphics-core_release"})
    public static final class Transaction
    implements SurfaceControlImpl.Transaction {
        @NotNull
        private final SurfaceControl.Transaction mTransaction = new SurfaceControl.Transaction();

        @Override
        @NotNull
        public SurfaceControlImpl.Transaction setOpaque(@NotNull SurfaceControlImpl surfaceControl, boolean isOpaque) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.mTransaction.setOpaque(this.asFrameworkSurfaceControl(surfaceControl), isOpaque);
            return this;
        }

        @Override
        @NotNull
        public SurfaceControlImpl.Transaction setVisibility(@NotNull SurfaceControlImpl surfaceControl, boolean visible) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.mTransaction.setVisibility(this.asFrameworkSurfaceControl(surfaceControl), visible);
            return this;
        }

        @Override
        @NotNull
        public Transaction setBuffer(@NotNull SurfaceControlImpl surfaceControl, @NotNull HardwareBuffer buffer, @Nullable SyncFenceImpl fence, @Nullable Function0<Unit> releaseCallback) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            SyncFenceImpl syncFenceImpl = fence;
            this.mTransaction.setBuffer(this.asFrameworkSurfaceControl(surfaceControl), buffer, syncFenceImpl != null ? this.asSyncFence(syncFenceImpl) : null, arg_0 -> Transaction.setBuffer$lambda$0(releaseCallback, arg_0));
            return this;
        }

        @Override
        @NotNull
        public SurfaceControlImpl.Transaction setLayer(@NotNull SurfaceControlImpl surfaceControl, int z) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.mTransaction.setLayer(this.asFrameworkSurfaceControl(surfaceControl), z);
            return this;
        }

        @Override
        @NotNull
        public Transaction reparent(@NotNull SurfaceControlImpl surfaceControl, @Nullable SurfaceControlImpl newParent) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            SurfaceControlImpl surfaceControlImpl = newParent;
            this.mTransaction.reparent(this.asFrameworkSurfaceControl(surfaceControl), surfaceControlImpl != null ? this.asFrameworkSurfaceControl(surfaceControlImpl) : null);
            return this;
        }

        @Override
        @NotNull
        public SurfaceControlImpl.Transaction reparent(@NotNull SurfaceControlImpl surfaceControl, @NotNull AttachedSurfaceControl attachedSurfaceControl) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            Intrinsics.checkNotNullParameter((Object)attachedSurfaceControl, (String)"attachedSurfaceControl");
            SurfaceControl.Transaction reparentTransaction = attachedSurfaceControl.buildReparentTransaction(this.asFrameworkSurfaceControl(surfaceControl));
            if (reparentTransaction != null) {
                this.mTransaction.merge(reparentTransaction);
            }
            return this;
        }

        @Override
        @NotNull
        public SurfaceControlImpl.Transaction addTransactionCommittedListener(@NotNull Executor executor, @NotNull SurfaceControlCompat.TransactionCommittedListener listener) {
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.mTransaction.addTransactionCommittedListener(executor, () -> Transaction.addTransactionCommittedListener$lambda$1(listener));
            return this;
        }

        @Override
        @NotNull
        public SurfaceControlImpl.Transaction setDamageRegion(@NotNull SurfaceControlImpl surfaceControl, @Nullable Region region) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.mTransaction.setDamageRegion(this.asFrameworkSurfaceControl(surfaceControl), region);
            return this;
        }

        @Override
        @NotNull
        public SurfaceControlImpl.Transaction setAlpha(@NotNull SurfaceControlImpl surfaceControl, float alpha) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.mTransaction.setAlpha(this.asFrameworkSurfaceControl(surfaceControl), alpha);
            return this;
        }

        @Override
        @NotNull
        public SurfaceControlImpl.Transaction setCrop(@NotNull SurfaceControlImpl surfaceControl, @Nullable Rect crop) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.mTransaction.setCrop(this.asFrameworkSurfaceControl(surfaceControl), crop);
            return this;
        }

        @Override
        @NotNull
        public SurfaceControlImpl.Transaction setPosition(@NotNull SurfaceControlImpl surfaceControl, float x, float y) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.mTransaction.setPosition(this.asFrameworkSurfaceControl(surfaceControl), x, y);
            return this;
        }

        @Override
        @NotNull
        public SurfaceControlImpl.Transaction setScale(@NotNull SurfaceControlImpl surfaceControl, float scaleX, float scaleY) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.mTransaction.setScale(this.asFrameworkSurfaceControl(surfaceControl), scaleX, scaleY);
            return this;
        }

        @Override
        @NotNull
        public SurfaceControlImpl.Transaction setBufferTransform(@NotNull SurfaceControlImpl surfaceControl, @SurfaceControlCompat.Companion.BufferTransform int transformation) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            this.mTransaction.setBufferTransform(this.asFrameworkSurfaceControl(surfaceControl), transformation);
            return this;
        }

        @Override
        public void commit() {
            this.mTransaction.apply();
        }

        @Override
        public void close() {
            this.mTransaction.close();
        }

        @Override
        public void commitTransactionOnDraw(@NotNull AttachedSurfaceControl attachedSurfaceControl) {
            Intrinsics.checkNotNullParameter((Object)attachedSurfaceControl, (String)"attachedSurfaceControl");
            attachedSurfaceControl.applyTransactionOnDraw(this.mTransaction);
        }

        private final SurfaceControl asFrameworkSurfaceControl(SurfaceControlImpl $this$asFrameworkSurfaceControl) {
            if (!($this$asFrameworkSurfaceControl instanceof SurfaceControlV33)) {
                throw new IllegalArgumentException("Parent implementation is not for Android T");
            }
            return ((SurfaceControlV33)$this$asFrameworkSurfaceControl).getSurfaceControl$graphics_core_release();
        }

        private final SyncFence asSyncFence(SyncFenceImpl $this$asSyncFence) {
            if (!($this$asSyncFence instanceof SyncFenceV33)) {
                throw new IllegalArgumentException("Expected SyncFenceCompat implementation for API level 33");
            }
            return ((SyncFenceV33)$this$asSyncFence).getMSyncFence$graphics_core_release();
        }

        private static final void setBuffer$lambda$0(Function0 $releaseCallback, SyncFence it) {
            block0: {
                Function0 function0 = $releaseCallback;
                if (function0 == null) break block0;
                function0.invoke();
            }
        }

        private static final void addTransactionCommittedListener$lambda$1(SurfaceControlCompat.TransactionCommittedListener $listener) {
            Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
            $listener.onTransactionCommitted();
        }
    }
}

