/*
 * Decompiled with CFR 0.152.
 */
package androidx.hardware;

import androidx.annotation.RequiresApi;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0004J\b\u0010\r\u001a\u00020\bH\u0007J\u0006\u0010\u000e\u001a\u00020\u0006J\u0011\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0082 J\u0011\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0082 J\u0019\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0082 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/hardware/SyncFence;", "Ljava/lang/AutoCloseable;", "fd", "", "(I)V", "await", "", "timeoutNanos", "", "awaitForever", "close", "", "finalize", "getSignalTime", "isValid", "nClose", "nGetSignalTime", "nWait", "timeoutMillis", "Companion", "graphics-core_release"})
@RequiresApi(value=19)
public final class SyncFence
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int fd;
    public static final long SIGNAL_TIME_INVALID = -1L;
    public static final long SIGNAL_TIME_PENDING = Long.MAX_VALUE;

    public SyncFence(int fd) {
        this.fd = fd;
    }

    public final boolean isValid() {
        return this.fd != -1;
    }

    @RequiresApi(value=26)
    public final long getSignalTime() {
        return this.isValid() ? this.nGetSignalTime(this.fd) : -1L;
    }

    public final boolean await(long timeoutNanos) {
        if (this.isValid()) {
            int timeout = 0;
            timeout = timeoutNanos < 0L ? -1 : (int)TimeUnit.NANOSECONDS.toMillis(timeoutNanos);
            return this.nWait(this.fd, timeout);
        }
        return true;
    }

    public final boolean awaitForever() {
        return this.await(-1L);
    }

    @Override
    public void close() {
        this.nClose(this.fd);
        this.fd = -1;
    }

    protected final void finalize() {
        this.close();
    }

    private final native boolean nWait(int var1, int var2);

    private final native long nGetSignalTime(int var1);

    private final native void nClose(int var1);

    static {
        System.loadLibrary("sync-fence");
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/hardware/SyncFence$Companion;", "", "()V", "SIGNAL_TIME_INVALID", "", "SIGNAL_TIME_PENDING", "graphics-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

