/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics;

import android.annotation.SuppressLint;
import android.graphics.HardwareRenderer;
import android.graphics.RenderNode;
import android.hardware.HardwareBuffer;
import android.media.Image;
import android.media.ImageReader;
import android.util.Log;
import androidx.annotation.RequiresApi;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00130\u0018R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/graphics/MultiBufferedCanvasRenderer;", "", "renderNode", "Landroid/graphics/RenderNode;", "width", "", "height", "format", "usage", "", "maxImages", "(Landroid/graphics/RenderNode;IIIJI)V", "mHardwareRenderer", "Landroid/graphics/HardwareRenderer;", "mImageReader", "Landroid/media/ImageReader;", "mIsReleased", "", "release", "", "renderFrame", "executor", "Ljava/util/concurrent/Executor;", "bufferAvailable", "Lkotlin/Function1;", "Landroid/hardware/HardwareBuffer;", "Companion", "graphics-core_release"})
@RequiresApi(value=29)
public final class MultiBufferedCanvasRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RenderNode renderNode;
    @SuppressLint(value={"WrongConstant"})
    @NotNull
    private final ImageReader mImageReader;
    @Nullable
    private HardwareRenderer mHardwareRenderer;
    private boolean mIsReleased;
    @NotNull
    public static final String TAG = "MultiBufferRenderer";

    /*
     * WARNING - void declaration
     */
    public MultiBufferedCanvasRenderer(@NotNull RenderNode renderNode, int width, int height, int format, long usage, int maxImages) {
        void $this$mHardwareRenderer_u24lambda_u240;
        HardwareRenderer hardwareRenderer;
        Intrinsics.checkNotNullParameter((Object)renderNode, (String)"renderNode");
        this.renderNode = renderNode;
        ImageReader imageReader = ImageReader.newInstance((int)width, (int)height, (int)format, (int)maxImages, (long)usage);
        Intrinsics.checkNotNullExpressionValue((Object)imageReader, (String)"newInstance(width, heigh\u2026format, maxImages, usage)");
        this.mImageReader = imageReader;
        HardwareRenderer hardwareRenderer2 = hardwareRenderer = new HardwareRenderer();
        MultiBufferedCanvasRenderer multiBufferedCanvasRenderer = this;
        boolean bl = false;
        $this$mHardwareRenderer_u24lambda_u240.setContentRoot(this.renderNode);
        $this$mHardwareRenderer_u24lambda_u240.setSurface(this.mImageReader.getSurface());
        $this$mHardwareRenderer_u24lambda_u240.start();
        multiBufferedCanvasRenderer.mHardwareRenderer = hardwareRenderer;
    }

    public /* synthetic */ MultiBufferedCanvasRenderer(RenderNode renderNode, int n, int n2, int n3, long l, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 8) != 0) {
            n3 = 1;
        }
        if ((n5 & 0x10) != 0) {
            l = 768L;
        }
        if ((n5 & 0x20) != 0) {
            n4 = 2;
        }
        this(renderNode, n, n2, n3, l, n4);
    }

    public final void renderFrame(@NotNull Executor executor, @NotNull Function1<? super HardwareBuffer, Unit> bufferAvailable) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(bufferAvailable, (String)"bufferAvailable");
        HardwareRenderer renderer = this.mHardwareRenderer;
        if (renderer != null && !this.mIsReleased) {
            HardwareRenderer $this$renderFrame_u24lambda_u244 = renderer;
            boolean bl = false;
            $this$renderFrame_u24lambda_u244.createRenderRequest().setFrameCommitCallback(executor, () -> MultiBufferedCanvasRenderer.renderFrame$lambda$4$lambda$3(this, executor, bufferAvailable)).syncAndDraw();
        } else {
            Log.v((String)TAG, (String)"mHardwareRenderer is null");
        }
    }

    public final void release() {
        if (!this.mIsReleased) {
            this.mImageReader.close();
            HardwareRenderer hardwareRenderer = this.mHardwareRenderer;
            if (hardwareRenderer != null) {
                HardwareRenderer renderer = hardwareRenderer;
                boolean bl = false;
                renderer.stop();
                renderer.destroy();
            }
            this.mHardwareRenderer = null;
            this.mIsReleased = true;
        }
    }

    private static final void renderFrame$lambda$4$lambda$3$lambda$2$lambda$1(Function1 $bufferAvailable, HardwareBuffer $buffer) {
        Intrinsics.checkNotNullParameter((Object)$bufferAvailable, (String)"$bufferAvailable");
        $bufferAvailable.invoke((Object)$buffer);
    }

    private static final void renderFrame$lambda$4$lambda$3(MultiBufferedCanvasRenderer this$0, Executor $executor, Function1 $bufferAvailable) {
        block1: {
            Image nextImage;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
            Intrinsics.checkNotNullParameter((Object)$bufferAvailable, (String)"$bufferAvailable");
            Image image = nextImage = this$0.mImageReader.acquireNextImage();
            if (image == null) break block1;
            Image image2 = image;
            boolean bl = false;
            HardwareBuffer buffer = image2.getHardwareBuffer();
            if (buffer != null) {
                $executor.execute(() -> MultiBufferedCanvasRenderer.renderFrame$lambda$4$lambda$3$lambda$2$lambda$1($bufferAvailable, buffer));
            }
            image2.close();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/graphics/MultiBufferedCanvasRenderer$Companion;", "", "()V", "TAG", "", "graphics-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

