/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics;

import android.graphics.HardwareRenderer;
import android.graphics.RenderNode;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0016\u001a\u00020\fJ\u0006\u0010\u0017\u001a\u00020\fR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/graphics/SurfaceTextureRenderer;", "", "renderNode", "Landroid/graphics/RenderNode;", "width", "", "height", "handler", "Landroid/os/Handler;", "frameAvailable", "Lkotlin/Function1;", "Landroid/graphics/SurfaceTexture;", "", "(Landroid/graphics/RenderNode;IILandroid/os/Handler;Lkotlin/jvm/functions/Function1;)V", "mHardwareRenderer", "Landroid/graphics/HardwareRenderer;", "mIsReleased", "", "mSurfaceTexture", "Landroidx/graphics/SurfaceTextureRenderer$RenderSurfaceTexture;", "mTextureSurface", "Landroid/view/Surface;", "release", "renderFrame", "Companion", "RenderSurfaceTexture", "graphics-core_release"})
@RequiresApi(value=29)
public final class SurfaceTextureRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RenderNode renderNode;
    @NotNull
    private final Handler handler;
    @NotNull
    private final Function1<SurfaceTexture, Unit> frameAvailable;
    private boolean mIsReleased;
    @NotNull
    private final RenderSurfaceTexture mSurfaceTexture;
    @NotNull
    private final Surface mTextureSurface;
    @NotNull
    private final HardwareRenderer mHardwareRenderer;
    @NotNull
    private static final String TAG = "SurfaceTextureRenderer";

    /*
     * WARNING - void declaration
     */
    public SurfaceTextureRenderer(@NotNull RenderNode renderNode, int width, int height, @NotNull Handler handler, @NotNull Function1<? super SurfaceTexture, Unit> frameAvailable) {
        void $this$mHardwareRenderer_u24lambda_u242;
        RenderSurfaceTexture $this$mSurfaceTexture_u24lambda_u241;
        RenderSurfaceTexture renderSurfaceTexture;
        Intrinsics.checkNotNullParameter((Object)renderNode, (String)"renderNode");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter(frameAvailable, (String)"frameAvailable");
        this.renderNode = renderNode;
        this.handler = handler;
        this.frameAvailable = frameAvailable;
        RenderSurfaceTexture renderSurfaceTexture2 = renderSurfaceTexture = new RenderSurfaceTexture(false);
        SurfaceTextureRenderer surfaceTextureRenderer = this;
        boolean bl = false;
        $this$mSurfaceTexture_u24lambda_u241.setDefaultBufferSize(width, height);
        $this$mSurfaceTexture_u24lambda_u241.setOnFrameAvailableListener(arg_0 -> SurfaceTextureRenderer.mSurfaceTexture$lambda$1$lambda$0(this, arg_0), this.handler);
        surfaceTextureRenderer.mSurfaceTexture = renderSurfaceTexture;
        this.mTextureSurface = new Surface((SurfaceTexture)this.mSurfaceTexture);
        $this$mSurfaceTexture_u24lambda_u241 = renderSurfaceTexture = new HardwareRenderer();
        surfaceTextureRenderer = this;
        boolean bl2 = false;
        $this$mHardwareRenderer_u24lambda_u242.setSurface(this.mTextureSurface);
        $this$mHardwareRenderer_u24lambda_u242.setContentRoot(this.renderNode);
        $this$mHardwareRenderer_u24lambda_u242.start();
        surfaceTextureRenderer.mHardwareRenderer = renderSurfaceTexture;
    }

    public final void renderFrame() {
        if (!this.mIsReleased) {
            HardwareRenderer hardwareRenderer;
            HardwareRenderer $this$renderFrame_u24lambda_u243 = hardwareRenderer = this.mHardwareRenderer;
            boolean bl = false;
            $this$renderFrame_u24lambda_u243.createRenderRequest().setWaitForPresent(false).syncAndDraw();
        } else {
            Log.w((String)TAG, (String)"Attempt to renderFrame when SurfaceTextureRenderer has already been released");
        }
    }

    public final void release() {
        if (!this.mIsReleased) {
            this.mHardwareRenderer.stop();
            this.mHardwareRenderer.destroy();
            this.mTextureSurface.release();
            if (!this.mSurfaceTexture.isReleased()) {
                this.mSurfaceTexture.release();
            }
            this.mIsReleased = true;
        } else {
            Log.w((String)TAG, (String)"Attempt to release a SurfaceTextureRenderer that has already been released");
        }
    }

    private static final void mSurfaceTexture$lambda$1$lambda$0(SurfaceTextureRenderer this$0, SurfaceTexture surfaceTexture) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Function1<SurfaceTexture, Unit> function1 = this$0.frameAvailable;
        Intrinsics.checkNotNullExpressionValue((Object)surfaceTexture, (String)"surfaceTexture");
        function1.invoke((Object)surfaceTexture);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/graphics/SurfaceTextureRenderer$Companion;", "", "()V", "TAG", "", "graphics-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Landroidx/graphics/SurfaceTextureRenderer$RenderSurfaceTexture;", "Landroid/graphics/SurfaceTexture;", "singleBufferMode", "", "(Z)V", "graphics-core_release"})
    private static final class RenderSurfaceTexture
    extends SurfaceTexture {
        public RenderSurfaceTexture(boolean singleBufferMode) {
            super(singleBufferMode);
        }
    }
}

