/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.lowlatency;

import android.os.Build;
import android.util.Log;
import android.view.Display;
import android.view.View;
import androidx.graphics.lowlatency.TransformHintHelper;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001d\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u000b\u00a8\u0006\r"}, d2={"Landroidx/graphics/lowlatency/BufferTransformHintResolver;", "", "()V", "getBufferTransformHint", "", "view", "Landroid/view/View;", "getBufferTransformHintFromInstallOrientation", "orientation", "", "rotation", "getBufferTransformHintFromInstallOrientation$graphics_core_release", "Companion", "graphics-core_release"})
public final class BufferTransformHintResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TAG = "TRANSFORM_HINT_RESOLVER";
    public static final int UNKNOWN_TRANSFORM = -1;
    @NotNull
    public static final String ORIENTATION_0 = "ORIENTATION_0";
    @NotNull
    public static final String ORIENTATION_90 = "ORIENTATION_90";
    @NotNull
    public static final String ORIENTATION_180 = "ORIENTATION_180";
    @NotNull
    public static final String ORIENTATION_270 = "ORIENTATION_270";

    public final int getBufferTransformHint(@NotNull View view) {
        int n;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (Build.VERSION.SDK_INT >= 32) {
            return TransformHintHelper.Companion.resolveBufferTransformHint(view);
        }
        String orientation = null;
        try {
            int n2;
            Integer rotation;
            orientation = Companion.getDisplayOrientation();
            Display display = view.getDisplay();
            Integer n3 = rotation = display != null ? Integer.valueOf(display.getRotation()) : null;
            if (rotation != null) {
                int transform = this.getBufferTransformHintFromInstallOrientation$graphics_core_release(orientation, rotation);
                Log.v((String)TAG, (String)("Obtained transform: " + transform + " for orientation: " + orientation));
                n2 = transform;
            } else {
                Log.w((String)TAG, (String)"Unable to obtain current display rotation");
                n2 = -1;
            }
            n = n2;
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)"Unable to obtain current display orientation");
            n = -1;
        }
        return n;
    }

    public final int getBufferTransformHintFromInstallOrientation$graphics_core_release(@NotNull String orientation, int rotation) {
        int n;
        Intrinsics.checkNotNullParameter((Object)orientation, (String)"orientation");
        block6 : switch (orientation) {
            case "ORIENTATION_90": {
                switch (rotation) {
                    case 0: {
                        n = 4;
                        break block6;
                    }
                    case 1: {
                        n = 3;
                        break block6;
                    }
                    case 2: {
                        n = 7;
                        break block6;
                    }
                    case 3: {
                        n = 0;
                        break block6;
                    }
                }
                n = -1;
                break;
            }
            case "ORIENTATION_180": {
                switch (rotation) {
                    case 0: {
                        n = 3;
                        break block6;
                    }
                    case 1: {
                        n = 7;
                        break block6;
                    }
                    case 2: {
                        n = 0;
                        break block6;
                    }
                    case 3: {
                        n = 4;
                        break block6;
                    }
                }
                n = -1;
                break;
            }
            case "ORIENTATION_270": {
                switch (rotation) {
                    case 0: {
                        n = 7;
                        break block6;
                    }
                    case 1: {
                        n = 0;
                        break block6;
                    }
                    case 2: {
                        n = 4;
                        break block6;
                    }
                    case 3: {
                        n = 3;
                        break block6;
                    }
                }
                n = -1;
                break;
            }
            case "ORIENTATION_0": {
                switch (rotation) {
                    case 0: {
                        n = 0;
                        break block6;
                    }
                    case 1: {
                        n = 4;
                        break block6;
                    }
                    case 2: {
                        n = 3;
                        break block6;
                    }
                    case 3: {
                        n = 7;
                        break block6;
                    }
                }
                n = -1;
                break;
            }
            default: {
                Log.w((String)TAG, (String)("Unknown orientation \"" + orientation + '\"'));
                n = -1;
            }
        }
        return n;
    }

    @JvmStatic
    @NotNull
    public static final native String getDisplayOrientation();

    static {
        System.loadLibrary("graphics-core");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u000b\u001a\u00020\u0004H\u0087 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Landroidx/graphics/lowlatency/BufferTransformHintResolver$Companion;", "", "()V", "ORIENTATION_0", "", "ORIENTATION_180", "ORIENTATION_270", "ORIENTATION_90", "TAG", "UNKNOWN_TRANSFORM", "", "getDisplayOrientation", "graphics-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String getDisplayOrientation() {
            return BufferTransformHintResolver.getDisplayOrientation();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

