/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.lowlatency;

import android.opengl.Matrix;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Landroidx/graphics/lowlatency/BufferTransformer;", "", "()V", "<set-?>", "", "glHeight", "getGlHeight", "()I", "glWidth", "getGlWidth", "mViewTransform", "", "transform", "getTransform", "()[F", "computeTransform", "", "width", "height", "transformHint", "invertBufferTransform", "graphics-core_release"})
public final class BufferTransformer {
    @NotNull
    private final float[] mViewTransform = new float[16];
    private int glWidth;
    private int glHeight;

    @NotNull
    public final float[] getTransform() {
        return this.mViewTransform;
    }

    public final int getGlWidth() {
        return this.glWidth;
    }

    public final int getGlHeight() {
        return this.glHeight;
    }

    public final int invertBufferTransform(int transform) {
        int n;
        switch (transform) {
            case 4: {
                n = 7;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 7: {
                n = 4;
                break;
            }
            case 0: {
                n = 0;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    public final void computeTransform(int width, int height, int transformHint) {
        float fWidth = width;
        float fHeight = height;
        this.glWidth = width;
        this.glHeight = height;
        switch (transformHint) {
            case 4: {
                Matrix.setRotateM((float[])this.mViewTransform, (int)0, (float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                Matrix.translateM((float[])this.mViewTransform, (int)0, (float)(-fWidth), (float)0.0f, (float)0.0f);
                this.glWidth = height;
                this.glHeight = width;
                break;
            }
            case 3: {
                Matrix.setRotateM((float[])this.mViewTransform, (int)0, (float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                Matrix.translateM((float[])this.mViewTransform, (int)0, (float)(-fWidth), (float)(-fHeight), (float)0.0f);
                break;
            }
            case 7: {
                Matrix.setRotateM((float[])this.mViewTransform, (int)0, (float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                Matrix.translateM((float[])this.mViewTransform, (int)0, (float)0.0f, (float)(-fHeight), (float)0.0f);
                this.glWidth = height;
                this.glHeight = width;
                break;
            }
            default: {
                Matrix.setIdentityM((float[])this.mViewTransform, (int)0);
            }
        }
    }
}

