/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.lowlatency;

import android.graphics.Canvas;
import android.graphics.SurfaceTexture;
import android.hardware.HardwareBuffer;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.graphics.lowlatency.BufferTransformer;
import androidx.graphics.lowlatency.FrontBufferSyncStrategy;
import androidx.graphics.lowlatency.FrontBufferUtils;
import androidx.graphics.lowlatency.SingleBufferedCanvasRenderer;
import androidx.graphics.lowlatency.SingleBufferedCanvasRendererV29;
import androidx.graphics.lowlatency.TextureProducer;
import androidx.graphics.opengl.FrameBuffer;
import androidx.graphics.opengl.FrameBufferRenderer;
import androidx.graphics.opengl.GLRenderer;
import androidx.graphics.opengl.QuadTextureRenderer;
import androidx.graphics.opengl.egl.EGLManager;
import androidx.graphics.opengl.egl.EGLSpec;
import androidx.hardware.SyncFenceCompat;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 9*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u00019B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010\fJ\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000201H\u0016J \u00103\u001a\u0002012\u0006\u00100\u001a\u00020\u00142\u000e\u00104\u001a\n\u0012\u0004\u0012\u000201\u0018\u000105H\u0016J\u0015\u00106\u001a\u0002012\u0006\u00107\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00108R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Landroidx/graphics/lowlatency/SingleBufferedCanvasRendererV29;", "T", "Landroidx/graphics/lowlatency/SingleBufferedCanvasRenderer;", "width", "", "height", "bufferTransformer", "Landroidx/graphics/lowlatency/BufferTransformer;", "executor", "Ljava/util/concurrent/Executor;", "callbacks", "Landroidx/graphics/lowlatency/SingleBufferedCanvasRenderer$RenderCallbacks;", "(IILandroidx/graphics/lowlatency/BufferTransformer;Ljava/util/concurrent/Executor;Landroidx/graphics/lowlatency/SingleBufferedCanvasRenderer$RenderCallbacks;)V", "buffer", "", "forceFlush", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getForceFlush$graphics_core_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "value", "", "isVisible", "()Z", "setVisible", "(Z)V", "mClearRunnable", "Ljava/lang/Runnable;", "mFrameBufferRenderer", "Landroidx/graphics/opengl/FrameBufferRenderer;", "mFrameBufferTarget", "Landroidx/graphics/opengl/GLRenderer$RenderTarget;", "mFrontBufferLayer", "Landroidx/graphics/opengl/FrameBuffer;", "mFrontBufferSyncStrategy", "Landroidx/graphics/lowlatency/FrontBufferSyncStrategy;", "mGLRenderer", "Landroidx/graphics/opengl/GLRenderer;", "mHardwareBufferUsageFlags", "", "mIsReleased", "mIsVisible", "mProducer", "Landroidx/graphics/lowlatency/TextureProducer;", "mQuadRenderer", "Landroidx/graphics/opengl/QuadTextureRenderer;", "mSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "mTextureId", "cancelPending", "", "clear", "release", "onReleaseComplete", "Lkotlin/Function0;", "render", "param", "(Ljava/lang/Object;)V", "Companion", "graphics-core_release"})
@RequiresApi(value=29)
@SourceDebugExtension(value={"SMAP\nSingleBufferedCanvasRendererV29.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleBufferedCanvasRendererV29.kt\nandroidx/graphics/lowlatency/SingleBufferedCanvasRendererV29\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,270:1\n1#2:271\n*E\n"})
public final class SingleBufferedCanvasRendererV29<T>
implements SingleBufferedCanvasRenderer<T> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final int width;
    private final int height;
    @NotNull
    private final BufferTransformer bufferTransformer;
    @NotNull
    private final Executor executor;
    @NotNull
    private final SingleBufferedCanvasRenderer.RenderCallbacks<T> callbacks;
    @NotNull
    private final TextureProducer<T> mProducer;
    @Nullable
    private SurfaceTexture mSurfaceTexture;
    private final long mHardwareBufferUsageFlags;
    @NotNull
    private final FrontBufferSyncStrategy mFrontBufferSyncStrategy;
    @Nullable
    private QuadTextureRenderer mQuadRenderer;
    private int mTextureId;
    @NotNull
    private final int[] buffer;
    @NotNull
    private final FrameBufferRenderer mFrameBufferRenderer;
    @NotNull
    private final GLRenderer mGLRenderer;
    @NotNull
    private GLRenderer.RenderTarget mFrameBufferTarget;
    private boolean mIsVisible;
    private boolean mIsReleased;
    @Nullable
    private FrameBuffer mFrontBufferLayer;
    @NotNull
    private final Runnable mClearRunnable;
    @NotNull
    private final AtomicBoolean forceFlush;
    @Deprecated
    @NotNull
    public static final String TAG = "SingleBufferedCanvasV29";

    /*
     * WARNING - void declaration
     */
    public SingleBufferedCanvasRendererV29(int width, int height, @NotNull BufferTransformer bufferTransformer, @NotNull Executor executor, @NotNull SingleBufferedCanvasRenderer.RenderCallbacks<T> callbacks) {
        void $this$mGLRenderer_u24lambda_u240;
        GLRenderer gLRenderer;
        Intrinsics.checkNotNullParameter((Object)bufferTransformer, (String)"bufferTransformer");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(callbacks, (String)"callbacks");
        this.width = width;
        this.height = height;
        this.bufferTransformer = bufferTransformer;
        this.executor = executor;
        this.callbacks = callbacks;
        this.mProducer = new TextureProducer(this.width, this.height, new TextureProducer.Callbacks<T>(this){
            final /* synthetic */ SingleBufferedCanvasRendererV29<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public void onTextureAvailable(@NotNull SurfaceTexture texture) {
                Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
                SingleBufferedCanvasRendererV29.access$setMSurfaceTexture$p(this.this$0, texture);
                GLRenderer.RenderTarget.requestRender$default(SingleBufferedCanvasRendererV29.access$getMFrameBufferTarget$p(this.this$0), null, 1, null);
            }

            public void render(@NotNull Canvas canvas, int width, int height, T param) {
                Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
                SingleBufferedCanvasRendererV29.access$getCallbacks$p(this.this$0).render(canvas, width, height, param);
            }
        });
        this.mHardwareBufferUsageFlags = FrontBufferUtils.Companion.obtainHardwareBufferUsageFlags$graphics_core_release();
        this.mFrontBufferSyncStrategy = new FrontBufferSyncStrategy(this.mHardwareBufferUsageFlags);
        this.mTextureId = -1;
        this.buffer = new int[1];
        this.mFrameBufferRenderer = new FrameBufferRenderer(new FrameBufferRenderer.RenderCallback(this){
            @NotNull
            private final float[] mMVPMatrix;
            @NotNull
            private final float[] mProjection;
            final /* synthetic */ SingleBufferedCanvasRendererV29<T> this$0;
            {
                this.this$0 = $receiver;
                this.mMVPMatrix = new float[16];
                this.mProjection = new float[16];
            }

            private final QuadTextureRenderer obtainQuadRenderer() {
                QuadTextureRenderer quadTextureRenderer = SingleBufferedCanvasRendererV29.access$getMQuadRenderer$p(this.this$0);
                if (quadTextureRenderer == null) {
                    QuadTextureRenderer quadTextureRenderer2 = new QuadTextureRenderer();
                    SingleBufferedCanvasRendererV29<T> singleBufferedCanvasRendererV29 = this.this$0;
                    QuadTextureRenderer $this$obtainQuadRenderer_u24lambda_u241 = quadTextureRenderer2;
                    boolean bl = false;
                    GLES20.glGenTextures((int)1, (int[])SingleBufferedCanvasRendererV29.access$getBuffer$p(singleBufferedCanvasRendererV29), (int)0);
                    SingleBufferedCanvasRendererV29.access$setMTextureId$p(singleBufferedCanvasRendererV29, SingleBufferedCanvasRendererV29.access$getBuffer$p(singleBufferedCanvasRendererV29)[0]);
                    SurfaceTexture surfaceTexture = SingleBufferedCanvasRendererV29.access$getMSurfaceTexture$p(singleBufferedCanvasRendererV29);
                    if (surfaceTexture != null) {
                        SurfaceTexture texture = surfaceTexture;
                        boolean bl2 = false;
                        texture.attachToGLContext(SingleBufferedCanvasRendererV29.access$getMTextureId$p(singleBufferedCanvasRendererV29));
                        $this$obtainQuadRenderer_u24lambda_u241.setSurfaceTexture$graphics_core_release(texture);
                    }
                    SingleBufferedCanvasRendererV29.access$setMQuadRenderer$p(singleBufferedCanvasRendererV29, $this$obtainQuadRenderer_u24lambda_u241);
                    quadTextureRenderer = quadTextureRenderer2;
                }
                return quadTextureRenderer;
            }

            @NotNull
            public FrameBuffer obtainFrameBuffer(@NotNull EGLSpec egl) {
                Intrinsics.checkNotNullParameter((Object)egl, (String)"egl");
                FrameBuffer frameBuffer = SingleBufferedCanvasRendererV29.access$getMFrontBufferLayer$p(this.this$0);
                if (frameBuffer == null) {
                    HardwareBuffer hardwareBuffer = HardwareBuffer.create((int)SingleBufferedCanvasRendererV29.access$getBufferTransformer$p(this.this$0).getGlWidth(), (int)SingleBufferedCanvasRendererV29.access$getBufferTransformer$p(this.this$0).getGlHeight(), (int)1, (int)1, (long)SingleBufferedCanvasRendererV29.access$getMHardwareBufferUsageFlags$p(this.this$0));
                    Intrinsics.checkNotNullExpressionValue((Object)hardwareBuffer, (String)"create(\n                \u2026ags\n                    )");
                    FrameBuffer frameBuffer2 = new FrameBuffer(egl, hardwareBuffer);
                    SingleBufferedCanvasRendererV29<T> singleBufferedCanvasRendererV29 = this.this$0;
                    FrameBuffer it = frameBuffer2;
                    boolean bl = false;
                    SingleBufferedCanvasRendererV29.access$setMFrontBufferLayer$p(singleBufferedCanvasRendererV29, it);
                    frameBuffer = frameBuffer2;
                }
                return frameBuffer;
            }

            @RequiresApi(value=31)
            public void onDraw(@NotNull EGLManager eglManager) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)eglManager, (String)"eglManager");
                    SurfaceTexture surfaceTexture = SingleBufferedCanvasRendererV29.access$getMSurfaceTexture$p(this.this$0);
                    if (surfaceTexture == null) break block0;
                    SurfaceTexture surfaceTexture2 = surfaceTexture;
                    SingleBufferedCanvasRendererV29<T> singleBufferedCanvasRendererV29 = this.this$0;
                    SurfaceTexture texture = surfaceTexture2;
                    boolean bl = false;
                    int bufferWidth = SingleBufferedCanvasRendererV29.access$getBufferTransformer$p(singleBufferedCanvasRendererV29).getGlWidth();
                    int bufferHeight = SingleBufferedCanvasRendererV29.access$getBufferTransformer$p(singleBufferedCanvasRendererV29).getGlHeight();
                    GLES20.glViewport((int)0, (int)0, (int)bufferWidth, (int)bufferHeight);
                    Matrix.orthoM((float[])this.mMVPMatrix, (int)0, (float)0.0f, (float)bufferWidth, (float)0.0f, (float)bufferHeight, (float)-1.0f, (float)1.0f);
                    Matrix.multiplyMM((float[])this.mProjection, (int)0, (float[])this.mMVPMatrix, (int)0, (float[])SingleBufferedCanvasRendererV29.access$getBufferTransformer$p(singleBufferedCanvasRendererV29).getTransform(), (int)0);
                    this.obtainQuadRenderer().draw(this.mProjection, SingleBufferedCanvasRendererV29.access$getWidth$p(singleBufferedCanvasRendererV29), SingleBufferedCanvasRendererV29.access$getHeight$p(singleBufferedCanvasRendererV29));
                    texture.releaseTexImage();
                    SingleBufferedCanvasRendererV29.access$getMProducer$p(singleBufferedCanvasRendererV29).markTextureConsumed();
                }
            }

            public void onDrawComplete(@NotNull FrameBuffer frameBuffer, @Nullable SyncFenceCompat syncFenceCompat) {
                Intrinsics.checkNotNullParameter((Object)frameBuffer, (String)"frameBuffer");
                if (this.this$0.getForceFlush$graphics_core_release().get()) {
                    GLES20.glReadPixels((int)0, (int)0, (int)1, (int)1, (int)6408, (int)5121, (Buffer)IntBuffer.wrap(new int[1]));
                }
                SingleBufferedCanvasRendererV29.access$getMProducer$p(this.this$0).execute(() -> mFrameBufferRenderer.1.onDrawComplete$lambda$4(this.this$0, frameBuffer, syncFenceCompat));
            }

            private static final void onDrawComplete$lambda$4(SingleBufferedCanvasRendererV29 this$0, FrameBuffer $frameBuffer, SyncFenceCompat $syncFenceCompat) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$frameBuffer, (String)"$frameBuffer");
                SingleBufferedCanvasRendererV29.access$getCallbacks$p(this$0).onBufferReady($frameBuffer.getHardwareBuffer(), $syncFenceCompat);
            }
        }, this.mFrontBufferSyncStrategy);
        GLRenderer gLRenderer2 = gLRenderer = new GLRenderer(null, null, 3, null);
        SingleBufferedCanvasRendererV29 singleBufferedCanvasRendererV29 = this;
        boolean bl = false;
        GLRenderer.start$default((GLRenderer)$this$mGLRenderer_u24lambda_u240, null, 1, null);
        singleBufferedCanvasRendererV29.mGLRenderer = gLRenderer;
        this.mFrameBufferTarget = this.mGLRenderer.createRenderTarget(this.width, this.height, this.mFrameBufferRenderer);
        this.mClearRunnable = () -> SingleBufferedCanvasRendererV29.mClearRunnable$lambda$2(this);
        this.forceFlush = new AtomicBoolean(false);
    }

    @Override
    public boolean isVisible() {
        return this.mFrontBufferSyncStrategy.isVisible();
    }

    @Override
    public void setVisible(boolean value) {
        this.mGLRenderer.execute(() -> SingleBufferedCanvasRendererV29._set_isVisible_$lambda$1(this, value));
        this.mIsVisible = value;
    }

    @Override
    public void render(T param) {
        if (!this.mIsReleased) {
            this.mProducer.requestRender(param);
        } else {
            Log.w((String)TAG, (String)"Attempt to render with CanvasRenderer that has already been released");
        }
    }

    @Override
    public void release(boolean cancelPending, @Nullable Function0<Unit> onReleaseComplete) {
        if (!this.mIsReleased) {
            if (cancelPending) {
                this.mProducer.cancelPending();
            }
            this.mProducer.release(cancelPending, (Function0<Unit>)((Function0)new Function0<Unit>(this, onReleaseComplete){
                final /* synthetic */ SingleBufferedCanvasRendererV29<T> this$0;
                final /* synthetic */ Function0<Unit> $onReleaseComplete;
                {
                    this.this$0 = $receiver;
                    this.$onReleaseComplete = $onReleaseComplete;
                    super(0);
                }

                public final void invoke() {
                    block0: {
                        SingleBufferedCanvasRendererV29.access$getMFrameBufferTarget$p(this.this$0).detach(true, (Function1<? super GLRenderer.RenderTarget, Unit>)((Function1)new Function1<GLRenderer.RenderTarget, Unit>(this.this$0){
                            final /* synthetic */ SingleBufferedCanvasRendererV29<T> this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull GLRenderer.RenderTarget it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                QuadTextureRenderer quadTextureRenderer = SingleBufferedCanvasRendererV29.access$getMQuadRenderer$p(this.this$0);
                                if (quadTextureRenderer != null) {
                                    quadTextureRenderer.release();
                                }
                                if (SingleBufferedCanvasRendererV29.access$getMTextureId$p(this.this$0) != -1) {
                                    SingleBufferedCanvasRendererV29.access$getBuffer$p(this.this$0)[0] = SingleBufferedCanvasRendererV29.access$getMTextureId$p(this.this$0);
                                    GLES20.glDeleteTextures((int)1, (int[])SingleBufferedCanvasRendererV29.access$getBuffer$p(this.this$0), (int)0);
                                    SingleBufferedCanvasRendererV29.access$setMTextureId$p(this.this$0, -1);
                                }
                            }
                        }));
                        GLRenderer.stop$default(SingleBufferedCanvasRendererV29.access$getMGLRenderer$p(this.this$0), true, null, 2, null);
                        Function0<Unit> function0 = this.$onReleaseComplete;
                        if (function0 == null) break block0;
                        function0.invoke();
                    }
                }
            }));
            this.mIsReleased = true;
        } else {
            Log.w((String)TAG, (String)"Attempt to release CanvasRenderer that has already been released");
        }
    }

    @Override
    public void cancelPending() {
        if (!this.mIsReleased) {
            this.mProducer.cancelPending();
        } else {
            Log.w((String)TAG, (String)"Attempt to cancel pending requests when the CanvasRender has already been released");
        }
    }

    @Override
    public void clear() {
        if (!this.mIsReleased) {
            this.mProducer.execute(this.mClearRunnable);
        } else {
            Log.w((String)TAG, (String)"Attempt to clear contents when the CanvasRenderer has already been released");
        }
    }

    @NotNull
    public final AtomicBoolean getForceFlush$graphics_core_release() {
        return this.forceFlush;
    }

    private static final void _set_isVisible_$lambda$1(SingleBufferedCanvasRendererV29 this$0, boolean $value) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.mFrontBufferSyncStrategy.setVisible($value);
    }

    private static final void mClearRunnable$lambda$2(SingleBufferedCanvasRendererV29 this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.mFrameBufferRenderer.clear();
        GLRenderer.RenderTarget.requestRender$default(this$0.mFrameBufferTarget, null, 1, null);
    }

    public static final /* synthetic */ GLRenderer.RenderTarget access$getMFrameBufferTarget$p(SingleBufferedCanvasRendererV29 $this) {
        return $this.mFrameBufferTarget;
    }

    public static final /* synthetic */ QuadTextureRenderer access$getMQuadRenderer$p(SingleBufferedCanvasRendererV29 $this) {
        return $this.mQuadRenderer;
    }

    public static final /* synthetic */ int access$getMTextureId$p(SingleBufferedCanvasRendererV29 $this) {
        return $this.mTextureId;
    }

    public static final /* synthetic */ int[] access$getBuffer$p(SingleBufferedCanvasRendererV29 $this) {
        return $this.buffer;
    }

    public static final /* synthetic */ void access$setMTextureId$p(SingleBufferedCanvasRendererV29 $this, int n) {
        $this.mTextureId = n;
    }

    public static final /* synthetic */ GLRenderer access$getMGLRenderer$p(SingleBufferedCanvasRendererV29 $this) {
        return $this.mGLRenderer;
    }

    public static final /* synthetic */ void access$setMSurfaceTexture$p(SingleBufferedCanvasRendererV29 $this, SurfaceTexture surfaceTexture) {
        $this.mSurfaceTexture = surfaceTexture;
    }

    public static final /* synthetic */ SingleBufferedCanvasRenderer.RenderCallbacks access$getCallbacks$p(SingleBufferedCanvasRendererV29 $this) {
        return $this.callbacks;
    }

    public static final /* synthetic */ FrameBuffer access$getMFrontBufferLayer$p(SingleBufferedCanvasRendererV29 $this) {
        return $this.mFrontBufferLayer;
    }

    public static final /* synthetic */ BufferTransformer access$getBufferTransformer$p(SingleBufferedCanvasRendererV29 $this) {
        return $this.bufferTransformer;
    }

    public static final /* synthetic */ long access$getMHardwareBufferUsageFlags$p(SingleBufferedCanvasRendererV29 $this) {
        return $this.mHardwareBufferUsageFlags;
    }

    public static final /* synthetic */ SurfaceTexture access$getMSurfaceTexture$p(SingleBufferedCanvasRendererV29 $this) {
        return $this.mSurfaceTexture;
    }

    public static final /* synthetic */ TextureProducer access$getMProducer$p(SingleBufferedCanvasRendererV29 $this) {
        return $this.mProducer;
    }

    public static final /* synthetic */ void access$setMQuadRenderer$p(SingleBufferedCanvasRendererV29 $this, QuadTextureRenderer quadTextureRenderer) {
        $this.mQuadRenderer = quadTextureRenderer;
    }

    public static final /* synthetic */ void access$setMFrontBufferLayer$p(SingleBufferedCanvasRendererV29 $this, FrameBuffer frameBuffer) {
        $this.mFrontBufferLayer = frameBuffer;
    }

    public static final /* synthetic */ int access$getWidth$p(SingleBufferedCanvasRendererV29 $this) {
        return $this.width;
    }

    public static final /* synthetic */ int access$getHeight$p(SingleBufferedCanvasRendererV29 $this) {
        return $this.height;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/graphics/lowlatency/SingleBufferedCanvasRendererV29$Companion;", "", "()V", "TAG", "", "graphics-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

