/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.lowlatency;

import android.graphics.Canvas;
import android.graphics.RecordingCanvas;
import android.graphics.RenderNode;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import androidx.annotation.AnyThread;
import androidx.annotation.RequiresApi;
import androidx.annotation.WorkerThread;
import androidx.graphics.SurfaceTextureRenderer;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 4*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u000234B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010!\u001a\u00020\u001bH\u0007J\b\u0010\"\u001a\u00020\u001bH\u0003J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%H\u0007J\b\u0010&\u001a\u00020\u000eH\u0003J\b\u0010'\u001a\u00020\u001bH\u0007J\"\u0010(\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u000e2\u0010\b\u0002\u0010)\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aH\u0007J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%H\u0007J\u0015\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00028\u0000H\u0007\u00a2\u0006\u0002\u0010-J\b\u0010.\u001a\u00020\u001bH\u0003J!\u0010/\u001a\u00020\u001b*\u00020\u001d2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u001b01H\u0082\bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0010j\b\u0012\u0004\u0012\u00028\u0000`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\f\u00a8\u00065"}, d2={"Landroidx/graphics/lowlatency/TextureProducer;", "T", "", "width", "", "height", "callbacks", "Landroidx/graphics/lowlatency/TextureProducer$Callbacks;", "(IILandroidx/graphics/lowlatency/TextureProducer$Callbacks;)V", "getCallbacks", "()Landroidx/graphics/lowlatency/TextureProducer$Callbacks;", "getHeight", "()I", "mIsReleasing", "", "mParams", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "mPendingRenders", "mProducerHandler", "Landroid/os/Handler;", "getMProducerHandler$annotations", "()V", "mProducerThread", "Landroid/os/HandlerThread;", "mReleaseCallback", "Lkotlin/Function0;", "", "mRenderNode", "Landroid/graphics/RenderNode;", "mSurfaceTextureRenderer", "Landroidx/graphics/SurfaceTextureRenderer;", "getWidth", "cancelPending", "doRender", "execute", "runnable", "Ljava/lang/Runnable;", "isPendingRendering", "markTextureConsumed", "release", "onReleaseComplete", "remove", "requestRender", "param", "(Ljava/lang/Object;)V", "teardown", "record", "block", "Lkotlin/Function1;", "Landroid/graphics/Canvas;", "Callbacks", "Companion", "graphics-core_release"})
@RequiresApi(value=29)
@SourceDebugExtension(value={"SMAP\nTextureProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextureProducer.kt\nandroidx/graphics/lowlatency/TextureProducer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n106#1,4:202\n1#2:201\n*S KotlinDebug\n*F\n+ 1 TextureProducer.kt\nandroidx/graphics/lowlatency/TextureProducer\n*L\n124#1:202,4\n*E\n"})
public final class TextureProducer<T> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final int width;
    private final int height;
    @NotNull
    private final Callbacks<T> callbacks;
    private boolean mIsReleasing;
    @Nullable
    private Function0<Unit> mReleaseCallback;
    @NotNull
    private final ArrayList<T> mParams;
    private int mPendingRenders;
    @NotNull
    private final HandlerThread mProducerThread;
    @NotNull
    private final Handler mProducerHandler;
    @NotNull
    private final RenderNode mRenderNode;
    @NotNull
    private final SurfaceTextureRenderer mSurfaceTextureRenderer;
    @Deprecated
    public static final int RENDER = 0;
    @Deprecated
    public static final int TEXTURE_CONSUMED = 1;
    @Deprecated
    public static final int CANCEL_PENDING = 2;
    @Deprecated
    public static final int RELEASE = 3;
    @Deprecated
    public static final int MAX_PENDING_RENDERS = 2;

    /*
     * WARNING - void declaration
     */
    public TextureProducer(int width, int height, @NotNull Callbacks<T> callbacks) {
        void $this$mRenderNode_u24lambda_u242;
        HandlerThread $this$mProducerThread_u24lambda_u240;
        HandlerThread handlerThread;
        Intrinsics.checkNotNullParameter(callbacks, (String)"callbacks");
        this.width = width;
        this.height = height;
        this.callbacks = callbacks;
        this.mParams = new ArrayList();
        HandlerThread handlerThread2 = handlerThread = new HandlerThread("producerThread");
        TextureProducer textureProducer = this;
        boolean bl = false;
        $this$mProducerThread_u24lambda_u240.start();
        textureProducer.mProducerThread = handlerThread;
        this.mProducerHandler = new Handler(this.mProducerThread.getLooper(), arg_0 -> TextureProducer.mProducerHandler$lambda$1(this, arg_0));
        $this$mProducerThread_u24lambda_u240 = handlerThread = new RenderNode("node");
        textureProducer = this;
        boolean bl2 = false;
        $this$mRenderNode_u24lambda_u242.setPosition(0, 0, this.width, this.height);
        textureProducer.mRenderNode = handlerThread;
        this.mSurfaceTextureRenderer = new SurfaceTextureRenderer(this.mRenderNode, this.width, this.height, this.mProducerHandler, (Function1<? super SurfaceTexture, Unit>)((Function1)new Function1<SurfaceTexture, Unit>(this){
            final /* synthetic */ TextureProducer<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull SurfaceTexture texture) {
                Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
                this.this$0.getCallbacks().onTextureAvailable(texture);
            }
        }));
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final Callbacks<T> getCallbacks() {
        return this.callbacks;
    }

    private static /* synthetic */ void getMProducerHandler$annotations() {
    }

    @WorkerThread
    private final void teardown() {
        Function0<Unit> function0 = this.mReleaseCallback;
        if (function0 != null) {
            function0.invoke();
        }
        this.mSurfaceTextureRenderer.release();
        this.mProducerThread.quit();
    }

    @WorkerThread
    private final boolean isPendingRendering() {
        return !((Collection)this.mParams).isEmpty() || this.mPendingRenders > 0;
    }

    private final void record(RenderNode $this$record, Function1<? super Canvas, Unit> block) {
        boolean $i$f$record = false;
        RecordingCanvas recordingCanvas = $this$record.beginRecording();
        Intrinsics.checkNotNullExpressionValue((Object)recordingCanvas, (String)"beginRecording()");
        RecordingCanvas canvas = recordingCanvas;
        block.invoke((Object)canvas);
        $this$record.endRecording();
    }

    @WorkerThread
    private final void doRender() {
        if (this.mPendingRenders < 2 && !((Collection)this.mParams).isEmpty()) {
            TextureProducer textureProducer = this;
            RenderNode $this$record$iv = this.mRenderNode;
            boolean $i$f$record = false;
            RecordingCanvas recordingCanvas = $this$record$iv.beginRecording();
            Intrinsics.checkNotNullExpressionValue((Object)recordingCanvas, (String)"beginRecording()");
            RecordingCanvas canvas$iv = recordingCanvas;
            Canvas canvas = (Canvas)canvas$iv;
            boolean bl = false;
            for (T p : this.mParams) {
                this.callbacks.render(canvas, this.width, this.height, p);
            }
            $this$record$iv.endRecording();
            this.mParams.clear();
            int n = this.mPendingRenders;
            this.mPendingRenders = n + 1;
            this.mSurfaceTextureRenderer.renderFrame();
        }
    }

    @AnyThread
    public final void requestRender(T param) {
        this.mProducerHandler.sendMessage(Message.obtain((Handler)this.mProducerHandler, (int)0, param));
    }

    @AnyThread
    public final void cancelPending() {
        this.mProducerHandler.removeMessages(0);
        this.mProducerHandler.sendMessage(Message.obtain((Handler)this.mProducerHandler, (int)2));
    }

    @AnyThread
    public final void markTextureConsumed() {
        this.mProducerHandler.sendMessage(Message.obtain((Handler)this.mProducerHandler, (int)1));
    }

    @AnyThread
    public final void execute(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.mProducerHandler.post(runnable);
    }

    @AnyThread
    public final void remove(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.mProducerHandler.removeCallbacks(runnable);
    }

    @AnyThread
    public final void release(boolean cancelPending, @Nullable Function0<Unit> onReleaseComplete) {
        if (cancelPending) {
            this.cancelPending();
        }
        this.mProducerHandler.sendMessage(Message.obtain((Handler)this.mProducerHandler, (int)3, onReleaseComplete));
    }

    public static /* synthetic */ void release$default(TextureProducer textureProducer, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = null;
        }
        textureProducer.release(bl, (Function0<Unit>)function0);
    }

    private static final boolean mProducerHandler$lambda$1(TextureProducer this$0, Message message) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        switch (message.what) {
            case 0: {
                if (this$0.mIsReleasing) break;
                Object param = message.obj;
                this$0.mParams.add(param);
                this$0.doRender();
                break;
            }
            case 1: {
                int n = this$0.mPendingRenders;
                this$0.mPendingRenders = n + -1;
                if (this$0.mIsReleasing && !this$0.isPendingRendering()) {
                    this$0.teardown();
                    break;
                }
                this$0.doRender();
                break;
            }
            case 2: {
                this$0.mParams.clear();
                break;
            }
            case 3: {
                this$0.mIsReleasing = true;
                this$0.mReleaseCallback = (Function0)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)message.obj, (int)0);
                if (this$0.isPendingRendering()) break;
                this$0.teardown();
            }
        }
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J-\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Landroidx/graphics/lowlatency/TextureProducer$Callbacks;", "T", "", "onTextureAvailable", "", "texture", "Landroid/graphics/SurfaceTexture;", "render", "canvas", "Landroid/graphics/Canvas;", "width", "", "height", "param", "(Landroid/graphics/Canvas;IILjava/lang/Object;)V", "graphics-core_release"})
    public static interface Callbacks<T> {
        public void onTextureAvailable(@NotNull SurfaceTexture var1);

        public void render(@NotNull Canvas var1, int var2, int var3, T var4);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/graphics/lowlatency/TextureProducer$Companion;", "", "()V", "CANCEL_PENDING", "", "MAX_PENDING_RENDERS", "RELEASE", "RENDER", "TEXTURE_CONSUMED", "graphics-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

