/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.opengl;

import android.hardware.HardwareBuffer;
import android.opengl.GLES20;
import androidx.annotation.RequiresApi;
import androidx.graphics.opengl.egl.EGLSpec;
import androidx.opengl.EGLExt;
import androidx.opengl.EGLImageKHR;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/graphics/opengl/FrameBuffer;", "Ljava/lang/AutoCloseable;", "egl", "Landroidx/graphics/opengl/egl/EGLSpec;", "hardwareBuffer", "Landroid/hardware/HardwareBuffer;", "(Landroidx/graphics/opengl/egl/EGLSpec;Landroid/hardware/HardwareBuffer;)V", "buffer", "", "eglImage", "Landroidx/opengl/EGLImageKHR;", "<set-?>", "", "frameBuffer", "getFrameBuffer$graphics_core_release", "()I", "getHardwareBuffer", "()Landroid/hardware/HardwareBuffer;", "", "isClosed", "()Z", "texture", "close", "", "makeCurrent", "graphics-core_release"})
@RequiresApi(value=26)
@SourceDebugExtension(value={"SMAP\nFrameBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameBuffer.kt\nandroidx/graphics/opengl/FrameBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public final class FrameBuffer
implements AutoCloseable {
    @NotNull
    private final EGLSpec egl;
    @NotNull
    private final HardwareBuffer hardwareBuffer;
    @Nullable
    private EGLImageKHR eglImage;
    private int texture;
    private int frameBuffer;
    private boolean isClosed;
    @NotNull
    private final int[] buffer;

    public FrameBuffer(@NotNull EGLSpec egl, @NotNull HardwareBuffer hardwareBuffer) {
        EGLImageKHR image;
        Intrinsics.checkNotNullParameter((Object)egl, (String)"egl");
        Intrinsics.checkNotNullParameter((Object)hardwareBuffer, (String)"hardwareBuffer");
        this.egl = egl;
        this.hardwareBuffer = hardwareBuffer;
        this.texture = -1;
        this.frameBuffer = -1;
        this.buffer = new int[1];
        EGLImageKHR eGLImageKHR = this.egl.eglCreateImageFromHardwareBuffer(this.hardwareBuffer);
        if (eGLImageKHR == null) {
            throw new IllegalArgumentException("Unable to create EGLImage from HardwareBuffer");
        }
        this.eglImage = image = eGLImageKHR;
        GLES20.glGenTextures((int)1, (int[])this.buffer, (int)0);
        this.texture = this.buffer[0];
        GLES20.glBindTexture((int)3553, (int)this.texture);
        EGLExt.Companion.glEGLImageTargetTexture2DOES(3553, image);
        GLES20.glGenFramebuffers((int)1, (int[])this.buffer, (int)0);
        this.frameBuffer = this.buffer[0];
    }

    @NotNull
    public final HardwareBuffer getHardwareBuffer() {
        return this.hardwareBuffer;
    }

    public final int getFrameBuffer$graphics_core_release() {
        return this.frameBuffer;
    }

    public final boolean isClosed() {
        return this.isClosed;
    }

    public final void makeCurrent() {
        if (!this.isClosed) {
            GLES20.glBindFramebuffer((int)36160, (int)this.frameBuffer);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.texture, (int)0);
        }
    }

    @Override
    public void close() {
        this.buffer[0] = this.frameBuffer;
        GLES20.glDeleteBuffers((int)1, (int[])this.buffer, (int)0);
        this.frameBuffer = -1;
        this.buffer[0] = this.texture;
        GLES20.glDeleteTextures((int)1, (int[])this.buffer, (int)0);
        this.texture = -1;
        EGLImageKHR eGLImageKHR = this.eglImage;
        if (eGLImageKHR != null) {
            EGLImageKHR it = eGLImageKHR;
            boolean bl = false;
            this.egl.eglDestroyImageKHR(it);
        }
        this.eglImage = null;
        this.hardwareBuffer.close();
        this.isClosed = true;
    }
}

