/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.opengl;

import android.graphics.SurfaceTexture;
import android.opengl.EGLConfig;
import android.opengl.EGLSurface;
import android.os.Handler;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.WorkerThread;
import androidx.graphics.opengl.GLRenderer;
import androidx.graphics.opengl.GLThread;
import androidx.graphics.opengl.egl.EGLManager;
import androidx.graphics.opengl.egl.EGLSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 :2\u00020\u0001:\u0004:;<=B0\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0019\b\u0002\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\u0010\nJ&\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u0017\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001e\u0010#\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eJ0\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(2\u0016\b\u0003\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020%\u0018\u00010\u0006H\u0007J\u000e\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020(J\u000e\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020\u000eJ(\u00100\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00152\u0016\b\u0002\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020%\u0018\u00010\u0006H\u0007J8\u00102\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0016\b\u0002\u00103\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020%\u0018\u00010\u0006H\u0007J\u0012\u00104\u001a\u00020%2\b\b\u0002\u00105\u001a\u000206H\u0007J(\u00107\u001a\u00020%2\u0006\u0010'\u001a\u00020(2\u0016\b\u0002\u00108\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020%\u0018\u00010\u0006H\u0007J\u000e\u00109\u001a\u00020%2\u0006\u0010/\u001a\u00020\u000eR\u001f\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Landroidx/graphics/opengl/GLRenderer;", "", "eglSpecFactory", "Lkotlin/Function0;", "Landroidx/graphics/opengl/egl/EGLSpec;", "eglConfigFactory", "Lkotlin/Function1;", "Landroidx/graphics/opengl/egl/EGLManager;", "Landroid/opengl/EGLConfig;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "mEglConfigFactory", "mEglContextCallback", "Ljava/util/HashSet;", "Landroidx/graphics/opengl/GLRenderer$EGLContextCallback;", "Lkotlin/collections/HashSet;", "mEglSpecFactory", "mGLThread", "Landroidx/graphics/opengl/GLThread;", "mRenderTargets", "Ljava/util/ArrayList;", "Landroidx/graphics/opengl/GLRenderer$RenderTarget;", "Lkotlin/collections/ArrayList;", "attach", "surface", "Landroid/view/Surface;", "width", "", "height", "renderer", "Landroidx/graphics/opengl/GLRenderer$RenderCallback;", "surfaceView", "Landroid/view/SurfaceView;", "textureView", "Landroid/view/TextureView;", "createRenderTarget", "detach", "", "target", "cancelPending", "", "onDetachComplete", "execute", "runnable", "Ljava/lang/Runnable;", "isRunning", "registerEGLContextCallback", "callback", "requestRender", "onRenderComplete", "resize", "onResizeComplete", "start", "name", "", "stop", "onStop", "unregisterEGLContextCallback", "Companion", "EGLContextCallback", "RenderCallback", "RenderTarget", "graphics-core_release"})
@SourceDebugExtension(value={"SMAP\nGLRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GLRenderer.kt\nandroidx/graphics/opengl/GLRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,753:1\n1#2:754\n*E\n"})
public final class GLRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<EGLSpec> mEglSpecFactory;
    @NotNull
    private final Function1<EGLManager, EGLConfig> mEglConfigFactory;
    @Nullable
    private GLThread mGLThread;
    @NotNull
    private final ArrayList<RenderTarget> mRenderTargets;
    @NotNull
    private final HashSet<EGLContextCallback> mEglContextCallback;
    @NotNull
    private static final AtomicInteger sToken = new AtomicInteger();

    public GLRenderer(@NotNull Function0<? extends EGLSpec> eglSpecFactory, @NotNull Function1<? super EGLManager, ? extends EGLConfig> eglConfigFactory) {
        Intrinsics.checkNotNullParameter(eglSpecFactory, (String)"eglSpecFactory");
        Intrinsics.checkNotNullParameter(eglConfigFactory, (String)"eglConfigFactory");
        this.mEglSpecFactory = eglSpecFactory;
        this.mEglConfigFactory = eglConfigFactory;
        this.mRenderTargets = new ArrayList();
        this.mEglContextCallback = new HashSet();
    }

    public /* synthetic */ GLRenderer(Function0 function0, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n & 2) != 0) {
            function1 = 2.INSTANCE;
        }
        this((Function0<? extends EGLSpec>)function0, (Function1<? super EGLManager, ? extends EGLConfig>)function1);
    }

    @JvmOverloads
    public final void detach(@NotNull RenderTarget target, boolean cancelPending, @WorkerThread @Nullable Function1<? super RenderTarget, Unit> onDetachComplete) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (this.mRenderTargets.contains(target)) {
            GLThread gLThread = this.mGLThread;
            if (gLThread != null) {
                gLThread.detachSurface(target.getToken$graphics_core_release(), cancelPending, () -> GLRenderer.detach$lambda$0(target, onDetachComplete));
            }
            this.mRenderTargets.remove(target);
        }
    }

    public static /* synthetic */ void detach$default(GLRenderer gLRenderer, RenderTarget renderTarget2, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        gLRenderer.detach(renderTarget2, bl, (Function1<? super RenderTarget, Unit>)function1);
    }

    public final boolean isRunning() {
        return this.mGLThread != null;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void start(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.mGLThread == null) {
            void $this$start_u24lambda_u241;
            GLThread gLThread;
            GLThread.Companion.log$graphics_core_release("starting thread...");
            GLThread gLThread2 = gLThread = new GLThread(name, this.mEglSpecFactory, this.mEglConfigFactory);
            GLRenderer gLRenderer = this;
            boolean bl = false;
            $this$start_u24lambda_u241.start();
            if (!this.mEglContextCallback.isEmpty()) {
                $this$start_u24lambda_u241.addEGLCallbacks(new ArrayList<EGLContextCallback>((Collection)this.mEglContextCallback));
            }
            gLRenderer.mGLThread = gLThread;
        }
    }

    public static /* synthetic */ void start$default(GLRenderer gLRenderer, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "GLThread";
        }
        gLRenderer.start(string);
    }

    @JvmOverloads
    public final void requestRender(@NotNull RenderTarget target, @Nullable Function1<? super RenderTarget, Unit> onRenderComplete) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            int token = target.getToken$graphics_core_release();
            Function1<? super RenderTarget, Unit> function1 = onRenderComplete;
            Runnable callbackRunnable = function1 != null ? () -> GLRenderer.requestRender$lambda$2(function1, target) : null;
            GLThread gLThread = this.mGLThread;
            if (gLThread == null) break block0;
            gLThread.requestRender(token, callbackRunnable);
        }
    }

    public static /* synthetic */ void requestRender$default(GLRenderer gLRenderer, RenderTarget renderTarget2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        gLRenderer.requestRender(renderTarget2, (Function1<? super RenderTarget, Unit>)function1);
    }

    @JvmOverloads
    public final void resize(@NotNull RenderTarget target, int width, int height, @Nullable Function1<? super RenderTarget, Unit> onResizeComplete) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            int token = target.getToken$graphics_core_release();
            Function1<? super RenderTarget, Unit> function1 = onResizeComplete;
            Runnable callbackRunnable = function1 != null ? () -> GLRenderer.resize$lambda$3(function1, target) : null;
            GLThread gLThread = this.mGLThread;
            if (gLThread == null) break block0;
            gLThread.resizeSurface(token, width, height, callbackRunnable);
        }
    }

    public static /* synthetic */ void resize$default(GLRenderer gLRenderer, RenderTarget renderTarget2, int n, int n2, Function1 function1, int n3, Object object) {
        if ((n3 & 8) != 0) {
            function1 = null;
        }
        gLRenderer.resize(renderTarget2, n, n2, (Function1<? super RenderTarget, Unit>)function1);
    }

    public final void execute(@NotNull Runnable runnable) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
            GLThread gLThread = this.mGLThread;
            if (gLThread == null) break block0;
            gLThread.execute(runnable);
        }
    }

    @JvmOverloads
    public final void stop(boolean cancelPending, @Nullable Function1<? super GLRenderer, Unit> onStop) {
        GLThread.Companion.log$graphics_core_release("stopping thread...");
        ArrayList renderTargets = new ArrayList(this.mRenderTargets);
        GLThread gLThread = this.mGLThread;
        if (gLThread != null) {
            gLThread.tearDown(cancelPending, () -> GLRenderer.stop$lambda$4(renderTargets, onStop, this));
        }
        this.mGLThread = null;
        this.mRenderTargets.clear();
    }

    public static /* synthetic */ void stop$default(GLRenderer gLRenderer, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        gLRenderer.stop(bl, (Function1<? super GLRenderer, Unit>)function1);
    }

    public final void registerEGLContextCallback(@NotNull EGLContextCallback callback2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
            this.mEglContextCallback.add(callback2);
            GLThread gLThread = this.mGLThread;
            if (gLThread == null) break block0;
            gLThread.addEGLCallback(callback2);
        }
    }

    public final void unregisterEGLContextCallback(@NotNull EGLContextCallback callback2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
            this.mEglContextCallback.remove(callback2);
            GLThread gLThread = this.mGLThread;
            if (gLThread == null) break block0;
            gLThread.removeEGLCallback(callback2);
        }
    }

    @NotNull
    public final RenderTarget attach(@NotNull Surface surface, int width, int height, @NotNull RenderCallback renderer) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        GLThread thread = this.mGLThread;
        if (thread != null) {
            RenderTarget renderTarget2;
            int token = sToken.getAndIncrement();
            thread.attachSurface(token, surface, width, height, renderer);
            RenderTarget it = renderTarget2 = new RenderTarget(token, this, null, 4, null);
            boolean bl = false;
            this.mRenderTargets.add(it);
            return renderTarget2;
        }
        throw new IllegalStateException("GLThread not started, did you forget to call start?");
    }

    @NotNull
    public final RenderTarget createRenderTarget(int width, int height, @NotNull RenderCallback renderer) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        GLThread thread = this.mGLThread;
        if (thread != null) {
            RenderTarget renderTarget2;
            int token = sToken.getAndIncrement();
            thread.attachSurface(token, null, width, height, renderer);
            RenderTarget it = renderTarget2 = new RenderTarget(token, this, null, 4, null);
            boolean bl = false;
            this.mRenderTargets.add(it);
            return renderTarget2;
        }
        throw new IllegalStateException("GLThread not started, did you forget to call start?");
    }

    @NotNull
    public final RenderTarget attach(@NotNull SurfaceView surfaceView, @NotNull RenderCallback renderer) {
        Intrinsics.checkNotNullParameter((Object)surfaceView, (String)"surfaceView");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        GLThread thread = this.mGLThread;
        if (thread != null) {
            int token = sToken.getAndIncrement();
            SurfaceHolder holder = surfaceView.getHolder();
            SurfaceHolder.Callback2 callback2 = new SurfaceHolder.Callback2(token, this, holder, thread, renderer){
                private boolean isAttached;
                @Nullable
                private volatile CountDownLatch renderLatch;
                @NotNull
                private final CountDownLatch detachLatch;
                @NotNull
                private final RenderTarget renderTarget;
                final /* synthetic */ int $token;
                final /* synthetic */ GLThread $thread;
                final /* synthetic */ RenderCallback $renderer;
                {
                    this.$token = $token;
                    this.$thread = $thread;
                    this.$renderer = $renderer;
                    this.detachLatch = new CountDownLatch(1);
                    this.renderTarget = new RenderTarget($token, $receiver, (Function0<Unit>)((Function0)new Function0<Unit>(this, $holder){
                        final /* synthetic */ attach.callback.1 this$0;
                        final /* synthetic */ SurfaceHolder $holder;
                        {
                            this.this$0 = $receiver;
                            this.$holder = $holder;
                            super(0);
                        }

                        @WorkerThread
                        public final void invoke() {
                            this.this$0.setAttached(false);
                            this.$holder.removeCallback((SurfaceHolder.Callback)this.this$0);
                            CountDownLatch countDownLatch = this.this$0.getRenderLatch();
                            if (countDownLatch != null) {
                                countDownLatch.countDown();
                            }
                            this.this$0.getDetachLatch().countDown();
                        }
                    }));
                }

                public final boolean isAttached() {
                    return this.isAttached;
                }

                public final void setAttached(boolean bl) {
                    this.isAttached = bl;
                }

                @Nullable
                public final CountDownLatch getRenderLatch() {
                    return this.renderLatch;
                }

                public final void setRenderLatch(@Nullable CountDownLatch countDownLatch) {
                    this.renderLatch = countDownLatch;
                }

                @NotNull
                public final CountDownLatch getDetachLatch() {
                    return this.detachLatch;
                }

                @NotNull
                public final RenderTarget getRenderTarget() {
                    return this.renderTarget;
                }

                public void surfaceRedrawNeeded(@NotNull SurfaceHolder p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    if (this.detachLatch.getCount() > 0L) {
                        CountDownLatch countDownLatch;
                        CountDownLatch it = countDownLatch = new CountDownLatch(1);
                        boolean bl = false;
                        this.renderLatch = it;
                        CountDownLatch latch = countDownLatch;
                        this.renderTarget.requestRender((Function1<? super RenderTarget, Unit>)((Function1)new Function1<RenderTarget, Unit>(latch){
                            final /* synthetic */ CountDownLatch $latch;
                            {
                                this.$latch = $latch;
                                super(1);
                            }

                            @WorkerThread
                            public final void invoke(@NotNull RenderTarget it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                this.$latch.countDown();
                            }
                        }));
                        latch.await();
                        this.renderLatch = null;
                    }
                }

                public void surfaceRedrawNeededAsync(@NotNull SurfaceHolder holder, @NotNull Runnable drawingFinished) {
                    Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                    Intrinsics.checkNotNullParameter((Object)drawingFinished, (String)"drawingFinished");
                    this.renderTarget.requestRender((Function1<? super RenderTarget, Unit>)((Function1)new Function1<RenderTarget, Unit>(drawingFinished){
                        final /* synthetic */ Runnable $drawingFinished;
                        {
                            this.$drawingFinished = $drawingFinished;
                            super(1);
                        }

                        public final void invoke(@NotNull RenderTarget it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            this.$drawingFinished.run();
                        }
                    }));
                }

                public void surfaceCreated(@NotNull SurfaceHolder holder) {
                    Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                }

                public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int width, int height) {
                    Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                    if (!this.isAttached) {
                        this.$thread.attachSurface(this.$token, holder.getSurface(), width, height, this.$renderer);
                        this.isAttached = true;
                    } else {
                        RenderTarget.resize$default(this.renderTarget, width, height, null, 4, null);
                    }
                    RenderTarget.requestRender$default(this.renderTarget, null, 1, null);
                }

                public void surfaceDestroyed(@NotNull SurfaceHolder holder) {
                    Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                    RenderTarget.detach$default(this.renderTarget, true, null, 2, null);
                    this.detachLatch.await();
                }
            };
            holder.addCallback((SurfaceHolder.Callback)callback2);
            if (holder.getSurface() != null && holder.getSurface().isValid()) {
                thread.attachSurface(token, holder.getSurface(), surfaceView.getWidth(), surfaceView.getHeight(), renderer);
            }
            this.mRenderTargets.add(callback2.getRenderTarget());
            return callback2.getRenderTarget();
        }
        throw new IllegalStateException("GLThread not started, did you forget to call start?");
    }

    @NotNull
    public final RenderTarget attach(@NotNull TextureView textureView, @NotNull RenderCallback renderer) {
        Intrinsics.checkNotNullParameter((Object)textureView, (String)"textureView");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        GLThread thread = this.mGLThread;
        if (thread != null) {
            int token = sToken.getAndIncrement();
            CountDownLatch detachLatch = new CountDownLatch(1);
            RenderTarget renderTarget2 = new RenderTarget(token, this, (Function0<Unit>)((Function0)new Function0<Unit>(textureView, detachLatch){
                final /* synthetic */ TextureView $textureView;
                final /* synthetic */ CountDownLatch $detachLatch;
                {
                    this.$textureView = $textureView;
                    this.$detachLatch = $detachLatch;
                    super(0);
                }

                @WorkerThread
                public final void invoke() {
                    Handler handler = this.$textureView.getHandler();
                    if (handler != null) {
                        handler.post(() -> attach.renderTarget.1.invoke$lambda$0(this.$textureView));
                    }
                    this.$detachLatch.countDown();
                }

                private static final void invoke$lambda$0(TextureView $textureView) {
                    Intrinsics.checkNotNullParameter((Object)$textureView, (String)"$textureView");
                    $textureView.setSurfaceTextureListener(null);
                }
            }));
            textureView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(thread, token, renderer, renderTarget2, detachLatch){
                final /* synthetic */ GLThread $thread;
                final /* synthetic */ int $token;
                final /* synthetic */ RenderCallback $renderer;
                final /* synthetic */ RenderTarget $renderTarget;
                final /* synthetic */ CountDownLatch $detachLatch;
                {
                    this.$thread = $thread;
                    this.$token = $token;
                    this.$renderer = $renderer;
                    this.$renderTarget = $renderTarget;
                    this.$detachLatch = $detachLatch;
                }

                public void onSurfaceTextureAvailable(@NotNull SurfaceTexture surfaceTexture, int width, int height) {
                    Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
                    this.$thread.attachSurface(this.$token, new Surface(surfaceTexture), width, height, this.$renderer);
                }

                public void onSurfaceTextureSizeChanged(@NotNull SurfaceTexture texture, int width, int height) {
                    Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
                    RenderTarget.resize$default(this.$renderTarget, width, height, null, 4, null);
                    RenderTarget.requestRender$default(this.$renderTarget, null, 1, null);
                }

                public boolean onSurfaceTextureDestroyed(@NotNull SurfaceTexture p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    RenderTarget.detach$default(this.$renderTarget, true, null, 2, null);
                    this.$detachLatch.await();
                    return true;
                }

                public void onSurfaceTextureUpdated(@NotNull SurfaceTexture p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                }
            });
            if (textureView.isAvailable()) {
                thread.attachSurface(token, new Surface(textureView.getSurfaceTexture()), textureView.getWidth(), textureView.getHeight(), renderer);
            }
            this.mRenderTargets.add(renderTarget2);
            return renderTarget2;
        }
        throw new IllegalStateException("GLThread not started, did you forget to call start?");
    }

    @JvmOverloads
    public final void detach(@NotNull RenderTarget target, boolean cancelPending) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        GLRenderer.detach$default(this, target, cancelPending, null, 4, null);
    }

    @JvmOverloads
    public final void start() {
        GLRenderer.start$default(this, null, 1, null);
    }

    @JvmOverloads
    public final void requestRender(@NotNull RenderTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        GLRenderer.requestRender$default(this, target, null, 2, null);
    }

    @JvmOverloads
    public final void resize(@NotNull RenderTarget target, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        GLRenderer.resize$default(this, target, width, height, null, 8, null);
    }

    @JvmOverloads
    public final void stop(boolean cancelPending) {
        GLRenderer.stop$default(this, cancelPending, null, 2, null);
    }

    private static final void detach$lambda$0(RenderTarget $target, Function1 $onDetachComplete) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
            $target.release$graphics_core_release();
            $target.getOnDetach$graphics_core_release().invoke();
            Function1 function1 = $onDetachComplete;
            if (function1 == null) break block0;
            function1.invoke((Object)$target);
        }
    }

    private static final void requestRender$lambda$2(Function1 $onRenderComplete, RenderTarget $target) {
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        $onRenderComplete.invoke((Object)$target);
    }

    private static final void resize$lambda$3(Function1 $onResizeComplete, RenderTarget $target) {
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        $onResizeComplete.invoke((Object)$target);
    }

    private static final void stop$lambda$4(ArrayList $renderTargets, Function1 $onStop, GLRenderer this$0) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)$renderTargets, (String)"$renderTargets");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            for (RenderTarget target : $renderTargets) {
                target.release$graphics_core_release();
                target.getOnDetach$graphics_core_release().invoke();
            }
            Function1 function1 = $onStop;
            if (function1 == null) break block1;
            function1.invoke((Object)this$0);
        }
    }

    public GLRenderer() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/graphics/opengl/GLRenderer$Companion;", "", "()V", "sToken", "Ljava/util/concurrent/atomic/AtomicInteger;", "graphics-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Landroidx/graphics/opengl/GLRenderer$EGLContextCallback;", "", "onEGLContextCreated", "", "eglManager", "Landroidx/graphics/opengl/egl/EGLManager;", "onEGLContextDestroyed", "graphics-core_release"})
    public static interface EGLContextCallback {
        @WorkerThread
        public void onEGLContextCreated(@NotNull EGLManager var1);

        @WorkerThread
        public void onEGLContextDestroyed(@NotNull EGLManager var1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J2\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0017\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0003"}, d2={"Landroidx/graphics/opengl/GLRenderer$RenderCallback;", "", "onDrawFrame", "", "eglManager", "Landroidx/graphics/opengl/egl/EGLManager;", "onSurfaceCreated", "Landroid/opengl/EGLSurface;", "spec", "Landroidx/graphics/opengl/egl/EGLSpec;", "config", "Landroid/opengl/EGLConfig;", "surface", "Landroid/view/Surface;", "width", "", "height", "graphics-core_release"})
    public static interface RenderCallback {
        @WorkerThread
        @Nullable
        default public EGLSurface onSurfaceCreated(@NotNull EGLSpec spec, @NotNull EGLConfig config, @NotNull Surface surface, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
            return spec.eglCreateWindowSurface(config, surface, null);
        }

        @WorkerThread
        public void onDrawFrame(@NotNull EGLManager var1);

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @Deprecated
            @WorkerThread
            @Nullable
            public static EGLSurface onSurfaceCreated(@NotNull RenderCallback $this, @NotNull EGLSpec spec, @NotNull EGLConfig config, @NotNull Surface surface, int width, int height) {
                Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
                return $this.onSurfaceCreated(spec, config, surface, width, height);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0003\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ(\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0016\b\u0002\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b\u0018\u00010\u0013H\u0007J\u0006\u0010\u0014\u001a\u00020\u0011J\r\u0010\u0015\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0016J \u0010\u0017\u001a\u00020\b2\u0016\b\u0003\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b\u0018\u00010\u0013H\u0007J0\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0016\b\u0003\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b\u0018\u00010\u0013H\u0007R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Landroidx/graphics/opengl/GLRenderer$RenderTarget;", "", "token", "", "glManager", "Landroidx/graphics/opengl/GLRenderer;", "onDetach", "Lkotlin/Function0;", "", "(ILandroidx/graphics/opengl/GLRenderer;Lkotlin/jvm/functions/Function0;)V", "mManager", "getOnDetach$graphics_core_release", "()Lkotlin/jvm/functions/Function0;", "getToken$graphics_core_release", "()I", "detach", "cancelPending", "", "onDetachComplete", "Lkotlin/Function1;", "isAttached", "release", "release$graphics_core_release", "requestRender", "onRenderComplete", "resize", "width", "height", "onResizeComplete", "graphics-core_release"})
    public static final class RenderTarget {
        private final int token;
        @NotNull
        private final Function0<Unit> onDetach;
        @Nullable
        private volatile GLRenderer mManager;

        public RenderTarget(int token, @NotNull GLRenderer glManager, @WorkerThread @NotNull Function0<Unit> onDetach) {
            Intrinsics.checkNotNullParameter((Object)glManager, (String)"glManager");
            Intrinsics.checkNotNullParameter(onDetach, (String)"onDetach");
            this.token = token;
            this.onDetach = onDetach;
            this.mManager = glManager;
        }

        public /* synthetic */ RenderTarget(int n, GLRenderer gLRenderer, Function0 function0, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                function0 = 1.INSTANCE;
            }
            this(n, gLRenderer, (Function0<Unit>)function0);
        }

        public final int getToken$graphics_core_release() {
            return this.token;
        }

        @NotNull
        public final Function0<Unit> getOnDetach$graphics_core_release() {
            return this.onDetach;
        }

        public final void release$graphics_core_release() {
            this.mManager = null;
        }

        @JvmOverloads
        public final void requestRender(@WorkerThread @Nullable Function1<? super RenderTarget, Unit> onRenderComplete) {
            block0: {
                GLRenderer gLRenderer = this.mManager;
                if (gLRenderer == null) break block0;
                gLRenderer.requestRender(this, onRenderComplete);
            }
        }

        public static /* synthetic */ void requestRender$default(RenderTarget renderTarget2, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                function1 = null;
            }
            renderTarget2.requestRender((Function1<? super RenderTarget, Unit>)function1);
        }

        public final boolean isAttached() {
            return this.mManager != null;
        }

        @JvmOverloads
        public final void resize(int width, int height, @WorkerThread @Nullable Function1<? super RenderTarget, Unit> onResizeComplete) {
            block0: {
                GLRenderer gLRenderer = this.mManager;
                if (gLRenderer == null) break block0;
                gLRenderer.resize(this, width, height, onResizeComplete);
            }
        }

        public static /* synthetic */ void resize$default(RenderTarget renderTarget2, int n, int n2, Function1 function1, int n3, Object object) {
            if ((n3 & 4) != 0) {
                function1 = null;
            }
            renderTarget2.resize(n, n2, (Function1<? super RenderTarget, Unit>)function1);
        }

        @JvmOverloads
        public final void detach(boolean cancelPending, @Nullable Function1<? super RenderTarget, Unit> onDetachComplete) {
            block0: {
                GLRenderer gLRenderer = this.mManager;
                if (gLRenderer == null) break block0;
                gLRenderer.detach(this, cancelPending, onDetachComplete);
            }
        }

        public static /* synthetic */ void detach$default(RenderTarget renderTarget2, boolean bl, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = null;
            }
            renderTarget2.detach(bl, (Function1<? super RenderTarget, Unit>)function1);
        }

        @JvmOverloads
        public final void requestRender() {
            RenderTarget.requestRender$default(this, null, 1, null);
        }

        @JvmOverloads
        public final void resize(int width, int height) {
            RenderTarget.resize$default(this, width, height, null, 4, null);
        }

        @JvmOverloads
        public final void detach(boolean cancelPending) {
            RenderTarget.detach$default(this, cancelPending, null, 2, null);
        }
    }
}

