/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.opengl;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLSurface;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.AnyThread;
import androidx.annotation.WorkerThread;
import androidx.graphics.opengl.GLRenderer;
import androidx.graphics.opengl.egl.EGLManager;
import androidx.graphics.opengl.egl.EGLSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 F2\u00020\u0001:\u0002FGB6\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000fH\u0007J \u0010\u001e\u001a\u00020\u001c2\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u001fj\b\u0012\u0004\u0012\u00020\u000f` H\u0007J2\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u00182\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(H\u0007J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u0019H\u0003J,\u0010+\u001a\u0004\u0018\u00010,2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u00182\u0006\u0010-\u001a\u00020(H\u0003J\"\u0010.\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u000102H\u0007J\u001a\u00103\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u00182\b\u00101\u001a\u0004\u0018\u000102H\u0003J\u0010\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u00020\u0019H\u0003J\u0010\u00106\u001a\u00020\u001c2\u0006\u00107\u001a\u000202H\u0007J\b\u00108\u001a\u00020\tH\u0007J\u0012\u00109\u001a\u0004\u0018\u00010,2\u0006\u00105\u001a\u00020\u0019H\u0003J\u0012\u0010:\u001a\u00020\u001c2\b\u00101\u001a\u0004\u0018\u000102H\u0003J\u0010\u0010;\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000fH\u0007J\u001c\u0010<\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u00182\n\b\u0002\u00101\u001a\u0004\u0018\u000102H\u0007J\u0010\u0010=\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0018H\u0003J,\u0010>\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u00182\n\b\u0002\u00101\u001a\u0004\u0018\u000102H\u0007J \u0010?\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u0018H\u0003J\b\u0010@\u001a\u00020\u001cH\u0016J\u001a\u0010A\u001a\u00020\u001c2\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u000102H\u0007J\"\u0010B\u001a\u00020\u001c2\u0017\u0010C\u001a\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001c0\b\u00a2\u0006\u0002\b\u000bH\u0082\bJ\u001e\u0010D\u001a\u00020\u001c*\u00020\u00132\b\u0010\"\u001a\u0004\u0018\u00010E2\u0006\u00107\u001a\u000202H\u0002R\u001f\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Landroidx/graphics/opengl/GLThread;", "Landroid/os/HandlerThread;", "name", "", "mEglSpecFactory", "Lkotlin/Function0;", "Landroidx/graphics/opengl/egl/EGLSpec;", "mEglConfigFactory", "Lkotlin/Function1;", "Landroidx/graphics/opengl/egl/EGLManager;", "Landroid/opengl/EGLConfig;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "mEglContextCallback", "Ljava/util/HashSet;", "Landroidx/graphics/opengl/GLRenderer$EGLContextCallback;", "Lkotlin/collections/HashSet;", "mEglManager", "mHandler", "Landroid/os/Handler;", "mIsTearingDown", "Ljava/util/concurrent/atomic/AtomicBoolean;", "mSurfaceSessions", "Ljava/util/HashMap;", "", "Landroidx/graphics/opengl/GLThread$SurfaceSession;", "Lkotlin/collections/HashMap;", "addEGLCallback", "", "callbacks", "addEGLCallbacks", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "attachSurface", "token", "surface", "Landroid/view/Surface;", "width", "height", "renderer", "Landroidx/graphics/opengl/GLRenderer$RenderCallback;", "attachSurfaceSessionInternal", "surfaceSession", "createEGLSurfaceForSession", "Landroid/opengl/EGLSurface;", "surfaceRenderer", "detachSurface", "cancelPending", "", "callback", "Ljava/lang/Runnable;", "detachSurfaceSessionInternal", "disposeSurfaceSession", "session", "execute", "runnable", "obtainEGLManager", "obtainEGLSurfaceForSession", "releaseResourcesInternalAndQuit", "removeEGLCallback", "requestRender", "requestRenderInternal", "resizeSurface", "resizeSurfaceSessionInternal", "start", "tearDown", "withHandler", "block", "post", "", "Companion", "SurfaceSession", "graphics-core_release"})
@SourceDebugExtension(value={"SMAP\nGLThread.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GLThread.kt\nandroidx/graphics/opengl/GLThread\n*L\n1#1,414:1\n350#1,6:415\n350#1,6:421\n350#1,6:427\n350#1,6:433\n350#1,6:439\n350#1,6:445\n350#1,6:451\n350#1,6:457\n350#1,6:463\n*S KotlinDebug\n*F\n+ 1 GLThread.kt\nandroidx/graphics/opengl/GLThread\n*L\n77#1:415,6\n91#1:421,6\n102#1:427,6\n116#1:433,6\n130#1:439,6\n138#1:445,6\n155#1:451,6\n171#1:457,6\n191#1:463,6\n*E\n"})
public final class GLThread
extends HandlerThread {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<EGLSpec> mEglSpecFactory;
    @NotNull
    private final Function1<EGLManager, EGLConfig> mEglConfigFactory;
    @NotNull
    private final AtomicBoolean mIsTearingDown;
    @Nullable
    private EGLManager mEglManager;
    @NotNull
    private final HashMap<Integer, SurfaceSession> mSurfaceSessions;
    @Nullable
    private Handler mHandler;
    @NotNull
    private final HashSet<GLRenderer.EGLContextCallback> mEglContextCallback;
    private static final boolean DEBUG = true;
    @NotNull
    private static final String TAG = "GLThread";

    public GLThread(@NotNull String name, @NotNull Function0<? extends EGLSpec> mEglSpecFactory, @NotNull Function1<? super EGLManager, ? extends EGLConfig> mEglConfigFactory) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(mEglSpecFactory, (String)"mEglSpecFactory");
        Intrinsics.checkNotNullParameter(mEglConfigFactory, (String)"mEglConfigFactory");
        super(name);
        this.mEglSpecFactory = mEglSpecFactory;
        this.mEglConfigFactory = mEglConfigFactory;
        this.mIsTearingDown = new AtomicBoolean(false);
        this.mSurfaceSessions = new HashMap();
        this.mEglContextCallback = new HashSet();
    }

    public /* synthetic */ GLThread(String string, Function0 function0, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = TAG;
        }
        this(string, (Function0<? extends EGLSpec>)function0, (Function1<? super EGLManager, ? extends EGLConfig>)function1);
    }

    public void start() {
        super.start();
        this.mHandler = new Handler(this.getLooper());
    }

    @AnyThread
    public final void attachSurface(int token, @Nullable Surface surface, int width, int height, @NotNull GLRenderer.RenderCallback renderer) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        GLThread this_$iv = this;
        boolean $i$f$withHandler = false;
        Handler handler = this_$iv.mHandler;
        if (handler == null) {
            throw new IllegalStateException("Did you forget to call GLThread.start()?");
        }
        Handler handler$iv = handler;
        if (!this_$iv.mIsTearingDown.get()) {
            Handler $this$attachSurface_u24lambda_u242 = handler$iv;
            boolean bl = false;
            this.post($this$attachSurface_u24lambda_u242, token, () -> GLThread.attachSurface$lambda$2$lambda$1(this, token, surface, renderer, width, height));
        }
    }

    @AnyThread
    public final void resizeSurface(int token, int width, int height, @Nullable Runnable callback2) {
        GLThread this_$iv = this;
        boolean $i$f$withHandler = false;
        Handler handler = this_$iv.mHandler;
        if (handler == null) {
            throw new IllegalStateException("Did you forget to call GLThread.start()?");
        }
        Handler handler$iv = handler;
        if (!this_$iv.mIsTearingDown.get()) {
            Handler $this$resizeSurface_u24lambda_u244 = handler$iv;
            boolean bl = false;
            this.post($this$resizeSurface_u24lambda_u244, token, () -> GLThread.resizeSurface$lambda$4$lambda$3(this, token, width, height, callback2));
        }
    }

    public static /* synthetic */ void resizeSurface$default(GLThread gLThread, int n, int n2, int n3, Runnable runnable, int n4, Object object) {
        if ((n4 & 8) != 0) {
            runnable = null;
        }
        gLThread.resizeSurface(n, n2, n3, runnable);
    }

    @AnyThread
    public final void addEGLCallbacks(@NotNull ArrayList<GLRenderer.EGLContextCallback> callbacks) {
        Intrinsics.checkNotNullParameter(callbacks, (String)"callbacks");
        GLThread this_$iv = this;
        boolean $i$f$withHandler = false;
        Handler handler = this_$iv.mHandler;
        if (handler == null) {
            throw new IllegalStateException("Did you forget to call GLThread.start()?");
        }
        Handler handler$iv = handler;
        if (!this_$iv.mIsTearingDown.get()) {
            Handler $this$addEGLCallbacks_u24lambda_u247 = handler$iv;
            boolean bl = false;
            $this$addEGLCallbacks_u24lambda_u247.post(() -> GLThread.addEGLCallbacks$lambda$7$lambda$6(this, callbacks));
        }
    }

    @AnyThread
    public final void addEGLCallback(@NotNull GLRenderer.EGLContextCallback callbacks) {
        Intrinsics.checkNotNullParameter((Object)callbacks, (String)"callbacks");
        GLThread this_$iv = this;
        boolean $i$f$withHandler = false;
        Handler handler = this_$iv.mHandler;
        if (handler == null) {
            throw new IllegalStateException("Did you forget to call GLThread.start()?");
        }
        Handler handler$iv = handler;
        if (!this_$iv.mIsTearingDown.get()) {
            Handler $this$addEGLCallback_u24lambda_u2410 = handler$iv;
            boolean bl = false;
            $this$addEGLCallback_u24lambda_u2410.post(() -> GLThread.addEGLCallback$lambda$10$lambda$9(this, callbacks));
        }
    }

    @AnyThread
    public final void removeEGLCallback(@NotNull GLRenderer.EGLContextCallback callbacks) {
        Intrinsics.checkNotNullParameter((Object)callbacks, (String)"callbacks");
        GLThread this_$iv = this;
        boolean $i$f$withHandler = false;
        Handler handler = this_$iv.mHandler;
        if (handler == null) {
            throw new IllegalStateException("Did you forget to call GLThread.start()?");
        }
        Handler handler$iv = handler;
        if (!this_$iv.mIsTearingDown.get()) {
            Handler $this$removeEGLCallback_u24lambda_u2412 = handler$iv;
            boolean bl = false;
            $this$removeEGLCallback_u24lambda_u2412.post(() -> GLThread.removeEGLCallback$lambda$12$lambda$11(this, callbacks));
        }
    }

    @AnyThread
    public final void execute(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        GLThread this_$iv = this;
        boolean $i$f$withHandler = false;
        Handler handler = this_$iv.mHandler;
        if (handler == null) {
            throw new IllegalStateException("Did you forget to call GLThread.start()?");
        }
        Handler handler$iv = handler;
        if (!this_$iv.mIsTearingDown.get()) {
            Handler $this$execute_u24lambda_u2413 = handler$iv;
            boolean bl = false;
            $this$execute_u24lambda_u2413.post(runnable);
        }
    }

    @AnyThread
    public final void detachSurface(int token, boolean cancelPending, @Nullable Runnable callback2) {
        Companion.log$graphics_core_release("dispatching request to detach surface w/ token: " + token);
        GLThread this_$iv = this;
        boolean $i$f$withHandler = false;
        Handler handler = this_$iv.mHandler;
        if (handler == null) {
            throw new IllegalStateException("Did you forget to call GLThread.start()?");
        }
        Handler handler$iv = handler;
        if (!this_$iv.mIsTearingDown.get()) {
            Handler $this$detachSurface_u24lambda_u2415 = handler$iv;
            boolean bl = false;
            if (cancelPending) {
                $this$detachSurface_u24lambda_u2415.removeCallbacksAndMessages((Object)token);
            }
            this.post($this$detachSurface_u24lambda_u2415, token, () -> GLThread.detachSurface$lambda$15$lambda$14(this, token, callback2));
        }
    }

    @AnyThread
    public final void tearDown(boolean cancelPending, @Nullable Runnable callback2) {
        GLThread this_$iv = this;
        boolean $i$f$withHandler = false;
        Handler handler = this_$iv.mHandler;
        if (handler == null) {
            throw new IllegalStateException("Did you forget to call GLThread.start()?");
        }
        Handler handler$iv = handler;
        if (!this_$iv.mIsTearingDown.get()) {
            Handler $this$tearDown_u24lambda_u2417 = handler$iv;
            boolean bl = false;
            if (cancelPending) {
                $this$tearDown_u24lambda_u2417.removeCallbacksAndMessages(null);
            }
            $this$tearDown_u24lambda_u2417.post(() -> GLThread.tearDown$lambda$17$lambda$16(this, callback2));
            this.mIsTearingDown.set(true);
        }
    }

    @AnyThread
    public final void requestRender(int token, @Nullable Runnable callback2) {
        Companion.log$graphics_core_release("dispatching request to render for token: " + token);
        GLThread this_$iv = this;
        boolean $i$f$withHandler = false;
        Handler handler = this_$iv.mHandler;
        if (handler == null) {
            throw new IllegalStateException("Did you forget to call GLThread.start()?");
        }
        Handler handler$iv = handler;
        if (!this_$iv.mIsTearingDown.get()) {
            Handler $this$requestRender_u24lambda_u2419 = handler$iv;
            boolean bl = false;
            this.post($this$requestRender_u24lambda_u2419, token, () -> GLThread.requestRender$lambda$19$lambda$18(this, token, callback2));
        }
    }

    public static /* synthetic */ void requestRender$default(GLThread gLThread, int n, Runnable runnable, int n2, Object object) {
        if ((n2 & 2) != 0) {
            runnable = null;
        }
        gLThread.requestRender(n, runnable);
    }

    @WorkerThread
    @NotNull
    public final EGLManager obtainEGLManager() {
        EGLManager eGLManager = this.mEglManager;
        if (eGLManager == null) {
            EGLManager eGLManager2;
            EGLManager it = eGLManager2 = new EGLManager((EGLSpec)this.mEglSpecFactory.invoke());
            boolean bl = false;
            it.initialize();
            EGLConfig config = (EGLConfig)this.mEglConfigFactory.invoke((Object)it);
            it.createContext(config);
            for (GLRenderer.EGLContextCallback callback2 : this.mEglContextCallback) {
                callback2.onEGLContextCreated(it);
            }
            this.mEglManager = it;
            eGLManager = eGLManager2;
        }
        return eGLManager;
    }

    @WorkerThread
    private final void disposeSurfaceSession(SurfaceSession session) {
        EGLSurface eglSurface = session.getEglSurface();
        if (eglSurface != null && !Intrinsics.areEqual((Object)eglSurface, (Object)EGL14.EGL_NO_SURFACE)) {
            this.obtainEGLManager().getEGLSpec().eglDestroySurface(eglSurface);
            session.setEglSurface(null);
        }
    }

    @WorkerThread
    private final EGLSurface obtainEGLSurfaceForSession(SurfaceSession session) {
        EGLSurface eGLSurface;
        if (session.getEglSurface() != null) {
            eGLSurface = session.getEglSurface();
        } else {
            EGLSurface eGLSurface2;
            EGLSurface it = eGLSurface2 = this.createEGLSurfaceForSession(session.getSurface(), session.getWidth(), session.getHeight(), session.getSurfaceRenderer());
            boolean bl = false;
            session.setEglSurface(it);
            eGLSurface = eGLSurface2;
        }
        return eGLSurface;
    }

    @WorkerThread
    private final EGLSurface createEGLSurfaceForSession(Surface surface, int width, int height, GLRenderer.RenderCallback surfaceRenderer) {
        EGLSurface eGLSurface;
        EGLManager $this$createEGLSurfaceForSession_u24lambda_u2422 = this.obtainEGLManager();
        boolean bl = false;
        if (surface != null) {
            EGLSpec eGLSpec = $this$createEGLSurfaceForSession_u24lambda_u2422.getEGLSpec();
            EGLConfig eGLConfig = $this$createEGLSurfaceForSession_u24lambda_u2422.getEGLConfig();
            Intrinsics.checkNotNull((Object)eGLConfig);
            eGLSurface = surfaceRenderer.onSurfaceCreated(eGLSpec, eGLConfig, surface, width, height);
        } else {
            eGLSurface = null;
        }
        return eGLSurface;
    }

    @WorkerThread
    private final void releaseResourcesInternalAndQuit(Runnable callback2) {
        EGLManager eglManager = this.obtainEGLManager();
        for (Map.Entry session : ((Map)this.mSurfaceSessions).entrySet()) {
            this.disposeSurfaceSession((SurfaceSession)session.getValue());
        }
        Runnable runnable = callback2;
        if (runnable != null) {
            runnable.run();
        }
        this.mSurfaceSessions.clear();
        for (GLRenderer.EGLContextCallback eglCallback : this.mEglContextCallback) {
            eglCallback.onEGLContextDestroyed(eglManager);
        }
        this.mEglContextCallback.clear();
        eglManager.release();
        this.mEglManager = null;
        this.quit();
    }

    @WorkerThread
    private final void requestRenderInternal(int token) {
        block4: {
            Companion.log$graphics_core_release("requesting render for token: " + token);
            SurfaceSession surfaceSession = this.mSurfaceSessions.get(token);
            if (surfaceSession == null) break block4;
            SurfaceSession surfaceSession2 = surfaceSession;
            boolean bl = false;
            EGLManager eglManager = this.obtainEGLManager();
            EGLSurface eglSurface = this.obtainEGLSurfaceForSession(surfaceSession2);
            if (eglSurface != null) {
                EGLManager.makeCurrent$default(eglManager, eglSurface, null, 2, null);
            } else {
                EGLManager.makeCurrent$default(eglManager, eglManager.getDefaultSurface(), null, 2, null);
            }
            int width = surfaceSession2.getWidth();
            int height = surfaceSession2.getHeight();
            if (width > 0 && height > 0) {
                surfaceSession2.getSurfaceRenderer().onDrawFrame(eglManager);
            }
            if (eglSurface != null) {
                eglManager.swapAndFlushBuffers();
            }
        }
    }

    @WorkerThread
    private final void attachSurfaceSessionInternal(SurfaceSession surfaceSession) {
        ((Map)this.mSurfaceSessions).put(surfaceSession.getSurfaceToken(), surfaceSession);
    }

    @WorkerThread
    private final void resizeSurfaceSessionInternal(int token, int width, int height) {
        block0: {
            SurfaceSession surfaceSession;
            SurfaceSession surfaceSession2 = this.mSurfaceSessions.get(token);
            if (surfaceSession2 == null) break block0;
            SurfaceSession surfaceSession3 = surfaceSession2;
            boolean bl = false;
            SurfaceSession $this$resizeSurfaceSessionInternal_u24lambda_u2425_u24lambda_u2424 = surfaceSession = surfaceSession3;
            boolean bl2 = false;
            $this$resizeSurfaceSessionInternal_u24lambda_u2425_u24lambda_u2424.setWidth(width);
            $this$resizeSurfaceSessionInternal_u24lambda_u2425_u24lambda_u2424.setHeight(height);
            this.disposeSurfaceSession(surfaceSession3);
            this.obtainEGLSurfaceForSession(surfaceSession3);
        }
    }

    @WorkerThread
    private final void detachSurfaceSessionInternal(int token, Runnable callback2) {
        block1: {
            SurfaceSession session = this.mSurfaceSessions.remove(token);
            if (session != null) {
                this.disposeSurfaceSession(session);
            }
            Runnable runnable = callback2;
            if (runnable == null) break block1;
            runnable.run();
        }
    }

    private final void withHandler(Function1<? super Handler, Unit> block) {
        boolean $i$f$withHandler = false;
        Handler handler = this.mHandler;
        if (handler == null) {
            throw new IllegalStateException("Did you forget to call GLThread.start()?");
        }
        Handler handler2 = handler;
        if (!this.mIsTearingDown.get()) {
            block.invoke((Object)handler2);
        }
    }

    private final void post(Handler $this$post, Object token, Runnable runnable) {
        $this$post.postAtTime(runnable, token, SystemClock.uptimeMillis());
    }

    /*
     * WARNING - void declaration
     */
    private static final void attachSurface$lambda$2$lambda$1(GLThread this$0, int $token, Surface $surface, GLRenderer.RenderCallback $renderer, int $width, int $height) {
        void $this$attachSurface_u24lambda_u242_u24lambda_u241_u24lambda_u240;
        SurfaceSession surfaceSession;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$renderer, (String)"$renderer");
        SurfaceSession surfaceSession2 = surfaceSession = new SurfaceSession($token, $surface, $renderer);
        GLThread gLThread = this$0;
        boolean bl = false;
        $this$attachSurface_u24lambda_u242_u24lambda_u241_u24lambda_u240.setWidth($width);
        $this$attachSurface_u24lambda_u242_u24lambda_u241_u24lambda_u240.setHeight($height);
        gLThread.attachSurfaceSessionInternal(surfaceSession);
    }

    private static final void resizeSurface$lambda$4$lambda$3(GLThread this$0, int $token, int $width, int $height, Runnable $callback) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.resizeSurfaceSessionInternal($token, $width, $height);
            this$0.requestRenderInternal($token);
            Runnable runnable = $callback;
            if (runnable == null) break block0;
            runnable.run();
        }
    }

    private static final void addEGLCallbacks$lambda$7$lambda$6(GLThread this$0, ArrayList $callbacks) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$callbacks, (String)"$callbacks");
            this$0.mEglContextCallback.addAll($callbacks);
            EGLManager eGLManager = this$0.mEglManager;
            if (eGLManager == null) break block1;
            EGLManager it = eGLManager;
            boolean bl = false;
            for (GLRenderer.EGLContextCallback callback2 : $callbacks) {
                callback2.onEGLContextCreated(it);
            }
        }
    }

    private static final void addEGLCallback$lambda$10$lambda$9(GLThread this$0, GLRenderer.EGLContextCallback $callbacks) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$callbacks, (String)"$callbacks");
            this$0.mEglContextCallback.add($callbacks);
            EGLManager eGLManager = this$0.mEglManager;
            if (eGLManager == null) break block0;
            EGLManager it = eGLManager;
            boolean bl = false;
            $callbacks.onEGLContextCreated(it);
        }
    }

    private static final void removeEGLCallback$lambda$12$lambda$11(GLThread this$0, GLRenderer.EGLContextCallback $callbacks) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$callbacks, (String)"$callbacks");
        this$0.mEglContextCallback.remove($callbacks);
    }

    private static final void detachSurface$lambda$15$lambda$14(GLThread this$0, int $token, Runnable $callback) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.detachSurfaceSessionInternal($token, $callback);
    }

    private static final void tearDown$lambda$17$lambda$16(GLThread this$0, Runnable $callback) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.releaseResourcesInternalAndQuit($callback);
    }

    private static final void requestRender$lambda$19$lambda$18(GLThread this$0, int $token, Runnable $callback) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.requestRenderInternal($token);
            Runnable runnable = $callback;
            if (runnable == null) break block0;
            runnable.run();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/graphics/opengl/GLThread$Companion;", "", "()V", "DEBUG", "", "TAG", "", "log", "", "msg", "log$graphics_core_release", "graphics-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void log$graphics_core_release(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Log.v((String)GLThread.TAG, (String)msg);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u001a\u0010\u0019\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013\u00a8\u0006\u001c"}, d2={"Landroidx/graphics/opengl/GLThread$SurfaceSession;", "", "surfaceToken", "", "surface", "Landroid/view/Surface;", "surfaceRenderer", "Landroidx/graphics/opengl/GLRenderer$RenderCallback;", "(ILandroid/view/Surface;Landroidx/graphics/opengl/GLRenderer$RenderCallback;)V", "eglSurface", "Landroid/opengl/EGLSurface;", "getEglSurface", "()Landroid/opengl/EGLSurface;", "setEglSurface", "(Landroid/opengl/EGLSurface;)V", "height", "getHeight", "()I", "setHeight", "(I)V", "getSurface", "()Landroid/view/Surface;", "getSurfaceRenderer", "()Landroidx/graphics/opengl/GLRenderer$RenderCallback;", "getSurfaceToken", "width", "getWidth", "setWidth", "graphics-core_release"})
    private static final class SurfaceSession {
        private final int surfaceToken;
        @Nullable
        private final Surface surface;
        @NotNull
        private final GLRenderer.RenderCallback surfaceRenderer;
        @Nullable
        private EGLSurface eglSurface;
        private int width;
        private int height;

        public SurfaceSession(int surfaceToken, @Nullable Surface surface, @NotNull GLRenderer.RenderCallback surfaceRenderer) {
            Intrinsics.checkNotNullParameter((Object)surfaceRenderer, (String)"surfaceRenderer");
            this.surfaceToken = surfaceToken;
            this.surface = surface;
            this.surfaceRenderer = surfaceRenderer;
        }

        public final int getSurfaceToken() {
            return this.surfaceToken;
        }

        @Nullable
        public final Surface getSurface() {
            return this.surface;
        }

        @NotNull
        public final GLRenderer.RenderCallback getSurfaceRenderer() {
            return this.surfaceRenderer;
        }

        @Nullable
        public final EGLSurface getEglSurface() {
            return this.eglSurface;
        }

        public final void setEglSurface(@Nullable EGLSurface eGLSurface) {
            this.eglSurface = eGLSurface;
        }

        public final int getWidth() {
            return this.width;
        }

        public final void setWidth(int n) {
            this.width = n;
        }

        public final int getHeight() {
            return this.height;
        }

        public final void setHeight(int n) {
            this.height = n;
        }
    }
}

